/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.jaxws.san.wo.SMISDiskLunMappingDO;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.storage.db.LunHelper;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.DiskLun;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DiskLunMapHelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    private static final String insertSql = "INSERT INTO SMIS_DISK_LUN_MAP (ID, SYSTEM_DB_ID, DISK_DB_ID, LUN_DB_ID, LAST_UPDATED) VALUES (?,?,?,?,?)";
    private static final String updateSql = "UPDATE SMIS_DISK_LUN_MAP SET SYSTEM_DB_ID=?, DISK_DB_ID=?, LUN_DB_ID=?, LAST_UPDATED=? WHERE ID=?";
    private static final String checkSql = "SELECT ID FROM SMIS_DISK_LUN_MAP WHERE SYSTEM_DB_ID=? AND DISK_DB_ID=? AND LUN_DB_ID=?";
    private static final String getListByDiskSql = "SELECT SMIS_DISK_LUN_MAP.ID, SMIS_DISK_LUN_MAP.LUN_DB_ID, SMIS_STORAGE_LUN.LUN_ID, SMIS_STORAGE_LUN.LUN_NAME, SMIS_STORAGE_LUN.POOL_NAME, SMIS_DISK_LUN_MAP.LAST_UPDATED FROM SMIS_DISK_LUN_MAP, SMIS_STORAGE_LUN WHERE SMIS_STORAGE_LUN.ID=SMIS_DISK_LUN_MAP.LUN_DB_ID AND SMIS_DISK_LUN_MAP.SYSTEM_DB_ID=? AND SMIS_DISK_LUN_MAP.DISK_DB_ID=?";
    private static final String getTimeListSql = "SELECT ID, DISK_DB_ID, LAST_UPDATED FROM SMIS_DISK_LUN_MAP WHERE SYSTEM_DB_ID=?";
    private static final String cleanupSql = "DELETE FROM SMIS_DISK_LUN_MAP WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, StorageSystem storageSystem) throws SQLException {
        if (con == null || storageSystem == null) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(insertSql);
            updateStat = con.prepareStatement(updateSql);
            for (ComponentSystem comp : storageSystem.get_comps()) {
                for (Disk disk : comp.get_disks()) {
                    if (disk.get_luns() == null) continue;
                    for (DiskLun obj : disk.get_luns()) {
                        long systemDbId = storageSystem.getDBID();
                        long lunDbId = obj.get_pKey()._dbid;
                        if (lunDbId == 0L) {
                            Lun lun = storageSystem.get_lun(obj.get_pKey().get_lunId(), null);
                            lunDbId = lun != null ? lun.getDBID() : LunHelper.getDbId(systemDbId, obj.get_pKey().get_lunId(), con);
                            obj.get_pKey()._dbid = lunDbId;
                        }
                        if (lunDbId == 0L) {
                            _Logger.debug((Object)("Lun Lookup failed bailing on this one: Listed lunID as " + obj.get_pKey().get_lunId()));
                            continue;
                        }
                        if (obj.getDBID() == 0L) {
                            checkStat = con.prepareStatement(checkSql);
                            DiskLunMapHelper.setupCheckExistenceStatement(systemDbId, disk.getDBID(), lunDbId, checkStat);
                            SMISHelper.checkPreexistRecord(obj, checkStat);
                        }
                        if (obj.getDBID() == 0L) {
                            obj.setDBID(Sequence.getSequence().getPK());
                            DiskLunMapHelper.setupInsertStatement(systemDbId, disk.getDBID(), obj, insertStat);
                            insertStat.addBatch();
                        } else if (obj.isModified() || obj.isPresent()) {
                            DiskLunMapHelper.setupUpdateStatement(systemDbId, disk.getDBID(), obj, updateStat);
                            if (updateStat.executeUpdate() < 1) {
                                obj.setDBID(Sequence.getSequence().getPK());
                                DiskLunMapHelper.setupInsertStatement(systemDbId, disk.getDBID(), obj, insertStat);
                                insertStat.addBatch();
                            }
                        }
                        obj.setFlushed(true);
                    }
                }
            }
            insertStat.executeBatch();
            for (ComponentSystem comp : storageSystem.get_comps()) {
                for (Disk disk : comp.get_disks()) {
                    if (disk.get_luns() == null) continue;
                    for (DiskLun obj : disk.get_luns()) {
                        obj.clearModified();
                        obj.setPresent(false);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public static void setupInsertStatement(long systemDbId, long diskDbId, DiskLun obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, diskDbId);
        stat.setLong(i++, obj.get_pKey()._dbid);
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public static void setupUpdateStatement(long systemDbId, long diskDbId, DiskLun obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, systemDbId);
        stat.setLong(i++, diskDbId);
        stat.setLong(i++, obj.get_pKey()._dbid);
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(long systemDbId, long diskDbId, long lunDbId, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, systemDbId);
        stat.setLong(2, diskDbId);
        stat.setLong(3, lunDbId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<SMISDiskLunMappingDO> getListByDisk(Connection con, long systemDbId, long diskDbId, Timestamp time) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISDiskLunMappingDO> ssl = new ArrayList<SMISDiskLunMappingDO>();
        try {
            getStat = con.prepareStatement(getListByDiskSql);
            getStat.setLong(1, systemDbId);
            getStat.setLong(2, diskDbId);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                int i = 1;
                SMISDiskLunMappingDO obj = new SMISDiskLunMappingDO();
                obj.setDbId(rs.getLong(i++));
                obj.setLunDbId(rs.getLong(i++));
                obj.setLunId(rs.getString(i++));
                obj.setLunName(rs.getString(i++));
                obj.setPoolName(rs.getString(i++));
                Timestamp t = rs.getTimestamp(i++);
                obj.setLastSeen(t.toString());
                if (t.after(time)) {
                    obj.setPresent(true);
                } else {
                    obj.setPresent(false);
                }
                ssl.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception getting DiskLunMap list for system with id " + systemDbId + " and disk id " + diskDbId), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup(Connection con, StorageSystem sys, Timestamp expired) {
        PreparedStatement getStat = null;
        PreparedStatement cleanStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(getTimeListSql);
            getStat.setLong(1, sys.getDBID());
            cleanStat = con.prepareStatement(cleanupSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                long dbid = rs.getLong(1);
                long diskDbId = rs.getLong(2);
                Timestamp ts = rs.getTimestamp(3);
                if (ts.getTime() >= expired.getTime()) continue;
                _Logger.info((Object)("DiskLunMap " + diskDbId + " has timestamp " + ts + " cleaning out."));
                cleanStat.setLong(1, dbid);
                cleanStat.addBatch();
            }
            cleanStat.executeBatch();
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)("Exception during cleanup for system " + sys.getDBID()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                DbUtil.close(cleanStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
            DbUtil.close(cleanStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        DbUtil.close(cleanStat);
    }
}

