/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.jaxws.san.wo.SMISProviderDO;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.type.ProviderPK;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.model.Provider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ProviderHelper {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    private static final String insertSql = "INSERT INTO SMIS_PROVIDER (ID, PROVID, PROVIDER_NS, INTEROP_NS, URL, USERNAME,PASSWORD, PORT, SECURE, VENDOR, LAST_UPDATED) VALUES (?,?,?,?,?,?, ?,?,?,?,?)";
    private static final String updateSql = "UPDATE SMIS_PROVIDER SET PROVIDER_NS=?, INTEROP_NS=?, URL=?, USERNAME=?,PASSWORD=?, PORT=?, SECURE=?, VENDOR=?, LAST_UPDATED=?  WHERE ID=?";
    private static final String checkSql = "SELECT ID FROM SMIS_PROVIDER WHERE URL=? AND PORT=?";
    private static final String getListSql = "SELECT ID, PROVID, PROVIDER_NS, INTEROP_NS, URL, USERNAME,PASSWORD, PORT, SECURE, VENDOR, LAST_UPDATED FROM SMIS_PROVIDER";
    static final String QuerySQLByPersistentFilteredByServerId = "SELECT p.ID, p.PROVID, p.PROVIDER_NS, p.INTEROP_NS, p.URL, p.USERNAME,p.PASSWORD, p.PORT, p.SECURE, p.VENDOR, p. LAST_UPDATED FROM SMIS_PROVIDER p, LOGICSVR_FABRIC lf where p.PROVID = lf.F_ID and lf.LSVR_ID = ?";
    private static final String getSql = "SELECT ID, PROVIDER_NS, INTEROP_NS, URL, USERNAME,PASSWORD, PORT, SECURE, VENDOR, LAST_UPDATED FROM SMIS_PROVIDER WHERE URL=? AND PORT=?";
    private static final String remSql = "DELETE FROM SMIS_PROVIDER WHERE URL=? AND PORT=?";
    private static final String getByIdSql = "SELECT PROVID, PROVIDER_NS, INTEROP_NS, URL, USERNAME,PASSWORD, PORT, SECURE, VENDOR, LAST_UPDATED FROM SMIS_PROVIDER WHERE ID=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, Provider provider) throws SQLException {
        if (con == null || provider == null) {
            return;
        }
        PreparedStatement insertStat = null;
        PreparedStatement updateStat = null;
        PreparedStatement checkStat = null;
        try {
            insertStat = con.prepareStatement(insertSql);
            updateStat = con.prepareStatement(updateSql);
            if (provider.getDBID() == 0L) {
                checkStat = con.prepareStatement(checkSql);
                ProviderHelper.setupCheckExistenceStatement(provider, checkStat);
                SMISHelper.checkPreexistRecord(provider, checkStat);
            }
            if (provider.getDBID() == 0L) {
                provider.setDBID(Sequence.getSequence().getPK(con));
                ProviderHelper.setupInsertStatement(provider, insertStat);
                insertStat.addBatch();
            } else if (provider.isModified() || provider.isPresent()) {
                ProviderHelper.setupUpdateStatement(provider, updateStat);
                if (updateStat.executeUpdate() < 1) {
                    provider.setDBID(Sequence.getSequence().getPK());
                    ProviderHelper.setupInsertStatement(provider, insertStat);
                    insertStat.addBatch();
                }
            }
            insertStat.executeBatch();
            provider.setFlushed(true);
            provider.clearModified();
        }
        catch (Throwable throwable) {
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
            throw throwable;
        }
        DbUtil.close(insertStat);
        DbUtil.close(updateStat);
        DbUtil.close(checkStat);
    }

    public static void setupInsertStatement(Provider obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setInt(i++, obj.getProvId());
        stat.setString(i++, obj.getNs());
        stat.setString(i++, obj.getInteropns());
        stat.setString(i++, obj.getUrl());
        stat.setString(i++, obj.getUsername());
        try {
            stat.setString(i++, StringEncrypter.DESedeEncrypt(obj.getPassword()));
        }
        catch (Exception e) {
            throw new SQLException("Store failed due to password encryption error " + e.getMessage());
        }
        stat.setInt(i++, obj.getPort());
        stat.setBoolean(i++, obj.isSecure());
        stat.setString(i++, obj.getVendor());
        stat.setTimestamp(i++, obj.getLastUpdated());
    }

    public static void setupUpdateStatement(Provider obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setString(i++, obj.getNs());
        stat.setString(i++, obj.getInteropns());
        stat.setString(i++, obj.getUrl());
        stat.setString(i++, obj.getUsername());
        try {
            stat.setString(i++, StringEncrypter.DESedeEncrypt(obj.getPassword()));
        }
        catch (Exception e) {
            throw new SQLException("Store failed due to password encryption error ", e);
        }
        stat.setInt(i++, obj.getPort());
        stat.setBoolean(i++, obj.isSecure());
        stat.setString(i++, obj.getVendor());
        stat.setTimestamp(i++, obj.getLastUpdated());
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(Provider obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, obj.getUrl());
        stat.setInt(2, obj.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Provider> loadFromDB(Connection con) throws SQLException {
        if (con == null) {
            return null;
        }
        ArrayList<Provider> providerList = new ArrayList<Provider>();
        PreparedStatement getStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(getListSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                String password = "";
                try {
                    password = StringEncrypter.DESedeDecrypt(rs.getString(7));
                }
                catch (Exception e) {
                    throw new SQLException("Read failed due to password decryption error " + e.getMessage());
                }
                Provider obj = new Provider(new ProviderPK(rs.getInt(2)), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), password, rs.getInt(8), rs.getBoolean(9), rs.getString(10));
                obj.setDBID(rs.getLong(1));
                providerList.add(obj);
            }
        }
        catch (SQLException e) {
            ArrayList<Provider> arrayList;
            try {
                _Logger.error((Object)"Exception loading Providers from db ", (Throwable)e);
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return providerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Provider> loadFromDBFilter(Connection con) throws SQLException {
        if (con == null) {
            return null;
        }
        ArrayList<Provider> providerList = new ArrayList<Provider>();
        PreparedStatement getStat = null;
        ResultSet rs = null;
        try {
            getStat = con.prepareStatement(QuerySQLByPersistentFilteredByServerId);
            getStat.setInt(1, Sequence.getSequence().getServerId());
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                String password = "";
                try {
                    password = StringEncrypter.DESedeDecrypt(rs.getString(7));
                }
                catch (Exception e) {
                    throw new SQLException("Read failed due to password decryption error " + e.getMessage());
                }
                Provider obj = new Provider(new ProviderPK(rs.getInt(2)), rs.getString(3), rs.getString(4), rs.getString(5), rs.getString(6), password, rs.getInt(8), rs.getBoolean(9), rs.getString(10));
                obj.setDBID(rs.getLong(1));
                providerList.add(obj);
            }
            DbUtil.close(rs);
        }
        catch (SQLException e) {
            _Logger.error((Object)"Exception in loadFromDbFilter ", (Throwable)e);
            ArrayList<Provider> arrayList = null;
            return arrayList;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(getStat);
        return providerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISProviderDO[] getList(Connection con) {
        PreparedStatement getStat = null;
        ResultSet rs = null;
        ArrayList<SMISProviderDO> returnList = new ArrayList<SMISProviderDO>();
        try {
            getStat = con.prepareStatement(getListSql);
            rs = SQLLoader.execute(getStat);
            while (rs.next()) {
                SMISProviderDO obj = new SMISProviderDO();
                obj.setDbId(rs.getLong(1));
                obj.setProvId(rs.getInt(2));
                obj.setNs(rs.getString(3));
                obj.setInteropns(rs.getString(4));
                obj.setUrl(rs.getString(5));
                obj.setUsername(rs.getString(6));
                obj.setPort(rs.getInt(8));
                obj.setSecure(rs.getBoolean(9));
                obj.setVendor(rs.getString(10));
                Timestamp t = rs.getTimestamp(11);
                if (t != null) {
                    obj.setLastUpdated(t.toString());
                }
                obj.setManagedstatus("Managed");
                returnList.add(obj);
            }
        }
        catch (SQLException e) {
            try {
                _Logger.error((Object)"Exception getting Provider List", (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(getStat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(getStat);
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return returnList.toArray(new SMISProviderDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SMISProviderDO get(Connection con, String url, int port) {
        SMISProviderDO obj;
        ResultSet rs;
        PreparedStatement getStat;
        block4: {
            getStat = null;
            rs = null;
            obj = null;
            try {
                getStat = con.prepareStatement(getSql);
                getStat.setString(1, url);
                getStat.setInt(2, port);
                rs = SQLLoader.execute(getStat);
                if (!rs.next()) break block4;
                obj = new SMISProviderDO();
                obj.setDbId(rs.getLong(1));
                obj.setNs(rs.getString(2));
                obj.setInteropns(rs.getString(3));
                obj.setUrl(rs.getString(4));
                obj.setUsername(rs.getString(5));
                obj.setPort(rs.getInt(7));
                obj.setSecure(rs.getBoolean(8));
                obj.setVendor(rs.getString(9));
                Timestamp t = rs.getTimestamp(10);
                if (t == null) break block4;
                obj.setLastUpdated(t.toString());
            }
            catch (SQLException e) {
                try {
                    _Logger.error((Object)("Exception getting Provider with url" + url + " and port " + port), (Throwable)e);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(getStat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int delete(Connection con, Provider provider) throws SQLException {
        PreparedStatement remStat = null;
        int effected = 0;
        try {
            remStat = con.prepareStatement(remSql);
            remStat.setString(1, provider.getUrl());
            remStat.setInt(2, provider.getPort());
            effected = SQLLoader.executeUpdate(remStat);
        }
        finally {
            DbUtil.close(remStat);
        }
        return effected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Provider get(Connection con, long dbid) {
        Provider obj;
        ResultSet rs;
        PreparedStatement getStat;
        block6: {
            getStat = null;
            rs = null;
            obj = null;
            try {
                getStat = con.prepareStatement(getByIdSql);
                getStat.setLong(1, dbid);
                rs = SQLLoader.execute(getStat);
                if (!rs.next()) break block6;
                ProviderPK provPk = new ProviderPK(rs.getInt(1));
                obj = new Provider(provPk, rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), StringEncrypter.DESedeDecrypt(rs.getString(6)), rs.getInt(7), rs.getBoolean(8), rs.getString(9));
                obj.setDBID(dbid);
            }
            catch (SQLException e) {
                _Logger.error((Object)("Exception getting Provider with id " + dbid), (Throwable)e);
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
            catch (Exception e2) {
                _Logger.error((Object)("Exception getting Provider with id " + dbid), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(getStat);
                        throw throwable;
                    }
                }
                DbUtil.close(rs);
                DbUtil.close(getStat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(getStat);
        return obj;
    }
}

