/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.db;

import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.model.DiskStatistics;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StorageStatistics;
import com.cisco.dcbu.storage.model.StorageSystem;
import com.cisco.dcbu.storage.model.StorageSystemStatistics;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;

public class StatisticsHelper {
    private static final String diskStatInsertSql = "INSERT INTO SMIS_STATISTICS_DISK (ID, SYSTEM_DB_ID, DISK_NAME, TIME_ID, totalIOs, kBytesTransferred, readIOs, kBytesRead, writeIOs, kBytesWritten, LAST_UPDATED) VALUES (?,?,?,?,?, ?,?,?,?,?, ?)";
    private static final String diskStatUpdateSql = "UPDATE SMIS_STATISTICS_DISK SET SYSTEM_DB_ID=?, DISK_NAME=?, TIME_ID=?, totalIOs=?, kBytesTransferred=?, readIOs=?, kBytesRead=?, writeIOs=?, kBytesWritten=?, LAST_UPDATED=? WHERE ID=?";
    private static final String diskStatCheckSql = "SELECT ID FROM SMIS_STATISTICS_DISK WHERE SYSTEM_DB_ID=? AND DISK_NAME=?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persist(Connection con, Provider provider, StorageSystem sys) throws SQLException {
        if (con == null || sys == null) {
            return;
        }
        for (StorageSystemStatistics sss : sys.getStatsList()) {
            if (sss.get_elementType() != 10) continue;
            PreparedStatement insertStat = null;
            PreparedStatement updateStat = null;
            PreparedStatement checkStat = null;
            try {
                insertStat = con.prepareStatement(diskStatInsertSql);
                updateStat = con.prepareStatement(diskStatUpdateSql);
                for (StorageStatistics ss : sss.get_strgStats()) {
                    if (!(ss instanceof DiskStatistics)) continue;
                    DiskStatistics obj = (DiskStatistics)ss;
                    if (obj.getDBID() == 0L) {
                        checkStat = con.prepareStatement(diskStatCheckSql);
                        StatisticsHelper.setupCheckExistenceStatement(sys.getDBID(), obj, checkStat);
                        SMISHelper.checkPreexistRecord(obj, checkStat);
                    }
                    if (obj.getDBID() == 0L) {
                        obj.setDBID(Sequence.getSequence().getPK());
                        StatisticsHelper.setupInsertStatement(sys.getDBID(), obj, insertStat);
                        insertStat.addBatch();
                        continue;
                    }
                    StatisticsHelper.setupUpdateStatement(sys.getDBID(), obj, updateStat);
                    if (updateStat.executeUpdate() >= 1) continue;
                    obj.setDBID(Sequence.getSequence().getPK());
                    StatisticsHelper.setupInsertStatement(sys.getDBID(), obj, insertStat);
                    insertStat.addBatch();
                }
                insertStat.executeBatch();
            }
            catch (Throwable throwable) {
                DbUtil.close(insertStat);
                DbUtil.close(updateStat);
                DbUtil.close(checkStat);
                throw throwable;
            }
            DbUtil.close(insertStat);
            DbUtil.close(updateStat);
            DbUtil.close(checkStat);
        }
    }

    public static void setupInsertStatement(long dbid, DiskStatistics obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, obj.getDBID());
        stat.setLong(i++, dbid);
        stat.setString(i++, obj.getElementName());
        stat.setLong(i++, 1L);
        stat.setLong(i++, obj.getTotalIOs());
        stat.setLong(i++, obj.getKBytesTransferred());
        stat.setLong(i++, obj.getReadIOs());
        stat.setLong(i++, obj.getKBytesRead());
        stat.setLong(i++, obj.getWriteIOs());
        stat.setLong(i++, obj.getKBytesWritten());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
    }

    public static void setupUpdateStatement(long dbid, DiskStatistics obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, dbid);
        stat.setString(i++, obj.getElementName());
        stat.setLong(i++, 1L);
        stat.setLong(i++, obj.getTotalIOs());
        stat.setLong(i++, obj.getKBytesTransferred());
        stat.setLong(i++, obj.getReadIOs());
        stat.setLong(i++, obj.getKBytesRead());
        stat.setLong(i++, obj.getWriteIOs());
        stat.setLong(i++, obj.getKBytesWritten());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, obj.getDBID());
    }

    public static void setupCheckExistenceStatement(long dbid, DiskStatistics obj, PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, dbid);
        stat.setString(2, obj.getElementName());
    }
}

