/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.storage.discovery.StorageWorkerIf;
import com.cisco.dcbu.storage.discovery.WorkerCallbackIf;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

abstract class AbstractStorageWorker
implements StorageWorkerIf {
    protected AtomicInteger _status = new AtomicInteger(0);
    protected WorkerCallbackIf _observer;

    AbstractStorageWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() == 1) {
                this._status.set(2);
                this._status.notifyAll();
            }
        }
    }

    @Override
    public int getStatus() {
        return this._status.get();
    }

    @Override
    public String getStatusDescr() {
        return AbstractStorageWorker.toStatusDescr(this._status.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        try {
            this._status.set(1);
            this.exec();
            this._status.compareAndSet(1, 5);
        }
        catch (Exception ex) {
            this._status.set(3);
            _Log.log((Priority)Level.WARN, (Object)(this + " aborted: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            this.sendUpdate();
            _Log.debug((Object)(this + " " + this.getStatusDescr() + " in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }

    protected void sendUpdate() {
        if (this._observer != null) {
            try {
                this._observer.update(this, this._status.get());
            }
            catch (Exception ex) {
                _Log.warn((Object)"Exception in sendUpdate", (Throwable)ex);
            }
        }
    }

    protected abstract void exec() throws Exception;

    static String toStatusDescr(int status) {
        switch (status) {
            case 0: {
                return "idle";
            }
            case 1: {
                return "discovering";
            }
            case 2: {
                return "interrupted";
            }
            case 3: {
                return "aborted";
            }
            case 4: {
                return "timed out";
            }
            case 5: {
                return "finished";
            }
            case 6: {
                return "bad auth";
            }
        }
        return "internal error";
    }
}

