/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.smis.client.cim.AuthorizedPrivilege;
import com.cisco.dcbu.smis.client.cim.Collection;
import com.cisco.dcbu.smis.client.cim.DiskDrive;
import com.cisco.dcbu.smis.client.cim.FCPort;
import com.cisco.dcbu.smis.client.cim.PhysicalPackage;
import com.cisco.dcbu.smis.client.cim.ProtocolControllerForUnit;
import com.cisco.dcbu.smis.client.cim.SoftwareIdentity;
import com.cisco.dcbu.smis.client.cim.StorageExtent;
import com.cisco.dcbu.smis.client.cim.StorageHardwareID;
import com.cisco.dcbu.smis.client.cim.StoragePool;
import com.cisco.dcbu.smis.client.cim.StorageVolume;
import com.cisco.dcbu.storage.discovery.PropertyList;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.DiskLun;
import com.cisco.dcbu.storage.model.DiskPool;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.CloseableIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HDSDiscoveryHandler
extends StorageDiscoveryHandler {
    private static boolean debug = true;
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");

    @Override
    public void discover(ArrayList<StorageSystem> strgSystems) {
        ArrayList<CIMInstance> regProfs = this.fetchRegisteredArrayProfiles();
        if (regProfs.size() > 0) {
            ArrayList<CIMInstance> comSysInsts = this.fetchTopLevelComputerSystem(regProfs);
            for (CIMInstance comSysInst : comSysInsts) {
                StorageSystem strgSystem = this.fetchComputerSystemPhysical(comSysInst);
                if (strgSystem == null || strgSystem.get_vendor() == null || strgSystem.get_pKey()._name == null || strgSystem.get_serialNumber() == null) continue;
                int index = strgSystems.indexOf(strgSystem);
                if (index >= 0) {
                    StorageSystem oldStrgSystem = strgSystems.get(index);
                    oldStrgSystem.update(strgSystem.get_nwwns(), strgSystem.get_storageType(), strgSystem.get_vendor(), strgSystem.get_version(), strgSystem.get_model(), strgSystem.get_partNumber(), strgSystem.get_serialNumber());
                    strgSystem = oldStrgSystem;
                } else {
                    strgSystem.set_provider(this._provider);
                    strgSystems.add(strgSystem);
                }
                this.fetchStorageProcessor(comSysInst, strgSystem);
                Map<CIMObjectPath, Pool> strgPools = this.fetchStoragePools(comSysInst, strgSystem);
                Map<Integer, Lun> strgLuns = null;
                CloseableIterator<CIMInstance> strgHWIDColInsts = null;
                strgHWIDColInsts = this.getAssociatorInstances("HITACHI_HardwareIDCollection", comSysInst.getObjectPath());
                if (strgHWIDColInsts == null || !strgHWIDColInsts.hasNext()) {
                    strgLuns = this.fetchLun(comSysInst, strgSystem, strgPools, true);
                } else {
                    strgLuns = this.fetchLun(comSysInst, strgSystem, strgPools, false);
                    this.fetchHostandMap(comSysInst, strgSystem);
                }
                this.fetchDiskDrive(comSysInst, strgSystem, strgLuns);
            }
        }
    }

    @Override
    public void perfCollection(StorageSystem strgSystem) {
    }

    private void fetchStorageProcessor(CIMInstance comSysInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> strgprocsysInsts = this.getAssociatorInstances("Hitachi_StorageProcessorSystem", comSysInst.getObjectPath());
        while (strgprocsysInsts != null && strgprocsysInsts.hasNext()) {
            StorageProcessor strgproc;
            CIMInstance strgprocsysInst = (CIMInstance)strgprocsysInsts.next();
            String elementName = this.getPropertyString(strgprocsysInst, "ElementName");
            String accessInfo = null;
            String serialNumber = null;
            long numPorts = 0L;
            HashSet<String> roles = new HashSet<String>();
            CloseableIterator<CIMInstance> portInsts = this.getAssociatorInstances("CIM_LogicalPort", strgprocsysInst.getObjectPath());
            while (portInsts != null && portInsts.hasNext()) {
                CIMInstance portInst = (CIMInstance)portInsts.next();
                FCPort fcport = new FCPort(this._wbclient, portInst);
                UnsignedInteger16 usgeRest = fcport.getUsageRestriction();
                if (usgeRest == null) {
                    roles.add("FRONT END");
                } else if (usgeRest.intValue() == 2) {
                    roles.add("FRONT END");
                } else if (usgeRest.intValue() == 3) {
                    roles.add("BACK END");
                }
                ++numPorts;
            }
            CloseableIterator<CIMInstance> remsrvaccessptInsts = this.getAssociatorInstances("Hitachi_RemoteServiceAccessPoint", comSysInst.getObjectPath());
            if (remsrvaccessptInsts != null && remsrvaccessptInsts.hasNext()) {
                accessInfo = this.getPropertyString((CIMInstance)remsrvaccessptInsts.next(), "AccessInfo");
                String[] _accessInfoArr = accessInfo.split("/");
                accessInfo = _accessInfoArr[2];
            } else {
                _Logger.warn((Object)("Failed to get CIM_RemoteServiceAccessPoint for " + elementName));
            }
            long[] status = this.unit16arrayTolongarray(this.getPropertyUint16Array(strgprocsysInst, "OperationalStatus"));
            CloseableIterator<CIMInstance> spCard = this.getAssociatorInstances("HITACHI_StorageProcessorCard", strgprocsysInst.getObjectPath());
            if (spCard != null && spCard.hasNext()) {
                serialNumber = this.getPropertyString((CIMInstance)spCard.next(), "SerialNumber");
            }
            if ((strgproc = strgSystem.get_strgproc(elementName)) == null) {
                strgproc = new StorageProcessor(elementName, -1L, numPorts, -1L, serialNumber, -1L, -1L, -1L, status, accessInfo, roles.toArray(new String[0]));
                strgSystem.add_strgproc(strgproc);
            } else {
                strgproc.update(-1L, numPorts, -1L, serialNumber, -1L, -1L, -1L, status, accessInfo, roles.toArray(new String[0]));
            }
            this.fetchComputerSystemPorts(strgprocsysInst, strgproc, strgSystem);
        }
    }

    private void fetchDiskDrive(CIMInstance comSysInst, StorageSystem strgSystem, Map<Integer, Lun> strgLuns) {
        ComponentSystem comp = strgSystem.get_comp(strgSystem.get_pKey()._name);
        if (comp == null) {
            comp = new ComponentSystem(strgSystem.get_pKey()._name);
            strgSystem.add_comp(comp);
        } else {
            comp.update();
        }
        CloseableIterator<CIMInstance> diskDrvInsts = this.getAssociatorInstances("Hitachi_DiskDrive", comSysInst.getObjectPath());
        while (diskDrvInsts != null && diskDrvInsts.hasNext()) {
            String[] lunIDs;
            CIMInstance arryGrpIn;
            CloseableIterator<CIMInstance> strgPoolInsts;
            CIMInstance diskDrvInst = (CIMInstance)diskDrvInsts.next();
            DiskDrive diskDrive = new DiskDrive(this._wbclient, diskDrvInst);
            long rawCapacity = -1L;
            long userCapacity = -1L;
            long speed = -1L;
            String raidLevel = null;
            String spName = "";
            ArrayList<DiskPool> poolList = new ArrayList<DiskPool>();
            ArrayList<DiskLun> lunList = new ArrayList<DiskLun>();
            CloseableIterator<CIMInstance> diskPhyPkgInsts = this.getAssociatorInstances("Hitachi_PhysicalDisk", diskDrvInst.getObjectPath());
            if (diskPhyPkgInsts == null || !diskPhyPkgInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_PhysicalPackage for " + diskDrive.getName()));
                return;
            }
            CIMInstance diskPhyPkgInst = (CIMInstance)diskPhyPkgInsts.next();
            PhysicalPackage diskPhyPkg = new PhysicalPackage(this._wbclient, diskPhyPkgInst);
            CloseableIterator<CIMInstance> softwareIdInsts = this.getAssociatorInstances("CIM_SoftwareIdentity", diskDrvInst.getObjectPath());
            if (softwareIdInsts == null || !softwareIdInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + diskDrive.getName()));
                return;
            }
            CIMInstance softwareIdInst = (CIMInstance)softwareIdInsts.next();
            SoftwareIdentity swId = new SoftwareIdentity(this._wbclient, softwareIdInst);
            CloseableIterator<CIMInstance> diskExtInsts = this.getAssociatorInstances("HITACHI_DiskExtent", diskDrvInst.getObjectPath());
            CIMInstance diskExtInst = null;
            if (diskExtInsts == null || !diskExtInsts.hasNext()) continue;
            diskExtInst = (CIMInstance)diskExtInsts.next();
            StorageExtent diskExtent = new StorageExtent(this._wbclient, diskExtInst);
            rawCapacity = diskExtent.getNumberOfBlocks().longValue() * diskExtent.getBlockSize().longValue();
            userCapacity = diskExtent.getConsumableBlocks().longValue() * diskExtent.getBlockSize().longValue();
            CloseableIterator<CIMInstance> arrayGroupInsts = this.getAssociatorInstances("HITACHI_ArrayGroup", diskExtInst.getObjectPath());
            if (arrayGroupInsts != null && arrayGroupInsts.hasNext() && (strgPoolInsts = this.getAssociatorInstances("CIM_StoragePool", (arryGrpIn = (CIMInstance)arrayGroupInsts.next()).getObjectPath())) != null && strgPoolInsts.hasNext()) {
                CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
                StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
                spName = strgPool.getElementName();
                poolList.add(new DiskPool(spName));
            }
            for (String lunId : lunIDs = this.getPropertyStringArray(diskExtInst, "SVDeviceIDs")) {
                Lun _lun = strgLuns.get(Integer.parseInt(lunId));
                String lunName = lunId.toString();
                if (_lun != null) {
                    lunName = _lun.get_pKey().get_lunName().toString();
                }
                lunList.add(new DiskLun(lunId, lunName));
            }
            UnsignedInteger16[] uint16 = diskDrive.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            DiskPool[] pList = poolList.toArray(new DiskPool[0]);
            DiskLun[] lList = lunList.toArray(new DiskLun[0]);
            Disk disk = comp.get_disk(diskDrive.getName());
            if (disk == null) {
                disk = new Disk(diskDrive.getName(), diskDrive.getCaption(), rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), raidLevel, pList, status, lList, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), speed, speed);
                comp.add_disk(disk);
                continue;
            }
            disk.update(diskDrive.getCaption(), rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), raidLevel, pList, status, lList, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), -1L, -1L);
        }
    }

    private void fetchHostandMap(CIMInstance comSysInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> strgHWIDColInsts = this.getAssociatorInstances("HITACHI_HardwareIDCollection", comSysInst.getObjectPath());
        while (strgHWIDColInsts != null && strgHWIDColInsts.hasNext()) {
            CIMInstance strgHWIDColInst = (CIMInstance)strgHWIDColInsts.next();
            Collection strgHWIDCol = new Collection(this._wbclient, strgHWIDColInst);
            String hostName = strgHWIDCol.getElementName();
            if (hostName == null) continue;
            Host host = strgSystem.get_host(hostName);
            if (host == null) {
                host = new Host(hostName);
                host.setNwwn("");
                strgSystem.add_host(host);
            }
            CloseableIterator<CIMInstance> strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", strgHWIDColInst.getObjectPath());
            while (strgHWIDInsts != null && strgHWIDInsts.hasNext()) {
                CIMInstance strgHWIDInst = (CIMInstance)strgHWIDInsts.next();
                StorageHardwareID strgHWID = new StorageHardwareID(this._wbclient, strgHWIDInst);
                host.add_strgHwid(strgHWID.getStorageID(), strgHWIDInst.getObjectPath());
                CloseableIterator<CIMInstance> privInsts = this.getAssociatorInstances("CIM_Privilege", strgHWIDInst.getObjectPath());
                if (privInsts == null || !privInsts.hasNext()) continue;
                CIMInstance privInst = (CIMInstance)privInsts.next();
                AuthorizedPrivilege authpriv = new AuthorizedPrivilege(this._wbclient, privInst);
                CloseableIterator<CIMInstance> pcInsts = this.getAssociatorInstances("CIM_ProtocolController", privInst.getObjectPath());
                if (pcInsts == null || !pcInsts.hasNext()) continue;
                CIMInstance pcInst = (CIMInstance)pcInsts.next();
                ArrayList<String> scsiPEPwwns = new ArrayList<String>();
                CloseableIterator<CIMInstance> fcPortInsts = this.getAssociatorInstances("cim_FCPort", pcInst.getObjectPath());
                while (fcPortInsts != null && fcPortInsts.hasNext()) {
                    CIMInstance fcPortInst = (CIMInstance)fcPortInsts.next();
                    scsiPEPwwns.add((String)fcPortInst.getPropertyValue("PermanentAddress"));
                }
                ArrayList<String> devices = new ArrayList<String>();
                CloseableIterator<CIMInstance> pc4UInsts = this.getReferenceInstances("CIM_ProtocolControllerForUnit", pcInst.getObjectPath());
                while (pc4UInsts != null && pc4UInsts.hasNext()) {
                    CIMInstance pc4UInst = (CIMInstance)pc4UInsts.next();
                    ProtocolControllerForUnit pc4U = new ProtocolControllerForUnit(this._wbclient, pc4UInst);
                    if (devices.contains(pc4U.getDeviceNumber())) continue;
                    devices.add(pc4U.getDeviceNumber());
                    CIMObjectPath strgHWIDOP = strgHWIDInst.getObjectPath();
                    CIMInstance strgVolInst = this.getInstance(pc4U.getDependent());
                    if (strgVolInst == null) continue;
                    StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
                    int strgHWIDType = strgHWID.getIDType().intValue();
                    boolean accessGranted = authpriv.getPrivilegeGranted();
                    String strgLun = strgVol.getDeviceID();
                    String mappedLun = pc4U.getDeviceNumber();
                    int lunAccess = pc4U.getDeviceAccess().intValue();
                    for (String protoEndPtWWN : scsiPEPwwns) {
                        HostLunMapping hostLunMap = new HostLunMapping(strgHWID.getStorageID(), "", "", protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
                        Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                        lun.add_hostLunMap(hostLunMap);
                        host.add_hostLunMap(hostLunMap);
                    }
                }
            }
        }
    }

    private void fetchHostandMap(CIMInstance strgVolInst, StorageVolume strgVol, StorageSystem strgSystem) {
        ArrayList<String> devices = new ArrayList<String>();
        CloseableIterator<CIMInstance> pc4UInsts = this.getReferenceInstances("CIM_ProtocolControllerForUnit", strgVolInst.getObjectPath());
        while (pc4UInsts != null && pc4UInsts.hasNext()) {
            CIMInstance pc4UInst = (CIMInstance)pc4UInsts.next();
            ProtocolControllerForUnit pc4U = new ProtocolControllerForUnit(this._wbclient, pc4UInst);
            devices.add(pc4U.getDeviceNumber());
            CIMInstance pcInst = this.getInstance(pc4U.getAntecedent());
            if (pcInst == null) continue;
            ArrayList<String> scsiPEPwwns = new ArrayList<String>();
            CloseableIterator<CIMInstance> fcPortInsts = this.getAssociatorInstances("CIM_FCPort", pcInst.getObjectPath());
            while (fcPortInsts != null && fcPortInsts.hasNext()) {
                CIMInstance fcPortInst = (CIMInstance)fcPortInsts.next();
                scsiPEPwwns.add((String)fcPortInst.getPropertyValue("PermanentAddress"));
            }
            CloseableIterator<CIMInstance> privInsts = this.getAssociatorInstances("CIM_Privilege", pcInst.getObjectPath());
            while (privInsts != null && privInsts.hasNext()) {
                CIMInstance privInst = (CIMInstance)privInsts.next();
                AuthorizedPrivilege authpriv = new AuthorizedPrivilege(this._wbclient, privInst);
                CloseableIterator<CIMInstance> strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", privInst.getObjectPath());
                while (strgHWIDInsts != null && strgHWIDInsts.hasNext()) {
                    Host host;
                    CIMInstance strgHWIDInst = (CIMInstance)strgHWIDInsts.next();
                    StorageHardwareID strgHWID = new StorageHardwareID(this._wbclient, strgHWIDInst);
                    String hostName = strgHWID.getElementName();
                    if (hostName != null && (host = strgSystem.get_host(hostName)) == null) {
                        host = new Host(hostName);
                        host.setNwwn("");
                        strgSystem.add_host(host);
                        host.add_strgHwid(strgHWID.getStorageID(), strgHWIDInst.getObjectPath());
                    }
                    boolean accessGranted = authpriv.getPrivilegeGranted();
                    String strgLun = strgVol.getDeviceID();
                    String mappedLun = pc4U.getDeviceNumber();
                    int lunAccess = pc4U.getDeviceAccess().intValue();
                    for (String protoEndPtWWN : scsiPEPwwns) {
                        HostLunMapping hostLunMap = new HostLunMapping(strgHWID.getStorageID(), hostName, "", protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
                        Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                        lun.add_hostLunMap(hostLunMap);
                        Host host2 = strgSystem.get_host(hostName);
                        if (host2 == null) continue;
                        host2.add_hostLunMap(hostLunMap);
                    }
                }
            }
        }
    }

    private Map<CIMObjectPath, Pool> fetchStoragePools(CIMInstance comSysInst, StorageSystem strgSystem) {
        HashMap<CIMObjectPath, Pool> pools = new HashMap<CIMObjectPath, Pool>();
        CloseableIterator<CIMInstance> strgPoolInsts = this.getAssociatorInstances("CIM_StoragePool", comSysInst.getObjectPath());
        while (strgPoolInsts != null && strgPoolInsts.hasNext()) {
            long usedSpace;
            CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
            StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
            long rawcapacity = -1L;
            String raidLevel = null;
            CloseableIterator<CIMInstance> arrayGroupInsts = this.getAssociatorInstances("HITACHI_ArrayGroup", strgPoolInst.getObjectPath());
            if (arrayGroupInsts != null && arrayGroupInsts.hasNext()) {
                StorageExtent arrGrp = new StorageExtent(this._wbclient, (CIMInstance)arrayGroupInsts.next());
                raidLevel = arrGrp.getErrorMethodology();
            }
            long totalManagedSpace = strgPool.getTotalManagedSpace().longValue();
            long remainingManagedSpace = strgPool.getRemainingManagedSpace().longValue();
            int per_sub = 0;
            if (totalManagedSpace > 0L && (usedSpace = totalManagedSpace - remainingManagedSpace) > 0L) {
                per_sub = (int)(usedSpace * 100L / totalManagedSpace);
            }
            UnsignedInteger16[] uint16 = strgPool.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            Pool pool = strgSystem.get_pool(strgPool.getElementName());
            if (pool == null) {
                pool = new Pool(strgPool.getElementName(), rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, raidLevel, null);
                strgSystem.add_pool(pool);
            } else {
                pool.update(rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, raidLevel, null);
            }
            pools.put(strgPoolInst.getObjectPath(), pool);
        }
        return pools;
    }

    private Map<Integer, Lun> fetchLun(CIMInstance comSysInst, StorageSystem strgSystem, Map<CIMObjectPath, Pool> strgPools, boolean doMap) {
        HashMap<Integer, Lun> _luns = new HashMap<Integer, Lun>();
        CloseableIterator<CIMInstance> strgVolInsts = this.getAssociatorInstances("CIM_StorageVolume", comSysInst.getObjectPath());
        while (strgVolInsts != null && strgVolInsts.hasNext()) {
            CIMInstance strgVolInst = (CIMInstance)strgVolInsts.next();
            StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
            UnsignedInteger16[] uint16 = strgVol.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            Lun lun = null;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            String raidType = strgVol.getErrorMethodology();
            CloseableIterator<CIMInstance> afSPlInsts = this.getReferenceInstances("CIM_AllocatedFromStoragePool", strgVolInst.getObjectPath());
            while (afSPlInsts != null && afSPlInsts.hasNext()) {
                StringBuilder poolName = new StringBuilder();
                CIMInstance afsCimInstance = (CIMInstance)afSPlInsts.next();
                long spaceConsumed = ((UnsignedInteger64)afsCimInstance.getPropertyValue("SpaceConsumed")).longValue();
                CIMObjectPath poolObj = (CIMObjectPath)afsCimInstance.getPropertyValue("Antecedent");
                Pool pool = strgPools.get(poolObj);
                if (pool == null) continue;
                poolName.append(pool.get_pKey()._name);
                lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                if (lun == null) {
                    lun = new Lun(strgVol.getName(), strgVol.getDeviceID(), null, poolName.toString(), strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), spaceConsumed, status, raidType, null, "", "");
                    strgSystem.add_lun(lun);
                } else {
                    lun.update(null, poolName.toString(), strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), spaceConsumed, status, raidType, null, "", "");
                }
                _luns.put(Integer.parseInt(lun.get_pKey().get_lunId()), lun);
            }
            if (!doMap) continue;
            this.fetchMaskingMappingView(strgVolInst, lun, strgSystem);
        }
        return _luns;
    }

    private void fetchMaskingMappingView(CIMInstance strgVolInst, Lun lun, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> maskmapViewInsts = this.getReferenceInstances("SNIA_MaskingMappingView", strgVolInst.getObjectPath(), PropertyList.HDSMaskingViewProperties);
        while (maskmapViewInsts != null && maskmapViewInsts.hasNext()) {
            CIMInstance maskmapViewInst = (CIMInstance)maskmapViewInsts.next();
            CIMObjectPath strgHWIDOP = this.getPropertyObjectPath(maskmapViewInst, "StorageHardwareID");
            String protoEndPtWWN = this.getPropertyString(maskmapViewInst, "SPEPName");
            String strgHWID = this.getPropertyString(maskmapViewInst, "SHIDStorageID");
            String initID = "Host";
            String nwwn = "";
            nwwn = strgHWID.length() > 16 ? strgHWID.substring(0, 16) : strgHWID;
            boolean accessGranted = this.getPropertyBoolean(maskmapViewInst, "APPrivilegeGranted");
            String strgLun = this.getPropertyString(maskmapViewInst, "LDDeviceID");
            String mappedLun = this.getPropertyString(maskmapViewInst, "PCFUDeviceNumber");
            int lunAccess = this.getPropertyUint16(maskmapViewInst, "PCFUDeviceAccess");
            String initAlias = strgHWID;
            HostLunMapping hostLunMap = new HostLunMapping(strgHWID, initID, initAlias, protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
            lun.add_hostLunMap(hostLunMap);
            Host host = strgSystem.get_host(initAlias);
            if (host == null) {
                host = new Host(initAlias);
                host.setNwwn(nwwn);
                strgSystem.add_host(host);
            }
            host.add_strgHwid(strgHWID, strgHWIDOP);
            host.add_hostLunMap(hostLunMap);
        }
    }
}

