/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.smis.client.cim.AuthorizedPrivilege;
import com.cisco.dcbu.smis.client.cim.BlockStorageStatisticalData;
import com.cisco.dcbu.smis.client.cim.Collection;
import com.cisco.dcbu.smis.client.cim.DiskDrive;
import com.cisco.dcbu.smis.client.cim.LogicalDisk;
import com.cisco.dcbu.smis.client.cim.PhysicalPackage;
import com.cisco.dcbu.smis.client.cim.ProtocolControllerForUnit;
import com.cisco.dcbu.smis.client.cim.SoftwareIdentity;
import com.cisco.dcbu.smis.client.cim.StorageExtent;
import com.cisco.dcbu.smis.client.cim.StorageHardwareID;
import com.cisco.dcbu.smis.client.cim.StoragePool;
import com.cisco.dcbu.smis.client.cim.StorageVolume;
import com.cisco.dcbu.smis.client.snia.LocalFileSystem;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.DiskPool;
import com.cisco.dcbu.storage.model.FilerVolume;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.StorageStatistics;
import com.cisco.dcbu.storage.model.StorageSystem;
import com.cisco.dcbu.storage.model.StorageSystemStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class NetappDiscoveryHandler
extends StorageDiscoveryHandler {
    private static boolean debug = true;
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");

    @Override
    public void discover(ArrayList<StorageSystem> strgSystems) {
        ArrayList<CIMInstance> regProfs = this.fetchRegisteredArrayProfiles();
        if (regProfs.size() > 0) {
            ArrayList<CIMInstance> comSysInsts = this.fetchTopLevelComputerSystem(regProfs);
            for (CIMInstance comSysInst : comSysInsts) {
                StorageSystem strgSystem = this.fetchComputerSystemPhysical(comSysInst);
                if (strgSystem == null || strgSystem.get_vendor() == null || strgSystem.get_pKey()._name == null || strgSystem.get_serialNumber() == null) continue;
                int index = strgSystems.indexOf(strgSystem);
                if (index >= 0) {
                    StorageSystem oldStrgSystem = strgSystems.get(index);
                    oldStrgSystem.update(strgSystem.get_nwwns(), strgSystem.get_storageType(), strgSystem.get_vendor(), strgSystem.get_version(), strgSystem.get_model(), strgSystem.get_partNumber(), strgSystem.get_serialNumber());
                    strgSystem = oldStrgSystem;
                } else {
                    strgSystem.set_provider(this._provider);
                    strgSystems.add(strgSystem);
                }
                Map<CIMObjectPath, Pool> strgPools = this.fetchStoragePools(comSysInst, strgSystem);
                this.fetchComputerSystemPorts(comSysInst, null, strgSystem);
                this.fetchDiskDrive(comSysInst, strgSystem);
                this.fetchLun(comSysInst, strgSystem, strgPools);
                this.fetchHostandMap(comSysInst, strgSystem);
                this.fetchFilerVolume(comSysInst, strgSystem);
            }
        }
    }

    @Override
    public void perfCollection(StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> statsColInsts = this.getAssociatorInstances("CIM_StatisticsCollection", strgSystem.get_objPath());
        StorageStatistics storageStat = null;
        if (statsColInsts != null && statsColInsts.hasNext()) {
            HashMap<Integer, StorageSystemStatistics> hs = new HashMap<Integer, StorageSystemStatistics>();
            CIMInstance statsColInst = (CIMInstance)statsColInsts.next();
            if (statsColInst != null) {
                CloseableIterator<CIMInstance> statsInsts = this.getAssociatorInstances("CIM_BlockStorageStatisticalData", statsColInst.getObjectPath());
                while (statsInsts != null && statsInsts.hasNext()) {
                    CIMInstance statsInst = (CIMInstance)statsInsts.next();
                    BlockStorageStatisticalData stat = new BlockStorageStatisticalData(this._wbclient, statsInst);
                    switch (stat.getElementType().intValue()) {
                        case 2: {
                            storageStat = this.fetchArrayStats(statsInst);
                            break;
                        }
                        case 3: {
                            storageStat = this.fetchAdapterStats(statsInst);
                            break;
                        }
                        case 6: {
                            storageStat = this.fetchPortStats(statsInst);
                            break;
                        }
                        case 8: {
                            storageStat = this.fetchVolumeStats(statsInst);
                            break;
                        }
                        case 10: {
                            storageStat = this.fetchDiskStats(statsInst);
                            break;
                        }
                        default: {
                            storageStat = null;
                        }
                    }
                    if (storageStat == null) continue;
                    StorageSystemStatistics sss = (StorageSystemStatistics)hs.get(new Integer(stat.getElementType().intValue()));
                    if (sss == null) {
                        sss = new StorageSystemStatistics(stat.getElementName(), stat.getElementType().intValue());
                        hs.put(new Integer(stat.getElementType().intValue()), sss);
                    }
                    sss.add_strgstat(storageStat);
                }
                if (!hs.isEmpty()) {
                    strgSystem.getStatsList().addAll(hs.values());
                }
            }
        }
    }

    private void fetchDiskDrive(CIMInstance comSysInst, StorageSystem strgSystem) {
        ComponentSystem comp = strgSystem.get_comp(strgSystem.get_pKey()._name);
        if (comp == null) {
            comp = new ComponentSystem(strgSystem.get_pKey()._name);
            strgSystem.add_comp(comp);
        } else {
            comp.update();
        }
        CloseableIterator<CIMInstance> diskDrvInsts = this.getAssociatorInstances("CIM_DiskDrive", comSysInst.getObjectPath());
        while (diskDrvInsts != null && diskDrvInsts.hasNext()) {
            CIMInstance diskDrvInst = (CIMInstance)diskDrvInsts.next();
            DiskDrive diskDrive = new DiskDrive(this._wbclient, diskDrvInst);
            long rawCapacity = -1L;
            long userCapacity = -1L;
            long speed = -1L;
            CloseableIterator<CIMInstance> diskPhyPkgInsts = this.getAssociatorInstances("CIM_PhysicalPackage", diskDrvInst.getObjectPath());
            if (diskPhyPkgInsts == null || !diskPhyPkgInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_PhysicalPackage for " + diskDrive.getName()));
                return;
            }
            CIMInstance diskPhyPkgInst = (CIMInstance)diskPhyPkgInsts.next();
            PhysicalPackage diskPhyPkg = new PhysicalPackage(this._wbclient, diskPhyPkgInst);
            CloseableIterator<CIMInstance> softwareIdInsts = this.getAssociatorInstances("CIM_SoftwareIdentity", diskDrvInst.getObjectPath());
            if (softwareIdInsts == null || !softwareIdInsts.hasNext()) {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + diskDrive.getName()));
                return;
            }
            CIMInstance softwareIdInst = (CIMInstance)softwareIdInsts.next();
            SoftwareIdentity swId = new SoftwareIdentity(this._wbclient, softwareIdInst);
            CloseableIterator<CIMInstance> diskExtInsts = this.getAssociatorInstances("CIM_StorageExtent", diskDrvInst.getObjectPath());
            CIMInstance diskExtInst = null;
            if (diskExtInsts != null && diskExtInsts.hasNext()) {
                diskExtInst = (CIMInstance)diskExtInsts.next();
                StorageExtent diskExtent = new StorageExtent(this._wbclient, diskExtInst);
                rawCapacity = diskExtent.getNumberOfBlocks().longValue() * diskExtent.getBlockSize().longValue();
                userCapacity = diskExtent.getConsumableBlocks().longValue() * diskExtent.getBlockSize().longValue();
                if (diskExtInst.getPropertyValue("DiskRPM") != null) {
                    speed = ((UnsignedInteger16)diskExtInst.getPropertyValue("DiskRPM")).intValue();
                }
            } else {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + diskDrive.getName()));
                return;
            }
            UnsignedInteger16[] uint16 = diskDrive.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            CloseableIterator<CIMInstance> strgPoolInsts = this.getAssociatorInstances("ONTAP_ConcretePool", diskExtInst.getObjectPath());
            String extendstripe = null;
            String spName = "";
            ArrayList<DiskPool> poolList = new ArrayList<DiskPool>();
            while (strgPoolInsts != null && strgPoolInsts.hasNext()) {
                CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
                StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
                spName = strgPool.getElementName();
                poolList.add(new DiskPool(spName));
            }
            Disk disk = comp.get_disk(diskDrive.getName());
            DiskPool[] pList = poolList.toArray(new DiskPool[0]);
            if (disk == null) {
                disk = new Disk(diskDrive.getName(), null, rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), extendstripe, pList, status, null, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), speed, speed);
                comp.add_disk(disk);
                continue;
            }
            disk.update(null, rawCapacity, userCapacity, -1L, diskDrive.getHealthState().intValue(), extendstripe, pList, status, null, diskPhyPkg.getManufacturer(), diskPhyPkg.getModel(), diskPhyPkg.getSerialNumber(), "", swId.getVersionString(), speed, speed);
        }
    }

    private void fetchLun(CIMInstance comSysInst, StorageSystem strgSystem, Map<CIMObjectPath, Pool> strgPools) {
        CloseableIterator<CIMInstance> strgVolInsts = this.getAssociatorInstances("CIM_StorageVolume", comSysInst.getObjectPath());
        while (strgVolInsts != null && strgVolInsts.hasNext()) {
            CIMInstance strgVolInst = (CIMInstance)strgVolInsts.next();
            StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
            String wwn = null;
            if (strgVol.getOtherIdentifyingInfo() != null) {
                wwn = strgVol.getOtherIdentifyingInfo()[0];
            }
            UnsignedInteger16[] uint16 = strgVol.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            StringBuilder poolName = new StringBuilder();
            CloseableIterator<CIMInstance> afSPlInsts = this.getReferenceInstances("CIM_AllocatedFromStoragePool", strgVolInst.getObjectPath());
            while (afSPlInsts != null && afSPlInsts.hasNext()) {
                CIMInstance afSPlInst = (CIMInstance)afSPlInsts.next();
                CIMObjectPath poolObj = (CIMObjectPath)afSPlInst.getPropertyValue("Antecedent");
                Pool pool = strgPools.get(poolObj);
                poolName.append(pool.get_pKey()._name);
                Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                if (lun == null) {
                    lun = new Lun(strgVol.getElementName(), strgVol.getDeviceID(), wwn, poolName.toString(), strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), -1L, strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), status, null, null, "", "");
                    strgSystem.add_lun(lun);
                    continue;
                }
                lun.update(wwn, poolName.toString(), strgVol.getBlockSize().longValue() * strgVol.getNumberOfBlocks().longValue(), -1L, strgVol.getBlockSize().longValue() * strgVol.getConsumableBlocks().longValue(), status, null, null, "", "");
            }
        }
    }

    private void fetchFilerVolume(CIMInstance comSysInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> logicalDiskInsts = this.getAssociatorInstances("CIM_LogicalDisk", comSysInst.getObjectPath());
        while (logicalDiskInsts != null && logicalDiskInsts.hasNext()) {
            CIMInstance logicalDiskInst = (CIMInstance)logicalDiskInsts.next();
            LogicalDisk ldisk = new LogicalDisk(this._wbclient, logicalDiskInst);
            CloseableIterator<CIMInstance> localFSInsts = this.getAssociatorInstances("ONTAP_LocalFS", logicalDiskInst.getObjectPath());
            if (localFSInsts == null || !localFSInsts.hasNext()) continue;
            CIMInstance localFSInst = (CIMInstance)localFSInsts.next();
            LocalFileSystem localFS = new LocalFileSystem(this._wbclient, localFSInst);
            long availableCap = localFS.getAvailableSpace().longValue();
            long totalCap = localFS.getFileSystemSize().longValue();
            long usedCap = 0L;
            if (totalCap > 0L) {
                usedCap = (totalCap - availableCap) * 100L / totalCap;
            }
            String aggregate = null;
            CloseableIterator<CIMInstance> strgPoolInsts = this.getAssociatorInstances("ONTAP_ConcretePool", logicalDiskInst.getObjectPath());
            if (strgPoolInsts != null && strgPoolInsts.hasNext()) {
                CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
                StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
                aggregate = strgPool.getElementName();
            }
            UnsignedInteger16[] uint16 = ldisk.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            long totalCapacity = ldisk.getConsumableBlocks().longValue() * ldisk.getBlockSize().longValue();
            FilerVolume vol = strgSystem.get_filerVol(ldisk.getElementName());
            if (vol == null) {
                vol = new FilerVolume(ldisk.getElementName(), availableCap, usedCap, totalCap, -1L, -1L, aggregate, status);
                strgSystem.add_filervol(vol);
                continue;
            }
            vol.update(availableCap, usedCap, totalCap, -1L, -1L, aggregate, status);
        }
    }

    private void fetchHostandMap(CIMInstance comSysInst, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> strgHWIDColInsts = this.getAssociatorInstances("ONTAP_HardwareIDCollection", comSysInst.getObjectPath());
        while (strgHWIDColInsts != null && strgHWIDColInsts.hasNext()) {
            CIMInstance strgHWIDColInst = (CIMInstance)strgHWIDColInsts.next();
            Collection strgHWIDCol = new Collection(this._wbclient, strgHWIDColInst);
            String hostName = strgHWIDCol.getElementName();
            if (hostName == null) continue;
            Host host = strgSystem.get_host(hostName);
            if (host == null) {
                host = new Host(hostName);
                host.setNwwn("");
                strgSystem.add_host(host);
            }
            CloseableIterator<CIMInstance> strgHWIDInsts = this.getAssociatorInstances("CIM_StorageHardwareID", strgHWIDColInst.getObjectPath());
            while (strgHWIDInsts != null && strgHWIDInsts.hasNext()) {
                CIMInstance strgHWIDInst = (CIMInstance)strgHWIDInsts.next();
                StorageHardwareID strgHWID = new StorageHardwareID(this._wbclient, strgHWIDInst);
                host.add_strgHwid(strgHWID.getStorageID(), strgHWIDInst.getObjectPath());
                CloseableIterator<CIMInstance> privInsts = this.getAssociatorInstances("CIM_Privilege", strgHWIDInst.getObjectPath());
                if (privInsts == null || !privInsts.hasNext()) continue;
                CIMInstance privInst = (CIMInstance)privInsts.next();
                AuthorizedPrivilege authpriv = new AuthorizedPrivilege(this._wbclient, privInst);
                CloseableIterator<CIMInstance> pcInsts = this.getAssociatorInstances("CIM_ProtocolController", privInst.getObjectPath());
                if (pcInsts == null || !pcInsts.hasNext()) continue;
                CIMInstance pcInst = (CIMInstance)pcInsts.next();
                ArrayList<String> scsiPEPwwns = new ArrayList<String>();
                CloseableIterator<CIMInstance> fcPortInsts = this.getAssociatorInstances("CIM_FCPort", pcInst.getObjectPath());
                while (fcPortInsts != null && fcPortInsts.hasNext()) {
                    CIMInstance fcPortInst = (CIMInstance)fcPortInsts.next();
                    scsiPEPwwns.add((String)fcPortInst.getPropertyValue("PermanentAddress"));
                }
                ArrayList<String> devices = new ArrayList<String>();
                CloseableIterator<CIMInstance> pc4UInsts = this.getReferenceInstances("CIM_ProtocolControllerForUnit", pcInst.getObjectPath());
                while (pc4UInsts != null && pc4UInsts.hasNext()) {
                    CIMInstance pc4UInst = (CIMInstance)pc4UInsts.next();
                    ProtocolControllerForUnit pc4U = new ProtocolControllerForUnit(this._wbclient, pc4UInst);
                    if (devices.contains(pc4U.getDeviceNumber())) continue;
                    devices.add(pc4U.getDeviceNumber());
                    CIMObjectPath strgHWIDOP = strgHWIDInst.getObjectPath();
                    CIMInstance strgVolInst = this.getInstance(pc4U.getDependent());
                    if (strgVolInst == null) continue;
                    StorageVolume strgVol = new StorageVolume(this._wbclient, strgVolInst);
                    int strgHWIDType = strgHWID.getIDType().intValue();
                    boolean accessGranted = authpriv.getPrivilegeGranted();
                    String strgLun = strgVol.getDeviceID();
                    String mappedLun = pc4U.getDeviceNumber();
                    int lunAccess = pc4U.getDeviceAccess().intValue();
                    for (String protoEndPtWWN : scsiPEPwwns) {
                        HostLunMapping hostLunMap = new HostLunMapping(strgHWID.getStorageID(), hostName, "", protoEndPtWWN, strgSystem.get_adapter(protoEndPtWWN), strgLun, mappedLun, lunAccess, accessGranted);
                        Lun lun = strgSystem.get_lun(strgVol.getDeviceID(), strgVol.getElementName());
                        if (lun != null) {
                            lun.add_hostLunMap(hostLunMap);
                        }
                        host.add_hostLunMap(hostLunMap);
                    }
                }
            }
        }
    }

    private Map<CIMObjectPath, Pool> fetchStoragePools(CIMInstance comSysInst, StorageSystem strgSystem) {
        HashMap<CIMObjectPath, Pool> pools = new HashMap<CIMObjectPath, Pool>();
        CloseableIterator<CIMInstance> strgPoolInsts = this.getAssociatorInstances("ONTAP_ConcretePool", comSysInst.getObjectPath());
        while (strgPoolInsts != null && strgPoolInsts.hasNext()) {
            StorageExtent stextent;
            CIMInstance extentInst;
            CIMInstance strgPoolInst = (CIMInstance)strgPoolInsts.next();
            StoragePool strgPool = new StoragePool(this._wbclient, strgPoolInst);
            long rawcapacity = -1L;
            String extendstripe = null;
            long totalManagedSpace = strgPool.getTotalManagedSpace().longValue();
            long remainingManagedSpace = strgPool.getRemainingManagedSpace().longValue();
            int per_sub = 0;
            if (totalManagedSpace > 0L) {
                per_sub = (int)((totalManagedSpace - remainingManagedSpace) * 100L / totalManagedSpace);
            }
            if (strgPool.getPrimordial().booleanValue()) continue;
            CloseableIterator<CIMInstance> extentInsts = this.getAssociatorInstances("ONTAP_ConcreteExtent", strgPoolInst.getObjectPath());
            if (extentInsts != null && extentInsts.hasNext()) {
                extentInst = (CIMInstance)extentInsts.next();
                stextent = new StorageExtent(this._wbclient, extentInst);
                rawcapacity = stextent.getNumberOfBlocks().longValue() * stextent.getBlockSize().longValue();
            } else {
                extentInsts = this.getAssociatorInstances("ONTAP_FlexVolExtent", strgPoolInst.getObjectPath());
                if (extentInsts != null && extentInsts.hasNext()) {
                    extentInst = (CIMInstance)extentInsts.next();
                    if ((extentInsts = this.getAssociatorInstances("ONTAP_ConcreteExtent", extentInst.getObjectPath())) != null && extentInsts.hasNext()) {
                        extentInst = (CIMInstance)extentInsts.next();
                        stextent = new StorageExtent(this._wbclient, extentInst);
                        rawcapacity = stextent.getNumberOfBlocks().longValue() * stextent.getBlockSize().longValue();
                    } else {
                        _Logger.warn((Object)("Error: Failed to get ONTAP_ConcreteExtent/ONTAP_FlexVolExtent for " + strgPool.getPoolID()));
                    }
                }
            }
            UnsignedInteger16[] uint16 = strgPool.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            Pool pool = strgSystem.get_pool(strgPool.getElementName());
            if (pool == null) {
                pool = new Pool(strgPool.getElementName(), rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, extendstripe, null);
                strgSystem.add_pool(pool);
            } else {
                pool.update(rawcapacity, totalManagedSpace, remainingManagedSpace, -1L, -1L, per_sub, status, extendstripe, null);
            }
            pools.put(strgPoolInst.getObjectPath(), pool);
        }
        return pools;
    }

    public void run() {
    }
}

