/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SSLHandler {
    private static SSLHandler _Instance = null;
    private static final String KEYPASS = "fmserver_1_2_3";
    static Logger logger = LogManager.getLogger((String)"fms.smis");
    private static boolean needReset = false;
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLHandler getInstance() {
        if (_Instance != null) {
            return _Instance;
        }
        Class<SSLHandler> clazz = SSLHandler.class;
        synchronized (SSLHandler.class) {
            if (_Instance == null) {
                _Instance = new SSLHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _Instance;
        }
    }

    private SSLHandler() {
    }

    public CallResultDO check(String host, int port) {
        CallResultDO res = new CallResultDO();
        if (needReset) {
            res.setResultStatus(-1);
            res.setResultMessage("Trust Certificate(s) added.  You must restart DCNM Service before adding this data source");
            return res;
        }
        String trustStore = System.getProperty("javax.net.ssl.trustStore");
        File file = new File(trustStore);
        if (!file.isFile()) {
            res.setResultStatus(-1);
            res.setResultMessage("Unable to access truststore.");
            return res;
        }
        logger.info((Object)("Loading KeyStore " + file + "..."));
        try {
            FileInputStream in = new FileInputStream(file);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(in, KEYPASS.toCharArray());
            ((InputStream)in).close();
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            logger.info((Object)("Opening connection to " + host + ":" + port + "..."));
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(10000);
            try {
                logger.info((Object)"Starting SSL handshake...");
                socket.startHandshake();
                socket.close();
                logger.info((Object)"No errors, certificate is already trusted");
                res.setResultStatus(0);
                res.setResultMessage("Success");
                return res;
            }
            catch (SSLException e) {
                logger.info((Object)("SSL Exception::" + e.getMessage()));
                X509Certificate[] chain = tm.chain;
                if (chain == null) {
                    res.setResultStatus(-1);
                    res.setResultMessage("Could not obtain server certificate chain.");
                    return res;
                }
                for (int k = 0; k < chain.length; ++k) {
                    X509Certificate cert = chain[k];
                    String alias = host + "-" + (k + 1);
                    ks.setCertificateEntry(alias, cert);
                    logger.info((Object)"Adding certificate");
                    logger.info((Object)cert);
                }
                FileOutputStream out = new FileOutputStream(trustStore);
                ks.store(out, KEYPASS.toCharArray());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            res.setResultStatus(-1);
            res.setResultMessage("Could not obtain server certificate chain.");
            return res;
        }
        res.setResultStatus(-1);
        needReset = true;
        res.setResultMessage("Trust Certificate(s) added.  You must restart DCNM Service before adding this data source");
        return res;
    }

    private static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 3);
        for (int n : bytes) {
            sb.append(HEXDIGITS[(n &= 0xFF) >> 4]);
            sb.append(HEXDIGITS[n & 0xF]);
            sb.append(' ');
        }
        return sb.toString();
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager tm;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager tm) {
            this.tm = tm;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
            this.tm.checkServerTrusted(chain, authType);
        }
    }
}

