/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.smis.client.cim.BlockStorageStatisticalData;
import com.cisco.dcbu.smis.client.cim.ComputerSystem;
import com.cisco.dcbu.smis.client.cim.FCPort;
import com.cisco.dcbu.smis.client.cim.PhysicalPackage;
import com.cisco.dcbu.smis.client.cim.SoftwareIdentity;
import com.cisco.dcbu.storage.discovery.CIMDiscoveryHandler;
import com.cisco.dcbu.storage.model.DiskStatistics;
import com.cisco.dcbu.storage.model.FrontEndAdapterStatistics;
import com.cisco.dcbu.storage.model.LunStatistics;
import com.cisco.dcbu.storage.model.StorageArrayStatistics;
import com.cisco.dcbu.storage.model.StoragePort;
import com.cisco.dcbu.storage.model.StoragePortStatistics;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.util.ArrayList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.CloseableIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class StorageDiscoveryHandler
extends CIMDiscoveryHandler {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");

    protected StorageDiscoveryHandler() {
    }

    public abstract void discover(ArrayList<StorageSystem> var1);

    public abstract void perfCollection(StorageSystem var1);

    protected ArrayList<CIMInstance> fetchRegisteredArrayProfiles() {
        ArrayList<CIMInstance> regProfInsts = new ArrayList<CIMInstance>();
        CloseableIterator<CIMInstance> regProfs = this.enumerateInstances("CIM_RegisteredProfile", this._provider.getInteropns(), null);
        while (regProfs != null && regProfs.hasNext()) {
            CIMInstance regProfInst = (CIMInstance)regProfs.next();
            String rgstrVersion = this.getPropertyString(regProfInst, "RegisteredVersion");
            String restrName = this.getPropertyString(regProfInst, "RegisteredName");
            if (!rgstrVersion.equals("1.4.0") && !rgstrVersion.equals("1.5.0") && !rgstrVersion.equals("1.6.0") || !restrName.equals("Array")) continue;
            regProfInsts.add(regProfInst);
        }
        if (regProfInsts.size() == 0) {
            _Logger.warn((Object)(this._provider.getVendor() + "Discovery handler found no registered Array profiles for interop@provider= " + this._provider.getInteropns() + "@" + this._provider.getUrl()));
        }
        return regProfInsts;
    }

    protected ArrayList<CIMInstance> fetchTopLevelComputerSystem(ArrayList<CIMInstance> regProfInsts) {
        ArrayList<CIMInstance> computerSysInsts = new ArrayList<CIMInstance>();
        CloseableIterator<CIMInstance> comSysInsts = null;
        for (CIMInstance regProfInst : regProfInsts) {
            comSysInsts = regProfInst.toString().contains("HITACHI") ? this.getAssociatorInstances("HITACHI_StorageSystem", regProfInst.getObjectPath(), null) : this.getAssociatorInstances("CIM_ComputerSystem", regProfInst.getObjectPath(), null);
            while (comSysInsts != null && comSysInsts.hasNext()) {
                CIMInstance comSysInst = (CIMInstance)comSysInsts.next();
                if (computerSysInsts.contains(comSysInst)) continue;
                computerSysInsts.add(comSysInst);
            }
        }
        if (computerSysInsts.size() == 0) {
            _Logger.warn((Object)(this._provider.getVendor() + "Discovery handler did not find top level storage systems for Array profiles for interop@provider= " + this._provider.getInteropns() + "@" + this._provider.getUrl()));
        }
        return computerSysInsts;
    }

    protected StorageSystem fetchComputerSystemPhysical(CIMInstance comSysInst) {
        ComputerSystem comsys = new ComputerSystem(this._wbclient, comSysInst);
        _Logger.info((Object)("Discovering Storage: " + comsys.getElementName() + " using provider: " + this._provider.getUrl()));
        UnsignedInteger16[] dedicatedTypes = comsys.getDedicated();
        String[] storageType = new String[dedicatedTypes.length];
        int st = 0;
        block8: for (UnsignedInteger16 dedicated : dedicatedTypes) {
            switch (dedicated.intValue()) {
                case 3: {
                    storageType[st++] = "Storage";
                    continue block8;
                }
                case 15: {
                    storageType[st++] = "Block Storage";
                    continue block8;
                }
                case 16: {
                    storageType[st++] = "Filer Storage";
                    continue block8;
                }
                case 21: {
                    storageType[st++] = "Storage Virtualizer";
                    continue block8;
                }
                case 25: {
                    storageType[st++] = "Self-contained NAS";
                    continue block8;
                }
                case 26: {
                    storageType[st++] = "UPS";
                }
            }
        }
        PhysicalPackage phypac = this.fetchPhyscialPackage(comSysInst.getObjectPath());
        if (phypac == null) {
            _Logger.warn((Object)("Error: Failed to get CIM_PhysicalPackage for " + comsys.getElementName()));
        } else if (phypac.getSerialNumber() == null && comsys.getCreationClassName().startsWith("IBM")) {
            phypac.setSerialNumber(phypac.getTag());
        }
        SoftwareIdentity swId = this.fetchSoftwareIdentity(comSysInst.getObjectPath());
        if (swId == null) {
            _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + comsys.getElementName()));
        }
        StorageSystem strgSystem = new StorageSystem(comsys.getElementName(), null, storageType, phypac != null ? phypac.getManufacturer() : null, swId != null ? swId.getVersionString() : null, phypac != null ? phypac.getModel() : null, phypac != null ? phypac.getPartNumber() : null, phypac != null ? phypac.getSerialNumber() : null);
        strgSystem.set_objPath(comSysInst.getObjectPath());
        strgSystem.set_storageSystemClassName(comsys.getCreationClassName());
        return strgSystem;
    }

    protected void fetchComputerSystemPorts(CIMInstance strgProcInst, StorageProcessor strgProc, StorageSystem strgSystem) {
        CloseableIterator<CIMInstance> portInsts = this.getAssociatorInstances("CIM_LogicalPort", strgProcInst.getObjectPath());
        while (portInsts != null && portInsts.hasNext()) {
            CIMInstance portInst = (CIMInstance)portInsts.next();
            FCPort fcport = new FCPort(this._wbclient, portInst);
            String nwaddr = null;
            if (fcport.getNetworkAddresses() != null) {
                nwaddr = fcport.getNetworkAddresses()[0];
            }
            String permAddr = null;
            if (fcport.getPermanentAddress() != null) {
                permAddr = fcport.getPermanentAddress();
            }
            int portType = -1;
            if (fcport.getPortType() != null) {
                portType = fcport.getPortType().intValue();
            }
            long speed = -1L;
            if (fcport.getSpeed() != null) {
                speed = fcport.getSpeed().longValue();
            }
            String[] desc = null;
            if (portInst.getPropertyValue("PortDiscriminator") != null) {
                Object descobj = portInst.getPropertyValue("PortDiscriminator");
                if (descobj instanceof String[]) {
                    desc = (String[])descobj;
                } else if (descobj instanceof UnsignedInteger16[]) {
                    UnsignedInteger16[] descuint = (UnsignedInteger16[])descobj;
                    desc = new String[descuint.length];
                    int i = 0;
                    for (UnsignedInteger16 tempuint16 : descuint) {
                        desc[i++] = Integer.toString(tempuint16.intValue());
                    }
                }
            }
            String portId = fcport.getElementName();
            if (desc != null && desc[0].equals("SNIA:FCoE")) {
                portId = portId + "_FCoE";
            }
            int portNumber = 0;
            if (fcport.getPortNumber() != null) {
                portNumber = fcport.getPortNumber().intValue();
            }
            int usage = -1;
            if (fcport.getUsageRestriction() != null) {
                usage = fcport.getUsageRestriction().intValue();
            } else if (strgSystem.get_vendor().equals("HITACHI") && portInst.getObjectPath().toString().contains("EthernetPort")) {
                usage = 2;
                portId = portId + "_" + fcport.getDeviceID();
            }
            if (portId == null && strgSystem.get_vendor().equals("IBM")) {
                portId = fcport.getDeviceID();
            }
            StoragePort port = null;
            int linkTech = -1;
            if (fcport.getLinkTechnology() != null) {
                linkTech = fcport.getLinkTechnology().intValue();
            }
            UnsignedInteger16[] uint16 = fcport.getOperationalStatus();
            long[] status = new long[uint16.length];
            int cnt = 0;
            for (UnsignedInteger16 unt16 : uint16) {
                status[cnt++] = unt16.longValue();
            }
            block0 : switch (usage) {
                case 2: {
                    switch (linkTech) {
                        case 2: {
                            port = new StoragePort(new NameKey(portId), portNumber, portType, nwaddr, permAddr, desc, speed, usage, status);
                            break block0;
                        }
                    }
                    port = new StoragePort(new NameKey(portId), portNumber, portType, nwaddr, permAddr, speed, usage, status);
                    break;
                }
                case 3: {
                    port = new StoragePort(new NameKey(portId), portNumber, portType, speed, usage, status);
                }
            }
            if (strgProc != null) {
                strgProc.add_port(port);
            }
            strgSystem.add_port(port);
        }
    }

    protected StorageArrayStatistics fetchArrayStats(CIMInstance statsInst) {
        return new StorageArrayStatistics(new BlockStorageStatisticalData(this._wbclient, statsInst));
    }

    protected FrontEndAdapterStatistics fetchAdapterStats(CIMInstance statsInst) {
        return new FrontEndAdapterStatistics(new BlockStorageStatisticalData(this._wbclient, statsInst));
    }

    protected DiskStatistics fetchDiskStats(CIMInstance statsInst) {
        return new DiskStatistics(new BlockStorageStatisticalData(this._wbclient, statsInst));
    }

    protected LunStatistics fetchVolumeStats(CIMInstance statsInst) {
        return new LunStatistics(new BlockStorageStatisticalData(this._wbclient, statsInst));
    }

    protected StoragePortStatistics fetchPortStats(CIMInstance statsInst) {
        return new StoragePortStatistics(new BlockStorageStatisticalData(this._wbclient, statsInst));
    }

    protected PhysicalPackage fetchPhyscialPackage(CIMObjectPath objPath) {
        CIMInstance[] phyPkgInsts = this.getAssociatorInstancesNew("CIM_PhysicalPackage", objPath, null);
        if (phyPkgInsts.length > 0) {
            return new PhysicalPackage(this._wbclient, phyPkgInsts[0]);
        }
        _Logger.warn((Object)("Error: Failed to get CIM_PhysicalPackage for " + objPath.toString()));
        return null;
    }

    protected SoftwareIdentity fetchSoftwareIdentity(CIMObjectPath objPath) {
        CIMInstance[] softwareIdInsts = null;
        SoftwareIdentity softwareId = null;
        if (objPath.toString().contains("hitachi")) {
            CloseableIterator<CIMInstance> strgprocsysInsts = this.getAssociatorInstances("Hitachi_StorageProcessorSystem", objPath);
            if (strgprocsysInsts != null && strgprocsysInsts.hasNext()) {
                CIMInstance strgprocsysInst = (CIMInstance)strgprocsysInsts.next();
                softwareIdInsts = this.getAssociatorInstancesNew("CIM_SoftwareIdentity", strgprocsysInst.getObjectPath(), null);
                softwareId = new SoftwareIdentity(this._wbclient, softwareIdInsts[0]);
            }
        } else {
            softwareIdInsts = this.getAssociatorInstancesNew("CIM_SoftwareIdentity", objPath, null);
            if (softwareIdInsts.length > 0) {
                softwareId = new SoftwareIdentity(this._wbclient, softwareIdInsts[0]);
            } else {
                _Logger.warn((Object)("Error: Failed to get CIM_SoftwareIdentity for " + objPath.toString()));
            }
        }
        return softwareId;
    }

    public long[] unit16arrayTolongarray(UnsignedInteger16[] uint16) {
        long[] longa = new long[uint16.length];
        int cnt = 0;
        for (UnsignedInteger16 unt16 : uint16) {
            longa[cnt++] = unt16.longValue();
        }
        return longa;
    }
}

