/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.discovery.EMCDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.HDSDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.NetappDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.OtherDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.StorageWorker;
import com.cisco.dcbu.storage.discovery.TESTDiscoveryHandler;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class StorageImpl {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    public static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};
    public static int _DefRediscInterval;
    public static int _DefPollInterval;
    private StorageWorker _worker = null;
    private Provider _provider;
    private SMISBaseModelObject _base;
    private ArrayList<StorageSystem> _storageSystems = new ArrayList();
    public static final String VALUE_NONE = "none";
    public static final String VALUE_NA = "n/a";
    private transient int _maxWait = 3300;
    private int _pollInterval = _DefPollInterval;
    private int _rediscInterval = _DefRediscInterval;

    public StorageImpl(Provider provider) {
        this._provider = provider;
    }

    public void scheduleRefresh(int delay) {
        if (this._worker == null) {
            return;
        }
        this._worker.start();
    }

    boolean isRefreshScheduled() {
        return this._worker != null && (this._worker.getState() == 1 || this._worker.getState() == 2);
    }

    public synchronized StorageWorker getWorker() {
        if (this._worker == null) {
            this._worker = this._provider.getVendor().equalsIgnoreCase("netapp") ? new StorageWorker<NetappDiscoveryHandler>(this, NetappDiscoveryHandler.class, this._pollInterval) : (this._provider.getVendor().equalsIgnoreCase("emc") ? new StorageWorker<EMCDiscoveryHandler>(this, EMCDiscoveryHandler.class, this._pollInterval) : (this._provider.getVendor().equalsIgnoreCase("hds") ? new StorageWorker<HDSDiscoveryHandler>(this, HDSDiscoveryHandler.class, this._pollInterval) : (this._provider.getVendor().equalsIgnoreCase("test") ? new StorageWorker<TESTDiscoveryHandler>(this, TESTDiscoveryHandler.class, this._pollInterval) : new StorageWorker<OtherDiscoveryHandler>(this, OtherDiscoveryHandler.class, this._pollInterval))));
            this._worker.setProvider(this._provider);
        }
        return this._worker;
    }

    public long getDiscoveryTimeout() {
        return this._maxWait * 1000;
    }

    public String getName() {
        return "storageImpl";
    }

    public void close(boolean cleanCache) throws Exception {
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)"storage-- closing", (Throwable)new NullPointerException("To track storage close"));
        }
        if (this._worker != null) {
            try {
                SchedulerSingleton.getInstance().removeTask(this._worker);
            }
            catch (Exception ex) {
                _Logger.warn((Object)"Failed to remove worker thread");
            }
            this._worker.stop();
            this._worker = null;
        }
    }

    public int getRediscoverInterval() {
        return this._rediscInterval;
    }

    public void setLastUpdateTime(long time) {
        this._base.setLastUpdateTime(time);
    }

    public long getLastUpdateTime() {
        return this._base.getLastUpdateTime();
    }

    public void setLastScanTime(long time) {
        this._base.setLastScanTime(time);
    }

    public long getLastScanTime() {
        return this._base.getLastScanTime();
    }

    public ArrayList<StorageSystem> getStorageSystemList() {
        return this._storageSystems;
    }

    public Provider getProvider() {
        return this._provider;
    }

    public void setProvider(Provider _provider) {
        this._provider = _provider;
    }

    public String dump(boolean detail) {
        StringBuilder sb = new StringBuilder("Storage Systems");
        sb.append("\n").append(this.dumpStorageSystems(detail, 1));
        return sb.toString();
    }

    public String dumpStorageSystems(boolean detail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of Storage Systems: ").append(this._storageSystems.size());
        for (StorageSystem sys : this._storageSystems) {
            sb.append(sys.dump(detail, level));
        }
        return sb.toString();
    }

    static {
        Integer n = Integer.getInteger("storage.rediscoverinterval");
        _DefRediscInterval = n == null || n <= 0 ? 12 : n;
        n = Integer.getInteger("storage.pollinterval");
        _DefPollInterval = n == null || n < 300 ? 300 : n;
    }
}

