/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.discovery;

import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.ScheduledTask;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.model.StorageEnclosureImpl;
import com.cisco.dcbu.storage.db.ProviderHelper;
import com.cisco.dcbu.storage.db.SMISHandler;
import com.cisco.dcbu.storage.db.StorageSystemHelper;
import com.cisco.dcbu.storage.discovery.CIMDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.discovery.StorageWorkerIf;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class StorageWorker<E extends StorageDiscoveryHandler>
extends ScheduledTask
implements StorageWorkerIf {
    static Logger _Logger = LogManager.getLogger((String)"fms.smis");
    static final int DISC_ALL = 65535;
    AtomicInteger _status = new AtomicInteger(0);
    private StorageImpl _storageImpl;
    private Provider _provider;
    boolean _timeout = false;
    int _pollNumber = 0;
    private Lock runlocker = new ReentrantLock();
    boolean _needRediscover = false;
    private int _pollInterval = 0;
    private boolean _cleanupScheduled = false;
    protected E _discHandler;

    public StorageWorker(StorageImpl storageImpl, Class<E> discHandler, int pollInterval) {
        super(storageImpl.getName(), new Schedule(pollInterval * 1000, (long)(pollInterval * 1000), false));
        SchedulerSingleton.getInstance().addTask(this);
        this._storageImpl = storageImpl;
        this._pollInterval = pollInterval;
        try {
            this._discHandler = (StorageDiscoveryHandler)discHandler.newInstance();
        }
        catch (InstantiationException e) {
            _Logger.error((Object)"Storage worker Exception ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            _Logger.error((Object)"Storage worker Exception ", (Throwable)e);
        }
    }

    public String checkCredentials() {
        try {
            String check = ((CIMDiscoveryHandler)this._discHandler).validateClient();
            if (check != null) {
                this._status.set(6);
            }
            return check;
        }
        catch (Exception e) {
            _Logger.error((Object)"Storage Worker Exception checking credentials ", (Throwable)e);
            return "Unknown Exception Occurred";
        }
    }

    public String checkConnection() {
        try {
            String check = ((CIMDiscoveryHandler)this._discHandler).validateClient();
            if (check != null) {
                this._status.set(7);
            }
            return check;
        }
        catch (Exception e) {
            _Logger.error((Object)"Storage Worker Exception checking connection ", (Throwable)e);
            return "Unknown Exception Occurred";
        }
    }

    public void discover(ArrayList<StorageSystem> strgSystems) {
        ((StorageDiscoveryHandler)this._discHandler).discover(strgSystems);
    }

    public void perfCollection(StorageSystem strgSystem) {
        ((StorageDiscoveryHandler)this._discHandler).perfCollection(strgSystem);
    }

    public void setProvider(Provider provider) {
        ((CIMDiscoveryHandler)this._discHandler).setProvider(provider);
        this._provider = provider;
    }

    private boolean isFinished() {
        return this._status.get() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStrorageSystemToFile(StorageSystem sys) {
        String writetofile = System.getProperty("storage.writetofile", "false");
        if (writetofile.equalsIgnoreCase("true")) {
            File dir = new File(ClientCache.getLogsDir() + "/storageSys");
            if (!dir.exists()) {
                dir.mkdir();
            }
            ObjectOutput output = null;
            try {
                output = new ObjectOutputStream(new FileOutputStream(ClientCache.getLogsDir() + "/storageSys/" + this._provider.getUrl() + "_" + sys.get_pKey()._name + "_StorageSystem.ser"));
                if (output != null) {
                    output.writeObject(sys);
                    output.close();
                }
            }
            catch (IOException ex) {
                _Logger.error((Object)("Cannot save storage system " + sys.get_pKey()._name), (Throwable)ex);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    _Logger.error((Object)"Storage Worker Exception writing to file ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProviderToFile(Provider provider) {
        String writetofile = System.getProperty("storage.writetofile", "false");
        if (writetofile.equalsIgnoreCase("true")) {
            File dir = new File(ClientCache.getLogsDir() + "/storageSys");
            if (!dir.exists()) {
                dir.mkdir();
            }
            ObjectOutput output = null;
            try {
                output = new ObjectOutputStream(new FileOutputStream(ClientCache.getLogsDir() + "/storageSys/" + this._provider.getUrl() + "_Provider.ser"));
                if (output != null) {
                    output.writeObject(provider);
                    output.close();
                }
            }
            catch (IOException ex) {
                _Logger.error((Object)("Cannot save provider " + provider.getUrl()), (Throwable)ex);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    _Logger.error((Object)"Storage Worker Exception writing to file ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discover() {
        if (this.isFinished()) {
            return;
        }
        ArrayList<StorageSystem> storageSystemList = this._storageImpl.getStorageSystemList();
        Connection con = null;
        SMISHandler h = SMISHandler.getInstance();
        if (this._provider == null) {
            this.setProvider(this._storageImpl.getProvider());
        }
        try {
            con = ConnectionManager.getConnection();
            Date startdate = new Date();
            if (this.isFinished()) {
                return;
            }
            _Logger.info((Object)("Start discovery for provider " + this._provider.getUrl() + " at " + startdate.toString()));
            this.discover(storageSystemList);
            Date enddate = new Date();
            _Logger.info((Object)("End discovery for provider " + this._provider.getUrl() + " at " + enddate.toString()));
            _Logger.info((Object)("Time Taken " + (enddate.getTime() - startdate.getTime())));
            if (storageSystemList.isEmpty()) {
                _Logger.info((Object)(this + " discovery is finished empty for provider" + this._provider.getUrl()));
                this._status.set(5);
                return;
            }
            if (this.isFinished()) {
                return;
            }
            this._provider.setLastUpdated(new Timestamp(System.currentTimeMillis()));
            ProviderHelper.persist(con, this._provider);
            StorageEnclosureImpl.persistStorageEnclosures(con);
            _Logger.info((Object)("discovery done, processing results we have " + storageSystemList.size() + " systems."));
            for (StorageSystem sys : storageSystemList) {
                if (this.isFinished()) {
                    return;
                }
                if (!sys.get_provider().equals(this._provider)) continue;
                _Logger.info((Object)("processing... " + sys.get_model() + " " + sys.get_serialNumber()));
                h.persistStorageSystem(con, this._provider, sys);
                System.out.println(sys.dump(false, 1));
                this.writeStrorageSystemToFile(sys);
            }
            this.writeProviderToFile(this._provider);
        }
        catch (Exception e) {
            _Logger.error((Object)"Storage Worker Exception during discovery ", (Throwable)e);
        }
        finally {
            DbUtil.close(con);
        }
    }

    public void start() {
        if (this._status.get() == 1) {
            _Logger.info((Object)(this + ": Attempted to start discovery at " + new Date() + " while previous still running"));
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " starts a storage discovery -- "));
        }
        DiscoveryManager.getInstance().getStorageWorkerExecutor().execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.runlocker.tryLock()) {
            try {
                block14: {
                    _Logger.info((Object)("Running storageWorker - status: " + this._status));
                    if (this._status.get() == 1) {
                        _Logger.info((Object)(this + ": Attempted to start discovery at " + new Date() + " while previous still running"));
                        return;
                    }
                    try {
                        if (this.isFinished()) {
                            _Logger.info((Object)("Breaking loop storageWorker - status: " + this._status));
                            break block14;
                        }
                        if (_Logger.isInfoEnabled()) {
                            _Logger.info((Object)(this + " starts a discovery"));
                        }
                        if (this._status.get() != 6) {
                            this._needRediscover = false;
                            this._status.set(1);
                            if (this.checkConnection() == null) {
                                this.discover();
                            }
                            if (_Logger.isInfoEnabled()) {
                                _Logger.info((Object)(this + " ends a discovery"));
                            }
                        }
                    }
                    catch (Throwable ex) {
                        this.setTimeout(true);
                        _Logger.error((Object)(this + " error: " + ex.getMessage()), ex);
                    }
                    this._status.compareAndSet(1, 5);
                }
                if (this._cleanupScheduled) {
                    this.cleanup();
                    this._cleanupScheduled = false;
                }
            }
            finally {
                this.runlocker.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResultDO scheduleCleanup() {
        CallResultDO res = new CallResultDO();
        if (this.runlocker.tryLock()) {
            try {
                this.cleanup();
            }
            catch (Exception exception) {
            }
            finally {
                this.runlocker.unlock();
            }
        } else {
            this._cleanupScheduled = true;
            res.setResultStatus(-1);
            res.setResultMessage("Cleanup is now scheduled to run after next discovery completes.");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        ArrayList<StorageSystem> storageSystemList = this._storageImpl.getStorageSystemList();
        Connection con = null;
        long now = System.currentTimeMillis();
        Timestamp expired = new Timestamp(now - (long)(this._pollInterval * 2000));
        try {
            con = ConnectionManager.getConnection();
            for (StorageSystem sys : storageSystemList) {
                StorageSystemHelper.cleanup(con, sys, expired);
            }
        }
        catch (Exception e) {
            _Logger.error((Object)"Storage Worker Exception during cleanup", (Throwable)e);
        }
        finally {
            DbUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(this + " stops the Storage worker"));
        }
        SchedulerSingleton.getInstance().removeTask(this);
        AtomicInteger atomicInteger = this._status;
        synchronized (atomicInteger) {
            if (this._status.get() == 1) {
                this._status.notifyAll();
            }
            this._status.set(2);
        }
    }

    @Override
    public int getStatus() {
        return this._status.get();
    }

    @Override
    public String getStatusDescr() {
        switch (this._status.get()) {
            case 0: 
            case 5: {
                if (this._storageImpl.getStorageSystemList().isEmpty()) {
                    return "Completed Empty";
                }
                return "Online";
            }
            case 1: {
                return "Active Discovery";
            }
            case 2: {
                return "Interrupted";
            }
            case 3: {
                return "Aborted";
            }
            case 4: {
                return "Timed out";
            }
            case 6: {
                return "Failed Authentication";
            }
            case 7: {
                return "Connection Failed";
            }
        }
        return "Unknown";
    }

    public boolean isTimedOut() {
        return this._timeout;
    }

    void resetTimeout() {
        this._timeout = false;
    }

    void setTimeout(boolean timeout) {
        this._timeout |= timeout;
    }

    public int getPollInterval() {
        return this._pollInterval;
    }

    public void setPollInterval(int pollInterval) {
        this._pollInterval = pollInterval;
    }

    public String toString() {
        return "StorageWorker [_provider=" + this._provider + "]";
    }
}

