/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.MappingUtility;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.DiskLun;
import com.cisco.dcbu.storage.model.DiskPool;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import javax.cim.CIMObjectPath;

public class Disk
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private NameKey _pKey;
    private String _driveType = "";
    private long _rawCapacity;
    private long _userCapacity;
    private long _userSectors;
    private int _state;
    private String _raidType = "";
    private long[] _status;
    private DiskLun[] _luns;
    private DiskPool[] _pools;
    private String _manufacturer = "";
    private String _model = "";
    private String _serialNumber = "";
    private String _partNumber = "";
    private String _firmwareRev = "";
    private long _currSpeed;
    private long _maxSpeed;
    private CIMObjectPath _objPath = null;

    public Disk() {
    }

    public Disk(String _diskName, String _drivetype, long _rawcapacity, long _usercapacity, long _userSectors, int _state, String _raidType, DiskPool[] _pools, long[] _status, DiskLun[] _luns, String _manufacturer, String _model, String _serialNumber, String _partNumber, String _firmwareRev, long _currSpeed, long _maxSpeed) {
        this();
        this._pKey = new NameKey(_diskName);
        this._driveType = _drivetype;
        this._rawCapacity = _rawcapacity;
        this._userCapacity = _usercapacity;
        this._userSectors = _userSectors;
        this._state = _state;
        this._raidType = _raidType;
        this._pools = _pools;
        this._status = _status;
        this._luns = _luns;
        this._manufacturer = _manufacturer;
        this._model = _model;
        this._serialNumber = _serialNumber;
        this._partNumber = _partNumber;
        this._firmwareRev = _firmwareRev;
        this._currSpeed = _currSpeed;
        this._maxSpeed = _maxSpeed;
        this._base.setModified(true);
    }

    public String dump(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Disk-Name=").append(this._pKey._name == null ? "" : this._pKey._name).append(", Drive-Type=").append(this._driveType == null ? "" : this._driveType).append(", Raw-Capacity=").append(this._rawCapacity).append(", User-Capacity=").append(this._userCapacity).append(", User-Sectors=").append(this._userSectors).append(", Manufacturer=").append(this._manufacturer == null ? "" : this._manufacturer).append(", Model=").append(this._model == null ? "" : this._model).append(", Serial-Number=").append(this._serialNumber == null ? "" : this._serialNumber).append(", Part-Number=").append(this._partNumber == null ? "" : this._partNumber).append(", State=").append(this._state).append(", Storage-Pools=").append(this._pools == null ? "" : this._pools).append(", Raid-Type=").append(this._raidType == null ? "" : this._raidType).append(", Luns=").append(this._luns == null ? "" : this._luns).append(", Firmware-Rev=").append(this._firmwareRev == null ? "" : this._firmwareRev).append(", Status=").append(Arrays.toString(this._status)).append(", Max-Speed=").append(this._maxSpeed).append(", Curr-Speed=").append(this._currSpeed);
        return sb.toString();
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(String drivetype, long rawcapacity, long usercapacity, long userSectors, int state, String raidType, DiskPool[] pools, long[] status, DiskLun[] _luns, String manufacturer, String model, String serialNumber, String partNumber, String firmwareRev, long currSpeed, long maxSpeed) {
        this.set_driveType(drivetype);
        this.set_rawCapacity(rawcapacity);
        this.set_userCapacity(usercapacity);
        this.set_userSectors(userSectors);
        this.set_raidType(raidType);
        this.set_status(status);
        this.set_manufacturer(manufacturer);
        this.set_model(model);
        this.set_serialNumber(serialNumber);
        this.set_partNumber(partNumber);
        this.set_firmwareRev(firmwareRev);
        this.set_currSpeed(currSpeed);
        this.set_maxSpeed(maxSpeed);
        this.set_pools(pools);
        this.set_luns(_luns);
        this._base.setPresent(true);
    }

    public String get_driveType() {
        return this._driveType;
    }

    public void set_driveType(String _driveType) {
        if (!SMISHelper.equals(this._driveType, _driveType)) {
            this._driveType = _driveType;
            this._base.setModified(true);
        }
    }

    public long get_rawCapacity() {
        return this._rawCapacity;
    }

    public void set_rawCapacity(long _rawCapacity) {
        if (this._rawCapacity != _rawCapacity) {
            this._rawCapacity = _rawCapacity;
            this._base.setModified(true);
        }
    }

    public long get_userCapacity() {
        return this._userCapacity;
    }

    public void set_userCapacity(long _userCapacity) {
        if (this._userCapacity != _userCapacity) {
            this._userCapacity = _userCapacity;
            this._base.setModified(true);
        }
    }

    public long get_userSectors() {
        return this._userSectors;
    }

    public void set_userSectors(long _userSectors) {
        if (this._userSectors != _userSectors) {
            this._userSectors = _userSectors;
            this._base.setModified(true);
        }
    }

    public int get_state() {
        return this._state;
    }

    public void set_state(int _state) {
        if (this._state != _state) {
            this._state = _state;
            this._base.setModified(true);
        }
    }

    public String get_raidType() {
        return this._raidType;
    }

    public void set_raidType(String _raidType) {
        if (!SMISHelper.equals(this._raidType, _raidType)) {
            this._raidType = _raidType;
            this._base.setModified(true);
        }
    }

    public DiskPool[] get_pools() {
        return this._pools;
    }

    public void set_pools(DiskPool[] _pools) {
        this._pools = _pools;
    }

    public DiskLun[] get_luns() {
        return this._luns;
    }

    public void set_luns(DiskLun[] _luns) {
        if (!Arrays.equals(_luns, this._luns)) {
            this._luns = _luns;
            this._base.setModified(true);
        }
    }

    public String get_manufacturer() {
        return this._manufacturer;
    }

    public void set_manufacturer(String _manufacturer) {
        if (!SMISHelper.equals(this._manufacturer, _manufacturer)) {
            this._manufacturer = _manufacturer;
            this._base.setModified(true);
        }
    }

    public String get_model() {
        return this._model;
    }

    public void set_model(String _model) {
        if (!SMISHelper.equals(this._model, _model)) {
            this._model = _model;
            this._base.setModified(true);
        }
    }

    public String get_serialNumber() {
        return this._serialNumber;
    }

    public void set_serialNumber(String _serialNumber) {
        if (!SMISHelper.equals(this._serialNumber, _serialNumber)) {
            this._serialNumber = _serialNumber;
            this._base.setModified(true);
        }
    }

    public String get_partNumber() {
        return this._partNumber;
    }

    public void set_partNumber(String _partNumber) {
        if (!SMISHelper.equals(this._partNumber, _partNumber)) {
            this._partNumber = _partNumber;
            this._base.setModified(true);
        }
    }

    public String get_firmwareRev() {
        return this._firmwareRev;
    }

    public void set_firmwareRev(String _firmwareRev) {
        if (!SMISHelper.equals(this._firmwareRev, _firmwareRev)) {
            this._firmwareRev = _firmwareRev;
            this._base.setModified(true);
        }
    }

    public long get_currSpeed() {
        return this._currSpeed;
    }

    public void set_currSpeed(long _currSpeed) {
        if (this._currSpeed != _currSpeed) {
            this._currSpeed = _currSpeed;
            this._base.setModified(true);
        }
    }

    public long get_maxSpeed() {
        return this._maxSpeed;
    }

    public void set_maxSpeed(long _maxSpeed) {
        if (this._maxSpeed != _maxSpeed) {
            this._maxSpeed = _maxSpeed;
            this._base.setModified(true);
        }
    }

    public long[] get_status() {
        return this._status;
    }

    public void set_status(long[] _status) {
        if (!Arrays.equals(_status, this._status)) {
            this._status = _status;
            this._base.setModified(true);
        }
    }

    public String getStatusAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long status : this._status) {
            String str = MappingUtility.getStatusMapping((int)status, false);
            if (str.length() == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }

    public NameKey get_pKey() {
        return this._pKey;
    }

    public void set_pKey(NameKey _pKey) {
        if (!SMISHelper.equals(this._pKey, _pKey)) {
            this._pKey = _pKey;
            this._base.setModified(true);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Disk)) {
            return false;
        }
        Disk p = (Disk)o;
        if (this._pKey != null && this._pKey.equals(p._pKey)) {
            return true;
        }
        return this._pKey == null && p._pKey == null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof Disk)) {
            throw new ClassCastException();
        }
        Disk p = (Disk)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof Disk)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof Disk)) {
            throw new ClassCastException();
        }
        Disk p0 = (Disk)arg0;
        Disk p1 = (Disk)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    public String toString() {
        return "Disk [_pKey=" + this._pKey + "]";
    }
}

