/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.MappingUtility;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.StoragePort;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.cim.CIMObjectPath;

public class StorageProcessor
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private NameKey _pKey;
    private long _adapterNumber;
    private long _numPorts;
    private long _memsize;
    private String _serialNumber = "";
    private long _slotNumber;
    private long _readCache;
    private long _writeCache;
    private long[] _status;
    private String _ipaddress = "";
    private boolean _frontEndAdapter = false;
    private boolean _backendEndAdapter = false;
    private boolean _srdfAdapter = false;
    private CIMObjectPath _objPath = null;
    private ConcurrentHashMap<NameKey, StoragePort> _PortByPK = new ConcurrentHashMap();

    public StorageProcessor() {
    }

    public StorageProcessor(String _adapterName, long _adapterNumber, long _numPorts, long _memsize, String _serialNumber, long _slotNumber, long _readCache, long _writeCache, long[] _status, String _ipaddress, String[] roles) {
        this();
        this._pKey = new NameKey(_adapterName);
        this._adapterNumber = _adapterNumber;
        this._numPorts = _numPorts;
        this._memsize = _memsize;
        this._serialNumber = _serialNumber;
        this._slotNumber = _slotNumber;
        this._readCache = _readCache;
        this._writeCache = _writeCache;
        this._status = _status;
        this._ipaddress = _ipaddress;
        if (roles != null) {
            for (String role : roles) {
                if (role.equalsIgnoreCase("FRONT END")) {
                    this._frontEndAdapter = true;
                    continue;
                }
                if (role.equalsIgnoreCase("BACK END")) {
                    this._backendEndAdapter = true;
                    continue;
                }
                if (!role.equalsIgnoreCase("SRDF")) continue;
                this._srdfAdapter = true;
            }
        }
        this._base.setModified(true);
    }

    public String dump(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Adapter-Name=").append(this._pKey._name == null ? "" : this._pKey._name).append(", Number=").append(this._adapterNumber).append(", Slot=").append(this._slotNumber).append(", Serial-Number=").append(this._serialNumber == null ? "" : this._serialNumber).append(", NumOfPorts=").append(this._numPorts).append(", Mem-Size=").append(this._memsize).append(", Read-Cache=").append(this._readCache).append(", Write-Cache=").append(this._writeCache).append(", IP-Addr=").append(this._ipaddress == null ? "" : this._ipaddress).append(", Status=").append(Arrays.toString(this._status)).append(", Type=").append(this._frontEndAdapter ? "Front End" : (this._backendEndAdapter ? "Back End" : "SRDF")).append('\n').append(this.dumpStoragePort(level + 1));
        return sb.toString();
    }

    public String dumpStoragePort(int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Storage Ports: ").append(this._PortByPK.size());
        for (StoragePort port : this._PortByPK.values()) {
            port.dump(level);
        }
        return sb.toString();
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(long adapterNumber, long numPorts, long memsize, String serialNumber, long slotNumber, long readCache, long writeCache, long[] status, String ipaddress, String[] roles) {
        this.set_adapterNumber(adapterNumber);
        this.set_numPorts(numPorts);
        this.set_memsize(memsize);
        this.set_serialNumber(serialNumber);
        this.set_slotNumber(slotNumber);
        this.set_readCache(readCache);
        this.set_writeCache(writeCache);
        this.set_status(status);
        this.set_ipaddress(ipaddress);
        boolean front = false;
        boolean back = false;
        boolean srdf = false;
        if (roles != null) {
            for (String role : roles) {
                if (role.equalsIgnoreCase("FRONT END")) {
                    front = true;
                    continue;
                }
                if (role.equalsIgnoreCase("BACK END")) {
                    back = true;
                    continue;
                }
                if (!role.equalsIgnoreCase("SRDF")) continue;
                srdf = true;
            }
        }
        this.set_frontEndAdapter(front);
        this.set_backendEndAdapter(back);
        this.set_srdfAdapter(srdf);
        this._base.setPresent(true);
    }

    public long get_adapterNumber() {
        return this._adapterNumber;
    }

    public void set_adapterNumber(long _adapterNumber) {
        if (this._adapterNumber != _adapterNumber) {
            this._base.setModified(true);
            this._adapterNumber = _adapterNumber;
        }
    }

    public long get_numPorts() {
        return this._numPorts;
    }

    public void set_numPorts(long _numPorts) {
        if (this._numPorts != _numPorts) {
            this._base.setModified(true);
            this._numPorts = _numPorts;
        }
    }

    public long get_memsize() {
        return this._memsize;
    }

    public void set_memsize(long _memsize) {
        if (this._memsize != _memsize) {
            this._base.setModified(true);
            this._memsize = _memsize;
        }
    }

    public String get_serialNumber() {
        return this._serialNumber;
    }

    public void set_serialNumber(String _serialNumber) {
        if (SMISHelper.equals(_serialNumber, this._serialNumber)) {
            this._base.setModified(true);
            this._serialNumber = _serialNumber;
        }
    }

    public long get_slotNumber() {
        return this._slotNumber;
    }

    public void set_slotNumber(long _slotNumber) {
        if (this._slotNumber != _slotNumber) {
            this._base.setModified(true);
            this._slotNumber = _slotNumber;
        }
    }

    public long get_readCache() {
        return this._readCache;
    }

    public void set_readCache(long _readCache) {
        if (this._readCache != _readCache) {
            this._base.setModified(true);
            this._readCache = _readCache;
        }
    }

    public long get_writeCache() {
        return this._writeCache;
    }

    public void set_writeCache(long _writeCache) {
        if (this._writeCache != _writeCache) {
            this._base.setModified(true);
            this._writeCache = _writeCache;
        }
    }

    public long[] get_status() {
        return this._status;
    }

    public void set_status(long[] _status) {
        if (!Arrays.equals(_status, this._status)) {
            this._base.setModified(true);
            this._status = _status;
        }
    }

    public String getStatusAsString() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long status : this._status) {
            String str = MappingUtility.getStatusMapping((int)status, false);
            if (str.length() == 0) continue;
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    public NameKey get_pKey() {
        return this._pKey;
    }

    public void set_pKey(NameKey _pKey) {
        if (!SMISHelper.equals(_pKey, this._pKey)) {
            this._base.setModified(true);
            this._pKey = _pKey;
        }
    }

    public String get_ipaddress() {
        return this._ipaddress;
    }

    public void set_ipaddress(String _ipaddress) {
        if (!SMISHelper.equals(_ipaddress, this._ipaddress)) {
            this._base.setModified(true);
            this._ipaddress = _ipaddress;
        }
    }

    public Collection<StoragePort> get_ports() {
        return this._PortByPK.values();
    }

    public void add_port(StoragePort port) {
        if (!this._PortByPK.contains(port)) {
            this._base.setModified(true);
            this._PortByPK.put(port.get_pKey(), port);
        } else {
            StoragePort p = this.get_port(port.get_pKey()._name);
            if (p != null) {
                p.update(port);
            }
        }
    }

    public StoragePort get_port(String name) {
        return this._PortByPK.get(new NameKey(name));
    }

    public boolean is_frontEndAdapter() {
        return this._frontEndAdapter;
    }

    public void set_frontEndAdapter(boolean _frontEndAdapter) {
        if (this._frontEndAdapter != _frontEndAdapter) {
            this._base.setModified(true);
            this._frontEndAdapter = _frontEndAdapter;
        }
    }

    public boolean is_backendEndAdapter() {
        return this._backendEndAdapter;
    }

    public void set_backendEndAdapter(boolean _backendEndAdapter) {
        if (this._backendEndAdapter != _backendEndAdapter) {
            this._base.setModified(true);
            this._backendEndAdapter = _backendEndAdapter;
        }
    }

    public boolean is_srdfAdapter() {
        return this._srdfAdapter;
    }

    public void set_srdfAdapter(boolean _srdfAdapter) {
        if (this._srdfAdapter != _srdfAdapter) {
            this._base.setModified(true);
            this._srdfAdapter = _srdfAdapter;
        }
    }

    public String[] get_roles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (this._frontEndAdapter) {
            roles.add("FRONT END");
        }
        if (this._backendEndAdapter) {
            roles.add("BACK END");
        }
        if (this._srdfAdapter) {
            roles.add("SRDF");
        }
        return roles.toArray(new String[0]);
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StorageProcessor)) {
            return false;
        }
        StorageProcessor p = (StorageProcessor)o;
        if (this._pKey != null && this._pKey.equals(p._pKey)) {
            return true;
        }
        return this._pKey == null && p._pKey == null;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof StorageProcessor)) {
            throw new ClassCastException();
        }
        StorageProcessor p = (StorageProcessor)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof StorageProcessor)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof StorageProcessor)) {
            throw new ClassCastException();
        }
        StorageProcessor p0 = (StorageProcessor)arg0;
        StorageProcessor p1 = (StorageProcessor)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }

    public String toString() {
        return "StorageProcessor [_pKey=" + this._pKey + "]";
    }
}

