/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.model;

import com.cisco.dcbu.sm.common.type.LunPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.storage.db.SMISBaseModelObject;
import com.cisco.dcbu.storage.db.SMISHelper;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.FilerVolume;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.HostLunMapping;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Pool;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StoragePort;
import com.cisco.dcbu.storage.model.StorageProcessor;
import com.cisco.dcbu.storage.model.StorageSystemStatistics;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.cim.CIMObjectPath;

public class StorageSystem
extends AbstractDBObjectImpl
implements Comparator<Object>,
Comparable<Object>,
Serializable {
    static final long serialVersionUID = 1L;
    private SMISBaseModelObject _base = new SMISBaseModelObject();
    private NameKey _pKey;
    private long[] _nwwns;
    private String[] _storageType;
    private String _vendor = "";
    private String _version = "";
    private String _model = "";
    private String _serialNumber = "";
    private String _partNumber = "";
    private String _storageSystemClassName = null;
    private CIMObjectPath _objPath = null;
    private Provider _provider;
    private Timestamp lastUpdated;
    private ConcurrentHashMap<NameKey, ComponentSystem> _compByPK;
    private ConcurrentHashMap<NameKey, StorageProcessor> _strgprocByPK = new ConcurrentHashMap();
    private ConcurrentHashMap<NameKey, Pool> _poolByPK;
    private ConcurrentHashMap<LunPK, Lun> _lunByPK;
    private ConcurrentHashMap<NameKey, Host> _hostByPK;
    private ConcurrentHashMap<String, String> _storageByPort;
    private ConcurrentHashMap<NameKey, FilerVolume> _filerVolByPK;
    private ConcurrentHashMap<NameKey, StoragePort> _PortByPK;
    private ArrayList<StorageSystemStatistics> _statsList;

    public String dump(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("\nStorage-Name=").append(this._pKey._name == null ? "" : this._pKey._name).append(", Vendor=").append(this._vendor == null ? "" : this._vendor).append(", Model=").append(this._model == null ? "" : this._model).append(", Serial-Number=").append(this._serialNumber == null ? "" : this._serialNumber).append(", Part-Number=").append(this._partNumber == null ? "" : this._partNumber).append(", Version=").append(this._version == null ? "" : this._version).append(", Type=").append(Arrays.toString(this._storageType)).append(", Class=").append(this._storageSystemClassName == null ? "" : this._storageSystemClassName).append(", Provider=").append(this._provider.getUrl()).append("\n").append(this.dumpStorageProc(detail, level + 1)).append('\n').append(this.dumpCompSystem(detail, level + 1)).append('\n').append(this.dumpFilerVolume(detail, level + 1)).append('\n').append(this.dumpPool(detail, level + 1)).append('\n').append(this.dumpLun(detail, level + 1)).append('\n').append(this.dumpHost(detail, level + 1)).append('\n').append(this.dumpStoragePort(detail, level + 1));
        return sb.toString();
    }

    public String dumpStorageProc(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Storage Processors: ").append(this._strgprocByPK.size());
        if (detail) {
            for (StorageProcessor proc : this._strgprocByPK.values()) {
                sb.append(proc.dump(detail, level));
            }
        }
        return sb.toString();
    }

    public String dumpFilerVolume(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Filer Volumes: ").append(this._filerVolByPK.size());
        if (detail) {
            for (FilerVolume filerVol : this._filerVolByPK.values()) {
                sb.append(filerVol.dump(level));
            }
        }
        return sb.toString();
    }

    public String dumpPool(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Storage Pools: ").append(this._poolByPK.size());
        if (detail) {
            for (Pool pool : this._poolByPK.values()) {
                sb.append(pool.dump(level));
            }
        }
        return sb.toString();
    }

    public String dumpCompSystem(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Compomnent System: ").append(this._compByPK.size());
        if (detail) {
            for (ComponentSystem comp : this._compByPK.values()) {
                sb.append(comp.dump(level));
            }
        }
        return sb.toString();
    }

    public String dumpLun(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Storage LUNs: ").append(this._lunByPK.size());
        if (detail) {
            for (Lun lun : this._lunByPK.values()) {
                sb.append(lun.dump(level));
            }
        }
        return sb.toString();
    }

    public String dumpHost(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Hosts: ").append(this._hostByPK.size());
        if (detail) {
            for (Host host : this._hostByPK.values()) {
                sb.append(host.dump(level));
            }
        }
        return sb.toString();
    }

    public String dumpStoragePort(boolean detail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(StorageImpl.LIL[level]).append("Num of Storage Ports: ").append(this._PortByPK.size());
        if (detail) {
            for (StoragePort port : this._PortByPK.values()) {
                sb.append(port.dump(level));
            }
        }
        return sb.toString();
    }

    public StorageSystem() {
        this._compByPK = new ConcurrentHashMap();
        this._poolByPK = new ConcurrentHashMap();
        this._lunByPK = new ConcurrentHashMap();
        this._hostByPK = new ConcurrentHashMap();
        this._storageByPort = new ConcurrentHashMap();
        this._PortByPK = new ConcurrentHashMap();
        this._filerVolByPK = new ConcurrentHashMap();
        this._statsList = new ArrayList();
    }

    public StorageSystem(String _storageName, long[] _nwwns, String[] _storageType, String _vendor, String _version, String _model, String _partNumber, String _serialNumber) {
        this();
        this._pKey = new NameKey(_storageName);
        this._nwwns = _nwwns;
        this._storageType = _storageType;
        this._vendor = _vendor;
        this._version = _version;
        this._model = _model;
        this._partNumber = _partNumber;
        this._serialNumber = _serialNumber;
        this._base.setModified(true);
    }

    public boolean isModified() {
        return this._base.isModified();
    }

    public void clearModified() {
        this._base.clear();
    }

    public boolean isPresent() {
        return this._base.isPresent();
    }

    public void setPresent(boolean present) {
        if (this._base.isPresent() != present) {
            this._base.setPresent(present);
        }
    }

    public void setFlushed(boolean isFlushed) {
        this._base.setFlushed(isFlushed);
    }

    public void update(long[] _nwwns, String[] _storageType, String _vendor, String _version, String _model, String _partNumber, String _serialNumber) {
        this.set_nwwns(_nwwns);
        this.set_storageType(_storageType);
        this.set_vendor(_vendor);
        this.set_version(_version);
        this.set_model(_model);
        this.set_partNumber(_partNumber);
        this.set_serialNumber(_serialNumber);
        for (StorageProcessor p : this._strgprocByPK.values()) {
            p.setPresent(false);
        }
        for (Pool p : this._poolByPK.values()) {
            p.setPresent(false);
        }
        for (Lun p : this._lunByPK.values()) {
            p.setPresent(false);
            for (HostLunMapping hlm : p.get_hostLunMaps()) {
                hlm.setPresent(false);
            }
        }
        for (Host p : this._hostByPK.values()) {
            p.setPresent(false);
            for (HostLunMapping hlm : p.get_hostLunMaps()) {
                hlm.setPresent(false);
            }
        }
        for (ComponentSystem p : this._compByPK.values()) {
            p.setPresent(false);
            for (Disk d : p.get_disks()) {
                d.setPresent(false);
            }
        }
        for (StoragePort p : this._PortByPK.values()) {
            p.setPresent(false);
        }
        for (FilerVolume p : this._filerVolByPK.values()) {
            p.setPresent(false);
        }
    }

    public long[] get_nwwns() {
        return this._nwwns;
    }

    public void set_nwwns(long[] _nwwns) {
        if (!Arrays.equals(_nwwns, this._nwwns)) {
            this._nwwns = _nwwns;
            this._base.setModified(true);
        }
    }

    public String[] get_storageType() {
        return this._storageType;
    }

    public void set_storageType(String[] _storageType) {
        if (!Arrays.equals(_storageType, this._storageType)) {
            this._base.setModified(true);
            this._storageType = _storageType;
        }
    }

    public String get_vendor() {
        return this._vendor;
    }

    public void set_vendor(String _vendor) {
        if (!SMISHelper.equals(_vendor, this._vendor)) {
            this._base.setModified(true);
            this._vendor = _vendor;
        }
    }

    public String get_version() {
        return this._version;
    }

    public void set_version(String _version) {
        if (!SMISHelper.equals(_version, this._version)) {
            this._base.setModified(true);
            this._version = _version;
        }
    }

    public String get_model() {
        return this._model;
    }

    public void set_model(String _model) {
        if (!SMISHelper.equals(_model, this._model)) {
            this._base.setModified(true);
            this._model = _model;
        }
    }

    public String get_serialNumber() {
        return this._serialNumber;
    }

    public void set_serialNumber(String _serialNumber) {
        if (!SMISHelper.equals(_serialNumber, this._serialNumber)) {
            this._base.setModified(true);
            this._serialNumber = _serialNumber;
        }
    }

    public String get_partNumber() {
        return this._partNumber;
    }

    public void set_partNumber(String _partNumber) {
        if (!SMISHelper.equals(_partNumber, this._partNumber)) {
            this._base.setModified(true);
            this._partNumber = _partNumber;
        }
    }

    public Collection<StorageProcessor> get_strgprocs() {
        return this._strgprocByPK.values();
    }

    public void add_strgproc(StorageProcessor _strgproc) {
        this._strgprocByPK.put(_strgproc.get_pKey(), _strgproc);
    }

    public StorageProcessor get_strgproc(String adapterName) {
        return this._strgprocByPK.get(new NameKey(adapterName));
    }

    public Collection<ComponentSystem> get_comps() {
        return this._compByPK.values();
    }

    public void add_comp(ComponentSystem comp) {
        this._compByPK.put(comp.get_pKey(), comp);
    }

    public ComponentSystem get_comp(String compName) {
        return this._compByPK.get(new NameKey(compName));
    }

    public Collection<Lun> get_luns() {
        return this._lunByPK.values();
    }

    public void add_lun(Lun _lun) {
        this._lunByPK.putIfAbsent(_lun.get_pKey(), _lun);
    }

    public Lun get_lun(String lunName) {
        return this._lunByPK.get(new LunPK(null, lunName));
    }

    public Lun get_lun(String lunId, String lunName) {
        return this._lunByPK.get(new LunPK(lunId, lunName));
    }

    public Collection<Pool> get_pools() {
        return this._poolByPK.values();
    }

    public void add_pool(Pool _pool) {
        this._poolByPK.putIfAbsent(_pool.get_pKey(), _pool);
    }

    public Pool get_pool(String name) {
        return this._poolByPK.get(new NameKey(name));
    }

    public Collection<FilerVolume> get_filervols() {
        return this._filerVolByPK.values();
    }

    public void add_filervol(FilerVolume _filervol) {
        this._filerVolByPK.put(_filervol.get_pKey(), _filervol);
    }

    public FilerVolume get_filerVol(String name) {
        return this._filerVolByPK.get(new NameKey(name));
    }

    public Collection<Host> get_hosts() {
        return this._hostByPK.values();
    }

    public void add_host(Host _host) {
        this._hostByPK.put(_host.get_pKey(), _host);
    }

    public Host get_host(String hostName) {
        return this._hostByPK.get(new NameKey(hostName));
    }

    public void add_storageAdapter(String strgpwwn, String adapterName) {
        if (this.get_adapter(strgpwwn) == null) {
            this._storageByPort.put(strgpwwn, adapterName);
        }
    }

    public String get_adapter(String strgpwwn) {
        return this._storageByPort.get(strgpwwn);
    }

    public void setStatsList(ArrayList<StorageSystemStatistics> statsList) {
        this._statsList = statsList;
    }

    public ArrayList<StorageSystemStatistics> getStatsList() {
        return this._statsList;
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        return null;
    }

    @Override
    public String getDBTableName() {
        return null;
    }

    public NameKey get_pKey() {
        return this._pKey;
    }

    public void set_pKey(NameKey _pKey) {
        if (!SMISHelper.equals(this._pKey, _pKey)) {
            this._pKey = _pKey;
            this._base.setModified(true);
        }
    }

    public CIMObjectPath get_objPath() {
        return this._objPath;
    }

    public void set_objPath(CIMObjectPath _objPath) {
        this._objPath = _objPath;
    }

    public Collection<StoragePort> get_ports() {
        return this._PortByPK.values();
    }

    public void add_port(StoragePort port) {
        if (!this._PortByPK.contains(port)) {
            this._base.setModified(true);
            this._PortByPK.put(port.get_pKey(), port);
        } else {
            StoragePort p = this.get_port(port.get_pKey()._name);
            if (p != null) {
                p.update(port);
            }
        }
    }

    public StoragePort get_port(String name) {
        return this._PortByPK.get(new NameKey(name));
    }

    public String get_storageSystemClassName() {
        return this._storageSystemClassName;
    }

    public void set_storageSystemClassName(String _storageSystemClassName) {
        if (!SMISHelper.equals(this._storageSystemClassName, _storageSystemClassName)) {
            this._storageSystemClassName = _storageSystemClassName;
            this._base.setModified(true);
        }
    }

    public Provider get_provider() {
        return this._provider;
    }

    public void set_provider(Provider _provider) {
        this._provider = _provider;
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof StorageSystem) {
            StorageSystem obj = (StorageSystem)o;
            if (obj == this) {
                return true;
            }
            if (obj._pKey.equals(this._pKey)) {
                return true;
            }
            if (obj._serialNumber != null && obj._serialNumber.length() > 0 && obj._serialNumber.equals(this._serialNumber)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof StorageSystem)) {
            throw new ClassCastException();
        }
        StorageSystem p = (StorageSystem)arg0;
        if (this._pKey != null) {
            return this._pKey.compareTo(p._pKey);
        }
        if (p._pKey != null) {
            return p._pKey.hashCode();
        }
        return 0;
    }

    @Override
    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof StorageSystem)) {
            throw new ClassCastException();
        }
        if (!(arg1 instanceof StorageSystem)) {
            throw new ClassCastException();
        }
        StorageSystem p0 = (StorageSystem)arg0;
        StorageSystem p1 = (StorageSystem)arg1;
        if (p1._pKey != null) {
            return p1._pKey.compareTo(p0._pKey);
        }
        if (p0._pKey != null) {
            return p0._pKey.hashCode();
        }
        return 0;
    }

    public int hashCode() {
        if (this._pKey != null) {
            return this._pKey.hashCode();
        }
        return 0;
    }

    public String toString() {
        return "StorageSystem [_pKey=" + this._pKey + "]";
    }
}

