/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.test;

import com.cisco.dcbu.jaxws.san.wo.SMISNavItemDO;
import com.cisco.dcbu.jaxws.san.wo.SMISSystemDO;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.storage.db.ProviderHelper;
import com.cisco.dcbu.storage.db.SMISHandler;
import com.cisco.dcbu.storage.db.StorageSystemHelper;
import com.cisco.dcbu.storage.model.ComponentSystem;
import com.cisco.dcbu.storage.model.Disk;
import com.cisco.dcbu.storage.model.DiskLun;
import com.cisco.dcbu.storage.model.Host;
import com.cisco.dcbu.storage.model.Lun;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.SQLException;

public class SMISPopulate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            SMISHandler h = SMISHandler.getInstance();
            SMISNavItemDO[] list = h.getStorageSystemList(con);
            if (list == null || list.length == 0) {
                throw new Exception("wtf");
            }
            SMISSystemDO s = h.getStorageSystem(con, list[0].getDbid());
            long providerDbId = StorageSystemHelper.getProviderDbIdForSystem(con, s.getDbid());
            Provider provider = ProviderHelper.get(con, providerDbId);
            StorageSystem system = new StorageSystem();
            system.set_model(s.getModel());
            system.set_nwwns(system.get_nwwns());
            system.set_pKey(new NameKey(s.getName()));
            system.set_provider(provider);
            system.set_serialNumber(s.getSerialNumber());
            system.setDBID(s.getDbid());
            SMISPopulate.populateLuns(system, 20000, 10000);
            SMISPopulate.populateHosts(system, 10000, 5000);
            SMISPopulate.populateDisks(system, 20000, 10000);
            h.persistStorageSystem(con, provider, system);
        }
        catch (Exception e) {
            System.out.println("yeah... " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        System.exit(0);
    }

    public static void populateLuns(StorageSystem system, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            Lun obj = new Lun("" + i, Integer.toHexString(i), "" + i, "deadPool", 1024L, 1L, 1L, new long[]{0L, 1L}, "Raid 5", new String[]{"SATA"}, "A", "A");
            system.add_lun(obj);
        }
    }

    public static void populateHosts(StorageSystem system, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            Host obj = new Host("Host-" + Integer.toHexString(i));
            system.add_host(obj);
        }
    }

    public static void populateDisks(StorageSystem system, int start, int count) {
        ComponentSystem comp = new ComponentSystem("Test");
        system.add_comp(comp);
        for (int i = start; i < start + count; ++i) {
            DiskLun[] _luns = null;
            Disk obj = new Disk("Disk-" + Integer.toHexString(i), "SATA", 1234L, 496L, 1L, 0, "RAID5", null, new long[]{0L}, _luns, "Majik", "STR1101", "" + i, "PartN0111", "rev1.01", 10000L, 10000L);
            comp.add_disk(obj);
        }
    }
}

