/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.storage.test;

import com.cisco.dcbu.sm.common.type.ProviderPK;
import com.cisco.dcbu.storage.db.SMISHandler;
import com.cisco.dcbu.storage.discovery.EMCDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.NetappDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.StorageDiscoveryHandler;
import com.cisco.dcbu.storage.discovery.StorageImpl;
import com.cisco.dcbu.storage.discovery.StorageWorker;
import com.cisco.dcbu.storage.model.Provider;
import com.cisco.dcbu.storage.model.StorageSystem;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.wbem.client.WBEMClient;

public class StorageWorkerTest {
    WBEMClient wbclient = null;
    private static ArrayList<StorageSystem> _strgSystems = new ArrayList();
    StorageImpl impl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discover(Provider provider) {
        Connection con = null;
        SMISHandler h = SMISHandler.getInstance();
        try {
            System.out.println("getting con");
            Class.forName("org.postgresql.Driver").newInstance();
            con = DriverManager.getConnection("jdbc:postgresql://localhost:5432/dcmdb?user=admin&password=nbv_12345");
            System.out.println("got con");
            Date startdate = new Date();
            System.out.println("Start discovery for provider " + provider.getUrl() + " at " + startdate.toString());
            StorageWorker<StorageDiscoveryHandler> discoveyWorker = null;
            StorageImpl storageImpl = new StorageImpl(provider);
            if (provider.getVendor().equalsIgnoreCase("netapp")) {
                discoveyWorker = new StorageWorker<NetappDiscoveryHandler>(storageImpl, NetappDiscoveryHandler.class, 1);
            } else if (provider.getVendor().equalsIgnoreCase("emc")) {
                discoveyWorker = new StorageWorker<EMCDiscoveryHandler>(storageImpl, EMCDiscoveryHandler.class, 1);
            }
            Date enddate = new Date();
            System.out.println("End discovery for provider " + provider.getUrl() + " at " + enddate.toString());
            System.out.println("Time Taken " + (enddate.getTime() - startdate.getTime()));
            for (StorageSystem sys : _strgSystems) {
                if (!sys.get_provider().equals(provider)) continue;
                h.persistStorageSystem(con, provider, sys);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void getPerformaceCounters(StorageSystem sys) {
        Date startdate = new Date();
        System.out.println("Start performance for Storage system " + sys.get_pKey()._name + " at " + startdate.toString());
        StorageWorker<StorageDiscoveryHandler> discoveyWorker = null;
        StorageImpl storageImpl = new StorageImpl(sys.get_provider());
        if (sys.get_provider().getVendor().equalsIgnoreCase("netapp")) {
            discoveyWorker = new StorageWorker<NetappDiscoveryHandler>(storageImpl, NetappDiscoveryHandler.class, 1);
        } else if (sys.get_provider().getVendor().equalsIgnoreCase("emc")) {
            discoveyWorker = new StorageWorker<EMCDiscoveryHandler>(storageImpl, EMCDiscoveryHandler.class, 1);
        }
        Date enddate = new Date();
        System.out.println("End performace for Storage system " + sys.get_pKey()._name + " at " + enddate.toString());
        System.out.println("Time Taken " + (enddate.getTime() - startdate.getTime()));
    }

    public static void main(String[] args) {
        Provider[] providers = new Provider[6];
        int i = 0;
        providers[i++] = new Provider(new ProviderPK(), "/root/emc", "interop", "172.22.29.57", "admin", "#1Password", 5988, false, "emc");
        for (Provider provider : providers) {
            if (provider == null) continue;
            StorageWorkerTest.discover(provider);
        }
        System.out.println(" ");
        for (StorageSystem sys : _strgSystems) {
            sys.dump(true, 1);
        }
    }
}

