/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.tools.LearnDialog;
import com.cisco.dcbu.tools.Simulator;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

class AddDialog
extends JDialog
implements ActionListener,
KeyListener {
    static final String[] _Labels = new String[]{"IP Address:", "Agent File:", null, "UDP Port:", "Read Community:", "Write Community:"};
    JComponent[] _values;
    Simulator _parent;
    LearnDialog _learnDialog;

    public AddDialog(Simulator parent) {
        super((Frame)parent, parent.getTitle() + " - Add");
        this._parent = parent;
        this._values = new JComponent[_Labels.length];
        try {
            this._values[0] = new JTextField(InetAddress.getLocalHost().getHostAddress(), 15);
        }
        catch (UnknownHostException ex) {
            this._values[0] = new JTextField();
        }
        JButton browse = new JButton("...");
        browse.addActionListener(this);
        browse.setMargin(DialogUtil.getInsets());
        this._values[1] = new FieldPanel(25, (JComponent)browse);
        JButton b = new JButton("Learn From Device...");
        b.addActionListener(this);
        this._values[2] = b;
        this._values[3] = new JTextField("161", 5);
        this._values[4] = new JTextField("public");
        this._values[5] = new JTextField("private");
        DialogUtil.buildDialog(this, parent, DialogUtil.buildPanel(DialogUtil.buildLabels(_Labels), this._values));
        this.getRootPane().getDefaultButton().setText("Add");
        DialogUtil.addKeyListener(this.getContentPane(), this);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton b = (JButton)e.getSource();
        try {
            switch (b.getText().charAt(0)) {
                case '.': {
                    String fName = Simulator.getFileName((JFrame)this.getParent(), "*.otv");
                    if (fName == null) break;
                    ((FieldPanel)this._values[1]).setText(fName);
                    break;
                }
                case 'L': {
                    if (this._learnDialog == null) {
                        this._learnDialog = new LearnDialog(this._parent, this);
                    }
                    this._learnDialog.setVisible(true);
                    break;
                }
                case 'A': {
                    String ipAddr = ((JTextField)this._values[0]).getText();
                    SnmpIpAddress.parse(ipAddr);
                    String port = ((JTextField)this._values[3]).getText();
                    try {
                        int p = Integer.parseInt(port);
                        if (p <= 0 || p > 32000) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new SnmpException("Port should be in range 1..32000");
                    }
                    String otvFile = ((FieldPanel)this._values[1]).getText();
                    File f = new File(otvFile);
                    if (!f.exists()) {
                        throw new SnmpException("File doesn't exist");
                    }
                    this._parent.addRow(ipAddr, port, otvFile, ((JTextField)this._values[4]).getText(), ((JTextField)this._values[5]).getText());
                }
                case 'C': {
                    this.setVisible(false);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }
}

