/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCounter;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.tools.Agent;
import com.cisco.dcbu.tools.OidRegisterIf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class Andiamo
implements OidRegisterIf {
    static final int TYPE1_IFINDEX = 0x1000000;
    static final int CHANNEL_IFINDEX = 0x4000000;
    static final int VSAN_IFINDEX = 0x8F80000;
    static HashMap _Methods;
    static int[] _Empty;
    static byte[] _EmptyIP;
    static final int ALARMSTATUS = 17;
    static String[][] _RowStatusVar;
    static int[] _IndexLen;
    static int[][][] _RowStatus;
    static String[] _PingStats;
    static MibNode[] _PingStatsNode;
    final String[] _UtilGauge = new String[]{"cseSysCPUUtilization", "cseSysMemoryUtilization"};
    static int[][] _UtilGaugeOid;
    static final int[] _IfAdminStatus;
    static final int[] _IfOperStatus;
    static final int[] _IfHighSpeed;
    Timer _timer;
    int _interval = 10;
    int[] _ifAdminKey;
    int[] _ifOperKey;
    int[] _ifIndex;
    long[] _ifHCSpeed;

    @Override
    public void init(Agent agent) {
        int i;
        _RowStatus = new int[_RowStatusVar.length][2][];
        for (i = 0; i < _RowStatusVar.length; ++i) {
            Andiamo._RowStatus[i][0] = MibNode.get(_RowStatusVar[i][0]).getOid();
            if (_RowStatusVar[i][1] != null) {
                SnmpOID oid = new SnmpOID(MibNode.get(_RowStatusVar[i][1]).getOid(), 0);
                Andiamo._RowStatus[i][1] = oid.getValue();
            }
            agent.oidRegister(_RowStatus[i][0], this);
        }
        if (_Methods == null) {
            _Methods = new HashMap();
            Method[] methods = Andiamo.class.getDeclaredMethods();
            for (int i2 = 0; i2 < methods.length; ++i2) {
                if (methods[i2].getReturnType() != SnmpVar.class) continue;
                _Methods.put(methods[i2].getName(), methods[i2]);
            }
        }
        _PingStatsNode = new MibNode[_PingStats.length];
        for (i = 0; i < _PingStats.length; ++i) {
            Andiamo._PingStatsNode[i] = MibNode.get(_PingStats[i]);
        }
        this.initUpdateCounters(agent);
    }

    @Override
    public void oidRegisterCallback(Agent agent, VarBindList vblist, int pos, InetAddress sourceAddress) {
        int tNo;
        SnmpVarBind vb = vblist.getVb(pos);
        int[] oid = vb.getOid().getValue();
        int action = ((SnmpInt)vb.getVar()).getValue();
        int[] index = null;
        Array rowVars = null;
        for (tNo = 0; tNo < _RowStatus.length; ++tNo) {
            if (!SnmpOID.startsWith(oid, _RowStatus[tNo][0])) continue;
            index = new int[_IndexLen[tNo]];
            System.arraycopy(oid, oid.length - index.length, index, 0, index.length);
            rowVars = this.getRowEntries(_RowStatus[tNo][0]);
            break;
        }
        if (tNo >= _RowStatus.length) {
            return;
        }
        if (Agent._Trace) {
            System.out.println(_RowStatusVar[tNo][0]);
        }
        if (rowVars.size() == 0) {
            int[][] oids = new int[][]{oid};
            if (this.isCreate(action, tNo)) {
                SnmpVar[] values = new SnmpVar[]{vb.getVar()};
                agent.insertRow(oids, values);
            } else if (this.isDelete(action, tNo)) {
                agent.deleteRow(oids);
            }
            return;
        }
        int[][] oids = new int[rowVars.size()][];
        SnmpVar[] values = new SnmpVar[oids.length];
        for (int i = 0; i < rowVars.size(); ++i) {
            MibNode node = (MibNode)rowVars.elementAt(i);
            if (this.isCreate(action, tNo)) {
                values[i] = this.createDefaultValue(index, node);
            }
            oids[i] = new int[node.getOid().length + index.length];
            System.arraycopy(node.getOid(), 0, oids[i], 0, oids[i].length - index.length);
            System.arraycopy(index, 0, oids[i], oids[i].length - index.length, index.length);
        }
        SnmpInt num = null;
        if (_RowStatus[tNo][1] != null) {
            num = (SnmpInt)agent.getValue(agent.findKey(_RowStatus[tNo][1]));
        }
        if (this.isCreate(action, tNo)) {
            agent.insertRow(oids, values);
            if (num != null) {
                num.setValue(num.getValue() + 1);
            }
        } else if (this.isDelete(action, tNo) && agent.deleteRow(oids) && num != null) {
            num.setValue(num.getValue() - 1);
        }
    }

    boolean isCreate(int action, int tableNo) {
        if (tableNo == 17) {
            return action == 2;
        }
        return action == 4;
    }

    boolean isDelete(int action, int tableNo) {
        if (tableNo == 17) {
            return action == 4;
        }
        return action == 6;
    }

    Array getRowEntries(int[] rowStatusOid) {
        int[] rowStatus = new int[rowStatusOid.length];
        System.arraycopy(rowStatusOid, 0, rowStatus, 0, rowStatus.length);
        Array<MibNode> entries = new Array<MibNode>();
        int rowLen = rowStatus[rowStatus.length - 1];
        for (int i = 1; i <= rowLen; ++i) {
            rowStatus[rowStatus.length - 1] = i;
            MibNode n = MibNode.lookupOid(rowStatus);
            if (n == null || n.getAccess() == 4) continue;
            entries.addElement(n);
        }
        return entries;
    }

    SnmpVar createDefaultValue(int[] index, MibNode n) {
        String v = MibNode.oidToName(n.getOid());
        Method m = (Method)_Methods.get(v);
        if (m != null) {
            try {
                Object[] args = new Object[]{index};
                return (SnmpVar)m.invoke(Andiamo.class, args);
            }
            catch (InvocationTargetException ex) {
                Exception realEx = (Exception)ex.getTargetException();
                System.err.println(v + " createDefaultValue: " + realEx);
            }
            catch (Exception ex) {
                System.err.println(v + " createDefaultValue: " + ex);
            }
        }
        switch (n.getType()) {
            case 2: {
                if (n.getDefVal() != -1) {
                    return new SnmpInt(n.getDefVal());
                }
                MibEnum[] me = n.getEnums();
                return new SnmpInt(me == null ? 0 : me[0].getValue());
            }
            case 4: {
                return new SnmpString("");
            }
            case 6: {
                return new SnmpOID(_Empty);
            }
            case 64: {
                return new SnmpIpAddress(_EmptyIP);
            }
            case 65: {
                return new SnmpCounter(0L);
            }
            case 66: {
                return new SnmpUnsignedInt(n.getDefVal() == -1 ? 0L : (long)n.getDefVal());
            }
            case 67: {
                return new SnmpTimeticks((System.currentTimeMillis() - Agent.START_TIME) / 10L);
            }
            case 70: {
                return new SnmpCounter64(0L);
            }
        }
        return null;
    }

    static SnmpVar zoneSetOperStatus(int[] index) {
        return new SnmpInt(2);
    }

    static SnmpVar zoneSetAdminStatus(int[] index) {
        return new SnmpInt(2);
    }

    static SnmpVar portChannelIfIndex(int[] index) {
        return new SnmpInt(0x4000000 + index[0] - 1);
    }

    void initUpdateCounters(Agent agent) {
        if (_UtilGaugeOid == null) {
            _UtilGaugeOid = new int[this._UtilGauge.length][];
            for (int i = 0; i < this._UtilGauge.length; ++i) {
                int[] oid = MibNode.get(this._UtilGauge[i]).getOid();
                Andiamo._UtilGaugeOid[i] = new int[oid.length + 1];
                System.arraycopy(oid, 0, _UtilGaugeOid[i], 0, oid.length);
                Andiamo._UtilGaugeOid[i][Andiamo._UtilGaugeOid[i].length - 1] = 0;
            }
        }
        this._ifIndex = new int[256];
        this._ifHCSpeed = new long[256];
        int[] speed = new int[_IfHighSpeed.length + 1];
        System.arraycopy(_IfHighSpeed, 0, speed, 0, _IfHighSpeed.length);
        speed[Andiamo._IfHighSpeed.length] = 0xFFFFFF;
        int ifNo = 0;
        while (ifNo < this._ifIndex.length) {
            int key = agent.findNextKey(speed);
            int[] target = (int[])agent._keys.elementAt(key);
            speed[Andiamo._IfHighSpeed.length] = target[target.length - 1];
            int result = Agent.equals(target, speed);
            if (result != 0) break;
            this._ifIndex[ifNo] = target[target.length - 1];
            this._ifHCSpeed[ifNo++] = ((SnmpGauge)agent._values.elementAt(key)).getValue();
        }
        if (ifNo > 0) {
            this._ifOperKey = new int[ifNo];
            this._ifAdminKey = new int[ifNo];
            int[] oper = new int[_IfOperStatus.length + 1];
            System.arraycopy(_IfOperStatus, 0, oper, 0, _IfOperStatus.length);
            int[] admin = new int[_IfAdminStatus.length + 1];
            System.arraycopy(_IfAdminStatus, 0, admin, 0, _IfAdminStatus.length);
            for (int i = 0; i < this._ifIndex.length && this._ifIndex[i] > 0; ++i) {
                int n = this._ifIndex[i];
                admin[Andiamo._IfAdminStatus.length] = n;
                oper[Andiamo._IfOperStatus.length] = n;
                this._ifOperKey[i] = agent.findKey(oper);
                this._ifAdminKey[i] = agent.findKey(admin);
            }
            this._timer = new Timer();
            this._timer.schedule((TimerTask)new UpdateCounters(agent), this._interval * 1000, (long)(this._interval * 1000));
        }
    }

    void updateCounters(int ifIndex, long ifSpeed, Agent agent) {
        int[] inOctetsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 10, ifIndex};
        double inRand = Math.random();
        long inOctets = this._interval * (int)((double)ifSpeed * inRand / 8.0);
        this.incrementCounter(inOctetsOid, inOctets, agent);
        int[] inHcOctetsOid = new int[]{1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 6, ifIndex};
        this.incrementCounter(inHcOctetsOid, inOctets, agent);
        int[] outOctetsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 16, ifIndex};
        double outRand = Math.random();
        long outOctets = this._interval * (int)((double)ifSpeed * outRand / 8.0);
        this.incrementCounter(outOctetsOid, outOctets, agent);
        int[] outHcOctetsOid = new int[]{1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 10, ifIndex};
        this.incrementCounter(outHcOctetsOid, outOctets, agent);
        int[] inPktsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 11, ifIndex};
        long inPkts = inOctets / 1000L;
        this.incrementCounter(inPktsOid, inPkts, agent);
        int[] inHcPktsOid = new int[]{1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 7, ifIndex};
        this.incrementCounter(inHcPktsOid, inPkts, agent);
        int[] outPktsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 17, ifIndex};
        long outPkts = outOctets / 1000L;
        this.incrementCounter(outPktsOid, outPkts, agent);
        int[] outHcPktsOid = new int[]{1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 11, ifIndex};
        this.incrementCounter(outHcPktsOid, outPkts, agent);
        long inDiscards = inRand > 0.9 ? 2L : 0L;
        int[] inDiscardsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 13, ifIndex};
        this.incrementCounter(inDiscardsOid, inDiscards, agent);
        long outDiscards = outRand > 0.9 ? 2L : 0L;
        int[] outDiscardsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 19, ifIndex};
        this.incrementCounter(outDiscardsOid, outDiscards, agent);
        long inErrors = inRand > 0.9 ? 1L : 0L;
        int[] inErrorsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 14, ifIndex};
        this.incrementCounter(inErrorsOid, inErrors, agent);
        if (inErrors > 0L) {
            int errVar = (int)(27.0 * Math.random()) % 6 + 1;
            int[] errOid = new int[]{1, 3, 6, 1, 4, 1, 9524, 3, 7, 1, 2, 1, 1, errVar, ifIndex};
            this.incrementCounter(errOid, inErrors, agent);
        }
        long outErrors = outRand > 0.9 ? 1L : 0L;
        int[] outErrorsOid = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 20, ifIndex};
        this.incrementCounter(outErrorsOid, outErrors, agent);
        if (outErrors > 0L) {
            int errVar = (int)(27.0 * Math.random()) % 6 + 1;
            int[] errOid = new int[]{1, 3, 6, 1, 4, 1, 9524, 3, 7, 1, 2, 1, 1, errVar, ifIndex};
            this.incrementCounter(errOid, outErrors, agent);
        }
        int[] fcIfC2InPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 2, 1, 1, ifIndex};
        this.incrementCounter(fcIfC2InPktsOid, (long)((double)inPkts * 0.19), agent);
        int[] fcIfC3InPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 3, 1, 1, ifIndex};
        this.incrementCounter(fcIfC3InPktsOid, (long)((double)inPkts * 0.8), agent);
        int[] fcIfCFInPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 4, 1, 1, ifIndex};
        this.incrementCounter(fcIfCFInPktsOid, (long)((double)inPkts * 0.01), agent);
        int[] fcIfC2OutPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 2, 1, 2, ifIndex};
        this.incrementCounter(fcIfC2OutPktsOid, (long)((double)outPkts * 0.19), agent);
        int[] fcIfC3OutPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 3, 1, 2, ifIndex};
        this.incrementCounter(fcIfC3OutPktsOid, (long)((double)outPkts * 0.8), agent);
        int[] fcIfCFOutPktsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 4, 1, 2, ifIndex};
        this.incrementCounter(fcIfCFOutPktsOid, (long)((double)outPkts * 0.01), agent);
        int[] fcIfC2InOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 2, 1, 3, ifIndex};
        this.incrementCounter(fcIfC2InOctetsOid, (long)((double)inOctets * 0.19), agent);
        int[] fcIfC3InOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 3, 1, 3, ifIndex};
        this.incrementCounter(fcIfC3InOctetsOid, (long)((double)inOctets * 0.8), agent);
        int[] fcIfCFInOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 4, 1, 3, ifIndex};
        this.incrementCounter(fcIfCFInOctetsOid, (long)((double)inOctets * 0.01), agent);
        int[] fcIfC2OutOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 2, 1, 4, ifIndex};
        this.incrementCounter(fcIfC2OutOctetsOid, (long)((double)outOctets * 0.19), agent);
        int[] fcIfC3OutOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 3, 1, 4, ifIndex};
        this.incrementCounter(fcIfC3OutOctetsOid, (long)((double)outOctets * 0.8), agent);
        int[] fcIfCFOutOctetsOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2, 4, 1, 4, ifIndex};
        this.incrementCounter(fcIfCFOutOctetsOid, (long)((double)outOctets * 0.01), agent);
    }

    void incrementCounter(int[] oid, long increment, Agent agent) {
        int key = agent.findKey(oid);
        if (key == -1) {
            return;
        }
        SnmpVar v = (SnmpVar)agent._values.elementAt(key);
        if (v.getType() == 65) {
            long value = ((SnmpCounter)v).getValue();
            ((SnmpCounter)v).setValue(value += increment);
        } else if (v.getType() == 70) {
            ((SnmpCounter64)v).increment();
        }
    }

    static {
        _Empty = new int[]{0, 0};
        _EmptyIP = new byte[]{0, 0, 0, 0};
        _RowStatusVar = new String[][]{{"vsanRowStatus", "vsanNumber"}, {"zoneSetRowStatus", "zoneSetNumber"}, {"zoneRowStatus", "zoneNumber"}, {"zoneAliasRowStatus", "zoneAliasNumber"}, {"zoneMemberRowStatus", "zoneMemberNumber"}, {"vrrpOperRowStatus", null}, {"vrrpAssoIpAddrRowStatus", null}, {"portChannelRowStatus", null}, {"fspfRowStatus", null}, {"fspfIfRowStatus", null}, {"ccCopyEntryRowStatus", null}, {"ipCidrRouteStatus", "ipCidrRouteNumber"}, {"fcRouteFlowRowStatus", null}, {"fcRouteRowStatus", null}, {"fcPingRowStatus", null}, {"alarmStatus", null}};
        _IndexLen = new int[]{1, 2, 2, 2, 4, 2, 6, 1, 1, 2, 1, 13, 2, 7, 1, 1};
        _PingStats = new String[]{"fcPingTxPackets", "fcPingRxPackets", "fcPingMinRtt", "fcPingAvgRtt", "fcPingMaxRtt", "fcPingNumTimeouts"};
        _IfAdminStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 7};
        _IfOperStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 8};
        _IfHighSpeed = new int[]{1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 15};
    }

    class UpdateCounters
    extends TimerTask {
        Agent _agent;

        public UpdateCounters(Agent agent) {
            this._agent = agent;
        }

        @Override
        public void run() {
            int i;
            for (i = 0; i < _UtilGaugeOid.length; ++i) {
                int key = this._agent.findKey(_UtilGaugeOid[i]);
                if (key == -1) continue;
                SnmpGauge v = (SnmpGauge)this._agent._values.elementAt(key);
                v.setValue((long)(Math.random() * 100.0));
            }
            for (i = 0; i < Andiamo.this._ifOperKey.length; ++i) {
                boolean isUp;
                SnmpInt oVal = (SnmpInt)this._agent._values.elementAt(Andiamo.this._ifOperKey[i]);
                SnmpInt aVal = (SnmpInt)this._agent._values.elementAt(Andiamo.this._ifAdminKey[i]);
                boolean bl = isUp = oVal.getValue() == 1 && aVal.getValue() == 1;
                if (!isUp) continue;
                Andiamo.this.updateCounters(Andiamo.this._ifIndex[i], Andiamo.this._ifHCSpeed[i] * 1000000L, this._agent);
            }
        }
    }
}

