/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.Comparator;

class CdpNode
implements Comparator,
Comparable {
    String _deviceId;
    String _platform;
    SnmpPeer _peer;
    boolean _isManagable;
    VarBindList _cacheVbl;
    String _version;
    byte[] _capabilities;

    public CdpNode(String deviceId, String platform, byte[] capabilities) {
        this._deviceId = deviceId;
        this._platform = platform;
        this._capabilities = capabilities;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._deviceId + ", " + this._platform);
        if (this._peer != null) {
            sb.append(", " + this._peer.getAddress().getHostAddress());
        }
        if (this._peer == null || !this._isManagable) {
            sb.append(", unmanagable");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this._deviceId.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CdpNode)) {
            return false;
        }
        return this._deviceId.equals(((CdpNode)obj)._deviceId);
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return ((CdpNode)o1)._deviceId.compareTo(((CdpNode)o2)._deviceId);
    }
}

