/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.tools;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.PowerSupply;
import com.cisco.dcbu.sm.server.event.EmcCallHomeHandler;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;

public class SimulateCallHomeTraps {
    static final int[] _SnmpTrapOID = new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 1, 0};
    static final int[] _SysUpTime = new int[]{1, 3, 6, 1, 2, 1, 1, 3, 0};
    static final int[] _IfIndex = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 1};
    static final int[] _IfAdminStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 7};
    static final int[] _IfOperStatus = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 8};
    static final int[] _FcIfOperStatusCause = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 1, 2, 1, 7};
    static final int[] _ConnUnitStatusChange = new int[]{1, 3, 6, 1, 3, 94, 1};
    static final int[] _ConnUnitStatus = new int[]{1, 3, 6, 1, 3, 94, 1, 6, 1, 6};
    static final int[] _ConnUnitState = new int[]{1, 3, 6, 1, 3, 94, 1, 6, 1, 5};
    static final int[] _CefcPowerStatusChange = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 2, 0, 2};
    static final int[] _CefcFRUPowerAdminStatus = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 1, 2, 1, 1};
    static final int[] _CefcFRUPowerOperStatus = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 1, 2, 1, 2};
    static final int[] _CefcModuleStatusChange = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 2, 0, 1};
    static final int[] _CefcModuleOperStatus = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 2, 1, 1, 2};
    static final int[] _CefcModuleStatusLastChangeTime = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 2, 1, 1, 4};
    static final int[] _CefcFRURemoved = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 2, 0, 4};
    static final int[] _CefcFRUInserted = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 2, 0, 3};
    static final int[] _CefcFanTrayStatusChange = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 2, 0, 6};
    static final int[] _CefcFanTrayOperStatus = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 117, 1, 4, 1, 1, 1};
    static final int[] _EntSensorThresholdNotification = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 91, 2, 0, 1};
    static final int[] _EntSensorThresholdValue = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 91, 1, 2, 1, 1, 4};
    static final int[] _EntSensorValue = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 91, 1, 1, 1, 1, 4};
    static final int[] _EntPhysicalContainedIn = new int[]{1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 4};
    static final boolean _Trace = true;
    static final int BUF_SIZE = 8000;
    static final long _StartTime = System.currentTimeMillis();
    public static InventoryManager _Im;
    public static SimulateCallHomeTraps _Instance;
    private InetAddress dest = null;
    private SnmpOutputStream _outBuf = new SnmpOutputStream(8000);
    private int _reqId;
    private EndPortImpl[] ports;
    private Card[] card;
    private HwInventoryComponent[] fan;
    private PowerSupply[] ps;

    public static SimulateCallHomeTraps getInstance() {
        if (_Instance == null) {
            _Instance = new SimulateCallHomeTraps();
        }
        return _Instance;
    }

    public void sendAllEmcTraps(SwitchImpl sw) {
        block6: {
            int slot;
            Iterator it;
            this.dest = sw.getInetAddress();
            _Im = InventoryManager.getInstance();
            _Im.poll(sw.getSwitchPK());
            List<Card> cards = _Im.findCards(sw.getPK());
            List<HwInventoryComponent> fanComps = _Im.findFans(sw.getPK());
            List<PowerSupply> powerComps = _Im.findPowerSupplies(sw.getPK());
            if (cards.size() < 1) {
                this.trace("Cannot read switch components... inventory of this swich may not be complete. try again..");
                return;
            }
            List l = SanManager.getInstance().findAttachedEndPorts(sw);
            this.trace("sending port failure Trap");
            if (l.size() > 0) {
                it = l.iterator();
                while (it.hasNext()) {
                    EndPortImpl port = (EndPortImpl)it.next();
                    if (!port.isPresent()) continue;
                    this.sendPortFailure(port.getIfIndex());
                    break;
                }
            }
            this.trace("sending Switch Failure trap : " + sw.getName());
            this.sendSwitchFailure();
            if (cards.size() > 0) {
                for (Card card : cards) {
                    slot = card.getSlotId();
                    if (!card.hasSup() && !card.hasEthernetPorts() && !card.isMixedCard()) continue;
                    this.trace("sending Diagnostic Failure trap for module { " + card.getName() + " } in Slot : " + slot + " on Switch " + sw.getIpAddress());
                    this.sendDiagFailure(card.getPhysicalIndex());
                    this.trace("sending Port Blade failure trap for module { " + card.getName() + " } in Slot : " + slot + " on Switch " + sw.getIpAddress());
                    this.sendPortBladeFailure(card.getPhysicalIndex());
                    this.trace("sending Port Card Inserted trap for module { " + card.getName() + " } in Slot : " + slot + " on Switch " + sw.getIpAddress());
                    this.sendXXXInserted(card.getPhysicalIndex(), slot);
                    break;
                }
            }
            if (powerComps.size() > 0 && (it = powerComps.iterator()).hasNext()) {
                PowerSupply ps = (PowerSupply)it.next();
                slot = ps.getSlotId();
                this.trace("sending Power Supply Failed trap for module { " + ps.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
                this.sendPowerSupFailure(ps.getPhysicalIndex());
                this.trace("sending AC Source Failed trap for module { " + ps.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
                this.sendACSourceFailure(ps.getPhysicalIndex());
                this.trace("sending RemovedPS trap for module { " + ps.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
                this.sendRemovedPS(ps.getPhysicalIndex(), slot);
                this.trace("sending Over Temperature trap for module { " + ps.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
                this.sendOverTemp(ps.getPhysicalIndex());
                this.trace("sending Power Supply Inserted trap for module { " + ps.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
                this.sendXXXInserted(ps.getPhysicalIndex(), slot);
            }
            if (fanComps.size() <= 0 || !(it = fanComps.iterator()).hasNext()) break block6;
            HwInventoryComponent fan = (HwInventoryComponent)it.next();
            slot = fan.getSlotId();
            this.trace("sending Fan Removed trap for module { " + fan.getName() + "} in slot : " + slot + " on Switch " + sw.getIpAddress());
            this.sendFanRemoved(fan.getPhysicalIndex(), fan.getSlotId() + 1);
            this.trace("sending Fan Failure trap for module { " + fan.getName() + " } in slot : " + slot + " on Switch " + sw.getIpAddress());
            this.sendFanFailure(fan.getPhysicalIndex());
        }
    }

    public void sendXXXInserted(int pi, int si) {
        VarBindList vbl = new VarBindList(3);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcFRUInserted)));
        vbl.add(new SnmpVarBind(new SnmpOID(_EntPhysicalContainedIn, pi), new SnmpInt(si)));
        this.sendPDU(vbl);
    }

    public void sendPortBladeFailure(int pi) {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcModuleStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcModuleOperStatus, pi), new SnmpInt(8)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcModuleStatusLastChangeTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        this.sendPDU(vbl);
    }

    public void sendFanFailure(int pi) {
        VarBindList vbl = new VarBindList(3);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcFanTrayStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFanTrayOperStatus, pi), new SnmpInt(4)));
        this.sendPDU(vbl);
    }

    public void sendOverTemp(int pi) {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_EntSensorThresholdNotification)));
        vbl.add(new SnmpVarBind(new SnmpOID(_EntSensorThresholdValue, pi), new SnmpInt(4)));
        vbl.add(new SnmpVarBind(new SnmpOID(_EntSensorValue, pi), new SnmpInt(121)));
        this.sendPDU(vbl);
    }

    public void sendFanRemoved(int pi, int si) {
        VarBindList vbl = new VarBindList(3);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcFRURemoved)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFRUPowerOperStatus, pi), new SnmpInt(si)));
        this.sendPDU(vbl);
    }

    public void sendRemovedPS(int pi, int si) {
        VarBindList vbl = new VarBindList(3);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcFRURemoved)));
        vbl.add(new SnmpVarBind(new SnmpOID(_EntPhysicalContainedIn, pi), new SnmpInt(si)));
        this.sendPDU(vbl);
    }

    public void sendACSourceFailure(int physicalIndex) {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcPowerStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFRUPowerOperStatus, physicalIndex), new SnmpInt(4)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFRUPowerAdminStatus, physicalIndex), new SnmpInt(2)));
        this.sendPDU(vbl);
    }

    public void sendPowerSupFailure(int physicalIndex) {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcPowerStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFRUPowerOperStatus, physicalIndex), new SnmpInt(7)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcFRUPowerAdminStatus, physicalIndex), new SnmpInt(2)));
        this.sendPDU(vbl);
    }

    public void sendDiagFailure(int physicalIndex) {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_CefcModuleStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcModuleOperStatus, physicalIndex), new SnmpInt(4)));
        vbl.add(new SnmpVarBind(new SnmpOID(_CefcModuleStatusLastChangeTime, physicalIndex), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        this.sendPDU(vbl);
    }

    public void sendSwitchFailure() {
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(_ConnUnitStatusChange)));
        vbl.add(new SnmpVarBind(new SnmpOID(_ConnUnitStatus), new SnmpInt(5)));
        vbl.add(new SnmpVarBind(new SnmpOID(_ConnUnitState), new SnmpInt(2)));
        this.sendPDU(vbl);
    }

    public void sendPortFailure(int ifIndex) {
        VarBindList vbl = new VarBindList(6);
        vbl.add(new SnmpVarBind(new SnmpOID(_SysUpTime), new SnmpTimeticks((System.currentTimeMillis() - _StartTime) / 10L)));
        vbl.add(new SnmpVarBind(new SnmpOID(_SnmpTrapOID), new SnmpOID(MibNode.get("linkDown").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(_IfIndex), new SnmpInt(ifIndex)));
        vbl.add(new SnmpVarBind(new SnmpOID(_IfAdminStatus), new SnmpInt(2)));
        vbl.add(new SnmpVarBind(new SnmpOID(_IfOperStatus), new SnmpInt(2)));
        vbl.add(new SnmpVarBind(new SnmpOID(_FcIfOperStatusCause), new SnmpInt(10)));
        this.sendPDU(vbl);
    }

    public void sendPDU(VarBindList vbl) {
        try {
            this._outBuf.reset();
            SnmpPDU pdu = new SnmpPDU(-89);
            pdu.setVersion(1);
            pdu.setReqid(++this._reqId);
            pdu.setAddress(this.dest);
            pdu.setCommunity("public");
            pdu.setVariables(vbl);
            System.out.println(pdu);
            pdu.encode(this._outBuf);
            EmcCallHomeHandler.getInstance().trapReceived(new SnmpTrapEntry(pdu));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex);
        }
    }

    private void trace(String r) {
        System.out.println(r);
    }
}

