/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.vi.model.DataCenter;
import com.cisco.dcbu.vi.model.HostSystem;
import com.cisco.dcbu.vi.model.ManagedEntity;
import com.cisco.dcbu.vi.model.VirtualMachine;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;

public class DataStore
extends ManagedEntity {
    static final long serialVersionUID = 1L;
    private ArrayList<HostSystem> _hosts = new ArrayList();
    private ArrayList<VirtualMachine> _vms = new ArrayList();
    private long _freeSpace;
    private long _maxFileSize;
    private String _name;
    private String _url;
    private DataCenter _dc;
    private int _dcId;
    private String _host;
    private long _nwwn;
    private long _pwwn;
    private int _lun;
    private String _lunUuid;
    private String _uuid;
    private String _scsiLun;
    private String _canonicalName;
    protected FabricPK _fabricPK;
    private InetAddress _vckey;

    public DataStore(long nwwn, long pwwn, String lunUuid, int lun, String scsiLun, String uuid, String canonicalName) {
        this._nwwn = nwwn;
        this._pwwn = pwwn;
        this._lunUuid = lunUuid;
        this._lun = lun;
        this._scsiLun = scsiLun;
        this._uuid = uuid;
        this._canonicalName = canonicalName;
        super.setNameKey(new NameKey(canonicalName));
    }

    public ArrayList<HostSystem> getHosts() {
        return this._hosts;
    }

    public void setHosts(ArrayList<HostSystem> hosts) {
        this._hosts = hosts;
    }

    public void addHost(HostSystem ht) {
        if (!this._hosts.contains(ht)) {
            this._hosts.add(ht);
        }
    }

    public void removeHost(HostSystem ht) {
        this._hosts.remove(ht);
    }

    public ArrayList<VirtualMachine> getVms() {
        return this._vms;
    }

    public void setVms(ArrayList<VirtualMachine> vms) {
        this._vms = vms;
    }

    public void addVm(VirtualMachine vm) {
        if (!this._vms.contains(vm)) {
            this._vms.add(vm);
        }
    }

    public boolean removeVm(VirtualMachine vm) {
        return this._vms.remove(vm);
    }

    public long getFreeSpace() {
        return this._freeSpace;
    }

    public void setFreeSpace(long freeSpace) {
        this._freeSpace = freeSpace;
    }

    public long getMaxFileSize() {
        return this._maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this._maxFileSize = maxFileSize;
    }

    public String getLunUuid() {
        return this._lunUuid;
    }

    public void setLunUuid(String lunUuid) {
        this._lunUuid = lunUuid;
    }

    public String getUuid() {
        return this._uuid;
    }

    public void setUuid(String uuid) {
        this._uuid = uuid;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getCanonicalName() {
        return this._canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this._canonicalName = canonicalName;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public DataCenter getDc() {
        return this._dc;
    }

    public void setDc(DataCenter dc) {
        this._dc = dc;
    }

    public int getDcId() {
        return this._dcId;
    }

    public void setDcId(int dcId) {
        this._dcId = dcId;
    }

    public String getHost() {
        return this._host;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public long getNwwn() {
        return this._nwwn;
    }

    public void setNwwn(long nwwn) {
        this._nwwn = nwwn;
    }

    public long getPwwn() {
        return this._pwwn;
    }

    public void setPwwn(long pwwn) {
        this._pwwn = pwwn;
    }

    public int getLun() {
        return this._lun;
    }

    public void setLun(int lun) {
        this._lun = lun;
    }

    public String getScsiLun() {
        return this._scsiLun;
    }

    public void setScsiLun(String scsiLun) {
        this._scsiLun = scsiLun;
    }

    public VirtualMachine findVm(NameKey vmPK) {
        for (VirtualMachine vm : this._vms) {
            if (!vm.getNameKey().equals(vmPK)) continue;
            return vm;
        }
        return null;
    }

    public InetAddress getVCPK() {
        return this._vckey;
    }

    public void setVCPK(InetAddress vckey) {
        this._vckey = vckey;
    }

    public FabricPK getFabricPK() {
        return this._fabricPK;
    }

    public void setFabricPK(FabricPK fabricPK) {
        this._fabricPK = fabricPK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._pkey).append(", lunUuid=").append(this._lunUuid).append(", uuid=").append(this._uuid).append(", scsiLun=").append(this._scsiLun).append(", canonicalName=").append(this._canonicalName).append(", name=").append(this._name).append(", freeSpace=").append(this._freeSpace).append(", maxFileSize=").append(this._maxFileSize).append(", url=").append(this._url).append(", pwwn=").append(new Wwn(DataStore.valueOf(this._pwwn))).append(", nwwn=").append(new Wwn(DataStore.valueOf(this._nwwn))).append("Num of VHosts: ");
        if (this._hosts.size() == 0) {
            sb.append("n/a");
        } else {
            sb.append(this._hosts.size());
            Collections.sort(this._hosts);
            for (HostSystem host : this._hosts) {
                sb.append(", ").append(host.getHostName());
            }
        }
        sb.append("Num of VMs: ");
        if (this._vms.size() == 0) {
            sb.append("n/a");
        } else {
            sb.append(this._vms.size());
            Collections.sort(this._vms);
            for (VirtualMachine vm : this._vms) {
                sb.append(", ").append(vm.getName());
            }
        }
        return sb.toString();
    }

    public static byte[] valueOf(long inm) {
        byte[] b = new byte[]{(byte)(inm >> 56 & 0xFFL), (byte)(inm >> 48 & 0xFFL), (byte)(inm >> 40 & 0xFFL), (byte)(inm >> 32 & 0xFFL), (byte)(inm >> 24 & 0xFFL), (byte)(inm >> 16 & 0xFFL), (byte)(inm >> 8 & 0xFFL), (byte)(inm & 0xFFL)};
        return b;
    }
}

