/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.model;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.NameValuePair;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VirtualCenterImpl;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import com.vmware.vim25.InvalidLogin;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfEntityMetricCSV;
import com.vmware.vim25.PerfInterval;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfMetricSeriesCSV;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSampleInfo;
import com.vmware.vim25.PerfStatsType;
import com.vmware.vim25.PerfSummaryType;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ViManager {
    public static final long MIN_INTERVAL = 30000L;
    static Logger _Logger = LogManager.getLogger((String)"fms.disc");
    private static ViManager _Instance;
    private Map _pci = new HashMap();
    private ConcurrentHashMap<InetAddress, VirtualCenterImpl> _virtualCenterByIp;
    private ConcurrentHashMap<NameKey, HostClusterImpl> _hostClusterByNameKey;
    private SanManager.DbLoadStatus _dbLoadStatus = SanManager.DbLoadStatus.NOTLOADED;
    private long _lastScanTime;
    private static final String VM_PM_FILE = "pmData.txt";
    private int serverId;

    private ViManager() {
        this._virtualCenterByIp = new ConcurrentHashMap();
        this._hostClusterByNameKey = new ConcurrentHashMap();
    }

    public static ViManager getInstance() {
        if (_Instance == null) {
            _Instance = new ViManager();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostClusterImpl createCluster(String clusterName) {
        ConcurrentHashMap<NameKey, HostClusterImpl> concurrentHashMap = this._hostClusterByNameKey;
        synchronized (concurrentHashMap) {
            HostClusterImpl cluster = this.findClusterByName(clusterName);
            if (cluster == null) {
                cluster = new HostClusterImpl(clusterName);
                this._hostClusterByNameKey.put(new NameKey(clusterName), cluster);
            }
            return cluster;
        }
    }

    public HostClusterImpl findCluster(NameKey pkey) {
        return pkey == null ? null : this._hostClusterByNameKey.get(pkey);
    }

    public HostClusterImpl[] getClusters() {
        return this._hostClusterByNameKey.values().toArray(new HostClusterImpl[this._hostClusterByNameKey.size()]);
    }

    public HostClusterImpl findClusterByPK(NameKey pkey) {
        return pkey == null ? null : this._hostClusterByNameKey.get(pkey);
    }

    public HostClusterImpl findClusterByName(String name) {
        return this.findClusterByPK(new NameKey(name));
    }

    public VirtualCenterImpl createVirtualCenter(InetAddress vcIp, String username, String passwd) throws Exception {
        if (VHostImpl.findVHostByIp(vcIp.getHostAddress())) {
            throw new Exception(vcIp.getHostAddress() + " is managed by another VCenter");
        }
        try {
            new ServiceInstance(new URL("https://" + vcIp.getHostAddress() + "/sdk"), username, passwd, true);
        }
        catch (InvalidLogin e) {
            throw new Exception("Invalid user name or password");
        }
        catch (Exception e1) {
            throw new Exception("Invalid IP address or virtual center - " + vcIp.getHostAddress());
        }
        VirtualCenterImpl vcImpl = null;
        try {
            vcImpl = this.createVirtualCenter(0, vcIp, username, passwd, true);
            if (vcImpl == null) {
                return null;
            }
            vcImpl.getWorker().start(DiscoveryType.VI_INITIAL);
            ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(vcImpl.getPK(), IdentityManager.getInstance().getClientAddress(), vcImpl.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' opened", Severity.INFO.getValue(), 2));
        }
        catch (Exception ex) {
            _Logger.error((Object)("Failed to create virtual center " + vcIp), (Throwable)ex);
            throw ex;
        }
        return vcImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualCenterImpl createVirtualCenter(int vcId, InetAddress vcIp, String username, String passwd, boolean discovery, boolean persist) throws Exception {
        ConcurrentHashMap<InetAddress, VirtualCenterImpl> concurrentHashMap = this._virtualCenterByIp;
        synchronized (concurrentHashMap) {
            VirtualCenterImpl vc = this.findVirtualCenterByIp(vcIp);
            if (vc == null) {
                if (this.reachMaxVCs()) {
                    throw new Exception("Maximum number of Virtual Centers is reached.");
                }
                if (persist) {
                    boolean licenseFound = FileLicensingHelper.getInstance().hasAtLeastOneLicenseFileInstalled();
                    if (!licenseFound) {
                        FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
                        if (fabrics == null) {
                            throw new Exception("No license or managed fabric is found.");
                        }
                        for (int i = 0; i < fabrics.length; ++i) {
                            if (fabrics[i] == null || !fabrics[i].isLicensed()) continue;
                            licenseFound = true;
                            break;
                        }
                    }
                    if (!licenseFound) {
                        throw new Exception("No license is found.");
                    }
                }
                if (vcIp == null) {
                    throw new Exception("Ip address not assigned for Virtual Centers.");
                }
                String serverAddr = vcIp.getHostAddress();
                if (persist) {
                    try {
                        new ServiceInstance(new URL("https://" + serverAddr + "/sdk"), username, passwd, true);
                    }
                    catch (Exception e1) {
                        throw new Exception("Failed to connect to Virtual Center " + serverAddr);
                    }
                }
                vc = vcId > 0 ? new VirtualCenterImpl(new VcenterPK(vcId), vcIp, username, passwd, discovery) : new VirtualCenterImpl(this.createVcenterPK(), vcIp, username, passwd, discovery);
                vc.setLastUpdateTime(System.currentTimeMillis());
                vc.setServerId(this.serverId);
                this._virtualCenterByIp.put(vcIp, vc);
                if (!persist) {
                    return vc;
                }
                try {
                    InventoryPersistentManager.getInstance().persistDBObject(vc);
                }
                catch (Exception se) {
                    _Logger.warn((Object)"can not write virtual center to db", (Throwable)se);
                    throw se;
                }
            }
            throw new Exception("Virtual Center already exists: " + vcIp.getHostAddress());
            return vc;
        }
    }

    public VirtualCenterImpl createVirtualCenter(int vcId, InetAddress vcIp, String username, String passwd, boolean discovery) throws Exception {
        return this.createVirtualCenter(vcId, vcIp, username, passwd, discovery, true);
    }

    public VirtualCenterBase[] getVirtualCenters() {
        VirtualCenterImpl[] vcImpls = this.getVirtualCenterImpls();
        if (vcImpls == null) {
            return null;
        }
        VirtualCenterBase[] vcs = new VirtualCenterBase[vcImpls.length];
        for (int i = 0; i < vcImpls.length; ++i) {
            vcs[i] = (VirtualCenterBase)vcImpls[i].getBaseObject();
        }
        return vcs;
    }

    public VirtualCenterImpl[] getVirtualCenterImpls() {
        return this._virtualCenterByIp.values().toArray(new VirtualCenterImpl[this._virtualCenterByIp.size()]);
    }

    public VirtualCenterImpl findVirtualCenterByIp(InetAddress vcIp) {
        return vcIp == null ? null : this._virtualCenterByIp.get(vcIp);
    }

    public void updateVirtualCenter(InetAddress vcIp, String username, String passwd, boolean discovery) throws Exception {
        VirtualCenterImpl vc = this.findVirtualCenterByIp(vcIp);
        if (vc == null) {
            throw new Exception("VirtualCenter " + vcIp + " not found");
        }
        vc.setUserName(username);
        vc.setPassword(passwd);
        if (discovery) {
            ServiceInstance _si = null;
            try {
                String serverAddr = vc.getIpAddressAsString();
                _si = new ServiceInstance(new URL("https://" + serverAddr + "/sdk"), username, passwd, true);
            }
            catch (Exception e1) {
                throw new Exception("Invalid username / password for VirtualCenter " + vcIp);
            }
            finally {
                if (_si != null) {
                    _si.getServerConnection().logout();
                }
            }
            this.rediscoverVirtualCenter(vcIp);
        } else {
            this.closeVCenter(vc, false);
            InventoryPersistentManager.getInstance().persistDBObject(vc);
        }
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(vc.getPK(), IdentityManager.getInstance().getClientAddress(), vc.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' updated", Severity.INFO.getValue(), 2));
    }

    public void manageVirtualCenter(InetAddress vcIp) throws Exception {
        this.updateVirtualCenter(vcIp, true);
    }

    public void unManageVirtualCenter(InetAddress vcIp) throws Exception {
        this.updateVirtualCenter(vcIp, false);
    }

    private void updateVirtualCenter(InetAddress vcIp, boolean discovery) throws Exception {
        VirtualCenterImpl vc = this.findVirtualCenterByIp(vcIp);
        if (vc == null) {
            throw new Exception("VirtualCenter " + vcIp + " not found");
        }
        vc.setDiscovery(discovery);
        vc.setManageState(discovery);
        if (!discovery) {
            vc.setStatusDescription("");
        }
        InventoryPersistentManager.getInstance().persistDBObject(vc);
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(vc.getPK(), IdentityManager.getInstance().getClientAddress(), vc.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' updated", Severity.INFO.getValue(), 2));
        if (discovery) {
            this.rediscoverVirtualCenter(vcIp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualCenterImpl removeVirtualCenter(InetAddress vcIp) throws Exception {
        VirtualCenterImpl vc;
        block9: {
            vc = null;
            try {
                vc = this.findVirtualCenterByIp(vcIp);
                if (vc == null) break block9;
                VirtualCenterImpl v = VirtualCenterImpl.getByIpAddress(vc.getIpAddress());
                if (v != null && v.getStatusDescription() != null && v.getStatusDescription().equalsIgnoreCase("Discovering")) {
                    throw new Exception("VCenter is in discovering state");
                }
                ConcurrentHashMap<InetAddress, VirtualCenterImpl> concurrentHashMap = this._virtualCenterByIp;
                synchronized (concurrentHashMap) {
                    this._virtualCenterByIp.remove(vcIp);
                }
                this.closeVCenter(vc, true);
                InventoryPersistentManager.getInstance().purgeVirtualCenter(vc);
                ClusterMapping.getInstance().deleteLOGIC(this.serverId, ((VcenterPK)vc.getVcPK())._vid);
                _Logger.log((Priority)Level.INFO, (Object)("deleted vCenter " + vc));
                ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(vc.getPK(), IdentityManager.getInstance().getClientAddress(), vc.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' removed", Severity.INFO.getValue(), 2));
            }
            catch (Exception ex) {
                _Logger.log((Priority)Level.WARN, (Object)("purge vCenter " + vc), (Throwable)ex);
                throw ex;
            }
        }
        ConcurrentHashMap<InetAddress, VirtualCenterImpl> concurrentHashMap = this._virtualCenterByIp;
        synchronized (concurrentHashMap) {
            this._virtualCenterByIp.remove(vcIp);
        }
        return vc;
    }

    public boolean rediscoverVirtualCenter(InetAddress vcIp, String username, String passwd) throws Exception {
        if (vcIp == null) {
            _Logger.warn((Object)" on demand vi discovery skipped due to null IP ");
            return false;
        }
        VirtualCenterImpl vc = this._virtualCenterByIp.get(vcIp);
        if (vc == null || vc.getIpAddress() == null) {
            _Logger.warn((Object)(" on demand vi discovery skipped due to unknown IP " + vcIp.getHostAddress()));
            return false;
        }
        if (username == null || !username.equals(vc.getUserName())) {
            _Logger.warn((Object)(vc.getPK() + " on demand vi discovery skipped due to invalid username"));
            return false;
        }
        if (passwd == null || !passwd.equals(vc.getPassword())) {
            _Logger.warn((Object)(vc.getPK() + " on demand vi discovery skipped due to invalid password"));
            return false;
        }
        vc.getWorker().start(DiscoveryType.VI_ONDEMAND);
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(IdentityManager.getInstance().getClientAddress(), vc.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' rediscovered", Severity.INFO.getValue(), 2));
        return true;
    }

    public boolean rediscoverVirtualCenter(InetAddress vcIp) throws Exception {
        if (vcIp == null) {
            _Logger.warn((Object)" on demand vi discovery skipped due to null IP ");
            return false;
        }
        VirtualCenterImpl vc = this._virtualCenterByIp.get(vcIp);
        if (vc == null || vc.getIpAddress() == null) {
            _Logger.warn((Object)(" on demand vi discovery skipped due to unknown IP " + vcIp.getHostAddress()));
            return false;
        }
        vc.getWorker().start(DiscoveryType.VI_ONDEMAND);
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(new SyslogEntry(vc.getPK(), IdentityManager.getInstance().getClientAddress(), vc.getDBID(), "DCNM-VC", LogEventType.VC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Virtual Center '" + vcIp.getHostAddress() + "' rediscovered", Severity.INFO.getValue(), 2));
        return true;
    }

    public PerfCounterInfo[] getCountersByHost(String host, VirtualCenterBase vcenter) {
        return this.getCouterByEntity("HostSystem", host, vcenter);
    }

    static void printPerfCounters(PerfCounterInfo[] pcis) {
        for (int i = 0; pcis != null && i < pcis.length; ++i) {
            _Logger.debug((Object)("\nKey:" + pcis[i].getKey()));
            String perfCounter = pcis[i].getGroupInfo().getKey() + "." + pcis[i].getNameInfo().getKey() + "." + pcis[i].getRollupType();
            _Logger.debug((Object)("PerfCounter:" + perfCounter));
            _Logger.debug((Object)("Level:" + pcis[i].getLevel()));
            _Logger.debug((Object)("StatsType:" + pcis[i].getStatsType()));
            _Logger.debug((Object)("UnitInfo:" + pcis[i].getUnitInfo().getKey()));
        }
    }

    public PerfCounterInfo[] getCountersByVm(String vm, VirtualCenterBase vcenter) {
        return this.getCouterByEntity("VirtualMachine", vm, vcenter);
    }

    private PerfCounterInfo[] getCouterByEntity(String entityType, String entityName, VirtualCenterBase vcenter) {
        try {
            String vcIp;
            String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
            if (vcIp == null) {
                throw new Exception("vcIp is null");
            }
            String uname = vcenter.getUserName();
            if (uname == null) {
                throw new Exception("username is null");
            }
            String passwd = vcenter.getPassword();
            if (passwd == null) {
                throw new Exception("password is null");
            }
            ServiceInstance si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
            PerformanceManager perfMgr = si.getPerformanceManager();
            ManagedEntity entity = null;
            entity = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity(entityType, entityName);
            _Logger.debug((Object)(entityType + "***Print All Perf Counters for entity*******" + entityName));
            PerfCounterInfo[] pcis = perfMgr.getPerfCounter();
            List<PerfCounterInfo> pciList = Arrays.asList(pcis);
            PerfCounterInfo[] result = pciList.toArray(new PerfCounterInfo[0]);
            ViManager.printPerfCounters(result);
            si.getServerConnection().logout();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[][] getHistoryPMData(String entityType, String entityName, VirtualCenterBase vcenter, Calendar endtime, int duration, String groupName, String counterName) throws Exception {
        Object results;
        block42: {
            String icounterId = "@" + entityType + ":" + duration + ":" + groupName + ":" + counterName;
            if (vcenter == null) {
                throw new Exception("vCenter does not exist");
            }
            if (Boolean.getBoolean("vi.demo")) {
                return this.getHistoryPMDataDemo(entityType, duration, groupName, counterName);
            }
            results = new double[][]{};
            ServiceInstance si = null;
            String vcIp = null;
            try {
                String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
                if (vcIp == null) {
                    throw new Exception("vcIp is null");
                }
                String uname = vcenter.getUserName();
                if (uname == null) {
                    throw new Exception("username is null");
                }
                String passwd = vcenter.getPassword();
                if (passwd == null) {
                    throw new Exception("password is null");
                }
                try {
                    si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
                }
                catch (Exception e1) {
                    throw new Exception("Failed to connect to Virtual Center " + vcIp + " to retrieve History PM Data");
                }
                ManagedEntity entity = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity(entityType, entityName);
                if (entity == null) {
                    VHostImpl vhost = null;
                    if (vcenter.getVcIP() != null) {
                        VirtualCenterImpl vc = VirtualCenterImpl.getByIpAddress(vcenter.getVcIP());
                        vhost = VHostImpl.getVhostByFullName(vc, entityName);
                    }
                    if (vhost != null && vhost.getIpAddresses() != null && !vhost.getIpAddresses().isEmpty()) {
                        entity = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity(entityType, vhost.getIpAddresses().get(0));
                    }
                    if (entity == null) {
                        _Logger.warn((Object)("****Entity not found****" + entityName));
                        throw new Exception(entityType + " " + entityName + " not found at Virtual Center " + vcIp);
                    }
                }
                PerformanceManager perfMgr = si.getPerformanceManager();
                this.CounterInfo(perfMgr, entity);
                String dur = "";
                int durSecs = -1;
                if (duration == 1) {
                    durSecs = 86400;
                    dur = "Past day";
                } else if (duration == 2) {
                    durSecs = 604800;
                    dur = "Past week";
                } else if (duration == 3) {
                    durSecs = 2592000;
                    dur = "Past month";
                } else if (duration == 4) {
                    durSecs = 31536000;
                    dur = "Past year";
                }
                PerfInterval[] intervals = perfMgr.getHistoricalInterval();
                int interval = this.getInterval(intervals, durSecs, dur);
                if (interval == -1) {
                    _Logger.warn((Object)("No " + dur + " history PM data available on entity " + entityName + " to collect."));
                    double[][] dArrayArray = results;
                    return dArrayArray;
                }
                PerfCounterInfo pci = null;
                pci = groupName.equals("disk") && counterName.equals("maxTotalLatency") ? this.getCounterInfo(groupName, counterName, PerfSummaryType.latest, null) : this.getCounterInfo(groupName, counterName, PerfSummaryType.average, null);
                if (pci == null) {
                    _Logger.error((Object)"Incorrect Group Name and Countername specified");
                    double[][] dArray = null;
                    return dArray;
                }
                PerfQuerySpec qSpec = new PerfQuerySpec();
                qSpec.setEntity(entity.getMOR());
                qSpec.setMaxSample(new Integer(10));
                PerfQuerySpec[] qSpecs = new PerfQuerySpec[]{qSpec};
                Calendar eTime = endtime;
                Calendar sTime = Calendar.getInstance();
                sTime.setTime(eTime.getTime());
                if (duration == 1) {
                    sTime.add(5, -1);
                } else if (duration == 2) {
                    sTime.add(3, -1);
                } else if (duration == 3) {
                    sTime.add(2, -1);
                } else if (duration == 4) {
                    sTime.add(1, -1);
                }
                _Logger.debug((Object)("Start Time " + sTime.getTime().toString()));
                _Logger.debug((Object)("End Time   " + eTime.getTime().toString()));
                PerfMetricId[] aMetrics = perfMgr.queryAvailablePerfMetric(entity, null, null, new Integer(interval));
                PerfMetricId ourCounter = null;
                if (aMetrics == null) {
                    double[][] dArray = null;
                    return dArray;
                }
                for (int index = 0; index < aMetrics.length; ++index) {
                    if (aMetrics[index].getCounterId() != pci.getKey()) continue;
                    ourCounter = aMetrics[index];
                    break;
                }
                if (ourCounter == null) {
                    _Logger.warn((Object)("No history PM data on " + entityName + ":" + pci.getGroupInfo().getKey() + ":" + pci.getNameInfo().getKey() + " to collect."));
                    throw new Exception("No history PM data on " + entityName + ":" + pci.getGroupInfo().getKey() + ":" + pci.getNameInfo().getKey() + " to collect.");
                }
                qSpec = new PerfQuerySpec();
                qSpec.setEntity(entity.getMOR());
                qSpec.setStartTime(sTime);
                qSpec.setEndTime(eTime);
                qSpec.setMetricId(new PerfMetricId[]{ourCounter});
                qSpec.setIntervalId(Integer.valueOf(interval));
                qSpecs = new PerfQuerySpec[]{qSpec};
                PerfEntityMetricBase[] samples = perfMgr.queryPerf(qSpecs);
                if (samples != null) {
                    results = this.displayValues(samples, pci, ourCounter, interval, icounterId);
                    if ((groupName.equals("cpu") || groupName.equals("mem")) && counterName.equals("usage")) {
                        for (int i = 0; i < ((double[][])results).length; ++i) {
                            results[i][1] = results[i][1] / 100.0;
                        }
                    }
                    break block42;
                }
                _Logger.debug((Object)("No samples found for " + entityName));
                throw new Exception("No samples found for " + entityName);
            }
            catch (Exception e) {
                _Logger.warn((Object)("getHistoryPMData failed for " + vcIp + " " + entityType + ":" + entityName + ":" + groupName + ":" + counterName), (Throwable)e);
                throw e;
            }
            finally {
                if (si != null) {
                    si.getServerConnection().logout();
                }
            }
        }
        return results;
    }

    private int getInterval(PerfInterval[] intervals, int durSecs, String durName) {
        if (intervals != null) {
            for (int i = 0; i < intervals.length; ++i) {
                PerfInterval pi = intervals[i];
                _Logger.debug((Object)(pi.getSamplingPeriod() + "\t" + pi.getLength() + "\t" + pi.getName()));
                if (pi == null || durName == null || pi.getLength() != durSecs && !durName.equals(pi.getName())) continue;
                return pi.getSamplingPeriod();
            }
        }
        return -1;
    }

    private PerfCounterInfo[] getCounterInfo(PerformanceManager perfMgr, String[] counters, PerfStatsType statsType) {
        if (counters == null || counters.length == 0) {
            return null;
        }
        PerfCounterInfo[] resultList = new PerfCounterInfo[counters.length];
        PerfCounterInfo[] cInfos = perfMgr.getPerfCounter();
        int num = 0;
        for (int i = 0; i < cInfos.length; ++i) {
            PerfCounterInfo cInfo = cInfos[i];
            String group = cInfo.getGroupInfo().getKey();
            String counterName = cInfo.getNameInfo().getKey();
            String rollupType = cInfo.getRollupType().name();
            String pcounter = group + "." + counterName + "." + rollupType;
            for (int j = 0; j < counters.length; ++j) {
                if (!counters[j].equals(pcounter)) continue;
                resultList[j] = cInfo;
                ++num;
                break;
            }
            if (num == counters.length) break;
        }
        return resultList;
    }

    private PerfCounterInfo getCounterInfo(String groupName, String counterName, PerfSummaryType rollupType, PerfStatsType statsType) {
        if (groupName == null || counterName == null || rollupType == null) {
            return null;
        }
        ArrayList counters = this.getCounterInfos(groupName, counterName + "." + rollupType.name());
        PerfCounterInfo res = null;
        if (counters != null) {
            for (PerfCounterInfo pci : counters) {
                if (!groupName.equalsIgnoreCase(pci.groupInfo.key) || !counterName.equalsIgnoreCase(pci.nameInfo.key) || !rollupType.name().equals(pci.getRollupType().name())) continue;
                res = pci;
            }
        }
        return res;
    }

    private ArrayList getCounterInfos(String groupName, String counterName) {
        ArrayList ret;
        Map nameMap = (Map)this._pci.get(groupName);
        if (nameMap != null && (ret = (ArrayList)nameMap.get(counterName)) != null) {
            return new ArrayList(ret);
        }
        return null;
    }

    private void CounterInfo(PerformanceManager perfMgr, ManagedEntity entity) throws Exception {
        PerfCounterInfo[] cInfos = perfMgr.getPerfCounter();
        for (int i = 0; i < cInfos.length; ++i) {
            PerfCounterInfo cInfo = cInfos[i];
            String group = cInfo.getGroupInfo().getKey();
            Map<String, ArrayList> nameMap = null;
            if (!this._pci.containsKey(group)) {
                nameMap = new HashMap();
                this._pci.put(group, nameMap);
            } else {
                nameMap = (Map)this._pci.get(group);
            }
            String name = cInfo.getNameInfo().getKey();
            String rollupType = cInfo.getRollupType().name();
            if (rollupType != null) {
                name = name + "." + rollupType;
            }
            ArrayList counters = null;
            if (!nameMap.containsKey(name)) {
                counters = new ArrayList();
                nameMap.put(name, counters);
            } else {
                counters = (ArrayList)nameMap.get(name);
            }
            counters.add(cInfo);
        }
    }

    public double[][] getPMDataRealTimeByHost(String host, String groupName, String counterName, VirtualCenterBase vcenter) {
        try {
            String vcIp;
            String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
            if (vcIp == null) {
                throw new Exception("vcIp is null");
            }
            String uname = vcenter.getUserName();
            if (uname == null) {
                throw new Exception("username is null");
            }
            String passwd = vcenter.getPassword();
            if (passwd == null) {
                throw new Exception("password is null");
            }
            ServiceInstance si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
            ManagedEntity h = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity("HostSystem", host);
            return this.getPmDataByEntity(si, h, null, null, 0, groupName, counterName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[][] getPMDataRealTimeByVm(String vm, String groupName, String counterName, VirtualCenterBase vcenter) {
        try {
            String vcIp;
            String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
            if (vcIp == null) {
                throw new Exception("vcIp is null");
            }
            String uname = vcenter.getUserName();
            if (uname == null) {
                throw new Exception("username is null");
            }
            String passwd = vcenter.getPassword();
            if (passwd == null) {
                throw new Exception("password is null");
            }
            ServiceInstance si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
            ManagedEntity machine = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity("VirtualMachine", vm);
            return this.getPmDataByEntity(si, machine, null, null, 0, groupName, counterName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public double[][] getRealTimePMData(String entityType, String entityName, String[] counters, VirtualCenterBase vcenter) {
        try {
            String vcIp;
            String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
            if (vcIp == null) {
                throw new Exception("vcIp is null");
            }
            String uname = vcenter.getUserName();
            if (uname == null) {
                throw new Exception("username is null");
            }
            String passwd = vcenter.getPassword();
            if (passwd == null) {
                throw new Exception("password is null");
            }
            ServiceInstance si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
            ManagedEntity me = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntity(entityType, entityName);
            return this.getPmDataByEntity(si, me, null, null, 0, counters);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NameValuePair> getRealTimePMData(String entityType, String[] counters, VirtualCenterBase vcenter) {
        ServiceInstance si = null;
        String vcIp = null;
        try {
            String string = vcIp = vcenter.getVcIP() == null ? null : vcenter.getVcIP().getHostAddress();
            if (vcIp == null) {
                throw new Exception("vcIp is null");
            }
            String uname = vcenter.getUserName();
            if (uname == null) {
                throw new Exception("username is null");
            }
            String passwd = vcenter.getPassword();
            if (passwd == null) {
                throw new Exception("password is null");
            }
            si = new ServiceInstance(new URL("https://" + vcIp + "/sdk"), uname, passwd, true);
            ManagedEntity[] me = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntities(entityType);
            List<NameValuePair> list = this.getPmDataByEntities(si, me, null, null, 0, counters);
            return list;
        }
        catch (Exception e) {
            _Logger.warn((Object)("getRealTimePMData failed for " + vcIp + " " + entityType + ":" + counters), (Throwable)e);
        }
        finally {
            if (si != null) {
                si.getServerConnection().logout();
            }
        }
        return null;
    }

    public List<NameValuePair> getRealTimePMData(String entityType, String[] counters, ServiceInstance si) {
        try {
            if (si == null) {
                return null;
            }
            ManagedEntity[] me = new InventoryNavigator((ManagedEntity)si.getRootFolder()).searchManagedEntities(entityType);
            return this.getPmDataByEntities(si, me, null, null, 0, counters);
        }
        catch (Exception e) {
            _Logger.warn((Object)("getRealTimePMData failed for " + si + " " + entityType + ":" + counters), (Throwable)e);
            return null;
        }
    }

    private List<NameValuePair> getPmDataByEntities(ServiceInstance si, ManagedEntity[] entities, Calendar startTime, Calendar endTime, int interval, String[] counters) {
        try {
            if (entities == null || entities.length == 0) {
                return null;
            }
            List<NameValuePair> results = null;
            PerformanceManager perfMgr = si.getPerformanceManager();
            _Logger.debug((Object)(entities[0].getClass() + "***Print Perf Real time data for entity****" + entities[0].getClass()));
            PerfCounterInfo[] pcis = this.getCounterInfo(perfMgr, counters, null);
            if (pcis == null || pcis.length == 0) {
                _Logger.error((Object)"Incorrect Group Name and Countername specified");
                return null;
            }
            ArrayList<PerfQuerySpec> qSpecList = new ArrayList<PerfQuerySpec>();
            for (int i = 0; i < entities.length; ++i) {
                if (interval == 0) {
                    PerfProviderSummary pps = perfMgr.queryPerfProviderSummary(entities[i]);
                    interval = pps.getRefreshRate();
                }
                PerfMetricId[] pmis = perfMgr.queryAvailablePerfMetric(entities[i], startTime, endTime, Integer.valueOf(interval));
                ArrayList<PerfMetricId> ourCounters = new ArrayList<PerfMetricId>();
                int num = 0;
                for (int index = 0; pmis != null && index < pmis.length; ++index) {
                    for (int j = 0; j < pcis.length; ++j) {
                        if (pmis[index].getCounterId() != pcis[j].getKey()) continue;
                        ourCounters.add(pmis[index]);
                        ++num;
                        break;
                    }
                    if (num == pcis.length) break;
                }
                if (num == 0) {
                    String counterStr = "";
                    for (int k = 0; k < counters.length; ++k) {
                        counterStr = counterStr + counters[k] + " ";
                    }
                    _Logger.warn((Object)("No PM data on entity to collect for " + entities[i].getName() + ":" + counterStr));
                    continue;
                }
                PerfMetricId[] pmIds = ourCounters.toArray(new PerfMetricId[ourCounters.size()]);
                PerfQuerySpec qSpec = ViManager.createPerfQuerySpec(entities[i], pmIds, 1, interval);
                qSpecList.add(qSpec);
            }
            if (qSpecList.size() == 0) {
                return null;
            }
            PerfQuerySpec[] qSpecs = qSpecList.toArray(new PerfQuerySpec[qSpecList.size()]);
            PerfEntityMetricBase[] pValues = perfMgr.queryPerf(qSpecs);
            if (pValues != null) {
                results = ViManager.constructValueEntities(pValues);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private double[][] getPmDataByEntity(ServiceInstance si, ManagedEntity entity, Calendar startTime, Calendar endTime, int interval, String[] counters) {
        try {
            PerfCounterInfo[] pcis;
            double[][] results = null;
            PerformanceManager perfMgr = si.getPerformanceManager();
            _Logger.debug((Object)(entity.getClass() + "***Print Perf Real time data for entity****" + entity.getName()));
            if (interval == 0) {
                PerfProviderSummary pps = perfMgr.queryPerfProviderSummary(entity);
                interval = pps.getRefreshRate();
            }
            if ((pcis = this.getCounterInfo(perfMgr, counters, null)) == null || pcis.length == 0) {
                _Logger.error((Object)"Incorrect Group Name and Countername specified");
                return null;
            }
            PerfMetricId[] pmis = perfMgr.queryAvailablePerfMetric(entity, startTime, endTime, Integer.valueOf(interval));
            ArrayList<PerfMetricId> ourCounters = new ArrayList<PerfMetricId>();
            for (int index = 0; index < pmis.length; ++index) {
                for (int j = 0; j < pcis.length; ++j) {
                    if (pmis[index].getCounterId() != pcis[j].getKey()) continue;
                    ourCounters.add(pmis[index]);
                }
                if (ourCounters.size() == pcis.length) break;
            }
            if (ourCounters.size() == 0) {
                String counterStr = "";
                for (int k = 0; k < counters.length; ++k) {
                    counterStr = counterStr + counters[k] + " ";
                }
                _Logger.warn((Object)("No PM data on entity to collect for " + entity.getName() + ":" + counterStr));
                return null;
            }
            PerfMetricId[] pmIds = ourCounters.toArray(new PerfMetricId[ourCounters.size()]);
            PerfQuerySpec qSpec = ViManager.createPerfQuerySpec(entity, pmIds, 1, interval);
            PerfEntityMetricBase[] pValues = perfMgr.queryPerf(new PerfQuerySpec[]{qSpec});
            if (pValues != null) {
                results = ViManager.displayValues(pValues);
            }
            si.getServerConnection().logout();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private double[][] getPmDataByEntity(ServiceInstance si, ManagedEntity entity, Calendar startTime, Calendar endTime, int interval, String groupName, String counterName) {
        try {
            PerfCounterInfo pci;
            double[][] results = null;
            PerformanceManager perfMgr = si.getPerformanceManager();
            if (entity == null) {
                return null;
            }
            _Logger.debug((Object)(entity.getClass() + "***Print Perf Real time data for entity****" + entity.getName()));
            this.CounterInfo(perfMgr, entity);
            if (interval == 0) {
                PerfProviderSummary pps = perfMgr.queryPerfProviderSummary(entity);
                interval = pps.getRefreshRate();
            }
            if ((pci = this.getCounterInfo(groupName, counterName, PerfSummaryType.average, null)) == null) {
                _Logger.error((Object)"Incorrect Group Name and Countername specified");
                return null;
            }
            PerfMetricId[] pmis = perfMgr.queryAvailablePerfMetric(entity, startTime, endTime, Integer.valueOf(interval));
            PerfMetricId ourCounter = null;
            for (int index = 0; index < pmis.length; ++index) {
                if (pmis[index].getCounterId() != pci.getKey()) continue;
                ourCounter = pmis[index];
                break;
            }
            if (ourCounter == null) {
                _Logger.warn((Object)("No PM data on enttiy to collect. " + entity.getName() + ":" + groupName + ":" + counterName));
                return null;
            }
            PerfQuerySpec qSpec = ViManager.createPerfQuerySpec(entity, new PerfMetricId[]{ourCounter}, 1, interval);
            PerfEntityMetricBase[] pValues = perfMgr.queryPerf(new PerfQuerySpec[]{qSpec});
            if (pValues != null) {
                results = ViManager.displayValues(pValues);
            }
            si.getServerConnection().logout();
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static PerfQuerySpec createPerfQuerySpec(ManagedEntity me, PerfMetricId[] metricIds, int maxSample, int interval) {
        PerfQuerySpec qSpec = new PerfQuerySpec();
        qSpec.setEntity(me.getMOR());
        qSpec.setMaxSample(new Integer(maxSample));
        qSpec.setMetricId(metricIds);
        qSpec.setIntervalId(new Integer(interval));
        return qSpec;
    }

    static List<NameValuePair> constructValueEntities(PerfEntityMetricBase[] values) {
        ArrayList<NameValuePair> resultList = new ArrayList<NameValuePair>();
        if (values == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            String entityDesc = values[i].getEntity().getType() + ":" + values[i].getEntity().get_value();
            _Logger.debug((Object)("Entity:" + entityDesc));
            if (values[i] instanceof PerfEntityMetric) {
                NameValuePair stats = ViManager.constructPerfMetric((PerfEntityMetric)values[i], values[i].getEntity());
                resultList.add(stats);
                continue;
            }
            _Logger.debug((Object)"UnExpected sub-type of PerfEntityMetricBase.");
        }
        return resultList;
    }

    static double[][] displayValues(PerfEntityMetricBase[] values) {
        double[][] stats = null;
        if (values == null) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            String entityDesc = values[i].getEntity().getType() + ":" + values[i].getEntity().get_value();
            _Logger.debug((Object)("Entity:" + entityDesc));
            if (values[i] instanceof PerfEntityMetric) {
                stats = ViManager.printPerfMetric((PerfEntityMetric)values[i]);
                continue;
            }
            _Logger.debug((Object)"UnExpected sub-type of PerfEntityMetricBase.");
        }
        return stats;
    }

    static NameValuePair constructPerfMetric(PerfEntityMetric pem, ManagedObjectReference entity) {
        PerfMetricSeries[] vals = pem.getValue();
        PerfSampleInfo[] samples = pem.getSampleInfo();
        if (samples == null || samples.length == 0) {
            return null;
        }
        double[][] stats = new double[samples.length * vals.length][2];
        _Logger.debug((Object)"Sampling Times and Intervales:");
        for (int i = 0; samples != null && i < samples.length; ++i) {
            _Logger.debug((Object)("Sample time: " + samples[i].getTimestamp().getTime()));
            _Logger.debug((Object)("Sample interval (sec):" + samples[i].getInterval()));
        }
        _Logger.debug((Object)"Sample values:");
        for (int j = 0; vals != null && j < vals.length; ++j) {
            PerfMetricIntSeries val;
            int counterId = vals[j].getId().getCounterId();
            _Logger.debug((Object)("Perf counter ID:" + vals[j].getId().getCounterId()));
            _Logger.debug((Object)("Device instance ID:" + vals[j].getId().getInstance()));
            if (vals[j] instanceof PerfMetricIntSeries) {
                val = (PerfMetricIntSeries)vals[j];
                long[] longs = val.getValue();
                for (int k = 0; k < longs.length; ++k) {
                    _Logger.debug((Object)(longs[k] + " "));
                    stats[j * samples.length + k][1] = longs[k];
                    stats[j * samples.length + k][0] = counterId == 94 || counterId == 95 ? (double)counterId : (double)samples[k].getTimestamp().getTimeInMillis();
                }
                _Logger.debug((Object)("Total:" + longs.length));
                continue;
            }
            if (!(vals[j] instanceof PerfMetricSeriesCSV)) continue;
            val = (PerfMetricSeriesCSV)vals[j];
            _Logger.debug((Object)("CSV value:" + val.getValue()));
        }
        return new NameValuePair<ManagedObjectReference, double[][]>(entity, stats);
    }

    static double[][] printPerfMetric(PerfEntityMetric pem) {
        PerfMetricSeries[] vals = pem.getValue();
        PerfSampleInfo[] infos = pem.getSampleInfo();
        if (infos == null || infos.length == 0) {
            return null;
        }
        double[][] stats = new double[vals.length][2];
        _Logger.debug((Object)"Sampling Times and Intervales:");
        for (int i = 0; infos != null && i < infos.length; ++i) {
            _Logger.debug((Object)("Sample time: " + infos[i].getTimestamp().getTime()));
            _Logger.debug((Object)("Sample interval (sec):" + infos[i].getInterval()));
        }
        _Logger.debug((Object)"Sample values:");
        for (int j = 0; vals != null && j < vals.length; ++j) {
            PerfMetricIntSeries val;
            _Logger.debug((Object)("Perf counter ID:" + vals[j].getId().getCounterId()));
            _Logger.debug((Object)("Device instance ID:" + vals[j].getId().getInstance()));
            if (vals[j] instanceof PerfMetricIntSeries) {
                val = (PerfMetricIntSeries)vals[j];
                long[] longs = val.getValue();
                for (int k = 0; k < longs.length; ++k) {
                    _Logger.debug((Object)(longs[k] + " "));
                    stats[j * infos.length + k][1] = longs[k];
                    stats[j * infos.length + k][0] = infos[k].getTimestamp().getTimeInMillis();
                }
                _Logger.debug((Object)("Total:" + longs.length));
                continue;
            }
            if (!(vals[j] instanceof PerfMetricSeriesCSV)) continue;
            val = (PerfMetricSeriesCSV)vals[j];
            _Logger.debug((Object)("CSV value:" + val.getValue()));
        }
        return stats;
    }

    static void printPerfMetricCSV(PerfEntityMetricCSV pems) {
        _Logger.debug((Object)("SampleInfoCSV:" + pems.getSampleInfoCSV()));
        PerfMetricSeriesCSV[] csvs = pems.getValue();
        for (int i = 0; i < csvs.length; ++i) {
            _Logger.debug((Object)("PerfCounterId:" + csvs[i].getId().getCounterId()));
            _Logger.debug((Object)("CSV sample values:" + csvs[i].getValue()));
        }
    }

    private double[][] displayValues(PerfEntityMetricBase[] values, PerfCounterInfo pci, PerfMetricId pmid, Integer interval, String counterId) {
        double[][] stats = null;
        for (int i = 0; i < values.length; ++i) {
            PerfMetricSeries[] vals = ((PerfEntityMetric)values[i]).getValue();
            PerfSampleInfo[] infos = ((PerfEntityMetric)values[i]).getSampleInfo();
            if (infos == null || infos.length == 0) {
                _Logger.debug((Object)"No Samples available. Continuing.");
                continue;
            }
            _Logger.debug((Object)("Sample time range: " + infos[0].getTimestamp().getTime().toString() + " - " + infos[infos.length - 1].getTimestamp().getTime().toString() + ", read every " + interval + " seconds"));
            for (int vi = 0; vi < vals.length; ++vi) {
                if (pci != null) {
                    if (pci.getKey() != vals[vi].getId().getCounterId()) continue;
                    _Logger.debug((Object)(pci.getNameInfo().getSummary() + " - Instance: " + pmid.getInstance()));
                }
                if (!(vals[vi] instanceof PerfMetricIntSeries)) continue;
                PerfMetricIntSeries val = (PerfMetricIntSeries)vals[vi];
                long[] longs = val.getValue();
                if (longs != null && longs.length > 0) {
                    stats = new double[longs.length][2];
                }
                for (int k = 0; longs != null && k < longs.length; ++k) {
                    _Logger.debug((Object)(infos[k].getTimestamp().getTime().toString() + "=====> "));
                    _Logger.debug((Object)(longs[k] + " "));
                    stats[k][0] = infos[k].getTimestamp().getTimeInMillis();
                    stats[k][1] = longs[k];
                }
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVCsFromDB() {
        InventoryPersistentManager mgr = InventoryPersistentManager.getInstance();
        this._dbLoadStatus = SanManager.DbLoadStatus.LOADING;
        try {
            try {
                this.serverId = ClusterSequence.getSequence().getServerId();
            }
            catch (Exception ex) {
                _Logger.warn((Object)"SanWS getVirtualCentersfailed on qALlIPStrings(), default to federation false");
            }
            List<Integer> fIds = ClusterMapping.getInstance().qFIdsFromSId(this.serverId);
            ArrayList al = VirtualCenterImpl.loadPersistentVirtualCentersFromDB();
            if (al != null) {
                for (VirtualCenterImpl vc : al) {
                    if (!fIds.contains(new Integer(((VcenterPK)vc.getVcPK())._vid))) continue;
                    ConcurrentHashMap<InetAddress, VirtualCenterImpl> concurrentHashMap = this._virtualCenterByIp;
                    synchronized (concurrentHashMap) {
                        this._virtualCenterByIp.put(vc.getIpAddress(), vc);
                    }
                }
                VirtualCenterImpl[] vcs = this.getVirtualCenterImpls();
                if (vcs != null) {
                    Thread runner = new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(300000L);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                            VirtualCenterImpl[] vcenters = ViManager.this.getVirtualCenterImpls();
                            DiscoveryManager dm = DiscoveryManager.getInstance();
                            for (int i = 0; i < vcenters.length; ++i) {
                                if (!vcenters[i].getDiscovery()) continue;
                                dm.discoverVC(vcenters[i], DiscoveryType.VI_INITIAL);
                            }
                        }
                    };
                    runner.start();
                }
                this._dbLoadStatus = SanManager.DbLoadStatus.LOADED;
            } else {
                this._dbLoadStatus = SanManager.DbLoadStatus.LOADFAILED;
            }
        }
        catch (SQLException ex) {
            _Logger.error((Object)"load virtual center from db failed:", (Throwable)ex);
            this._dbLoadStatus = SanManager.DbLoadStatus.LOADFAILED;
        }
    }

    public VHostImpl[] getHosts() {
        Iterator<VirtualCenterImpl> itr = this._virtualCenterByIp.values().iterator();
        ArrayList<VHostImpl> vhostList = new ArrayList<VHostImpl>();
        while (itr.hasNext()) {
            VirtualCenterImpl map = itr.next();
            vhostList.addAll(map.getAllHosts());
        }
        return vhostList.toArray(new VHostImpl[vhostList.size()]);
    }

    public boolean reachMaxVCs() {
        Integer maxopen = Integer.getInteger("vi.maxopen");
        return maxopen != null && maxopen <= this._virtualCenterByIp.size();
    }

    public boolean isOpened(InetAddress vcIp) throws Exception {
        if (vcIp == null) {
            return false;
        }
        VirtualCenterImpl vc = this.findVirtualCenterByIp(vcIp);
        if (vc != null) {
            return vc.getManageState();
        }
        return false;
    }

    public static double[][] readFile2(String fileName) {
        String line = "";
        ArrayList<String> data = new ArrayList<String>();
        double[][] results = null;
        try {
            FileReader fr = new FileReader(fileName);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                data.add(line);
            }
            if (data.size() == 0) {
                return null;
            }
            results = new double[data.size()][2];
            for (int i = 0; i < data.size(); ++i) {
                String iline = (String)data.get(i);
                String[] theline = iline.split(" ");
                results[i][0] = Double.valueOf(theline[0].trim());
                results[i][1] = Double.valueOf(theline[1].trim());
            }
        }
        catch (FileNotFoundException fN) {
            fN.printStackTrace();
        }
        catch (IOException e) {
            _Logger.warn((Object)("Read file " + fileName + " IO error"), (Throwable)e);
        }
        return results;
    }

    public double[][] getHistoryPMDataDemo(String entityType, int duration, String groupName, String counterName) throws Exception {
        String line = "";
        String counterId = "@" + entityType + ":" + duration + ":" + groupName + ":" + counterName;
        ArrayList<String> data = new ArrayList<String>();
        double[][] results = null;
        try {
            String inFile = ClientCache.getConfDir() + VM_PM_FILE;
            FileReader fr = new FileReader(inFile);
            BufferedReader br = new BufferedReader(fr);
            while (!((line = br.readLine()) == null || line.startsWith("@") && line.equals(counterId))) {
            }
            while ((line = br.readLine()) != null && !line.startsWith("@")) {
                data.add(line);
            }
            if (data.size() == 0) {
                return null;
            }
            results = new double[data.size()][2];
            for (int i = 0; i < data.size(); ++i) {
                String iline = (String)data.get(i);
                String[] theline = iline.split(" ");
                results[i][0] = Double.valueOf(theline[0].trim());
                results[i][1] = Double.valueOf(theline[1].trim());
            }
        }
        catch (FileNotFoundException fN) {
            fN.printStackTrace();
        }
        catch (IOException e) {
            _Logger.warn((Object)"Read file pmData.txt IO error", (Throwable)e);
        }
        return results;
    }

    public void closeVCenter(VirtualCenterImpl vc, boolean cleanCache) throws Exception {
        try {
            vc.close(cleanCache);
        }
        catch (Exception ex) {
            _Logger.log((Priority)Level.WARN, (Object)("close virtual center" + vc + "error: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
    }

    synchronized VcenterPK createVcenterPK() {
        try {
            int vcId = (int)Sequence.getSequence().getFabricPK();
            return new VcenterPK(vcId);
        }
        catch (SQLException ex) {
            _Logger.log((Priority)Level.WARN, (Object)"Cannot create VcenterPK from sequence id, choose default 1 as VcenterPK id");
            return new VcenterPK(1);
        }
    }
}

