/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.vi.model;

import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.vi.model.GuestNic;
import com.cisco.dcbu.vi.model.ManagedEntity;
import com.cisco.dcbu.vi.model.PhyNic;
import java.util.ArrayList;
import java.util.Date;

public class VirtualMachine
extends ManagedEntity {
    static final long serialVersionUID = 1L;
    protected NameKey _pkey;
    private String _name;
    private String _fullName;
    private long _memorySize;
    private int _cpuCount;
    private long _hostId;
    private String _ostype = "";
    private String _dnsname;
    private String _ipaddress;
    private int _powerState;
    private String _guestHeartbeatStatus;
    private GuestNic[] _vnic;
    private PhyNic[] _pnic;
    protected NameKey _vhostPK;
    protected NameKey _dataStorePK;
    protected String _dataStore;
    protected double _diskReadAvg;
    protected double _diskWriteAvg;
    protected long _lastUpdateTime;
    public static final String VALUE_NA = "n/a";
    static final String[] LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};

    public VirtualMachine() {
    }

    public VirtualMachine(String name, String moRef, long memorySize, int cpuCount, String ostype) {
        this._name = name;
        this._fullName = name;
        this._memorySize = memorySize;
        this._cpuCount = cpuCount;
        this._ostype = ostype;
        this._moRef = moRef;
        this.setNameKey(new NameKey(moRef));
    }

    public VirtualMachine(String name, String fullName, String moRef, long memorySize, int cpuCount, String ostype) {
        this._name = name;
        this._fullName = fullName;
        this._memorySize = memorySize;
        this._cpuCount = cpuCount;
        this._ostype = ostype;
        this._moRef = moRef;
        this.setNameKey(new NameKey(moRef));
    }

    public VirtualMachine(String name, String fullName, String moRef, long memorySize, int cpuCount, long hostId, String ostype, String ipaddr, int powerState) {
        this._name = name;
        this._fullName = fullName;
        this._memorySize = memorySize;
        this._cpuCount = cpuCount;
        this._hostId = hostId;
        this._ostype = ostype;
        this._ipaddress = ipaddr;
        this._powerState = powerState;
        this._moRef = moRef;
        this.setNameKey(new NameKey(moRef));
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public void setFullName(String _fullName) {
        this._fullName = _fullName;
    }

    public long getMemorySize() {
        return this._memorySize;
    }

    public void setMemorySize(long memorySize) {
        this._memorySize = memorySize;
    }

    public int getCpuCount() {
        return this._cpuCount;
    }

    public void setCpuCount(int cpuCount) {
        this._cpuCount = cpuCount;
    }

    public int getPowerState() {
        return this._powerState;
    }

    public void setPowerState(int powerState) {
        this._powerState = powerState;
    }

    public double getDiskReadAvg() {
        return this._diskReadAvg;
    }

    public void setDiskReadAvg(double diskReadAvg) {
        this._diskReadAvg = diskReadAvg;
    }

    public double getDiskWriteAvg() {
        return this._diskWriteAvg;
    }

    public void setDiskWriteAvg(double diskWriteAvg) {
        this._diskWriteAvg = diskWriteAvg;
    }

    public String getOstype() {
        return this._ostype;
    }

    public void setOstype(String ostype) {
        this._ostype = ostype;
    }

    public String getIpAddress() {
        return this._ipaddress;
    }

    public void setIpAddress(String ipaddress) {
        this._ipaddress = ipaddress;
    }

    public String getDnsName() {
        return this._dnsname;
    }

    public void setDnsName(String dnsname) {
        this._dnsname = dnsname;
    }

    public GuestNic[] getVnic() {
        return this._vnic;
    }

    public void setVnic(GuestNic[] vnic) {
        this._vnic = vnic;
    }

    public ArrayList<String> getPnicKeys() {
        if (this._pnic == null) {
            return null;
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < this._pnic.length; ++i) {
            resultList.add(this._pnic[i].getKey());
        }
        return resultList;
    }

    public PhyNic[] getPnic() {
        return this._pnic;
    }

    public void setPnic(PhyNic[] pnic) {
        this._pnic = pnic;
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this._lastUpdateTime = lastUpdateTime;
    }

    public long getHostId() {
        return this._hostId;
    }

    public void setHostId(long hostId) {
        this._hostId = hostId;
    }

    public void setVhostPK(NameKey vhostPK) {
        this.setModified(true);
        this._vhostPK = vhostPK;
    }

    public NameKey getVhostPK() {
        return this._vhostPK;
    }

    public void setDataStorePK(NameKey dataStorePK) {
        this.setModified(true);
        this._dataStorePK = dataStorePK;
    }

    public NameKey getDataStorePK() {
        return this._dataStorePK;
    }

    public String getDataStore() {
        return this._dataStore;
    }

    public void setDataStore(String dataStore) {
        this._dataStore = dataStore;
    }

    public String getGuestHeartbeatStatus() {
        return this._guestHeartbeatStatus;
    }

    public void setGuestHeartbeatStatus(String guestHeartbeatStatus) {
        this._guestHeartbeatStatus = guestHeartbeatStatus;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(this._name).append(", fullName=").append(this._fullName).append(", memorySize=").append(this._memorySize).append(", cpuCount=").append(this._cpuCount).append(", hostId=").append(this._hostId).append(", osType=").append(this._ostype).append(", dnsName=").append(this._dnsname).append(", ipAddress=").append(this._ipaddress).append(", guestHeartbeatStatus=").append(this._guestHeartbeatStatus).append(", powerState=").append(this._powerState).append(", dataStore=").append(this._dataStore).append(", diskReadAvg=").append(this._diskReadAvg).append(", diskWriteAvg=").append(this._diskWriteAvg).append(", lastUpdateTime=").append(new Date(this._lastUpdateTime));
        sb.append("Virtual NICs: ");
        GuestNic[] vnics = this.getVnic();
        if (vnics == null || vnics.length == 0) {
            sb.append(VALUE_NA);
        } else {
            for (int i = 0; i < vnics.length; ++i) {
                if (vnics[i] == null) continue;
                sb.append(", network=").append(vnics[i].getNetwork()).append(", macAddress=").append(vnics[i].getMacAddress()).append("ipAddresses: ");
                String[] ipAddresses = vnics[i].getIpAddress();
                for (int j = 0; ipAddresses != null && j < ipAddresses.length; ++j) {
                    sb.append(ipAddresses[j]).append(",");
                }
            }
        }
        sb.append("Host Physical NICs: ");
        PhyNic[] pnics = this.getPnic();
        if (pnics == null || pnics.length == 0) {
            sb.append(VALUE_NA);
        } else {
            for (int i = 0; i < pnics.length; ++i) {
                if (pnics[i] == null) continue;
                sb.append(", device=").append(pnics[i].getDevice()).append(", key=").append(pnics[i].getKey()).append(", macAddress=").append(pnics[i].getMac());
            }
        }
        return sb.toString();
    }
}

