/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.ws.wsGenerator;

import com.cisco.dcbu.ws.wsGenerator.MetaInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class wsGenerator
extends DefaultHandler {
    static final String NL = "\n";
    static final String fileHeader = "/********************************************************************\n**      File:   $FILENAME$ \n*      Name:   $NAME$\n*\n*      Description: Generated file. \n*\n*\n*      Copyright (c) 2006 by Cisco Systems, Inc.\n*\n*       ALL RIGHTS RESERVED. THESE SOURCE FILES ARE THE SOLE PROPERTY\n*       OF CISCO SYSTEMS, Inc. AND CONTAIN CONFIDENTIAL  AND PROPRIETARY\n*       INFORMATION.  REPRODUCTION OR DUPLICATION BY ANY MEANS OF ANY\n*       PORTION OF THIS SOFTWARE WITHOUT PRIOR WRITTEN CONSENT OF\n*       CISCO SYSTEMS, Inc. IS STRICTLY PROHIBITED.\n*\n* $Id$\n* $Source$\n* $Author$\n*\n*\n*********************************************************************/\n\n\n";
    String globalExclude = MetaInfo.globalExclude;
    static MetaInfo tMeta;
    Map<String, MetaInfo> classMeta = new HashMap<String, MetaInfo>();

    public static void main(String[] args) {
        wsGenerator gen = new wsGenerator();
        gen.loadAndGenerate("com/cisco/dcbu/ws/wsGenerator/wsdataobjects.xml");
    }

    private wsGenerator() {
    }

    public void loadAndGenerate(String path) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(new File(path), (DefaultHandler)this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generateFile();
    }

    public void getAttribute() {
    }

    private void print(String str) {
        System.out.println(str);
    }

    public void generateFile() {
        Collection<MetaInfo> values = this.classMeta.values();
        for (MetaInfo cMeta : values) {
            cMeta.toJava();
            this.generateFile(cMeta.getFields());
        }
    }

    public void generateFile(MetaInfo[] m) {
        for (int i = 0; i < m.length; ++i) {
            m[i].toJava();
            this.generateFile(m[i].getFields());
        }
    }

    public void generateFile2() {
        try {
            String path = "E:\\webServices\\nms\\com\\cisco\\dcbu\\ws\\dataObjects";
            Collection<MetaInfo> values = this.classMeta.values();
            for (MetaInfo cMeta : values) {
                boolean containFlag;
                File file = new File("E:\\webServices\\nms\\com\\cisco\\dcbu\\ws\\dataObjects\\" + cMeta.className + ".java");
                PrintWriter writer = new PrintWriter(new FileOutputStream(file));
                writer.print("/** Generated file, do no modify */ \n\n\n\n");
                writer.print("package com.cisco.dcbu.ws.dataObjects; \n\n");
                String cFullName = cMeta.location + "." + cMeta.className;
                this.print("generating: " + cFullName);
                Class<?> c = Class.forName(cFullName);
                MetaInfo superClass = null;
                if (c.getSuperclass() != null && !(containFlag = this.globalExclude.contains(this.stripClassName(c.getSuperclass().getName())))) {
                    superClass = new MetaInfo();
                    superClass.className = this.stripClassName(c.getSuperclass().getName());
                    superClass.location = this.stripPackageName(c.getSuperclass().getName());
                }
                writer.print("@webservices\n");
                if (superClass != null) {
                    writer.print("public class " + cMeta.className + " extends " + superClass.className + " {\n");
                } else {
                    writer.print("public class " + cMeta.className + " {\n");
                }
                ArrayList<String> nameList = new ArrayList<String>();
                ArrayList<String> typeList = new ArrayList<String>();
                Field[] publicFields = c.getDeclaredFields();
                for (int i = 0; i < publicFields.length; ++i) {
                    String fieldName = this.removeUnderscore(publicFields[i].getName());
                    Class<?> typeClass = publicFields[i].getType();
                    String fieldType = publicFields[i].getType().getName();
                    boolean isArray = this.isArray(fieldType);
                    if (!Modifier.isStatic(publicFields[i].getModifiers())) {
                        if (isArray) {
                            fieldType = fieldType.substring(0, fieldType.length() - 1);
                        }
                        typeList.add(fieldType);
                        nameList.add(fieldName);
                    }
                    if (isArray) {
                        fieldType = this.stripClassName(fieldType);
                        fieldType = fieldType + "[]";
                    }
                    this.print("FieldName: " + fieldName + " type: " + fieldType);
                    if (Modifier.isStatic(publicFields[i].getModifiers())) continue;
                    if (Modifier.isPublic(publicFields[i].getModifiers())) {
                        writer.print(" public ");
                    }
                    if (Modifier.isProtected(publicFields[i].getModifiers())) {
                        writer.print(" protected ");
                    }
                    if (Modifier.isPrivate(publicFields[i].getModifiers())) {
                        writer.print(" private ");
                    }
                    writer.print(fieldType + " " + fieldName + ";" + NL);
                }
                Constructor<?>[] ctors = c.getConstructors();
                for (int i = 0; i < ctors.length; ++i) {
                    writer.print("public " + this.stripClassName(ctors[i].getName()) + "( ");
                    Class<?>[] pTypes = ctors[i].getParameterTypes();
                    for (int j = 0; j < pTypes.length; ++j) {
                        String name = this.stripClassName(pTypes[j].getName());
                        String arg = "a" + name.substring(0, 1).toUpperCase() + name.substring(1);
                        writer.print(name + " " + arg + (j == pTypes.length - 1 ? "" : ", "));
                    }
                    writer.print(") {\n}\n");
                }
                Iterator nameItr = nameList.iterator();
                Iterator typeItr = typeList.iterator();
                while (nameItr.hasNext()) {
                    String name = (String)nameItr.next();
                    writer.print("public " + (String)typeItr.next() + " get" + name + "() {\n");
                    writer.print("return " + name + ";");
                    writer.print("\n}\n");
                }
                nameItr = nameList.iterator();
                typeItr = typeList.iterator();
                while (nameItr.hasNext()) {
                    String name = (String)nameItr.next();
                    writer.print("public void set" + name + "( " + (String)typeItr.next() + " value) {\n");
                    writer.print(name + "=value;");
                    writer.print("}");
                }
                writer.print("\n}\n");
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isArray(String className) {
        return className.indexOf(59) == className.length() - 1;
    }

    protected String removeUnderscore(String str) {
        if (str.substring(0, 1).equals("_")) {
            return str.substring(1);
        }
        return str;
    }

    protected String stripClassName(String name) {
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        if (name.charAt(name.length() - 1) == ';') {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    protected String stripPackageName(String name) {
        if (name.lastIndexOf(46) != -1) {
            return name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        tMeta = new MetaInfo();
        System.out.println("uri : " + uri);
        System.out.println("localname : " + localName);
        System.out.println("rawname : " + rawName);
        if (rawName.equals("WebServices")) {
            return;
        }
        if (rawName.equals("DataObjects")) {
            if (attributes == null) {
                return;
            }
            int i = 0;
            if (i < attributes.getLength()) {
                if ("excludes".equals(attributes.getQName(i))) {
                    MetaInfo.setGlobalExclude(attributes.getValue(i));
                }
                return;
            }
        }
        if (localName.equals("")) {
            localName = rawName;
        }
        System.out.println("startElement: " + localName);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qName = attributes.getQName(i);
                String value = attributes.getValue(i);
                System.out.println("attributes : " + qName + " values: " + value);
                if ("name".equals(qName)) {
                    wsGenerator.tMeta.className = value;
                }
                if (!"package".equals(qName)) continue;
                wsGenerator.tMeta.location = value;
            }
        }
        System.out.println("className: " + wsGenerator.tMeta.className);
        System.out.println("location: " + wsGenerator.tMeta.location);
    }

    @Override
    public void endElement(String uri, String localName, String rawName) {
        System.out.println("end of element");
        if (wsGenerator.tMeta.className == null) {
            return;
        }
        if (!this.classMeta.containsKey(wsGenerator.tMeta.className)) {
            this.classMeta.put(wsGenerator.tMeta.className, tMeta);
            tMeta = new MetaInfo();
        } else {
            System.err.println("Duplicate class found!");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        System.out.println("Start of Document");
    }

    @Override
    public void endDocument() throws SAXException {
        System.out.println("End of Document");
    }

    @Override
    public void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        System.out.println("characters: " + s);
    }
}

