/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String target;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    @Override
    void init() {
        try {
            this.io = new IO();
            if (this.lport == -1) {
                Class<?> c = Class.forName(this.target);
                ForwardedTCPIPDaemon daemon = (ForwardedTCPIPDaemon)c.newInstance();
                daemon.setChannel(this);
                Object[] foo = ChannelForwardedTCPIP.getPort(this.session, this.rport);
                daemon.setArg((Object[])foo[3]);
                new Thread(daemon).start();
                return;
            }
            Socket socket = new Socket(this.target, this.lport);
            socket.setTcpNoDelay(true);
            this.io.setInputStream(socket.getInputStream());
            this.io.setOutputStream(socket.getOutputStream());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 16 - 20);
                if (i <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buf.putByte((byte)94);
                        buf.putInt(this.recipient);
                        buf.putInt(i);
                        buf.skip(i);
                        this.session.write(packet, this, i);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getInt());
        this.setRemotePacketSize(buf.getInt());
        byte[] addr = buf.getString();
        int port = buf.getInt();
        byte[] orgaddr = buf.getString();
        int orgport = buf.getInt();
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] foo = (Object[])pool.elementAt(i);
                if (foo[0] != this.session || (Integer)foo[1] != port) continue;
                this.rport = port;
                this.target = (String)foo[2];
                if (foo[3] == null || foo[3] instanceof Object[]) {
                    this.lport = -1;
                    break;
                }
                this.lport = (Integer)foo[3];
                break;
            }
            if (this.target == null) {
                System.out.println("??");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session || (Integer)bar[1] != rport) continue;
                return bar;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        int i;
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            for (i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session) continue;
                if (bar[3] == null) {
                    foo.addElement(bar[1] + ":" + bar[2] + ":");
                    continue;
                }
                foo.addElement(bar[1] + ":" + bar[2] + ":" + bar[3]);
            }
        }
        String[] bar = new String[foo.size()];
        for (i = 0; i < foo.size(); ++i) {
            bar[i] = (String)foo.elementAt(i);
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int port, String target, int lport) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), target, new Integer(lport)};
            pool.addElement(foo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, int port, String daemon, Object[] arg) throws JSchException {
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), daemon, arg};
            pool.addElement(foo);
        }
    }

    static void delPort(ChannelForwardedTCPIP c) {
        ChannelForwardedTCPIP.delPort(c.session, c.rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            Object[] foo = null;
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session || (Integer)bar[1] != rport) continue;
                foo = bar;
                break;
            }
            if (foo == null) {
                return;
            }
            pool.removeElement(foo);
        }
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        try {
            packet.reset();
            buf.putByte((byte)80);
            buf.putString("cancel-tcpip-forward".getBytes());
            buf.putByte((byte)0);
            buf.putString("0.0.0.0".getBytes());
            buf.putInt(rport);
            session.write(packet);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int[] rport = null;
        int count = 0;
        Vector vector = pool;
        synchronized (vector) {
            rport = new int[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session) continue;
                rport[count++] = (Integer)bar[1];
            }
        }
        for (int i = 0; i < count; ++i) {
            ChannelForwardedTCPIP.delPort(session, rport[i]);
        }
    }

    public int getRemotePort() {
        return this.rport;
    }
}

