/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class KnownHosts
implements HostKeyRepository {
    private static final String _known_hosts = "known_hosts";
    private JSch jsch = null;
    private String known_hosts = null;
    private Vector pool = null;
    private static final byte[] space = new byte[]{32};
    private static final byte[] cr = "\n".getBytes();

    KnownHosts(JSch jsch) {
        this.jsch = jsch;
        this.pool = new Vector();
    }

    void setKnownHosts(String foo) throws JSchException {
        try {
            this.known_hosts = foo;
            FileInputStream fis = new FileInputStream(foo);
            this.setKnownHosts(fis);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    void setKnownHosts(InputStream foo) throws JSchException {
        this.pool.removeAllElements();
        StringBuffer sb = new StringBuffer();
        boolean error = false;
        try {
            InputStream fis = foo;
            String key = null;
            byte[] buf = new byte[1024];
            int bufl = 0;
            block2: while (true) {
                int j;
                bufl = 0;
                while ((j = fis.read()) != -1) {
                    byte i;
                    if (j == 13) continue;
                    if (j != 10) {
                        buf[bufl++] = (byte)j;
                        continue;
                    }
                    for (j = 0; j < bufl; ++j) {
                        i = buf[j];
                        if (i == 32 || i == 9) {
                            continue;
                        }
                        if (i != 35) break;
                        this.addInvalidLine(new String(buf, 0, bufl));
                        continue block2;
                    }
                    if (j >= bufl) {
                        this.addInvalidLine(new String(buf, 0, bufl));
                        continue block2;
                    }
                    sb.setLength(0);
                    while (j < bufl && (i = buf[j++]) != 32 && i != 9) {
                        sb.append((char)i);
                    }
                    String host = sb.toString();
                    if (j >= bufl || host.length() == 0) {
                        this.addInvalidLine(new String(buf, 0, bufl));
                        continue block2;
                    }
                    sb.setLength(0);
                    int type = -1;
                    while (j < bufl && (i = buf[j++]) != 32 && i != 9) {
                        sb.append((char)i);
                    }
                    if (sb.toString().equals("ssh-dss")) {
                        type = 0;
                    } else if (sb.toString().equals("ssh-rsa")) {
                        type = 1;
                    } else {
                        j = bufl;
                    }
                    if (j >= bufl) {
                        this.addInvalidLine(new String(buf, 0, bufl));
                        continue block2;
                    }
                    sb.setLength(0);
                    while (j < bufl) {
                        if ((i = buf[j++]) == 13) continue;
                        if (i == 10) break;
                        sb.append((char)i);
                    }
                    if ((key = sb.toString()).length() == 0) {
                        this.addInvalidLine(new String(buf, 0, bufl));
                        continue block2;
                    }
                    HostKey hk = new HostKey(host, type, Util.fromBase64(key.getBytes(), 0, key.length()));
                    this.pool.addElement(hk);
                    continue block2;
                }
                break;
            }
            fis.close();
            if (error) {
                throw new JSchException("KnownHosts: invalid format");
            }
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            throw new JSchException(e.toString());
        }
    }

    private void addInvalidLine(String line) {
        HostKey hk = new HostKey(line, 2, null);
        this.pool.addElement(hk);
    }

    String getKnownHostsFile() {
        return this.known_hosts;
    }

    @Override
    public String getKnownHostsRepositoryID() {
        return this.known_hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int check(String host, byte[] key) {
        int result = 1;
        int type = this.getType(key);
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hk = (HostKey)this.pool.elementAt(i);
                if (!this.isIncluded(hk.host, host) || hk.type != type) continue;
                if (Util.array_equals(hk.key, key)) {
                    return 0;
                }
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(String host, byte[] key, UserInfo userinfo) {
        HostKey hk;
        int type = this.getType(key);
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                hk = (HostKey)this.pool.elementAt(i);
                if (this.isIncluded(hk.host, host) && hk.type != type) continue;
            }
        }
        hk = new HostKey(host, type, key);
        this.pool.addElement(hk);
        String bar = this.getKnownHostsRepositoryID();
        if (bar != null) {
            boolean foo = true;
            File goo = new File(bar);
            if (!goo.exists()) {
                foo = false;
                if (userinfo != null) {
                    foo = userinfo.promptYesNo(bar + " does not exist.\n" + "Are you sure you want to create it?");
                    goo = goo.getParentFile();
                    if (foo && goo != null && !goo.exists() && (foo = userinfo.promptYesNo("The parent directory " + goo + " does not exist.\n" + "Are you sure you want to create it?"))) {
                        if (!goo.mkdirs()) {
                            userinfo.showMessage(goo + " has not been created.");
                            foo = false;
                        } else {
                            userinfo.showMessage(goo + " has been succesfully created.\nPlease check its access permission.");
                        }
                    }
                    if (goo == null) {
                        foo = false;
                    }
                }
            }
            if (foo) {
                try {
                    this.sync(bar);
                }
                catch (Exception e) {
                    System.out.println("sync known_hosts: " + e);
                }
            }
        }
    }

    @Override
    public HostKey[] getHostKey() {
        return this.getHostKey(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostKey[] getHostKey(String host, String type) {
        Vector vector = this.pool;
        synchronized (vector) {
            int count = 0;
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hk = (HostKey)this.pool.elementAt(i);
                if (hk.type == 2 || host != null && (!this.isIncluded(hk.host, host) || type != null && !hk.getType().equals(type))) continue;
                ++count;
            }
            if (count == 0) {
                return null;
            }
            HostKey[] foo = new HostKey[count];
            int j = 0;
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hk = (HostKey)this.pool.elementAt(i);
                if (hk.type == 2 || host != null && (!this.isIncluded(hk.host, host) || type != null && !hk.getType().equals(type))) continue;
                foo[j++] = hk;
            }
            return foo;
        }
    }

    @Override
    public void remove(String host, String type) {
        this.remove(host, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String host, String type, byte[] key) {
        boolean sync = false;
        Vector vector = this.pool;
        synchronized (vector) {
            for (int i = 0; i < this.pool.size(); ++i) {
                HostKey hk = (HostKey)this.pool.elementAt(i);
                if (host != null && (!hk.getHost().equals(host) || type != null && (!hk.getType().equals(type) || key != null && !Util.array_equals(key, hk.key)))) continue;
                this.pool.removeElement(hk);
                sync = true;
            }
        }
        if (sync) {
            try {
                this.sync();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void sync() throws IOException {
        if (this.known_hosts != null) {
            this.sync(this.known_hosts);
        }
    }

    protected synchronized void sync(String foo) throws IOException {
        if (foo == null) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(foo);
        this.dump(fos);
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(OutputStream out) throws IOException {
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                for (int i = 0; i < this.pool.size(); ++i) {
                    HostKey hk = (HostKey)this.pool.elementAt(i);
                    String host = hk.getHost();
                    String type = hk.getType();
                    if (type.equals("UNKNOWN")) {
                        out.write(host.getBytes());
                        out.write(cr);
                        continue;
                    }
                    out.write(host.getBytes());
                    out.write(space);
                    out.write(type.getBytes());
                    out.write(space);
                    out.write(hk.getKey().getBytes());
                    out.write(cr);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private int getType(byte[] key) {
        if (key[8] == 100) {
            return 0;
        }
        if (key[8] == 114) {
            return 1;
        }
        return 2;
    }

    private String deleteSubString(String hosts, String host) {
        int j;
        int i = 0;
        int hostlen = host.length();
        int hostslen = hosts.length();
        while (i < hostslen && (j = hosts.indexOf(44, i)) != -1) {
            if (!host.equals(hosts.substring(i, j))) {
                i = j + 1;
                continue;
            }
            return hosts.substring(0, i) + hosts.substring(j + 1);
        }
        if (hosts.endsWith(host) && hostslen - i == hostlen) {
            return hosts.substring(0, hostlen == hostslen ? 0 : hostslen - hostlen - 1);
        }
        return hosts;
    }

    private boolean isIncluded(String hosts, String host) {
        int i = 0;
        int hostlen = host.length();
        int hostslen = hosts.length();
        while (i < hostslen) {
            int j = hosts.indexOf(44, i);
            if (j == -1) {
                if (hostlen != hostslen - i) {
                    return false;
                }
                return hosts.regionMatches(true, i, host, 0, hostlen);
            }
            if (hostlen == j - i && hosts.regionMatches(true, i, host, 0, hostlen)) {
                return true;
            }
            i = j + 1;
        }
        return false;
    }
}

