/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

public class FetchRequest {
    private RrdDb parentDb;
    private String consolFun;
    private long fetchStart;
    private long fetchEnd;
    private long resolution;
    private String dsPattern = null;
    private int[] indexes = null;

    FetchRequest(RrdDb parentDb, String consolFun, long fetchStart, long fetchEnd, long resolution) throws RrdException {
        this(parentDb, consolFun, fetchStart, fetchEnd, resolution, null);
    }

    FetchRequest(RrdDb parentDb, String consolFun, long fetchStart, long fetchEnd, long resolution, String pattern, int[] ind) throws RrdException {
        this.parentDb = parentDb;
        this.consolFun = consolFun;
        this.fetchStart = fetchStart;
        this.fetchEnd = fetchEnd;
        this.resolution = resolution;
        this.dsPattern = pattern;
        this.indexes = ind;
        this.validate();
    }

    FetchRequest(RrdDb parentDb, String consolFun, long fetchStart, long fetchEnd, long resolution, String pattern) throws RrdException {
        this.parentDb = parentDb;
        this.consolFun = consolFun;
        this.fetchStart = fetchStart;
        this.fetchEnd = fetchEnd;
        this.resolution = resolution;
        this.dsPattern = pattern;
        this.validate();
    }

    public String getConsolFun() {
        return this.consolFun;
    }

    public long getFetchStart() {
        return this.fetchStart;
    }

    public long getFetchEnd() {
        return this.fetchEnd;
    }

    public long getResolution() {
        return this.resolution;
    }

    private void validate() throws RrdException {
        if (!ArcDef.isValidConsolFun(this.consolFun)) {
            throw new RrdException("Invalid consolidation function in fetch request: " + this.consolFun);
        }
        if (this.fetchStart < 0L) {
            throw new RrdException("Invalid start time in fetch request: " + this.fetchStart);
        }
        if (this.fetchEnd < 0L) {
            throw new RrdException("Invalid end time in fetch request: " + this.fetchEnd);
        }
        if (this.fetchStart >= this.fetchEnd) {
            throw new RrdException("Invalid start/end time in fetch request: " + this.fetchStart + "/" + this.fetchEnd);
        }
        if (this.resolution <= 0L) {
            throw new RrdException("Invalid resolution in fetch request: " + this.resolution);
        }
    }

    public String dump() {
        return RrdDb.RRDTOOL + " fetch " + this.parentDb.getRrdFile().getFilePath() + " " + this.consolFun + " --start " + this.fetchStart + " --end " + this.fetchEnd + (this.resolution > 1L ? " --resolution " + this.resolution : "");
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    public FetchPoint[] fetch() throws RrdException, IOException {
        return this.parentDb.fetch(this);
    }

    public void setDsPattern(String pattern) {
        this.dsPattern = pattern;
    }

    public String getDsPattern() {
        return this.dsPattern;
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(int[] indexes) {
        this.indexes = indexes;
    }
}

