/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.FetchRequest;
import org.jrobin.core.Header;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFile;
import org.jrobin.core.RrdTimeOutOfSeqException;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.core.XmlReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RrdDb
implements RrdUpdater {
    static String RRDTOOL = "rrdtool";
    static boolean DEBUG = false;
    private RrdFile file;
    private Header header;
    private Datasource[] datasources;
    private Archive[] archives;

    public RrdDb(RrdDef rrdDef) throws IOException, RrdException {
        rrdDef.validate();
        this.initializeSetup(rrdDef.getPath());
        this.header = new Header(this, rrdDef);
        DsDef[] dsDefs = rrdDef.getDsDefs();
        this.datasources = new Datasource[dsDefs.length];
        for (int i = 0; i < dsDefs.length; ++i) {
            this.datasources[i] = new Datasource(this, dsDefs[i]);
            this.datasources[i].setLastUpdateTime(this.header.getLastUpdateTime());
        }
        ArcDef[] arcDefs = rrdDef.getArcDefs();
        this.archives = new Archive[arcDefs.length];
        for (int i = 0; i < arcDefs.length; ++i) {
            this.archives[i] = new Archive(this, arcDefs[i]);
        }
        this.finalizeSetup(true);
        Util.debug(rrdDef.getRrdToolCommand());
    }

    public RrdDb(String path) throws IOException, RrdException {
        this.initializeSetup(path);
        this.header = new Header(this);
        int dsCount = this.header.getDsCount();
        this.datasources = new Datasource[dsCount];
        for (int i = 0; i < dsCount; ++i) {
            this.datasources[i] = new Datasource(this);
        }
        int arcCount = this.header.getArcCount();
        this.archives = new Archive[arcCount];
        for (int i = 0; i < arcCount; ++i) {
            this.archives[i] = new Archive(this);
        }
        this.finalizeSetup(false);
    }

    public RrdDb(String rrdPath, String xmlPath) throws IOException, RrdException {
        int i;
        this.initializeSetup(rrdPath);
        XmlReader reader = new XmlReader(xmlPath);
        this.header = new Header(this, reader);
        this.datasources = new Datasource[reader.getDsCount()];
        for (i = 0; i < this.datasources.length; ++i) {
            this.datasources[i] = new Datasource(this, reader, i);
        }
        this.archives = new Archive[reader.getArcCount()];
        for (i = 0; i < this.archives.length; ++i) {
            this.archives[i] = new Archive(this, reader, i);
        }
        this.finalizeSetup(true);
    }

    private void initializeSetup(String path) throws IOException {
        this.file = new RrdFile(path);
        this.file.setSafeMode(true);
    }

    private void finalizeSetup(boolean newFile) throws IOException {
        if (newFile) {
            this.file.truncate();
        } else if (!this.file.isEndReached()) {
            throw new IOException("Extra bytes found in RRD file. Not a RRD file at all?");
        }
        this.file.setSafeMode(false);
    }

    public synchronized void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    @Override
    public RrdFile getRrdFile() {
        return this.file;
    }

    public Header getHeader() {
        return this.header;
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] dsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            dsNames[i] = this.datasources[i].getDsName();
        }
        return dsNames;
    }

    public Sample createSample(long time) throws IOException {
        return new Sample(this, time);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd, long resolution) throws RrdException {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution);
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd, long resolution, int dsIndex) throws RrdException {
        String pattern = Integer.toString(dsIndex) + ".";
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution, pattern);
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd, long resolution, int[] dsIndex) throws RrdException {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution, null, dsIndex);
    }

    public FetchRequest createFetchRequest(String consolFun, long fetchStart, long fetchEnd) throws RrdException {
        return this.createFetchRequest(consolFun, fetchStart, fetchEnd, 1L);
    }

    synchronized void store(Sample sample) throws IOException, RrdException {
        long newTime = sample.getTime();
        Datasource firstds = this.getDatasource(sample.getDsNames()[0]);
        long lastTime = firstds.getLastUpdateTime();
        if (lastTime > newTime) {
            if (lastTime - newTime < 200L) {
                throw new RrdTimeOutOfSeqException("The new time is: " + newTime + "\n" + "last time is : " + lastTime);
            }
            throw new RrdException("Bad sample timestamp " + newTime + ". Last update time was " + lastTime + ", at least one second step is required");
        }
        double[] newValues = sample.getValues();
        List<Integer> valueSetIdxList = sample.getValueSetIdxList();
        for (int i = 0; i < sample.getDsNames().length; ++i) {
            double newValue = newValues[i];
            Datasource ds = this.getDatasource(valueSetIdxList.get(i));
            ds.process(newTime, newValue);
            ds.setLastUpdateTime(newTime);
        }
        this.header.setLastUpdateTime(newTime);
        Util.debug(sample.getRrdToolCommand());
    }

    synchronized FetchPoint[] fetch(FetchRequest request) throws IOException, RrdException {
        Archive archive = this.findMatchingArchive(request);
        FetchPoint[] points = archive.fetch(request);
        Util.debug(request.getRrdToolCommand());
        return points;
    }

    public Archive getArchive(int arcIndex) {
        return this.archives[arcIndex];
    }

    public Archive getArchive(long arcStep, String consolFun) throws IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (this.archives[i].getArcStep() != arcStep || !this.archives[i].getConsolFun().equalsIgnoreCase(consolFun)) continue;
            return this.archives[i];
        }
        return null;
    }

    public Archive getNextArchive(Archive arch, String consolFun) throws IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (this.archives[i].getArcStep() <= arch.getArcStep() || !this.archives[i].getConsolFun().equalsIgnoreCase(consolFun)) continue;
            return this.archives[i];
        }
        return null;
    }

    private Archive findMatchingArchive(FetchRequest request) throws IOException, RrdException {
        String consolFun = request.getConsolFun();
        long fetchStart = request.getFetchStart();
        long fetchEnd = request.getFetchEnd();
        long resolution = request.getResolution();
        int[] index = request.getIndexes();
        Datasource ds = this.datasources[index[0]];
        request.setDsPattern(ds.getDsName());
        Archive bestFullMatch = null;
        Archive bestPartialMatch = null;
        long bestStepDiff = 0L;
        long bestMatch = 0L;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().equals(consolFun)) continue;
            long arcStep = this.archives[i].getArcStep();
            long arcStart = this.archives[i].getStartTime(ds) - arcStep;
            long arcEnd = this.archives[i].getEndTime(ds);
            long fullMatch = fetchEnd - fetchStart;
            if (arcEnd >= fetchEnd && arcStart <= fetchStart) {
                long tmpStepDiff = Math.abs(this.archives[i].getArcStep() - resolution);
                if (bestFullMatch != null && tmpStepDiff >= bestStepDiff) continue;
                bestStepDiff = tmpStepDiff;
                bestFullMatch = this.archives[i];
                continue;
            }
            long tmpMatch = fullMatch;
            if (arcStart > fetchStart) {
                tmpMatch -= arcStart - fetchStart;
            }
            if (arcEnd < fetchEnd) {
                tmpMatch -= fetchEnd - arcEnd;
            }
            if (bestPartialMatch != null && bestMatch >= tmpMatch) continue;
            bestPartialMatch = this.archives[i];
            bestMatch = tmpMatch;
        }
        if (bestFullMatch != null) {
            return bestFullMatch;
        }
        if (bestPartialMatch != null) {
            return bestPartialMatch;
        }
        throw new RrdException("RRD file does not contain RRA:" + consolFun + " archive");
    }

    public synchronized String dump() throws IOException {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.header.dump());
        for (i = 0; i < this.datasources.length; ++i) {
            buffer.append(this.datasources[i].dump());
        }
        for (i = 0; i < this.archives.length; ++i) {
            buffer.append(this.archives[i].dump());
        }
        return buffer.toString();
    }

    void archive(Datasource datasource, double value, long numUpdates) throws IOException, RrdException {
        int dsIndex = this.getDsIndex(datasource.getDsName());
        for (int i = 0; i < this.archives.length; ++i) {
            this.archives[i].archive(dsIndex, value, numUpdates);
        }
    }

    public int getDsIndex(String dsName) throws IOException, RrdException {
        for (int i = 0; i < this.datasources.length; ++i) {
            if (!this.datasources[i].getDsName().equals(dsName)) continue;
            return i;
        }
        throw new RrdException("Unknown datasource name: " + dsName);
    }

    public Datasource[] getDatasources() {
        return this.datasources;
    }

    public Datasource getDatasource(int dsIndex) {
        return this.datasources[dsIndex];
    }

    public Datasource getDatasource(String dsName) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(dsName));
        }
        catch (RrdException e) {
            return null;
        }
    }

    public Archive[] getArchives() {
        return this.archives;
    }

    public synchronized String getXml() throws IOException, RrdException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            int i;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("rrd");
            doc.appendChild(root);
            this.header.appendXml(root);
            for (i = 0; i < this.datasources.length; ++i) {
                this.datasources[i].appendXml(root);
            }
            for (i = 0; i < this.archives.length; ++i) {
                this.archives[i].appendXml(root);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("media-type", "text/xml");
            transformer.setOutputProperty("standalone", "yes");
            DOMSource source = new DOMSource(root);
            ByteArrayOutputStream destination = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(destination);
            transformer.transform(source, result);
            return destination.toString();
        }
        catch (ParserConfigurationException e) {
            throw new RrdException("XML Error: " + e);
        }
        catch (DOMException e) {
            throw new RrdException("XML Error: " + e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RrdException("XML Error: " + e);
        }
        catch (TransformerException e) {
            throw new RrdException("XML Error: " + e);
        }
        catch (IllegalArgumentException e) {
            throw new RrdException("XML Error: " + e);
        }
    }

    public synchronized void dumpXml(String filename) throws IOException, RrdException {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        out.print(this.getXml());
        out.close();
    }

    public long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public long getLastUpdateTimeForDsIndex(int index) throws IOException {
        return this.getDatasource(index).getLastUpdateTime();
    }

    public void setLastUpdateTime(long t) throws IOException {
        this.header.setLastUpdateTime(t);
    }

    public RrdDef getRrdDef() throws IOException, RrdException {
        int i;
        long startTime = this.header.getLastUpdateTime();
        long step = this.header.getStep();
        String path = this.getRrdFile().getFilePath();
        RrdDef rrdDef = new RrdDef(path, startTime, step);
        for (i = 0; i < this.datasources.length; ++i) {
            DsDef dsDef = new DsDef(this.datasources[i].getDsName(), this.datasources[i].getDsType(), this.datasources[i].getHeartbeat(), this.datasources[i].getMinValue(), this.datasources[i].getMaxValue());
            rrdDef.addDatasource(dsDef);
        }
        for (i = 0; i < this.archives.length; ++i) {
            ArcDef arcDef = new ArcDef(this.archives[i].getConsolFun(), this.archives[i].getXff(), this.archives[i].getSteps(), this.archives[i].getRows());
            rrdDef.addArchive(arcDef);
        }
        return rrdDef;
    }
}

