/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class Sample {
    private RrdDb parentDb;
    private long time;
    private String[] dsNames;
    private double[] values;
    private List<Integer> valueSetIdxList = new ArrayList<Integer>();

    Sample(RrdDb parentDb, long time) throws IOException {
        this.parentDb = parentDb;
        this.time = time;
        this.dsNames = parentDb.getDsNames();
        int n = this.dsNames.length;
        this.values = new double[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = Double.NaN;
        }
    }

    Sample(Sample orig) throws IOException {
        this.parentDb = orig.parentDb;
        this.time = orig.time;
        int n = orig.valueSetIdxList.size();
        this.values = new double[n];
        this.dsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.values[i] = orig.values[orig.valueSetIdxList.get(i)];
            this.dsNames[i] = orig.dsNames[orig.valueSetIdxList.get(i)];
        }
        this.valueSetIdxList.addAll(orig.getValueSetIdxList());
    }

    public void setValue(String dsName, double value) throws RrdException {
        for (int i = 0; i < this.dsNames.length; ++i) {
            if (!this.dsNames[i].equals(dsName)) continue;
            this.values[i] = value;
            this.valueSetIdxList.add(new Integer(i));
            return;
        }
        throw new RrdException("Datasource " + dsName + " not found");
    }

    public void setValue(int i, double value) throws RrdException {
        if (i < this.dsNames.length) {
            this.values[i] = value;
            this.valueSetIdxList.add(new Integer(i));
            return;
        }
        throw new RrdException("Sample index " + i + " out of bounds");
    }

    public void setValues(double[] values) throws RrdException {
        if (values.length == this.dsNames.length) {
            this.values = values;
            for (int i = 0; i < this.dsNames.length; ++i) {
                this.valueSetIdxList.add(new Integer(i));
            }
            return;
        }
        throw new RrdException("Invalid number of values specified (found " + values.length + ", exactly " + this.dsNames.length + " needed");
    }

    public void setValues(int[] dses, double[] valuesIn) throws RrdException {
        this.values = this.values;
        for (int i = 0; i < dses.length; ++i) {
            this.values[dses[i]] = valuesIn[i];
            this.valueSetIdxList.add(new Integer(dses[i]));
        }
    }

    public double[] getValues() {
        return this.values;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String[] getDsNames() {
        return this.dsNames;
    }

    public void update() throws IOException, RrdException {
        this.parentDb.store(new Sample(this));
    }

    public String dump() {
        StringBuffer buffer = new StringBuffer(RrdDb.RRDTOOL);
        buffer.append(" update " + this.parentDb.getRrdFile().getFilePath() + " " + this.time);
        for (int i = 0; i < this.values.length; ++i) {
            buffer.append(":");
            buffer.append(Util.formatDouble(this.values[i], true));
        }
        return buffer.toString();
    }

    String getRrdToolCommand() {
        return this.dump();
    }

    public List<Integer> getValueSetIdxList() {
        return this.valueSetIdxList;
    }
}

