/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.dialogs.security;

import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class FeatureGroupManagerForm
extends EditForm {
    private JTree featuresTree;
    private JTree featureGroupsTree;
    private JTextField featureGroupTF;
    private JButton deleteGroupBtn;
    private JButton addFeatureBtn;
    private TreeMap<String, TreeSet<CommonRoleExtUtil.FeatureElement>> featureGroupsMap;
    private static final ImageIcon FEATURE_GROUP_ICON = Util.loadIcon((String)"com/cisco/dcbu/portland/icons/feature_group_tree_node.gif");
    private static final ImageIcon FEATURE_ICON = Util.loadIcon((String)"com/cisco/dcbu/portland/icons/feature_tree_node.gif");
    private static final ImageIcon FEATURE_COMMAND_ICON = Util.loadIcon((String)"com/cisco/dcbu/portland/icons/feature_command_tree_node.gif");
    private static final int GROUP_POS_IN_GROUP_TREE = 1;
    private static final int FEATURE_POS_IN_GROUP_TREE = 2;
    private static final int CONTAINER_NODE_POS_IN_EITHER_TREE = 1;
    private static final String ROOT = "ROOT";

    public FeatureGroupManagerForm() {
        super(new String[0]);
        this._isEditable = true;
    }

    protected void build() {
        this._container.setLayout(new BorderLayout());
        this._container.add((Component)this.createFeatureMgrPanel(), "Center");
        this.buildButtons();
        this._parent.pack();
    }

    public JPanel createFeatureMgrPanel() {
        JPanel lPanel = new JPanel(new GridBagLayout());
        lPanel.add((Component)this.createFeaturesPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.addFeatureBtn = new JButton("Add Feature ->");
        this.addFeatureBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureGroupManagerForm.this.addFeaturesToGroups();
            }
        });
        lPanel.add((Component)this.addFeatureBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        lPanel.add((Component)this.createFeatureGroupsPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        return lPanel;
    }

    public JPanel createFeaturesPanel() {
        JPanel lPanel = new JPanel(new GridBagLayout());
        lPanel.setBorder(BorderFactory.createTitledBorder("Features"));
        this.featuresTree = this.getTree(FEATURE_ICON, FEATURE_ICON, FEATURE_COMMAND_ICON);
        JScrollPane lScroll = this.getScrollPane(this.featuresTree);
        lPanel.add((Component)lScroll, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        return lPanel;
    }

    public JPanel createFeatureGroupsPanel() {
        JPanel lPanel = new JPanel(new GridBagLayout());
        lPanel.setBorder(BorderFactory.createTitledBorder("Feature Groups"));
        this.featureGroupsTree = this.getTree(FEATURE_GROUP_ICON, FEATURE_GROUP_ICON, FEATURE_ICON);
        JScrollPane lScroll = this.getScrollPane(this.featureGroupsTree);
        ActionListener addFeatureGroupAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureGroupManagerForm.this.addFeatureGroup();
            }
        };
        int y = 0;
        lPanel.add((Component)new JLabel("Name : "), new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.featureGroupTF = new JTextField();
        this.featureGroupTF.addActionListener(addFeatureGroupAction);
        lPanel.add((Component)this.featureGroupTF, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        JButton lAddGroupBtn = new JButton("Add");
        lAddGroupBtn.addActionListener(addFeatureGroupAction);
        lPanel.add((Component)lAddGroupBtn, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        lPanel.add((Component)lScroll, new GridBagConstraints(0, ++y, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.deleteGroupBtn = new JButton("Delete");
        this.deleteGroupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureGroupManagerForm.this.delete();
            }
        });
        lPanel.add((Component)this.deleteGroupBtn, new GridBagConstraints(0, ++y, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        return lPanel;
    }

    private JScrollPane getScrollPane(JTree tree) {
        JScrollPane lScroll = new JScrollPane(tree);
        lScroll.setPreferredSize(new Dimension(300, 400));
        return lScroll;
    }

    private JTree getTree(ImageIcon closedNodeIcon, ImageIcon openNodeIcon, ImageIcon leafIcon) {
        JTree lTree = new JTree(new DefaultTreeModel(new CustomTreeNode(ROOT)));
        lTree.setRootVisible(false);
        lTree.setShowsRootHandles(true);
        CustomTreeCellRenderer renderer = new CustomTreeCellRenderer(openNodeIcon, closedNodeIcon, leafIcon);
        lTree.setCellRenderer(renderer);
        lTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FeatureGroupManagerForm.this.treeSelectionChanged(e);
            }
        });
        return lTree;
    }

    private void treeSelectionChanged(TreeSelectionEvent e) {
        int featuresSelected = this.featuresTree.getSelectionCount();
        int featureGroupsSelected = this.featureGroupsTree.getSelectionCount();
        this.deleteGroupBtn.setEnabled(featureGroupsSelected > 0);
        this.addFeatureBtn.setEnabled(featureGroupsSelected > 0 && featuresSelected > 0);
    }

    private DefaultTreeModel getTreeModel(TreeMap<String, TreeSet<CommonRoleExtUtil.FeatureElement>> map) {
        CustomTreeNode root = new CustomTreeNode(ROOT);
        for (String lNodeName : map.keySet()) {
            CustomTreeNode lNode = new CustomTreeNode(lNodeName);
            root.add(lNode);
            for (CommonRoleExtUtil.FeatureElement lChildName : map.get(lNodeName)) {
                lNode.add(new CustomTreeNode(lChildName.getName()));
            }
        }
        return new DefaultTreeModel(root);
    }

    private void addFeaturesToGroups() {
        Set<CustomTreeNode> lFeatures = this.getSelected(this.featuresTree);
        Set<CustomTreeNode> lFeatureGroups = this.getSelected(this.featureGroupsTree);
        DefaultTreeModel model = (DefaultTreeModel)this.featureGroupsTree.getModel();
        for (CustomTreeNode lFeatureNode : lFeatures) {
            for (CustomTreeNode lFeatureGroupNode : lFeatureGroups) {
                this.addNode(model, lFeatureGroupNode, lFeatureNode.toString());
            }
        }
    }

    private void addFeatureGroup() {
        String featureGroupName = this.featureGroupTF.getText().trim();
        DefaultTreeModel lFeaturesModel = (DefaultTreeModel)this.featuresTree.getModel();
        DefaultTreeModel lFeatureGroupsModel = (DefaultTreeModel)this.featureGroupsTree.getModel();
        if (featureGroupName.length() == 0) {
            Util.errorMessage((Component)this._parent, (String)"Feature Group Name cannot be blank.");
        } else if (((CustomTreeNode)lFeaturesModel.getRoot()).containsChild(featureGroupName)) {
            Util.errorMessage((Component)this._parent, (String)"A Feature with the same name as the Feature Group already exists.");
        } else if (((CustomTreeNode)lFeatureGroupsModel.getRoot()).containsChild(featureGroupName)) {
            Util.errorMessage((Component)this._parent, (String)"A Feature Group with the same name already exists.");
        } else {
            this.addNode(lFeatureGroupsModel, (CustomTreeNode)lFeatureGroupsModel.getRoot(), featureGroupName);
        }
        this.featureGroupTF.setText("");
    }

    private void addNode(DefaultTreeModel model, CustomTreeNode parentNode, String childName) {
        if (parentNode.containsChild(childName)) {
            return;
        }
        this.enableButton('A', true);
        CustomTreeNode lChildNode = new CustomTreeNode(childName);
        model.insertNodeInto(lChildNode, parentNode, this.getInsertLocation(parentNode, childName));
    }

    private void delete() {
        TreePath[] lPaths;
        this.enableButton('A', true);
        for (TreePath lPath : lPaths = this.featureGroupsTree.getSelectionPaths()) {
            ((DefaultTreeModel)this.featureGroupsTree.getModel()).removeNodeFromParent((CustomTreeNode)lPath.getLastPathComponent());
        }
    }

    private int getInsertLocation(CustomTreeNode parentNode, String name) {
        String lChildName;
        int i;
        int count = parentNode.getChildCount();
        for (i = 0; i < count && CommonRoleExtUtil.strComp.compare(name, lChildName = parentNode.getChildAt(i).toString()) >= 0; ++i) {
        }
        return i;
    }

    protected MenuButton getCFSButton() {
        MenuButton btn = super.getCFSButton();
        btn.setVisible(false);
        return btn;
    }

    public void setCFSButton(boolean[] enable) {
    }

    protected void get() {
        if (this._isRefresh) {
            CommonRoleExtUtil.getInstance().initialize((Component)this._parent, this.getPeer());
        }
        this.deleteGroupBtn.setEnabled(false);
        this.addFeatureBtn.setEnabled(false);
        this.enableButton('A', false);
        this.featureGroupsMap = CommonRoleExtUtil.getInstance().getFeatureGroupsMap();
        this.featuresTree.setModel(this.getTreeModel(CommonRoleExtUtil.getInstance().getFeaturesMap()));
        this.featureGroupsTree.setModel(this.getTreeModel(this.featureGroupsMap));
    }

    protected void set() throws Exception {
        SnmpPDU lDeletePDU = new SnmpPDU(-93, new VarBindList());
        ArrayList<SnmpPDU> lInsertPDUs = new ArrayList<SnmpPDU>();
        CustomTreeNode lRootNode = (CustomTreeNode)((DefaultTreeModel)this.featureGroupsTree.getModel()).getRoot();
        int lFeatureGroupCount = lRootNode.getChildCount();
        Set<String> lOrigFeatureGroups = this.featureGroupsMap.keySet();
        for (String lGroupName : lOrigFeatureGroups) {
            boolean found = false;
            for (int i = 0; i < lFeatureGroupCount; ++i) {
                if (!lGroupName.equals(lRootNode.getChildAt(i).toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addFeatureGroupToDeletePDU(lDeletePDU, lGroupName);
        }
        for (int i = 0; i < lFeatureGroupCount; ++i) {
            CustomTreeNode lFeatureGroupNode = (CustomTreeNode)lRootNode.getChildAt(i);
            this.updatePDUs(lDeletePDU, lInsertPDUs, lFeatureGroupNode);
        }
        this.sendPdu(lDeletePDU);
        for (SnmpPDU pdu : lInsertPDUs) {
            this.sendPdu(pdu);
        }
        this.refresh();
    }

    private void refresh() {
        this._isRefresh = true;
        this.get();
    }

    private void updatePDUs(SnmpPDU deletePDU, ArrayList<SnmpPDU> insertPDUs, CustomTreeNode featureGroupNode) {
        if (this.featureGroupsMap.containsKey(featureGroupNode.toString())) {
            TreeSet<CommonRoleExtUtil.FeatureElement> lOrigFeaturesInGroup = this.featureGroupsMap.get(featureGroupNode.toString());
            this.updatePDUsForChangedFeatureGroup(insertPDUs, deletePDU, featureGroupNode, lOrigFeaturesInGroup);
        } else {
            this.addFeatureGroupToInsertPDUs(insertPDUs, featureGroupNode);
        }
    }

    private void addFeatureGroupToDeletePDU(SnmpPDU deletePDU, String featureGroupName) {
        CommonRoleExtUtil.getInstance().addFeatureGroupToDeletePDU(deletePDU, featureGroupName);
    }

    private void addFeatureGroupToInsertPDUs(ArrayList<SnmpPDU> insertPDUs, CustomTreeNode featureGroupNode) {
        int lIndex = 1;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        CommonRoleExtUtil.getInstance().addFeatureGroupToInsertPDU(pdu, featureGroupNode.toString(), lIndex++, null);
        int lCount = featureGroupNode.getChildCount();
        if (lCount > 0) {
            for (int i = 0; i < lCount; ++i) {
                String featureName = featureGroupNode.getChildAt(i).toString();
                CommonRoleExtUtil.getInstance().addFeatureGroupToInsertPDU(pdu, featureGroupNode.toString(), lIndex++, new SnmpString(featureName.getBytes()));
            }
        }
        insertPDUs.add(pdu);
    }

    private void updatePDUsForChangedFeatureGroup(ArrayList<SnmpPDU> insertPDUs, SnmpPDU deletePDU, CustomTreeNode featureGroupNode, TreeSet<CommonRoleExtUtil.FeatureElement> origFeaturesInGroup) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        int newFeatureCount = featureGroupNode.getChildCount();
        int origFeatureCount = origFeaturesInGroup.size();
        for (CommonRoleExtUtil.FeatureElement element : origFeaturesInGroup) {
            if (featureGroupNode.containsChild(element.getName())) continue;
            CommonRoleExtUtil.getInstance().addFeatureElementToDeletePDU(deletePDU, featureGroupNode.toString(), element.getIndex());
        }
        int lIndex = origFeatureCount + 2;
        for (int i = 0; i < newFeatureCount; ++i) {
            String featureName = featureGroupNode.getChildAt(i).toString();
            if (origFeaturesInGroup.contains(new CommonRoleExtUtil.FeatureElement(null, featureName))) continue;
            CommonRoleExtUtil.getInstance().addFeatureElementToInsertPDU(pdu, featureGroupNode.toString(), new SnmpString(featureName.getBytes()), lIndex++);
        }
        insertPDUs.add(pdu);
    }

    private Set<CustomTreeNode> getSelected(JTree tree) {
        HashSet<CustomTreeNode> lFeatures = new HashSet<CustomTreeNode>();
        TreePath[] lPaths = tree.getSelectionPaths();
        if (lPaths != null) {
            for (TreePath lPath : lPaths) {
                lFeatures.add((CustomTreeNode)lPath.getPath()[1]);
            }
        }
        return lFeatures;
    }

    static class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon openIcon;
        ImageIcon closedIcon;
        ImageIcon leafIcon;

        CustomTreeCellRenderer(ImageIcon openIcon, ImageIcon closedIcon, ImageIcon leafIcon) {
            this.openIcon = openIcon;
            this.closedIcon = closedIcon;
            this.leafIcon = leafIcon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (((CustomTreeNode)value).getPath().length > 2) {
                this.setIcon(this.leafIcon);
            } else if (expanded) {
                this.setIcon(this.openIcon);
            } else {
                this.setIcon(this.closedIcon);
            }
            return this;
        }
    }

    static class CustomTreeNode
    extends DefaultMutableTreeNode {
        public CustomTreeNode() {
            this(null);
        }

        public CustomTreeNode(Object userObject) {
            super(userObject, true);
        }

        @Override
        public boolean isLeaf() {
            if (this.toString().equals(FeatureGroupManagerForm.ROOT)) {
                return false;
            }
            return super.isLeaf();
        }

        public boolean containsChild(String childName) {
            CustomTreeNode childNode = new CustomTreeNode(childName);
            return this.children != null && this.children.contains(childNode);
        }

        public boolean equals(Object o) {
            return o instanceof CustomTreeNode && this.toString().equals(((CustomTreeNode)o).toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

