/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.elements;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.portland.dmdb.elements.N5KQSFPEthPort;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class N5KQSFPGEMEthPort
extends N5KQSFPEthPort {
    public static final Font _QSFPGEMModeFont = new Font("SansSerif", 1, 8);

    @Override
    public int[] getStatusIndex(int[] index) {
        int[] ifIndex = new int[]{Discover.getRoot().nameToIfIndex(index[0] - 21, 111 + index[1] + 1, Discover.getRoot().getActualType(26))};
        return ifIndex;
    }

    @Override
    public String getBitmap() {
        return "qsfp-gem-ethport.gif";
    }

    @Override
    public String getErrorBitmap() {
        return "qsfp-gem-ethport-err.gif";
    }

    @Override
    protected void drawMode(String m, PhysicalView view) {
        if (this._hide) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        Rectangle r = this.getRect();
        int x = r.x + (m.length() > 2 ? 6 : (m.length() > 1 ? 6 : 9));
        int y = r.y + 9;
        g.setFont(_QSFPGEMModeFont);
        g.setColor(Color.white);
        g.drawString(m, x, y);
        g.dispose();
    }

    public void clearBreakoutPortLed(PhysicalView view, int breakoutFactor) {
        Graphics g = view.getOffscreenImage().getGraphics();
        Color bg = new Color(184, 186, 188);
        g.setColor(bg);
        Rectangle r = this.getRect();
        for (int i = 0; i < breakoutFactor; ++i) {
            int xOffset = 1 + i * 5;
            int yOffset = 10;
            this.drawBreakoutPortLine(g, r, xOffset, yOffset, bg);
        }
        this._breakoutPorts = null;
        g.dispose();
    }

    public void drawBreakoutPortLed(Graphics g, int breaoutFactor) {
        Rectangle r = this.getRect();
        this._breakoutPorts = new int[4][2];
        for (int i = 0; i < breaoutFactor; ++i) {
            Color blankColor = Color.black;
            int xOffset = 1 + i * 5;
            int yOffset = 10;
            this.drawBreakoutPortLine(g, r, xOffset, yOffset, blankColor);
        }
    }

    public void drawBreakoutPortLed(Graphics g, int bpIfIndex, int breaoutPort, int operCause) {
        Rectangle r = this.getRect();
        Color portColor = _Colors[1];
        this._breakoutPorts[breaoutPort][0] = bpIfIndex;
        this._breakoutPorts[breaoutPort][1] = operCause;
        switch (operCause) {
            case 2: {
                portColor = _Colors[0];
                break;
            }
            case 12: {
                portColor = _Colors[1];
                break;
            }
            case 155: {
                portColor = Color.black;
                break;
            }
            case 7: {
                portColor = _Colors[2];
            }
        }
        int xOffset = 1 + breaoutPort * 5;
        int yOffset = 10;
        this.drawBreakoutPortLine(g, r, xOffset, yOffset, portColor);
    }

    public void drawBreakoutPortLine(Graphics g, Rectangle r, int xOffset, int yOffset, Color color) {
        g.setColor(color);
        g.fillRect(r.x + xOffset, r.y + yOffset, 2, 5);
        g.drawRect(r.x + xOffset, r.y + yOffset, 2, 5);
    }
}

