/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.lib.util;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.CommonRoleUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.StringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class CommonRoleExtUtil {
    private static CommonRoleExtUtil _INSTANCE;
    static final int[] featureRowStatusOid;
    static final int[] featureElementNameOid;
    static final int[] featureElementTypeOid;
    static final int[] scopeRestOid;
    static final int[] scopeValueOid;
    static final int[] scopeRowStatusOid;
    static final SnmpInt CREATEANDGO;
    static final SnmpInt DELETE;
    public static final int ROLE_POLICY_VSAN_BIT = 0;
    public static final int ROLE_POLICY_VLAN_BIT = 1;
    public static final int ROLE_POLICY_INTFACE_BIT = 2;
    public static final int VSAN_SCOPE_REST_ENUM_VAL = 1;
    public static final int VLAN_SCOPE_REST_ENUM_VAL = 2;
    public static final int INTFACE_SCOPE_REST_ENUM_VAL = 3;
    public static final int COMMAND_ELEMENT_TYPE_ENUM_VAL = 1;
    public static final int FEATURE_ELEMENT_TYPE_ENUM_VAL = 2;
    public static final int NONE_ELEMENT_TYPE_ENUM_VAL = 3;
    public static final int RULE_COMMAND_ELEMENT_TYPE_ENUM_VAL = 1;
    public static final int RULE_FEATURE_ELEMENT_TYPE_ENUM_VAL = 2;
    public static final int RULE_FEATURE_GROUP_ELEMENT_TYPE_ENUM_VAL = 3;
    public static final int RULE_ALL_ELEMENT_TYPE_ENUM_VAL = 4;
    public static final int MAX_RULE_NUM = 256;
    public static final StringComparator strComp;
    private TreeMap<String, TreeSet<FeatureElement>> featureGroupsMap = new TreeMap(strComp);
    private TreeMap<String, TreeSet<FeatureElement>> featuresMap = new TreeMap(strComp);
    private HashMap<String, int[]> featureGroupNameToIndexMap = new HashMap();
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent;
    private long maxRulesPerRole;

    public static synchronized CommonRoleExtUtil getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new CommonRoleExtUtil();
        }
        return _INSTANCE;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public static boolean validateVlanVsanScopes(JDialog parent, String scopes, String prefix) {
        try {
            CommonRoleExtUtil.validateVlanVsanScopes(scopes, prefix);
        }
        catch (Exception e) {
            Util.errorMessage((Component)parent, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public static void validateVlanVsanScopes(String scopes, String prefix) throws Exception {
        try {
            StringUtil.tokenize((String)scopes, (String)",", (String)"-", (int)10, (boolean)true, (int)1, (int)4096, (boolean)true);
        }
        catch (Exception e) {
            throw new Exception(prefix + " : " + e.getMessage(), e);
        }
    }

    public static boolean validateIntFaceScopes(JDialog parent, SnmpIntList scopes, String prefix, IfIndexIf ifIndexIf) {
        try {
            CommonRoleExtUtil.validateIntFaceScopes(scopes, prefix, ifIndexIf);
        }
        catch (Exception e) {
            Util.errorMessage((Component)parent, (String)e.getMessage());
            return false;
        }
        return true;
    }

    public static void validateIntFaceScopes(SnmpIntList scopes, String prefix, IfIndexIf ifIndexIf) throws Exception {
        int[] lIfIndices;
        for (int lIfIndex : lIfIndices = SnmpIntList.valueOf((byte[])scopes.getValue())) {
            if (IfIndexUtil.getType((int)lIfIndex) == 1 || ifIndexIf.getType(lIfIndex) == 30 || IfIndexUtil.getType((int)lIfIndex) == 5 || IfIndexUtil.getType((int)lIfIndex) == 4) continue;
            throw new Exception(prefix + " : Invalid Interface type : <" + ifIndexIf.ifIndexToName(lIfIndex) + ">");
        }
    }

    public DefaultComboBoxModel getRuleElementModel(int ruleElementType) {
        Set<Object> set;
        switch (ruleElementType) {
            case 1: 
            case 4: {
                set = new HashSet();
                break;
            }
            case 2: {
                set = this.featuresMap.keySet();
                break;
            }
            case 3: {
                set = this.featureGroupsMap.keySet();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid rule Element Type :" + ruleElementType);
            }
        }
        return new DefaultComboBoxModel<String>(set.toArray(new String[0]));
    }

    public void initialize(Component parent, SnmpPeer peer) {
        this.initializeFeaturesAndFeatureGroups(parent, peer);
        this.initMaxRulesPerRole(parent, peer);
        this.fireStateChanged();
    }

    private void initializeFeaturesAndFeatureGroups(Component parent, SnmpPeer peer) {
        this.featureGroupsMap.clear();
        this.featuresMap.clear();
        int[] lElementNameOid = featureElementNameOid;
        int[] lElementTypeOid = featureElementTypeOid;
        try {
            VarBindList lVbl = new VarBindList(2);
            lVbl.add(lElementNameOid);
            lVbl.add(lElementTypeOid);
            SnmpPDU lRspPdu = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)lVbl);
            VarBindList lRspVbl = lRspPdu.getVariables();
            for (int i = 0; i < lRspVbl.size(); i += 2) {
                TreeSet<Object> lElements;
                int[] lOid = lRspVbl.getOid(i).getValue();
                int[] lIndex = new SnmpOID(lOid, lElementNameOid.length, lOid.length - lElementNameOid.length).getValue();
                String lFeatureOrGroupName = SnmpString.toString((int[])lIndex, (int)1, (int)(lIndex[0] + 1));
                String lElementName = lRspVbl.stringValue(i);
                int lElementType = lRspVbl.intValue(i + 1);
                TreeMap<String, TreeSet<FeatureElement>> map = lElementType == 1 ? this.featuresMap : this.featureGroupsMap;
                if (map.containsKey(lFeatureOrGroupName)) {
                    lElements = map.get(lFeatureOrGroupName);
                } else {
                    lElements = new TreeSet();
                    map.put(lFeatureOrGroupName, lElements);
                }
                if (lElementType == 3 || lElementType == 2 && lElementName.trim().length() == 0) {
                    this.featureGroupNameToIndexMap.put(lFeatureOrGroupName, lIndex);
                    continue;
                }
                lElements.add(new FeatureElement(lIndex, lElementName.trim()));
            }
        }
        catch (SnmpException e) {
            Util.errorMessage((Component)parent, (Exception)((Object)e));
        }
    }

    private void initMaxRulesPerRole(Component parent, SnmpPeer peer) {
        this.maxRulesPerRole = CommonRoleUtil.getInstance().getMaxRulePerRole(peer, 0L);
    }

    public HashMap<Integer, ArrayList<CommonRoleExtScope>> getScopesForRole(SnmpPeer peer, int[] roleNameIndex) {
        HashMap<Integer, ArrayList<CommonRoleExtScope>> restrictionHash;
        block6: {
            restrictionHash = new HashMap<Integer, ArrayList<CommonRoleExtScope>>();
            if (roleNameIndex != null && roleNameIndex.length > 0) {
                int[] lRestrictionOid = new SnmpOID(scopeRestOid, roleNameIndex).getValue();
                int[] lValueOid = new SnmpOID(scopeValueOid, roleNameIndex).getValue();
                try {
                    VarBindList lVbl = new VarBindList(2);
                    lVbl.add(lRestrictionOid);
                    lVbl.add(lValueOid);
                    SnmpPDU lRspPdu = SnmpFetch.getBulk((SnmpPeer)peer, (VarBindList)lVbl);
                    VarBindList lRspVbl = lRspPdu.getVariables();
                    for (int i = 0; i < lRspVbl.size(); i += 2) {
                        ArrayList<Object> lScopesList;
                        int[] lOid = lRspVbl.getOid(i).getValue();
                        int[] lScopeTableIndex = new SnmpOID(lOid, scopeRestOid.length, lOid.length - scopeRestOid.length).getValue();
                        int lScopeIndex = lScopeTableIndex[lScopeTableIndex.length - 1];
                        int lScopeRestType = lRspVbl.intValue(i);
                        int lScopeVal = lRspVbl.intValue(i + 1);
                        if (restrictionHash.containsKey(lScopeRestType)) {
                            lScopesList = restrictionHash.get(lScopeRestType);
                        } else {
                            lScopesList = new ArrayList();
                            restrictionHash.put(lScopeRestType, lScopesList);
                        }
                        lScopesList.add(new CommonRoleExtScope(lScopeIndex, lScopeRestType, lScopeVal));
                    }
                }
                catch (SnmpException e) {
                    if (!SnmpSession.isTrace()) break block6;
                    DefaultLogger._DefLogger.debug((Object)e);
                }
            }
        }
        return restrictionHash;
    }

    public TreeMap<String, TreeSet<FeatureElement>> getFeaturesMap() {
        return (TreeMap)this.featuresMap.clone();
    }

    public TreeMap<String, TreeSet<FeatureElement>> getFeatureGroupsMap() {
        return (TreeMap)this.featureGroupsMap.clone();
    }

    public long getMaxRulesPerRole() {
        return this.maxRulesPerRole;
    }

    public int[] createIndexFor(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        byte[] b = name.getBytes();
        int[] index = new int[b.length + 1];
        index[0] = b.length;
        for (int j = 0; j < b.length; ++j) {
            index[j + 1] = b[j] & 0xFF;
        }
        return index;
    }

    public void createNewScope(SnmpPDU pdu, int[] index, SnmpInt restriction, SnmpInt value) {
        if (pdu == null) {
            pdu = new SnmpPDU(-93, new VarBindList());
        }
        pdu.addVar(new SnmpOID(scopeRowStatusOid, index), (SnmpVar)CREATEANDGO);
        pdu.addVar(new SnmpOID(scopeRestOid, index), (SnmpVar)restriction);
        pdu.addVar(new SnmpOID(scopeValueOid, index), (SnmpVar)value);
    }

    public void addFeatureGroupToDeletePDU(SnmpPDU pdu, String featureGroupName) {
        if (this.featureGroupNameToIndexMap.containsKey(featureGroupName)) {
            int[] index = this.featureGroupNameToIndexMap.get(featureGroupName);
            pdu.addVar(new SnmpOID(featureRowStatusOid, index), (SnmpVar)DELETE);
        }
    }

    public void addFeatureElementToDeletePDU(SnmpPDU pdu, String featureGroupName, int[] index) {
        if (this.featureGroupNameToIndexMap.containsKey(featureGroupName)) {
            pdu.addVar(new SnmpOID(featureRowStatusOid, index), (SnmpVar)DELETE);
        }
    }

    public void addFeatureElementToInsertPDU(SnmpPDU pdu, String featureGroupName, SnmpString elementName, int lIndex) {
        if (this.featureGroupNameToIndexMap.containsKey(featureGroupName)) {
            int[] index = this.featureGroupNameToIndexMap.get(featureGroupName);
            index[index.length - 1] = lIndex;
            pdu.addVar(new SnmpOID(featureRowStatusOid, index), (SnmpVar)CREATEANDGO);
            SnmpInt elementType = new SnmpInt(2);
            pdu.addVar(new SnmpOID(featureElementNameOid, index), (SnmpVar)elementName);
            pdu.addVar(new SnmpOID(featureElementTypeOid, index), (SnmpVar)elementType);
        }
    }

    public void addFeatureGroupToInsertPDU(SnmpPDU pdu, String featureGroupName, int featureGroupIndex, SnmpString elementName) {
        SnmpInt elementType;
        int[] nameIndex = this.createIndexFor(featureGroupName);
        int[] index = new int[nameIndex.length + 1];
        System.arraycopy(nameIndex, 0, index, 0, nameIndex.length);
        index[index.length - 1] = featureGroupIndex;
        pdu.addVar(new SnmpOID(featureRowStatusOid, index), (SnmpVar)CREATEANDGO);
        if (elementName == null) {
            elementType = new SnmpInt(3);
        } else {
            elementType = new SnmpInt(2);
            pdu.addVar(new SnmpOID(featureElementNameOid, index), (SnmpVar)elementName);
        }
        pdu.addVar(new SnmpOID(featureElementTypeOid, index), (SnmpVar)elementType);
    }

    static {
        featureRowStatusOid = MibNode.get((String)"ccreFeatureRowStatus").getOid();
        featureElementNameOid = MibNode.get((String)"ccreFeatureElementName").getOid();
        featureElementTypeOid = MibNode.get((String)"ccreFeatureElementType").getOid();
        scopeRestOid = MibNode.get((String)"ccreRoleScopeRestriction").getOid();
        scopeValueOid = MibNode.get((String)"ccreRoleScopeValue").getOid();
        scopeRowStatusOid = MibNode.get((String)"ccreRoleScopeRowStatus").getOid();
        CREATEANDGO = new SnmpInt(4);
        DELETE = new SnmpInt(6);
        strComp = new StringComparator();
    }

    public static class StringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }

    public static class Rule {
        private SnmpOID roleNameRuleIndex;
        private SnmpInt isPermit;
        private SnmpInt elementType;
        private SnmpInt operation;
        private SnmpString elementName;

        public Rule(SnmpOID roleNameRuleIndex, SnmpInt isPermit, SnmpInt elementType, SnmpString elementName, SnmpInt operation) {
            this.roleNameRuleIndex = roleNameRuleIndex;
            this.isPermit = isPermit;
            this.elementType = elementType;
            this.elementName = elementName;
            this.operation = operation;
        }

        public SnmpOID getRoleNameRuleIndex() {
            return this.roleNameRuleIndex;
        }

        public SnmpInt getPermit() {
            return this.isPermit;
        }

        public SnmpInt getElementType() {
            return this.elementType;
        }

        public SnmpInt getOperation() {
            return this.operation;
        }

        public SnmpString getElementName() {
            return this.elementName;
        }
    }

    public static class FeatureElement
    implements Comparable {
        int[] index;
        String name;

        public FeatureElement(int[] index, String name) {
            this.index = index;
            this.name = name;
        }

        public int[] getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }

        public int compareTo(Object o) {
            if (o instanceof FeatureElement) {
                return strComp.compare(this.name, ((FeatureElement)o).getName());
            }
            return -1;
        }

        public boolean equals(Object o) {
            if (o instanceof String) {
                return this.name.equals(o);
            }
            if (o instanceof FeatureElement) {
                return this.name.equals(((FeatureElement)o).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void updateDeletePDU(SnmpPDU pdu) {
            pdu.addVar(new SnmpOID(featureRowStatusOid, this.getIndex()), (SnmpVar)DELETE);
        }
    }

    public static class CommonRoleExtScope {
        int index;
        int restType;
        int value;

        public CommonRoleExtScope(int index, int restType, int value) {
            this.restType = restType;
            this.value = value;
            this.index = index;
        }

        public int getValue() {
            return this.value;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

