/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.dialogs.security;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.portland.lib.util.CommonRoleExtUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InsertRoleRule
extends InsertForm
implements ItemListener,
ChangeListener {
    static final int ROLE_NAME = 0;
    static final int RULE_NUM = 1;
    static final int PERMIT = 2;
    static final int OPERATION = 3;
    static final int ELEMENT_TYPE = 4;
    static final int ELEMENT_NAME = 5;
    private int[] roleNameIndex;
    private JComboBox elementCombo = new JComboBox();
    private RadioButtonPanel elementTypePanel;
    private DefaultComboBoxModel[] models;

    public InsertRoleRule(InsertDialog parent, EditTable table, Object formParameter) {
        super(parent, table);
        if (formParameter.getClass().isArray()) {
            this.roleNameIndex = (int[])formParameter;
        }
    }

    protected void build() {
        super.build();
        CommonRoleExtUtil.getInstance().addChangeListener(this);
        this.stateChanged(null);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.models = new DefaultComboBoxModel[]{CommonRoleExtUtil.getInstance().getRuleElementModel(1), CommonRoleExtUtil.getInstance().getRuleElementModel(2), CommonRoleExtUtil.getInstance().getRuleElementModel(3)};
        this.updateElementComboModel();
    }

    protected void insert() throws Exception {
        super.insert();
        int index = Integer.parseInt(this.getComponentText(1));
        this.setComponentText(1, index < this._mibNodes[1].getHi() ? Integer.toString(index + 1) : "");
    }

    public void dispose() {
        super.dispose();
        CommonRoleExtUtil.getInstance().removeChangeListener(this);
        this.models = null;
    }

    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 1) {
            int width = this.getWidth(mibVar, mibNode, mibNode.getTCLabel());
            FieldPanel p = new FieldPanel(width, mibNode.getLo(), 256, (String)SnmpTableModel._Units.get(mibVar));
            p.setText(String.valueOf(this.getLastIndex()[0] + 1));
            return p;
        }
        if (index == 5) {
            this.elementCombo.setPrototypeDisplayValue("QQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQQ");
            this.elementCombo.setEditable(true);
            return this.elementCombo;
        }
        JComponent lComp = super.buildComponent(mibVar, mibNode, index);
        if (index == 0) {
            if (lComp instanceof JTextField) {
                JTextField f = (JTextField)lComp;
                f.setEditable(false);
                f.setText(SnmpString.toString((int[])this.roleNameIndex, (int)1, (int)(this.roleNameIndex[0] + 1)));
            }
        } else if (index == 4 && lComp instanceof RadioButtonPanel) {
            this.elementTypePanel = (RadioButtonPanel)lComp;
            this.elementTypePanel.addChangeListener((ItemListener)this);
        }
        return lComp;
    }

    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 5 && this._values[index] instanceof JComboBox) {
            Object selected = ((JComboBox)this._values[index]).getSelectedItem();
            int lSelectedRb = this.elementTypePanel.getSelected() + 1;
            if (selected == null) {
                if (lSelectedRb == 3) {
                    throw new SnmpException("Feature Group cannot be blank. Please create a Feature Group.");
                }
                if (lSelectedRb == 1) {
                    throw new SnmpException("Command cannot be blank. Please type in a Command.");
                }
            }
            return this.getVarFromString(selected.toString(), index);
        }
        return super.getComponentValue(index);
    }

    protected int[] getLastIndex() {
        SnmpOID lRuleNum;
        Array lData = this.getTableModel().getData();
        int lNextIndex = 1;
        for (int i = 0; i < lData.size() && lNextIndex >= (lRuleNum = (SnmpOID)((Object[])lData.elementAt(i))[0]).getIndexFromEnd(0); ++lNextIndex, ++i) {
        }
        return new int[]{lNextIndex - 1};
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            int lSelectedRb = this.elementTypePanel.getSelected() + 1;
            this.setEnabled(5, lSelectedRb != 4);
            this.setEnabled(3, lSelectedRb != 1);
            this.elementCombo.setEditable(lSelectedRb == 1);
            if (lSelectedRb != 4) {
                this.updateElementComboModel();
            }
        }
    }

    private void updateElementComboModel() {
        this.elementCombo.setModel(this.models[this.elementTypePanel.getSelected()]);
    }
}

