/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.AbstractEthPort;
import com.cisco.dcbu.dmdb.andiamo.elements.FCCard;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.portland.dmdb.elements.N5KEthPort;
import com.cisco.dcbu.portland.dmdb.elements.N5KPort;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JPopupMenu;

public abstract class N5KCard
extends FCCard {
    public static boolean _isSupportEthPortStatusPerModuleFeature;
    protected Class[] _PortClass;
    public static int[] _fcPortVendorType;

    public SnmpVarBind[] getStatusVar() {
        _isSupportEthPortStatusPerModuleFeature = Discover.isSysVersionGreaterThanEqual((String)"4.2(0)");
        return super.getStatusVar();
    }

    protected static int[][] buildPortPos(int[] pX_pos, int[] pY_pos, int pX_offset, int pY_offset, boolean pIsNamingOrderVertical) {
        N5KCard.prepareArray(pX_pos, pX_offset);
        N5KCard.prepareArray(pY_pos, pY_offset);
        return N5KCard.buildPortPos(pX_pos, pY_pos, pIsNamingOrderVertical);
    }

    public abstract int getNumPorts();

    protected Class[] discoverPorts() throws Exception {
        this._PortClass = new Class[this.getNumPorts()];
        int slot = this.getIndex()[0] - 21;
        int[] vendorType = MibNode.get((String)"entPhysicalVendorType").getOid();
        VarBindList lVbl = new VarBindList(1);
        lVbl.add(vendorType);
        int portStartIndex = 4949 + 256 * (slot - 1);
        int portEndIndex = portStartIndex + this.getNumPorts() + 1;
        try {
            SnmpPDU resp = SnmpFetch.getBulkWithStartIndexFix((SnmpPeer)Discover.getPeer(), (VarBindList)lVbl, (int)0, (int[])new int[]{portStartIndex}, (int[])new int[]{portEndIndex});
            if (resp.getVariables().size() == 0 || resp.getVariables().size() < this.getNumPorts()) {
                return null;
            }
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                SnmpVarBind vb = resp.getVariables().get(i);
                if (!vb.getOid().startsWith(vendorType)) continue;
                SnmpOID oid = (SnmpOID)vb.getVar();
                int[] entityVendorType = oid.getValue();
                this._PortClass[i] = this.isFCPortType(entityVendorType) ? N5KPort.class : N5KEthPort.class;
            }
        }
        catch (SnmpException ex) {
            throw new Exception("discoverPorts: " + (Object)((Object)ex));
        }
        return this._PortClass;
    }

    void updateView(AbstractEthPort port, int fpIfIndex, int bpIfIndex, int operCause) {
        try {
            PhysicalView view = DeviceManager.getInstance().getView();
            Array elements = view.getElements();
            Graphics g = view.getOffscreenImage().getGraphics();
            Color bg = new Color(66, 66, 66);
            g.setColor(bg);
            int vport = bpIfIndex >> 12 & 0x7F;
            int breakOutOffset = FRUConstants.getBreakoutOffset((int)this.getCardType());
            int[] cliPort = IfIndexUtil.getCliPort4VirtualPortN5K((int)vport, (int)breakOutOffset);
            if (cliPort[1] == 1) {
                int breakoutFactor = FRUConstants.getBreakoutFactor((int)this.getCardType());
                port.drawBreakoutPortLed(g, breakoutFactor);
            }
            port.drawBreakoutPortLed(g, bpIfIndex, cliPort[1] - 1, operCause);
            g.dispose();
            view.repaint();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected boolean isFCPortType(int[] vendorType) {
        return Arrays.equals(vendorType, _fcPortVendorType);
    }

    private static void prepareArray(int[] pPos, int pOffset) {
        if (pPos[0] < 0) {
            pPos[0] = pOffset;
        }
        for (int i = 1; i < pPos.length; ++i) {
            if (pPos[i] >= 0) continue;
            pPos[i] = pPos[i - 1] + pOffset;
        }
    }

    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        byte[] b = varBindList.byteValue(offset);
        byte[] operModeList = varBindList.byteValue(offset + 1);
        byte[] operCauseList = varBindList.byteValue(offset + 2);
        int i = 0;
        int j = 0;
        if (b.length == 0 || operModeList.length == 0 || operCauseList.length == 0) {
            this.disable();
            return;
        }
        for (int k = 0; (i < b.length || j < operModeList.length || k < operCauseList.length) && i <= b.length - 4 && j <= operModeList.length - 1 && k <= operCauseList.length - 2; i += 4, ++j, k += 2) {
            int ifIndex = ((b[i + 3] & 0xFF) << 24) + ((b[i + 2] & 0xFF) << 16) + ((b[i + 1] & 0xFF) << 8) + (b[i] & 0xFF);
            PhysicalElement e = view.find(AbstractPort.class, ifIndex);
            if (e == null && FRUConstants.isBreakoutCapable((int)this.getCardType())) {
                int breakoutIfIndex = ifIndex;
                int frontPort = Discover.getRoot().ifIndex2Port(ifIndex);
                ifIndex = FRUConstants.isBreakoutLineCard((int)this.getCardType()) ? Discover.getRoot().nameToIfIndex(this._index[0] - 21 - 1, 112 + frontPort + 1, 26) : Discover.getRoot().nameToIfIndex(this._index[0] - 21, 112 + frontPort + 1, 26);
                e = view.find(AbstractPort.class, ifIndex);
                if (e != null) {
                    int operMode = operModeList[j] & 0xFF;
                    int operCause = ((operCauseList[k + 1] & 0xFF) << 8) + (operCauseList[k] & 0xFF);
                    this.updateView((AbstractEthPort)e, ifIndex, breakoutIfIndex, operCause);
                    int vport = breakoutIfIndex >> 12 & 0x7F;
                    int breakOutOffset = FRUConstants.getBreakoutOffset((int)this.getCardType());
                    int[] cliPort = IfIndexUtil.getCliPort4VirtualPortN5K((int)vport, (int)breakOutOffset);
                    if (cliPort[1] == 1) {
                        ((N5KEthPort)e).resetStatus(false);
                    }
                    if (((N5KEthPort)e)._cause == 2) continue;
                    this.updatePortStatus(view, e, operMode, operCause);
                    continue;
                }
                DefaultLogger._DefLogger.debug((Object)("setStatus port not found : " + ifIndex));
                continue;
            }
            int operMode = operModeList[j] & 0xFF;
            int operCause = ((operCauseList[k + 1] & 0xFF) << 8) + (operCauseList[k] & 0xFF);
            this.updatePortStatus(view, e, operMode, operCause);
            if (!FRUConstants.isBreakoutCapable((int)this.getCardType())) continue;
            ((AbstractEthPort)e).clearBreakoutPortLed(view, FRUConstants.getBreakoutFactor((int)this.getCardType()));
        }
    }

    private static int[][] buildPortPos(int[] pX_pos, int[] pY_pos, boolean pIsNamingOrderVertical) {
        int size = pX_pos.length * pY_pos.length;
        int[][] port_pos = new int[size][2];
        int i = 0;
        for (int x = 0; x < pX_pos.length; ++x) {
            for (int y = 0; y < pY_pos.length; ++y) {
                i = pIsNamingOrderVertical ? y + pY_pos.length * x : x + pX_pos.length * y;
                port_pos[i] = new int[]{pX_pos[x], pY_pos[y]};
            }
        }
        return port_pos;
    }

    public JPopupMenu getMenu() {
        if (this._Menu == null) {
            this._Menu = this.buildMenu((ActionListener)((Object)this));
        }
        return this._Menu;
    }

    public String getToolTipText() {
        if (this._toolTipText == null) {
            this._toolTipText = this.getHTMLToolTipText();
        }
        return this._toolTipText;
    }

    protected void updatePortStatus(PhysicalView view, PhysicalElement e, int operMode, int operCause) {
        if (e != null && e instanceof N5KEthPort) {
            ((N5KEthPort)e).resetStatus(false);
            ((N5KEthPort)e).setStatus(portModeMap[operMode], operCause, view);
        } else {
            super.updatePortStatus(view, e, operMode, operCause);
        }
    }

    protected boolean isUpStatus() {
        return this.getStatus().equalsIgnoreCase("ok");
    }

    protected String getStatusForTooltip() {
        return this.getStatus();
    }

    static {
        _fcPortVendorType = new int[]{1, 3, 6, 1, 4, 1, 9, 12, 3, 1, 10, 131};
    }
}

