/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

IlvButton.prototype.mouseDown = function(e) {
if (this.enabled && e.button != 2) {
var toggle = this.isToggleButton();
if (toggle)
this.setSelected(!this.isSelected());
else
this.setSelected(true);
this.doAction(e);
}
}
IlvButton.prototype.doAction = function(event) {
if (this.enabled) {
if (typeof(this.action) == 'function')
return this.action(this.imageView.imagePanel._div, event);
else
eval(this.action);
}
}
IlvButton.prototype.doClick = function() {
if (this.enabled) {
var toggle = this.isToggleButton();
if (toggle)
this.setSelected(!this.isSelected());
else
this.setSelected(true);
this.doAction();
if (!toggle)
this.setSelected(false);
}
}
IlvButton.prototype.getDoActionOnBGDeselect = function () {
return this.doActionOnBGDeselect;
}
IlvButton.prototype.setDoActionOnBGDeselect = function (doActionOnBGDeselect) {
this.doActionOnBGDeselect = doActionOnBGDeselect;
}
function IlvGroupedButton(left, top, width, height, image, action) {
this.superConstructor(left, top, width, height, image, action);
this.group = null;
this.registerDispose();
}
IlvGroupedButton.prototype = new IlvButton();
IlvGroupedButton.prototype.setClassName("IlvGroupedButton");
IlvGroupedButton.prototype.dispose = function() {
this.superInvoke("dispose");
this.group = null;
}
IlvGroupedButton.prototype.setSelected = function(selected) {
if (this.group && selected && this.enabled) {
this.group.select(this);
}
this.superInvoke("setSelected", selected);
this.JSFRef.notify("Selected");
}
IlvGroupedButton.prototype.mouseDown = function(e) {
if (this.isSelected())
return false;
return this.superInvoke("mouseDown", e);
}
function IlvToggleButton(left, top, width, height, image, action) {
this.superConstructor(left, top, width, height, image, action);
this.registerDispose();
}
IlvToggleButton.prototype = new IlvButton();
IlvToggleButton.prototype.setClassName("IlvToggleButton");
IlvToggleButton.prototype.setSelected = function(selected) {
this.superInvoke("setSelected", selected);
this.JSFRef.notify("Selected");
}
function IlvButtonGroup() {
this.superConstructor();
this.selection = null;
this.registerDispose();
}
IlvButtonGroup.prototype = new IlvObject();
IlvButtonGroup.prototype.setClassName("IlvButtonGroup");
IlvButtonGroup.prototype.dispose = function() {
this.superInvoke("dispose");
this.selection = null;
}
IlvButtonGroup.prototype.select = function(button) {
if (this.selection) {
var saveEnabledState =this.selection.isEnabled();
this.selection.setEnabled(true);
this.selection.setSelected(false);
if (this.selection.getDoActionOnBGDeselect()) {
this.selection.doAction();
}
this.selection.setEnabled(saveEnabledState);
}
this.selection = button;
}
IlvButtonGroup.prototype.add = function(button) {
button.group = this;
if (button.isSelected() && !this.selection)
this.selection = button;
}
function IlvImageButtonProxy (clientId, refNodeId, grouped) {
if (clientId) {
this.superConstructor(clientId);
this.setMinimumSize(10, 10);
var size = this.getCreationSize(refNodeId);
var button = grouped ? new IlvGroupedButton(0, 0, size.width, size.height) : new IlvToggleButton(0, 0, size.width, size.height);
this.setJViewsDHTMLObject(button);
this.doActionOnBGDeselect = false;
}
}
IlvImageButtonProxy.prototype = new IlvSizedViewProxy;
IlvImageButtonProxy.prototype.setClassName("IlvImageButtonProxy");
IlvImageButtonProxy.prototype.setImage = function (image) {
this.getJViewsDHTMLObject().setImage(image);
this.notify("Image");
}
IlvImageButtonProxy.prototype.getImage = function () {
return this.getJViewsDHTMLObject().getImage();
}
IlvImageButtonProxy.prototype.setRolloverImage = function (image) {
this.getJViewsDHTMLObject().setRolloverImage(image);
this.notify("RolloverImage");
}
IlvImageButtonProxy.prototype.getRolloverImage = function () {
return this.getJViewsDHTMLObject().getRolloverImage();
}
IlvImageButtonProxy.prototype.setSelectedImage = function (image) {
this.getJViewsDHTMLObject().setSelectedImage(image);
this.notify("SelectedImage");
}
IlvImageButtonProxy.prototype.getSelectedImage = function () {
return this.getJViewsDHTMLObject().getSelectedImage();
}
IlvImageButtonProxy.prototype.setCursor = function (cursor) {
this.getJViewsDHTMLObject().setCursor(cursor);
this.notify("Cursor");
}
IlvImageButtonProxy.prototype.getCursor = function () {
return this.getJViewsDHTMLObject().getCursor();
}
IlvImageButtonProxy.prototype.setToggle = function (toggle) {
this.getJViewsDHTMLObject().setToggleButton(toggle);
this.notify("Toggle");
}
IlvImageButtonProxy.prototype.isToggle = function () {
return this.getJViewsDHTMLObject().isToggleButton();
}
IlvImageButtonProxy.prototype.setMessage = function (message) {
this.getJViewsDHTMLObject().setMessage(message);
this.notify("Message");
}
IlvImageButtonProxy.prototype.getMessage = function () {
return this.getJViewsDHTMLObject().getMessage();
}
IlvImageButtonProxy.prototype.setMessageBox = function (messageBox) {
this.messageBox = messageBox;
this.getJViewsDHTMLObject().setMessagePanel(messageBox.getJViewsDHTMLObject());
this.notify("MessageBoxId");
}
IlvImageButtonProxy.prototype.getMessageBox = function () {
return this.messageBox;
}
IlvImageButtonProxy.prototype.getMessageBoxId = function () {
return this.messageBox.getAbsoluteId();
}
IlvImageButtonProxy.prototype.setTitle = function (title) {
this.getJViewsDHTMLObject().setToolTipText(title);
this.notify("Title");
}
IlvImageButtonProxy.prototype.getTitle = function () {
return this.getJViewsDHTMLObject().getTitle();
}
IlvImageButtonProxy.prototype.setOnclick = function (onclick) {
this.getJViewsDHTMLObject().setAction(onclick);
this.notify("onClick");
}
IlvImageButtonProxy.prototype.getOnclick = function () {
return this.getJViewsDHTMLObject().getOnClick();
}
IlvImageButtonProxy.prototype.setEnabled = function (enabled) {
this.getJViewsDHTMLObject().setEnabled(enabled);
this.notify("Enabled");
}
IlvImageButtonProxy.prototype.isEnabled = function () {
return this.getJViewsDHTMLObject().isEnabled();
}
IlvImageButtonProxy.prototype.setSelected = function (selected) {
this.getJViewsDHTMLObject().setSelected(selected);
this.notify("Selected");
}
IlvImageButtonProxy.prototype.isSelected = function () {
return this.getJViewsDHTMLObject().isSelected();
}
IlvImageButtonProxy.prototype.setCommitted = function (committed) {
this.committed = committed;
this.notify("Committed");
}
IlvImageButtonProxy.prototype.isCommitted = function () {
return this.committed;
}
IlvImageButtonProxy.prototype.getDoActionOnBGDeselect = function () {
return this.getJViewsDHTMLObject().getDoActionOnBGDeselect();
}
IlvImageButtonProxy.prototype.setDoActionOnBGDeselect = function (doActionOnBGDeselect) {
this.getJViewsDHTMLObject().setDoActionOnBGDeselect(doActionOnBGDeselect);
this.notify("DoActionOnBGDeselect");
}
IlvImageButtonProxy.prototype.doClick = function () {
this.getJViewsDHTMLObject().doClick();
}
