/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvPopupMenuFactory () {
this.superConstructor();
}
IlvPopupMenuFactory.prototype = new IlvObject();
IlvPopupMenuFactory.prototype.setClassName("IlvPopupMenuFactory");
IlvPopupMenuFactory.prototype.displayPopupMenu = function (view,event,modelId) {
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
var request = this.popupMenu.createRequestURL(view, event, modelId);
if (!request)
return;
this.onload();
var onload = "'"+this.toString()+"'";
if (document.layers) {
request+="&onload="+onload;
} else {
request+="&onload="+onload+"&parent=true";
}
this._view = view;
if (!IlvPopupMenuFactory._loader)
IlvPopupMenuFactory._loader = new IlvDynPanel();
IlvPopupMenuFactory._loader.setURL(request);
return false;
}
IlvPopupMenuFactory.prototype.create = function (data) {
var array = data.menu;
if (!array)
return null;
menu = this.read(array);
menu.popupMenu = this.popupMenu;
menu.popupMenu._triggerLeft = data.left;
menu.popupMenu._triggerTop = data.top;
return menu;
}
IlvPopupMenuFactory.prototype.getRequestType = function () {
return this._requestType || "popupmenurequested";
}
IlvPopupMenuFactory.prototype.setRequestType = function (requestType) {
this._requestType = requestType;
}
IlvPopupMenuFactory.prototype.read = function (array) {
var type = array[0];
if (type == "Menu") {
var menu = this.readMenu(array);
var width = 0, height = 0;
var i, imax = array.length;
for (i = 4; i < imax; i++)
menu.add(this.read(array[i]));
return menu;
} else if (type == "MenuItem") {
var item = this.readMenuItem(array);
item._view = this._view;
return item;
} else
alert("Don't know how to read menu of type "
+ type + ", send by the server.");
return null;
}
IlvPopupMenuFactory.prototype.readAction = function (item, array) {
var type = array[0];
if (type == "JS") {
item.setAction(function(viewObj, itemObj){eval(array[1]);});
} else if (type == "Servlet") {
var actionName = array[1];
var updateAll = array[2];
var params =  array.slice(3);
item.setAction(function(){item.performServerAction(actionName,params,updateAll);});
}
}
IlvPopupMenuFactory.prototype.onload = function (factory) {
if (factory && IlvPopupMenuFactory._factories) {
var f = IlvPopupMenuFactory._factories[factory];
f.asyncDisplayPopupMenu(IlvPopupMenuFactory._loader.getContext());
} else {
if (!IlvPopupMenuFactory._factories)
IlvPopupMenuFactory._factories = new Array();
IlvPopupMenuFactory._factories[this.toString()] = this;
}
}
IlvPopupMenuFactory.prototype.asyncDisplayPopupMenu = function (data) {
var view = this._view;
var viewLoc = view.getLocation();
var res = this.popupMenu.imageToPageCoordinateSystem(view, data.left, data.top);
this.popupMenu.hidePopupMenu();
var menu = this.create(data);
this.popupMenu.internalDisplayPopupMenu(res.x, res.y ,menu);
}
IlvPopupMenuFactory.prototype.readMenu = function (array, path) {
var menu;
if (!IlvMenu._reusable) {
menu = new IlvMenu(array[1],array[2]);
} else {
var menu = IlvMenu._reusable;
IlvMenu._reusable = menu._next;
menu._next = null;
menu._child = new Array();
menu._parent = null;
menu._isExpanded = false;
menu._isHighlighted = false;
menu._action = null;
menu.setLabel(array[1]);
menu.setEnabled(array[2]);
}
var image = array[3];
if (image != null && image != "no")
menu._img = image;
return menu;
}
IlvPopupMenuFactory.prototype.readMenuItem = function (array) {
if (!IlvMenuItem._reusable) {
var item = new IlvMenuItem(array[1],array[3]);
this.readAction(item, array[2]);
if (array[4] != "no")
item._img = array[4];
item._path = array[5];
return item;
} else {
var item = IlvMenuItem._reusable;
IlvMenuItem._reusable = item._next;
item._next = null;
item._isHighlighted = false;
item._img = null;
item._action = null;
item.setLabel(array[1]);
item.setEnabled(array[3]);
if (array[4] != "no")
item._img = array[4];
item._path = array[5];
this.readAction(item, array[2]);
return item;
}
}
function IlvAbstractPopupMenu(init) {
if (init) {
this.superConstructor();
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
if (document.body.addEventListener) {
document.body.addEventListener("contextmenu", IlvAbstractPopupMenu.onContextMenuHandler, false);
} else {
document.oncontextmenu = function () {
var res = IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if (!res) {
window.event.cancelBubble = true;
window.event.returnValue = res;
}
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
return res;
};
}
this.dynamic = true;
this.factory = new IlvPopupMenuFactory();
this.factory.popupMenu = this;
this.subMenuIcon = ilvImagePath + "sub.gif";
}
}
IlvAbstractPopupMenu.prototype = new IlvObject();
IlvAbstractPopupMenu.prototype.setClassName("IlvAbstractPopupMenu");
IlvAbstractPopupMenu.onblur = function () {
var m = IlvAbstractPopupMenu._openMenu;
if (m && m.popupMenu){
m.popupMenu.hidePopupMenu();
}
}
IlvAbstractPopupMenu.onContextMenuHandler = function (event) {
var res = IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if (!res){
event.preventDefault();
}
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
return res;
}
IlvAbstractPopupMenu.onContextMenuHandler2 = function (event) {
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
}
IlvAbstractPopupMenu.prototype.createIEEventPanel = function () {
if (IlvBrowserInfo.instance.ie5up && !this.eventPanel) {
this.eventPanel = new IlvDynPanel();
this.eventPanel.setLocation(0,0);
this.eventPanel._div.style.width = "100%";
this.eventPanel._div.style.height = "100%";
this.eventPanel.setZIndex(9);
var p = this.eventPanel;
var popup = this;
this.eventPanel.getMouseEventSource().onmouseup =  function (event) {
popup.hidePopupMenu();
if (IlvBrowserInfo.instance.ie5up) {
var v = popup._view;
var event = v.eventPanel.enhanceEvent();
var x = event.mouseX;
var y = event.mouseY;
var inView = (x<0||x>v.getWidth()||y<0||y>v.getHeight());
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = inView;
}
};
}
}
IlvAbstractPopupMenu.prototype.displayPopupMenu = function (view,event,modelId) {
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (event.stopPropagation) {
event.stopPropagation();
}
this._view = view;
if (!this.isPopupTrigger(event)) {
return true;
}
this._triggerLeft = event.mouseX;
this._triggerTop = event.mouseY;
if (this.dynamic) {
return this.factory.displayPopupMenu(view, event, modelId);
} else {
var x = event.mouseX;
var y = event.mouseY;
var res = this.imageToPageCoordinateSystem(view, x, y);
this.hidePopupMenu();
this.internalDisplayPopupMenu(res.x, res.y, this.menu);
}
}
IlvAbstractPopupMenu.prototype.internalResetEvent = function () {
IlvAbstractPopupMenu._documentOnMouseUp = document.onmouseup;
}
IlvAbstractPopupMenu.prototype.imageToPageCoordinateSystem = function (view, x, y) {
var viewLoc = view.getLocation();
return {x : x + viewLoc.left, y: y + viewLoc.top};
}
IlvAbstractPopupMenu.prototype.internalDisplayPopupMenu = function (x, y, menu) {
var view = this._view;
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (menu && menu.getChildrenCount() > 0) {
menu.createHTMLContainer();
menu._delegate.setZIndex(10);
menu.setLocation(x, y);
menu.setVisible(true);
IlvAbstractPopupMenu._openMenu = menu;
if (IlvBrowserInfo.instance.ie5up) {
this.createIEEventPanel();
this.eventPanel.setVisible(true);
this._onscroll = document.body.onscroll;
var panel = this.eventPanel;
document.body.onscroll = function() {
var doc = document;
var de = doc.documentElement.clientWidth?doc.documentElement:doc.body;
panel.setLocation(0, de.scrollTop);
}
} else {
IlvAbstractPopupMenu._documentOnMouseUp = document.onmouseup;
var popup = this;
document.onmouseup = function (event) {
popup.hidePopupMenu();
};
}
}
}
IlvAbstractPopupMenu.prototype.createRequestURL = function (view,event,modelId) {
}
IlvAbstractPopupMenu.prototype.hidePopupMenu = function () {
if (IlvAbstractPopupMenu._openMenu) {
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
if (IlvBrowserInfo.instance.ie5up) {
this.eventPanel.setVisible(false);
if (this._onscroll) {
document.body.onscroll = this._onscroll;
this._onscroll = null;
}
}
if (IlvAbstractPopupMenu._documentOnMouseUp)
document.onmouseup = IlvAbstractPopupMenu._documentOnMouseUp;
else
document.onmouseup = null;
IlvAbstractPopupMenu._openMenu.setVisible(false);
if (this.dynamic) {
IlvAbstractPopupMenu._openMenu.recycle();
} else {
this.deselectAll(IlvAbstractPopupMenu._openMenu);
}
IlvAbstractPopupMenu._openMenu = null;
return true;
} else
return false;
}
IlvAbstractPopupMenu.prototype.performServerAction = function (actionName, params, updateAll) {
var view = this.view;
if (view != null && actionName != null) {
view.performAction(actionName, params, updateAll);
}
}
IlvAbstractPopupMenu.prototype.deselectAll = function(menu){
menu.setHighlighted(false);
for (var i=0; i<menu._child.length; i++) {
menu._child[i].setHighlighted(false);
if (menu._child[i].setExpanded)
this.deselectAll(menu._child[i]);
}
}
IlvAbstractPopupMenu.prototype.setViewInternal = function(view){
var src;
if (this.view) {
if (document.addEventListener) {
src = this.view.eventPanel.getMouseEventSource();
src.removeEventListener("contextmenu", IlvAbstractPopupMenu.onContextMenuHandler2, false);
}
}
this.view = view;
if (view) {
src = view.eventPanel.getMouseEventSource();
if (document.addEventListener) {
if (src) {
src.addEventListener("contextmenu", IlvAbstractPopupMenu.onContextMenuHandler2, false);
} else {
var l = function (view) {
var src = view.eventPanel.getMouseEventSource();
src.addEventListener("contextmenu", IlvAbstractPopupMenu.onContextMenuHandler2, false);
if (view.removeCapabilitiesOnLoadListener) {
view.removeCapabilitiesOnLoadListener(l);
} else if (view.removeCapabilitiesLoadListener){
view.removeCapabilitiesLoadListener(l);
}
};
if (view.addCapabilitiesOnLoadListener) {
view.addCapabilitiesOnLoadListener(l);
} else if (view.addCapabilitiesLoadListener){
view.addCapabilitiesLoadListener(l);
}
}
}
}
}
IlvAbstractPopupMenu.prototype.setMenu = function(menu){
if (this.menu != null)
menu.popupMenu = null;
this.menu = menu;
if (menu != null) {
this.setDynamic(false);
menu.popupMenu = this;
} else {
this.setDynamic(true);
}
}
IlvAbstractPopupMenu.prototype.getMenu = function(){
return this.menu;
}
IlvAbstractPopupMenu.prototype.setDynamic = function (dynamic) {
this.dynamic = dynamic;
}
IlvAbstractPopupMenu.prototype.isDynamic = function () {
return this.dynamic;
}
IlvAbstractPopupMenu.prototype.getItemStyleClass = function () {
return this.itemStyleClass;
}
IlvAbstractPopupMenu.prototype.setItemStyleClass = function (itemStyleClass){
this.itemStyleClass = itemStyleClass;
}
IlvAbstractPopupMenu.prototype.getItemHighlightedStyleClass = function (){
return this.itemHighlightedStyleClass;
}
IlvAbstractPopupMenu.prototype.setItemHighlightedStyleClass = function (itemHighlightedStyleClass){
this.itemHighlightedStyleClass = itemHighlightedStyleClass;
}
IlvAbstractPopupMenu.prototype.getItemDisabledStyleClass = function (){
return this.itemDisabledStyleClass;
}
IlvAbstractPopupMenu.prototype.setItemDisabledStyleClass = function (itemDisabledStyleClass){
this.itemDisabledStyleClass = itemDisabledStyleClass;
}
IlvAbstractPopupMenu.prototype.getSubMenuIcon = function (){
return this.subMenuIcon;
}
IlvAbstractPopupMenu.prototype.setSubmenuIcon = function (subMenuIcon){
this.subMenuIcon = subMenuIcon;
}
IlvAbstractPopupMenu.prototype.isPopupTrigger = function (event) {
return event.button == 2;
}
function IlvMenuItem (label, isEnabled, action, image, path) {
if (typeof(label) == "undefined")
return;
this.superConstructor();
if (typeof(isEnabled) == "undefined")
this._isEnabled = true;
else
this._isEnabled = isEnabled;
this._label = label;
if (action != null)
this.setAction(action);
this._img = image;
if (path != null) {
this._path = path;
}
}
IlvMenuItem.prototype = new IlvPanel();
IlvMenuItem.prototype.setClassName("IlvMenuItem");
IlvMenuItem.prototype.createHTMLContainer = function () {
if (!this._delegate) {
this._delegate = new IlvDynPanel();
this._div = this._delegate._div;
this._div.style.width = "auto";
this._layer = this._delegate._layer;
this._proxy = new IlvDynPanel();
var item = this;
var eventSource = this._proxy.getMouseEventSource();
if (eventSource.addEventListener) {
eventSource.addEventListener("mouseover", function(){item.onmouseover();}, false);
eventSource.addEventListener("mouseup", function() {item.mouseUpHandler();}, false);
} else {
eventSource.onmouseover = function () {
item.onmouseover();
};
eventSource.onmouseup = function () {
item.mouseUpHandler();
};
}
}
}
IlvMenuItem.prototype.mouseUpHandler = function() {
IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (this.getLabel() == "" || this.getLabel() == "-" || !this.isEnabled() || this.setExpanded ) {
return true;
}
var root = this.getRoot();
root.setVisible(false);
if (IlvBrowserInfo.instance.ie5up) {
root.popupMenu.eventPanel.setVisible(false);
}
this.onmouseup();
}
IlvMenuItem.prototype.setAction = function (action) {
if (typeof(action) == "function" || typeof(action) == "string" )
this._action = action;
else if (typeof(action) != "undefined")
alert("The action parameter must be a function or a string");
}
IlvMenuItem.prototype.getAction = function () {
return this._action;
}
IlvMenuItem.prototype.getIconPreferredSize = function () {
if (document.all || IlvBrowserInfo.instance.nav6up)  {
if (this._img == null) {
return {width:8, height:0};
}
if (!IlvMenuItem._span) {
var span = document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
IlvMenuItem._span = span;
}
var span = IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML = "<img border='0' src="+this.getIcon()+"/>";
return {width: span.clientWidth, height: span.clientHeight};
}
if (!this._defaultIconSize) {
this._defaultIconSize = { width: 20, height: 20 };
}
return this._defaultIconSize;
}
IlvMenuItem.prototype.setPreferredIconSize = function (width,height) {
if (!this._defaultIconSize)
this._defaultIconSize = new Object();
this._defaultIconSize.width = width;
this._defaultIconSize.height = height;
}
IlvMenuItem.prototype.getPreferredSize = function () {
if (this._label && (document.all || IlvBrowserInfo.instance.nav6up))  {
if (!IlvMenuItem._span) {
var span = document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
IlvMenuItem._span = span;
}
var span = IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML = this.createHTMLContent(0);
var size = new Object();
if (this._label == "-")
size.width = 0;
else
size.width = span.clientWidth;
size.height = span.clientHeight;
return size;
}
if (!this._defaultSize) {
this._defaultSize = {width:200, height:20};
}
return this._defaultSize;
}
IlvMenuItem.prototype.setPreferredSize = function (width,height) {
if (!this._defaultSize)
this._defaultSize = new Object();
this._defaultSize.width = width;
this._defaultSize.height = height;
}
IlvMenuItem.prototype.setVisible = function (isVisible) {
this.superInvoke("setVisible",isVisible);
this._proxy.setVisible(isVisible);
if (isVisible) {
this.update();
}
}
IlvMenuItem.prototype.setLabel = function (label) {
if (this._label != label) {
this._label = label || "";
this.update();
}
}
IlvMenuItem.prototype.getLabel = function () {
return this._label;
}
IlvMenuItem.prototype.setIcon = function (image) {
if (this._img != image) {
this._img = image;
this.update();
}
}
IlvMenuItem.prototype.getIcon = function () {
return this._img;
}
IlvMenuItem.prototype.setEnabled = function (isEnabled) {
if (this._isEnabled != isEnabled) {
this._isEnabled = isEnabled;
this.update();
}
}
IlvMenuItem.prototype.isEnabled = function () {
return this._isEnabled;
}
IlvMenuItem.prototype.setHighlighted = function (isHighlighted) {
if (this._isHighlighted != isHighlighted) {
this._isHighlighted = isHighlighted;
this.update();
}
}
IlvMenuItem.prototype.isHighlighted = function () {
return this._isHighlighted;
}
IlvMenuItem.prototype.setSize = function (width,height) {
this.superInvoke("setSize",width,height);
this._proxy.setSize(width,height);
this.update();
}
IlvMenuItem.prototype.setLocation = function (left,top) {
this.superInvoke("setLocation",left,top);
this._proxy.setLocation(left,top);
}
IlvMenuItem.prototype.getParent = function () {
return this._parent;
}
IlvMenuItem.prototype.isRoot = function () {
return !this.getParent();
}
IlvMenuItem.prototype.getRoot = function () {
var current = this;
while (!current.isRoot())
current = current.getParent();
return current;
}
IlvMenuItem.prototype.onmouseover = function () {
if (this.getLabel() == "" || this.getLabel() == "-")
return true;
if (this.getParent())
this.getParent().setHighlightedChild(this);
}
IlvMenuItem.prototype.onmouseup = function () {
if (this._action) {
if (typeof(this._action) == 'function')
this._action(this._view,this);
else
eval(this._action);
}
}
IlvMenuItem.prototype.performServerAction = function (actionName, params, updateAll) {
if (this.getRoot() && this.getRoot().popupMenu) {
var popup = this.getRoot().popupMenu;
var fParams = [popup._triggerLeft, popup._triggerTop, this._path];
popup.performServerAction(actionName, fParams.concat(params), updateAll);
}
}
IlvMenuItem.prototype.getStyle = function (width) {
var root = this.getRoot();
var style = "width:"+ (width?width+"px":"auto") + ";";
var styleClass;
if (root.popupMenu) {
if (root.popupMenu.itemStyleClass)
styleClass = root.popupMenu.itemStyleClass;
else
style+="background:#f0eff2;color:black;font-family:sans-serif;font-size:12px;";
if (this._isHighlighted) {
if (root.popupMenu.itemHighlightedStyleClass)
styleClass+= " " + root.popupMenu.itemHighlightedStyleClass;
else {
style += "background-color:#335ea8;color:white;";
}
}
if (!this._isEnabled) {
if (root.popupMenu.itemDisabledStyleClass)
styleClass+= " " + root.popupMenu.itemDisabledStyleClass;
else {
style += "color:#a7a6aa;";
}
}
}
return [style, styleClass];
}
IlvMenuItem.prototype.createHTMLContent = function (width, height) {
if (this._label) {
var cols = (this.setExpanded ? 4 : 3);
if (this._label == "-")
cols -=  2;
var styleArray = this.getStyle(width);
var h = '<table cols='+cols+' border=0 cellpadding=1 cellspacing=0';
if (styleArray[0] != null)
h +=' style="'+styleArray[0]+'"';
if (styleArray[1] != null)
h += ' class="'+styleArray[1]+'"';
h += (width ? ' width="'+width+'"' : '');
h += (height ? ' height="'+height+'"' : '');
h += '>';
h += '<tr>';
var size = 8;
if (this._iconWidth != null)
size = this._iconWidth;
if (this._label != "-") {
h += '<td width="'+size+'">';
if (this._img != null)
h += '<img border="0" src="'+this._img+'"/>';
h += '</td>';
}
h += '<td>';
if (this._label == "-")
h += "<hr/>"
else
h += " "+this._label+" ";
h += '</td>';
if (this._label != "-") {
if (this.setExpanded) {
h += '<td width="20" valign="middle"><div align=right>';
if (this.getRoot().popupMenu.subMenuIcon != null)
h += '<img border="0" src="'+this.getRoot().popupMenu.subMenuIcon+'"/>';
else
h += '&gt;';
h +='</div></td>';
} else
h += '<td width="10"></td>';
}
h += '</tr></table>';
return h;
}
return "";
}
IlvMenuItem.prototype.update = function () {
if (this._label == "")
return;
else if (!this.isVisible()) {
this._needUpdate = true;
return;
}
this._needUpdate = false;
var content = this.createHTMLContent(this.getWidth(), this.getHeight());
this._delegate.setContent(content);
}
IlvMenuItem.prototype.recycle = function () {
this._next = IlvMenuItem._reusable;
IlvMenuItem._reusable = this;
}
function IlvMenu (label, isEnabled, image ,path) {
this.superConstructor(label, isEnabled, null, image, path);
}
IlvMenu.prototype = new IlvMenuItem();
IlvMenu.prototype.setClassName("IlvMenu");
IlvMenu.prototype.createHTMLContainer = function () {
this.superInvoke("createHTMLContainer");
this.createBorders();
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
array[i].createHTMLContainer();
}
}
IlvMenu.prototype.createBorders = function () {
if (!this._border) {
this._border = [];
for (var i = 0; i < 4; i++)
this._border[i] = new IlvDynPanel();
this._border[0].setBackgroundColor("#C0C0C0");
this._border[1].setBackgroundColor("#000000");
this._border[2].setBackgroundColor("#FFFFFF");
this._border[3].setBackgroundColor("#808080");
}
}
IlvMenu.prototype.add = function (menuItem) {
if (!this._child)
this._child = [];
this._child[this._child.length] = menuItem;
menuItem._parent = this;
}
IlvMenu.prototype.getChildrenCount = function () {
return this._child ? this._child.length : 0;
}
IlvMenu.prototype.setVisible = function (isVisible) {
if (this.isRoot())
this._rootVisibility = isVisible;
var isExpanded = this.isExpanded();
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
array[i].setVisible(isVisible && isExpanded);
if (this.isRoot())
this.superInvoke("setVisible",false);
else
this.superInvoke("setVisible",isVisible);
for (i = 0; i < 4; i++)
this._border[i].setVisible(isExpanded && isVisible);
}
IlvMenu.prototype.isVisible = function () {
if (this.isRoot())
return this._rootVisibility;
else
return this.superInvoke("isVisible");
}
IlvMenu.prototype.setLocation = function (left, top) {
this.superInvoke("setLocation",left,top);
var width = (this.isRoot() ? 0 : this.getWidth());
var height = (this.isRoot() ? 0 : this.getHeight());
var b = document.body;
var pageLeft = window.pageXOffset || (b ? b.scrollLeft : 0);
var pageRight = window.innerWidth || (b ? b.clientWidth : 0);
pageRight -= pageLeft;
var pageTop = window.pageYOffset || (b ? b.scrollTop : 0);
var pageBottom = window.innerHeight || (b ? b.clientHeight : 0);
pageBottom -= pageTop;
var cWidth = this.getChildrenWidth();
var cHeight = this.getChildrenHeight();
if (left + width + cWidth > pageRight
&& left - cWidth > pageLeft)
left -= cWidth;
else
left += width;
if (top + cHeight > pageBottom
&& top + height - cHeight > pageTop)
top -= cHeight - height;
var zIndex = this._delegate.getZIndex();
var array = this._child;
var i, itop = top, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
array[i]._delegate.setZIndex(zIndex+2);
array[i]._proxy.setZIndex(zIndex+3);
array[i].setLocation(left,itop);
itop += array[i].getHeight();
}
for (i = 0; i < 4; i++)
this._border[i].setZIndex(zIndex+1);
this._border[0].setBounds(left-2,top-2,cWidth+4,cHeight+4);
this._border[1].setBounds(left-1,top-1,cWidth+3,cHeight+3);
this._border[2].setBounds(left-1,top-1,cWidth+2,cHeight+2);
this._border[3].setBounds(left,top,cWidth+1,cHeight+1);
}
IlvMenu.prototype.getChildren = function () {
var children = [];
var length = this.getChildrenCount();
for(var i=0; i<length; i++) {
children[i] = this._child[i];
}
return children;
}
IlvMenu.prototype.getChild = function (index) {
return this._child.length > index ? this._child[index] : null;
}
IlvMenu.prototype.getChildrenWidth = function () {
this.computeChildrenSize();
var width = 0;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var childW = array[i].getWidth();
if (width < childW)
width = childW;
}
return width;
}
IlvMenu.prototype.getChildrenHeight = function () {
this.computeChildrenSize();
var height = 0;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
height += array[i].getHeight() || 0;
return height;
}
IlvMenu.prototype.setHighlighted = function (isHighlighted) {
this.superInvoke("setHighlighted",isHighlighted);
this.setExpanded(isHighlighted);
}
IlvMenu.prototype.isExpanded = function () {
if (this.isRoot())
return true;
return this._isExpanded;
}
IlvMenu.prototype.setExpanded = function (isExpanded) {
if (isExpanded == this._isExpanded)
return;
if (isExpanded) {
var current = this;
while (current) {
current._isExpanded = true;
current = current.getParent();
}
var root = this.getRoot();
root.setVisible(root.isVisible());
} else {
this.collapse();
this.setVisible(this.isVisible());
}
}
IlvMenu.prototype.onmouseover = function () {
this.superInvoke("onmouseover");
this.setHighlightedChild(null);
}
IlvMenu.prototype.computeChildrenSize = function () {
if (this._child._sizeComputed)
return;
var width = 0;
var height = new Array();
var iconWidth = 0;
var array = this._child;
var i, itop = top, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var s;
s = this._child[i].getIconPreferredSize();
if (iconWidth < s.width) iconWidth = s.width;
}
for (i = 0; i < imax; i++) {
this._child[i]._iconWidth = iconWidth;
var s = this._child[i].getPreferredSize();
if (width < s.width) width = s.width;
height[i] = s.height;
}
for (i = 0; i < imax; i++) {
this._child[i].setSize(width,height[i]);
}
this._child._sizeComputed = true;
}
IlvMenu.prototype.setHighlightedChild = function (child) {
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
array[i].setHighlighted(child == array[i]);
}
IlvMenu.prototype.collapse = function () {
if (!this._isExpanded)
return;
this._isExpanded = false;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var menu = array[i];
if (menu._isExpanded)
menu.collapse();
}
}
IlvMenu.prototype.recycle = function () {
var array = this._child;
var i, imax = (array ? array.length : 0);
for (i = 0; i < imax; i++)
array[i].recycle();
this._next = IlvMenu._reusable;
IlvMenu._reusable = this;
}
