/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvButton(left, top, width, height, image, action)
{
if (!window.IlvImageView)
alert("IlvButton requires IlvImageView");
this.superConstructor(left, top, width, height);
this.imageView = new IlvImageEventView(left, top, width, height, image);
this.imageView.setBlendTransform(false);
this.imageView.setEventHandler(this);
this.selected = false;
this.rollover = false;
this.imageSrc = image;
if (image) {
this.image = new Image();
this.image.src = image;
}
this.rolloverImageSrc = null;
this.selectedImageSrc = null;
this.setAction(action)
this.infoPanel = IlvButton.defaultMessagePanel;
this.message = '';
this.isToggle = false;
this.registerDispose();
this.enabled = true;
}
if (!window.IlvEmptyView)
alert("IlvButton requires IlvEmptyView");
IlvButton.prototype = new IlvEmptyView();
IlvButton.prototype.setClassName("IlvButton")
IlvButton.defaultMessagePanel = null;
IlvButton.prototype.getWidth = function() {
return this.imageView.getWidth();
}
IlvButton.prototype.getHeight = function() {
return this.imageView.getHeight();
}
IlvButton.prototype.dispose = function() {
this.superInvoke("dispose");
this.action = null;
this.infoPanel = null;
if (this.image) {
disposeImageSource(this.image);
this.image = null;
}
if (this.rolloverImage) {
disposeImageSource(this.rolloverImage);
this.rolloverImage = null;
}
if (this.selectedImage) {
disposeImageSource(this.selectedImage);
this.selectedImage = null;
}
}
IlvButton.prototype.removeHTML = function () {
this.imageView.removeHTML();
}
IlvButton.prototype.updateVisibility = function (){
this.imageView.updateVisibility();
}
IlvButton.prototype.getAction = function()
{
return this.action;
}
IlvButton.prototype.setAction = function(action)
{
if (typeof(action) == "function" || typeof(action) == "string" )
this.action = action;
else if (typeof(action) != "undefined")
alert("The action parameter must be a function or a string");
}
IlvButton.prototype.getMessagePanel = function() {
return this.infoPanel;
}
IlvButton.prototype.setMessagePanel = function(ilvHTMLPanel) {
this.infoPanel = ilvHTMLPanel;
}
IlvButton.prototype.getMessage = function() {
return this.message;
}
IlvButton.prototype.setMessage = function(message) {
this.message = message;
}
IlvButton.prototype.getToolTipText = function() {
return this.imageView.getToolTipText();
}
IlvButton.prototype.setToolTipText = function(string) {
this.imageView.setToolTipText(string);
}
IlvButton.prototype.getCursor = function() {
return this.imageView.getCursor();
}
IlvButton.prototype.setCursor = function(cursor) {
this.imageView.setCursor(cursor);
}
IlvButton.prototype.isEnabled = function () {
return this.enabled;
}
IlvButton.prototype.setEnabled = function (enabled) {
if (this.selected && !enabled) {
this.setSelected(false);
}
this.enabled = enabled;
this.updateCurrentImage();
}
IlvButton.prototype.isSelected = function () {
return this.selected;
}
IlvButton.prototype.setSelected = function (selected) {
if (this.enabled) {
this.selected = selected;
this.updateCurrentImage();
}
}
IlvButton.prototype.isToggleButton = function () {
return this.isToggle;
}
IlvButton.prototype.setToggleButton = function (set) {
this.isToggle = set;
}
IlvButton.prototype.getImage = function()
{
return this.imageSrc;
}
IlvButton.prototype.setImage = function(image)
{
if (this.image) {
disposeImageSource(this.image);
this.image = null;
}
this.imageSrc = image;
if (image)  {
this.image = new Image();
this.image.src = image;
}
this.updateCurrentImage();
}
IlvButton.prototype.getRolloverImage = function()
{
return this.rolloverImageSrc;
}
IlvButton.prototype.setRolloverImage = function(image)
{
if (this.rolloverImage) {
disposeImageSource(this.rolloverImage);
this.rolloverImage = null;
}
this.rolloverImageSrc = image;
if (image)  {
this.rolloverImage = new Image();
this.rolloverImage.src = image;
}
this.updateCurrentImage();
}
IlvButton.prototype.getSelectedImage = function()
{
return this.selectedImageSrc;
}
IlvButton.prototype.setSelectedImage = function(image)
{
if (this.selectedImage) {
disposeImageSource(this.selectedImage);
this.selectedImage = null;
}
this.selectedImageSrc = image;
if (image)  {
this.selectedImage = new Image();
this.selectedImage.src = image;
}
this.updateCurrentImage();
}
IlvButton.prototype.updateCurrentImage = function() {
var image = this.imageSrc;
if (this.selected && this.selectedImageSrc)
image = this.selectedImageSrc;
else if (this.rollover && this.rolloverImageSrc)
image = this.rolloverImageSrc;
this.imageView.setImage(image);
if (this.imageView.inHTML) {
if (this.enabled) {
this.imageView.imagePanel.setOpacity(1);
} else {
this.imageView.imagePanel.setOpacity(0.4);
}
}
}
IlvButton.prototype.setChildrenBounds = function(left, top, width, height) {
this.imageView.setBounds(left, top, width, height);
}
IlvButton.prototype.childrenToHTML = function() {
this.imageView.toHTML();
if (this.enabled) {
this.imageView.imagePanel.setOpacity(1);
} else {
this.imageView.imagePanel.setOpacity(0.4);
}
}
IlvButton.prototype.doAction = function() {
if (this.enabled) {
if (typeof(this.action) == 'function')
this.action();
else
eval(this.action);
}
}
IlvButton.prototype.doClick = function() {
if (this.enabled) {
var toggle = this.isToggleButton();
if (toggle)
this.setSelected(!this.isSelected());
else
this.setSelected(true);
this.doAction();
if (!toggle)
this.setSelected(false);
}
}
IlvButton.prototype.mouseDown = function(e) {
if (this.enabled && e.button != 2) {
var toggle = this.isToggleButton();
if (toggle)
this.setSelected(!this.isSelected());
else
this.setSelected(true);
this.doAction();
}
}
IlvButton.prototype.mouseUp = function(e)
{
if (this.enabled) {
if (!this.isToggleButton())
this.setSelected(false);
}
}
IlvButton.prototype.mouseOver = function(e) {
this.rollover = true;
if (this.enabled) {
this.updateCurrentImage();
}
if (this.message != '')
window.status = this.message;
else
window.status = '';
if (this.infoPanel) {
if (IlvPanel.prototype.isIE && document.readyState != 'complete')
return;
this.infoPanel.setContent(this.message);
}
}
IlvButton.prototype.mouseOut = function(e) {
this.rollover = false;
if (this.enabled) {
this.updateCurrentImage();
}
window.status = '';
if (this.infoPanel) {
if (IlvPanel.prototype.isIE && document.readyState != 'complete')
return true;
this.infoPanel.setContent('');
}
}
