/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvResizableView(left, top, width, height, namespace) {
if (!window.IlvEmptyView)
alert("IlvResizableView requires IlvEmptyView");
this.superConstructor(left, top, width, height, namespace);
this.minimumHeight = 100;
this.minimumWidth = 100;
this.maximumWidth = 1024;
this.maximumHeight = 600;
this.resizable = false;
}
IlvResizableView.prototype = new IlvEmptyView;
IlvResizableView.prototype.setClassName("IlvResizableView");
IlvResizableView.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
if (this.resizeTool)
this.resizeTool.removeHTML();
}
IlvResizableView.prototype.updateVisibility = function () {
this.superInvoke("updateVisibility");
if (this.resizeTool)
this.resizeTool.updateVisibility();
}
IlvResizableView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
if (this.resizeTool)
this.resizeTool.setBounds(left, top, width, height);
}
IlvResizableView.prototype.setResizable = function(set) {
this.resizable = set;
if (this.resizeTool)
this.resizeTool.setVisible(set);
}
IlvResizableView.prototype.isResizable = function(set) {
return this.resizable;
}
IlvResizableView.prototype.isResizeable = IlvResizableView.prototype.isResizable;
IlvResizableView.prototype.setResizeable = IlvResizableView.prototype.setResizable;
IlvResizableView.prototype.setMaximumSize = function(width, height) {
this.maximumWidth = width;
this.maximumHeight = height;
}
IlvResizableView.prototype.getMaximumSize = function() {
var size = new Object;
size.width =  this.maximumWidth;
size.height = this.maximumHeight;
return size;
}
IlvResizableView.prototype.setMinimumSize = function(width, height) {
this.minimumWidth = width;
this.minimumHeight = height;
}
IlvResizableView.prototype.getMinimumSize = function() {
var size = new Object;
size.width =  this.minimumWidth;
size.height = this.minimumHeight;
return size;
}
IlvResizableView.prototype.toHTML = function() {
this.superInvoke("toHTML");
this.resizeTool = new IlvResizeTool(this);
this.resizeTool.toHTML();
this.resizeTool.setVisible(this.resizable);
}
function IlvResizeTool(view) {
this.superConstructor();
this.view = view;
this.color = '#808080';
this.lineWidth = 2;
this.inHTML = false;
this.registerDispose();
}
IlvResizeTool.prototype = new IlvObject;
IlvResizeTool.prototype.setClassName("IlvResizeTool");
IlvResizeTool.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
if (this.corner)
this.corner.removeHTML();
if (this.rect)
this.rect.removeHTML();
}
IlvResizeTool.prototype.updateVisibility = function () {
this.superInvoke("updateVisibility");
if (this.corner)
this.corner.updateVisibility();
if (this.rect)
this.rect.updateVisibility();
}
IlvResizeTool.prototype.dispose = function() {
this.superInvoke("dispose");
if (this.corner) {
this.corner.resizeTool = null;
this.corner = null;
}
this.view = null;
}
IlvResizeTool.prototype.setVisible = function(visible) {
if (this.corner)
this.corner.setVisible(visible);
}
IlvResizeTool.prototype.toHTML = function() {
if (this.inHTML)
return;
var view = this.view;
var x = view.left;
var y = view.top;
var w = view.width;
var h = view.height;
this.rect = new IlvRectangle();
this.rect.setColor(this.color);
this.rect.setThickness(this.lineWidth);
this.corner = new IlvGlassView(x + w - 20, y + h - 20, 20, 20);
var corner = this.corner;
corner.resizeTool = this;
corner.setContent('<img width="' + corner.getWidth() +
'" height="' + corner.getHeight() +
'" src="' + ilvImagePath + 'resize-corner.gif">');
corner.getEventOriginLeft = function() {
return this.resizeTool.view.getLeft();
}
corner.getEventOriginTop = function() {
return this.resizeTool.view.getTop();
}
corner.setEventHandler(this);
corner.setCursor("se-resize");
corner.toHTML();
this.inHTML = true;
}
IlvResizeTool.prototype.setBounds = function(x, y, w, h) {
this.corner.setBounds(x + w - 20, y + h - 20, 20, 20);
}
IlvResizeTool.prototype.startResize = function(e) {
this.dragging = true;
var view = this.view;
this.offsetX = view.getWidth() - e.mouseX;
this.offsetY = view.getHeight() - e.mouseY;
this.duringResize(e);
this.rect.setVisible(true);
}
IlvResizeTool.prototype.duringResize = function(e) {
if (!this.dragging)
return;
var view = this.view;
var width  = e.mouseX + this.offsetX;
var height = e.mouseY + this.offsetY;
var mini = view.getMinimumSize();
var maxi = view.getMaximumSize();
width  = Math.max(mini.width, width);
height = Math.max(mini.height, height);
width  = Math.min(width, maxi.width);
height = Math.min(height, maxi.height);
this.rect.setBounds(view.left, view.top, width, height);
var corner = this.corner;
corner.setLocation(width  + view.left - corner.getWidth(),
height + view.top  - corner.getHeight());
}
IlvResizeTool.prototype.stopResize = function(e) {
var view = this.view;
var width  = e.mouseX + this.offsetX;
var height = e.mouseY + this.offsetY;
var mini = view.getMinimumSize();
var maxi = view.getMaximumSize();
width  = Math.max(mini.width, width);
height = Math.max(mini.height, height);
width  = Math.min(width, maxi.width);
height = Math.min(height, maxi.height);
view.resizeTool = null;
view.setBounds(view.left, view.top, width, height);
view.resizeTool = this;
this.rect.setVisible(false);
var corner = this.corner;
corner.setLocation(width  + view.left - corner.getWidth(),
height + view.top  - corner.getHeight());
this.dragging = false;
}
IlvResizeTool.prototype.mouseDown = function(e) {
if (this.dragging)
this.stopResize(e);
else
this.startResize(e);
}
IlvResizeTool.prototype.mouseDrag = function(e) {
this.duringResize(e);
}
IlvResizeTool.prototype.mouseUp = function(e) {
if (this.dragging)
this.stopResize(e);
}
