/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvMapRectInteractor(actionName) {
this.superConstructor();
this.setActionName(actionName);
var inter = this;
this.addRectangleDraggedListener(function(event) {inter.onEndDrag(event);});
}
IlvMapRectInteractor.prototype = new IlvDragRectangleInteractor;
IlvMapRectInteractor.prototype.setClassName("IlvMapRectInteractor");
IlvMapRectInteractor.prototype.getActionName = function() {
return this.action;
}
IlvMapRectInteractor.prototype.setActionName = function(actionName) {
return this.action = actionName;
}
IlvMapRectInteractor.prototype.onEndDrag = function(event) {
if (this.getActionName()) {
var view = this.view;
var bbox = view.getViewBBox();
var s1 = bbox.width/view.getWidth();
var s2 = bbox.height/view.getHeight();
var x = bbox.left + event.left*s1;
var y = bbox.top + event.top*s2;
var w = event.width*s1;
var h = event.height*s2;
var params = new Array();
params[0] = x;
params[1] = y;
params[2] = w;
params[3] = h;
params[4] = event.corner;
view.performAction(this.getActionName(), params);
}
}
