/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function IlvPanInteractor() {
this.superConstructor();
this.setCursor('move');
this.setMessage('Click on map to pan the view');
this.duringpan = false;
this.startx = 0;
this.starty = 0;
this.x = 0;
this.y = 0;
this.panTimer = null;
this.taskTimer = null;
this.tiledView = false;
var inter = this;
this.needRefreshLayer = false;
var inter = this;
this.beforeImageloadedListener = function(view)
{ inter.onBeforeImageLoaded(view);};
this.imageloadedListener = function(view)
{ inter.onImageLoaded(view);};
}
IlvPanInteractor.prototype = new IlvInteractor;
IlvPanInteractor.prototype.setClassName("IlvPanInteractor");
IlvPanInteractor.instances = new Object;
IlvPanInteractor.prototype.setView = function(view) {
if (this.view != null) {
IlvPanInteractor.instances[this.view] = null;
this.view.removeBeforeImageOnLoadListener(this.beforeImageloadedListener);
this.view.removeImageOnLoadListener(this.imageloadedListener);
}
if (view != null) {
this.tiledView = view.isTiled();
IlvPanInteractor.instances[view] = this;
view.addBeforeImageOnLoadListener(this.beforeImageloadedListener);
view.addImageOnLoadListener(this.imageloadedListener);
}
}
IlvPanInteractor.prototype.onmousedown = function(e) {
if (this.tiledView) {
if (!this.duringpan) {
this.bx = -this.view.qbboxx;
this.by = -this.view.qbboxy;
this.startx = this.x = (e.mouseX / -this.view.sx + this.bx) - this.view.qbboxx;
this.starty = this.y = (e.mouseY / -this.view.sy + this.by) - this.view.qbboxy;
this.view.getDynamicLayer().setVisible(false);
this.view.getDynamicLayer().setPanning(true);
this.view.getDynamicLayer().cancelUpdateTimer();
if (window.IlvSelectionManager)
this.view.getSelectionManager().hideAll();
this.duringpan = true;
if (this.taskTimer)
clearInterval(this.taskTimer);
this.taskTimer = setInterval(
'IlvPanInteractor.instances["' + this.view.toString() + '"].processUpdate(true)',
50);
this.pan();
}
} else {
if (this.needRefreshLayer)
return false;
if (!this.duringpan) {
this.startx = e.mouseX;
this.starty = e.mouseY;
this.duringpan = true;
} else
this.onmouseup(e);
}
return false;
}
IlvPanInteractor.prototype.onmousemove = function(e) {
if (this.tiledView) {
if (!this.duringpan)
return false;
this.x = (e.mouseX / -this.view.sx + this.bx);
this.y = (e.mouseY / -this.view.sy + this.by);
} else {
if (!this.duringpan || this.needRefreshLayer)
return false;
var view = this.view;
var dx = this.startx - e.mouseX;
var dy = this.starty - e.mouseY;
view.imagePanel.setScrollPosition(dx, dy);
}
return false;
}
IlvPanInteractor.prototype.onmouseup = function(e) {
if (this.tiledView) {
if (!this.duringpan)
return false;
this.x = (e.mouseX / -this.view.sx + this.bx);
this.y = (e.mouseY / -this.view.sy + this.by);
this.duringpan = false;
if (this.taskTimer)
clearInterval(this.taskTimer);
this.cancelPan();
} else {
if (!this.duringpan || this.needRefreshLayer)
return false;
var view = this.view;
var x = e.mouseX;
var y = e.mouseY;
var dx = x - this.startx;
var dy = y - this.starty;
this.needRefreshLayer = true;
var bbox = view.getViewBBox();
view.moveTo(bbox.left - dx*bbox.width/view.getWidth(),
bbox.top - dy*bbox.height/view.getHeight());
this.duringpan = false;
}
return false;
}
IlvPanInteractor.prototype.onBeforeImageLoaded = function(view) {
if (!this.tiledView && this.needRefreshLayer) {
view.imagePanel.setVisible(false);
view.imagePanel.setScrollPosition(0, 0);
}
}
IlvPanInteractor.prototype.onImageLoaded = function(view) {
if (!this.tiledView && this.needRefreshLayer) {
this.needRefreshLayer = false;
}
}
IlvPanInteractor.prototype.pan = function() {
if (this.panTimer)
clearTimeout(this.panTimer);
var dx = this.x - this.startx;
var dy = this.y - this.starty;
if (this.x != this.startx || this.y != this.starty) {
this.view.moveTo(dx, dy, true);
this.view.getDynamicLayer().setVisible(false);
}
var panInteractor = this
this.panTimer = setTimeout(function(){panInteractor.pan();}, 50);
}
IlvPanInteractor.prototype.cancelPan = function() {
if (this.panTimer)
clearTimeout(this.panTimer);
this.view.getDynamicLayer().setPanning(false);
this.processUpdate(false);
}
IlvPanInteractor.prototype.processUpdate = function(noUpdate) {
this.view.update(noUpdate, true);
}
IlvPanInteractor.prototype.mouseWheel = function(e) {
if (e.wheelDelta > 0) {
this.view.zoomIn();
} else {
this.view.zoomOut();
}
}
