/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvPopupMenuFactory () {
this.superConstructor();
}
$ns$IlvPopupMenuFactory.prototype = new $ns$IlvObject();
$ns$IlvPopupMenuFactory.prototype.setClassName("$ns$IlvPopupMenuFactory");
$ns$IlvPopupMenuFactory.prototype.displayPopupMenu = function (view,event,modelId) {
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
var request = this.popupMenu.createRequestURL(view, event, modelId);
if (!request)
return;
this.onload();
var onload = "'"+this.toString()+"'";
if (document.layers) {
request+="&onload="+onload;
} else {
request+="&onload="+onload+"&parent=true";
}
this._view = view;
if (!$ns$IlvPopupMenuFactory._loader)
$ns$IlvPopupMenuFactory._loader = new $ns$IlvDynPanel();
$ns$IlvPopupMenuFactory._loader.setURL(request);
return false;
}
$ns$IlvPopupMenuFactory.prototype.create = function (data) {
var array = data.menu;
if (!array)
return null;
menu = this.read(array);
menu.popupMenu = this.popupMenu;
menu.popupMenu._triggerLeft = data.left;
menu.popupMenu._triggerTop = data.top;
return menu;
}
$ns$IlvPopupMenuFactory.prototype.getRequestType = function () {
return this._requestType || "popupmenurequested";
}
$ns$IlvPopupMenuFactory.prototype.setRequestType = function (requestType) {
this._requestType = requestType;
}
$ns$IlvPopupMenuFactory.prototype.read = function (array) {
var type = array[0];
if (type == "Menu") {
var menu = this.readMenu(array);
var width = 0, height = 0;
var i, imax = array.length;
for (i = 4; i < imax; i++)
menu.add(this.read(array[i]));
return menu;
} else if (type == "MenuItem") {
var item = this.readMenuItem(array);
item._view = this._view;
return item;
} else
alert("Don't know how to read menu of type "
+ type + ", send by the server.");
return null;
}
$ns$IlvPopupMenuFactory.prototype.readAction = function (item, array) {
var type = array[0];
if (type == "JS") {
item.setAction(function(viewObj, itemObj){eval(array[1]);});
} else if (type == "Servlet") {
var actionName = array[1];
var updateAll = array[2];
var params =  array.slice(3);
item.setAction(function(){item.performServerAction(actionName,params,updateAll);});
}
}
$ns$IlvPopupMenuFactory.prototype.onload = function (factory) {
if (factory && $ns$IlvPopupMenuFactory._factories) {
var f = $ns$IlvPopupMenuFactory._factories[factory];
f.asyncDisplayPopupMenu($ns$IlvPopupMenuFactory._loader.getContext());
} else {
if (!$ns$IlvPopupMenuFactory._factories)
$ns$IlvPopupMenuFactory._factories = new Array();
$ns$IlvPopupMenuFactory._factories[this.toString()] = this;
}
}
$ns$IlvPopupMenuFactory.prototype.asyncDisplayPopupMenu = function (data) {
var view = this._view;
var viewLoc = view.getLocation();
var res = this.popupMenu.imageToPageCoordinateSystem(view, data.left, data.top);
this.popupMenu.hidePopupMenu();
var menu = this.create(data);
this.popupMenu.internalDisplayPopupMenu(res.x, res.y ,menu);
}
$ns$IlvPopupMenuFactory.prototype.readMenu = function (array, path) {
var menu;
if (!$ns$IlvMenu._reusable) {
menu = new $ns$IlvMenu(array[1],array[2]);
} else {
var menu = $ns$IlvMenu._reusable;
$ns$IlvMenu._reusable = menu._next;
menu._next = null;
menu._child = new Array();
menu._parent = null;
menu._isExpanded = false;
menu._isHighlighted = false;
menu._action = null;
menu.setLabel(array[1]);
menu.setEnabled(array[2]);
}
var image = array[3];
if (image != null && image != "no")
menu._img = image;
return menu;
}
$ns$IlvPopupMenuFactory.prototype.readMenuItem = function (array) {
if (!$ns$IlvMenuItem._reusable) {
var item = new $ns$IlvMenuItem(array[1],array[3]);
this.readAction(item, array[2]);
if (array[4] != "no")
item._img = array[4];
item._path = array[5];
return item;
} else {
var item = $ns$IlvMenuItem._reusable;
$ns$IlvMenuItem._reusable = item._next;
item._next = null;
item._isHighlighted = false;
item._img = null;
item._action = null;
item.setLabel(array[1]);
item.setEnabled(array[3]);
if (array[4] != "no")
item._img = array[4];
item._path = array[5];
this.readAction(item, array[2]);
return item;
}
}
function $ns$IlvAbstractPopupMenu(init) {
if (init) {
this.superConstructor();
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
if (document.body.addEventListener) {
document.body.addEventListener("contextmenu", $ns$IlvAbstractPopupMenu.onContextMenuHandler, false);
} else {
document.oncontextmenu = function () {
var res = $ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if (!res) {
window.event.cancelBubble = true;
window.event.returnValue = res;
}
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
return res;
};
}
this.dynamic = true;
this.factory = new $ns$IlvPopupMenuFactory();
this.factory.popupMenu = this;
this.subMenuIcon = $ns$ilvImagePath + "sub.gif";
}
}
$ns$IlvAbstractPopupMenu.prototype = new $ns$IlvObject();
$ns$IlvAbstractPopupMenu.prototype.setClassName("$ns$IlvAbstractPopupMenu");
$ns$IlvAbstractPopupMenu.onblur = function () {
var m = $ns$IlvAbstractPopupMenu._openMenu;
if (m && m.popupMenu){
m.popupMenu.hidePopupMenu();
}
}
$ns$IlvAbstractPopupMenu.onContextMenuHandler = function (event) {
var res = $ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu;
if (!res){
event.preventDefault();
}
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
return res;
}
$ns$IlvAbstractPopupMenu.onContextMenuHandler2 = function (event) {
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
}
$ns$IlvAbstractPopupMenu.prototype.createIEEventPanel = function () {
if ($ns$IlvBrowserInfo.instance.ie5up && !this.eventPanel) {
this.eventPanel = new $ns$IlvDynPanel();
this.eventPanel.setLocation(0,0);
this.eventPanel._div.style.width = "100%";
this.eventPanel._div.style.height = "100%";
this.eventPanel.setZIndex(9);
var p = this.eventPanel;
var popup = this;
this.eventPanel.getMouseEventSource().onmouseup =  function (event) {
popup.hidePopupMenu();
if ($ns$IlvBrowserInfo.instance.ie5up) {
var v = popup._view;
var event = v.eventPanel.enhanceEvent();
var x = event.mouseX;
var y = event.mouseY;
var inView = (x<0||x>v.getWidth()||y<0||y>v.getHeight());
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = inView;
}
};
}
}
$ns$IlvAbstractPopupMenu.prototype.displayPopupMenu = function (view,event,modelId) {
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (event.stopPropagation) {
event.stopPropagation();
}
this._view = view;
if (!this.isPopupTrigger(event)) {
return true;
}
this._triggerLeft = event.mouseX;
this._triggerTop = event.mouseY;
if (this.dynamic) {
return this.factory.displayPopupMenu(view, event, modelId);
} else {
var x = event.mouseX;
var y = event.mouseY;
var res = this.imageToPageCoordinateSystem(view, x, y);
this.hidePopupMenu();
this.internalDisplayPopupMenu(res.x, res.y, this.menu);
}
}
$ns$IlvAbstractPopupMenu.prototype.internalResetEvent = function () {
$ns$IlvAbstractPopupMenu._documentOnMouseUp = document.onmouseup;
}
$ns$IlvAbstractPopupMenu.prototype.imageToPageCoordinateSystem = function (view, x, y) {
var viewLoc = view.getLocation();
return {x : x + viewLoc.left, y: y + viewLoc.top};
}
$ns$IlvAbstractPopupMenu.prototype.internalDisplayPopupMenu = function (x, y, menu) {
var view = this._view;
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (menu && menu.getChildrenCount() > 0) {
menu.createHTMLContainer();
menu._delegate.setZIndex(10);
menu.setLocation(x, y);
menu.setVisible(true);
$ns$IlvAbstractPopupMenu._openMenu = menu;
if ($ns$IlvBrowserInfo.instance.ie5up) {
this.createIEEventPanel();
this.eventPanel.setVisible(true);
this._onscroll = document.body.onscroll;
var panel = this.eventPanel;
document.body.onscroll = function() {
var doc = document;
var de = doc.documentElement.clientWidth?doc.documentElement:doc.body;
panel.setLocation(0, de.scrollTop);
}
} else {
$ns$IlvAbstractPopupMenu._documentOnMouseUp = document.onmouseup;
var popup = this;
document.onmouseup = function (event) {
popup.hidePopupMenu();
};
}
}
}
$ns$IlvAbstractPopupMenu.prototype.createRequestURL = function (view,event,modelId) {
}
$ns$IlvAbstractPopupMenu.prototype.hidePopupMenu = function () {
if ($ns$IlvAbstractPopupMenu._openMenu) {
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = true;
if ($ns$IlvBrowserInfo.instance.ie5up) {
this.eventPanel.setVisible(false);
if (this._onscroll) {
document.body.onscroll = this._onscroll;
this._onscroll = null;
}
}
if ($ns$IlvAbstractPopupMenu._documentOnMouseUp)
document.onmouseup = $ns$IlvAbstractPopupMenu._documentOnMouseUp;
else
document.onmouseup = null;
$ns$IlvAbstractPopupMenu._openMenu.setVisible(false);
if (this.dynamic) {
$ns$IlvAbstractPopupMenu._openMenu.recycle();
} else {
this.deselectAll($ns$IlvAbstractPopupMenu._openMenu);
}
$ns$IlvAbstractPopupMenu._openMenu = null;
return true;
} else
return false;
}
$ns$IlvAbstractPopupMenu.prototype.performServerAction = function (actionName, params, updateAll) {
var view = this.view;
if (view != null && actionName != null) {
view.performAction(actionName, params, updateAll);
}
}
$ns$IlvAbstractPopupMenu.prototype.deselectAll = function(menu){
menu.setHighlighted(false);
for (var i=0; i<menu._child.length; i++) {
menu._child[i].setHighlighted(false);
if (menu._child[i].setExpanded)
this.deselectAll(menu._child[i]);
}
}
$ns$IlvAbstractPopupMenu.prototype.setViewInternal = function(view){
var src;
if (this.view) {
if (document.addEventListener) {
src = this.view.eventPanel.getMouseEventSource();
src.removeEventListener("contextmenu", $ns$IlvAbstractPopupMenu.onContextMenuHandler2, false);
}
}
this.view = view;
if (view) {
src = view.eventPanel.getMouseEventSource();
if (document.addEventListener) {
if (src) {
src.addEventListener("contextmenu", $ns$IlvAbstractPopupMenu.onContextMenuHandler2, false);
} else {
var l = function (view) {
var src = view.eventPanel.getMouseEventSource();
src.addEventListener("contextmenu", $ns$IlvAbstractPopupMenu.onContextMenuHandler2, false);
if (view.removeCapabilitiesOnLoadListener) {
view.removeCapabilitiesOnLoadListener(l);
} else if (view.removeCapabilitiesLoadListener){
view.removeCapabilitiesLoadListener(l);
}
};
if (view.addCapabilitiesOnLoadListener) {
view.addCapabilitiesOnLoadListener(l);
} else if (view.addCapabilitiesLoadListener){
view.addCapabilitiesLoadListener(l);
}
}
}
}
}
$ns$IlvAbstractPopupMenu.prototype.setMenu = function(menu){
if (this.menu != null)
menu.popupMenu = null;
this.menu = menu;
if (menu != null) {
this.setDynamic(false);
menu.popupMenu = this;
} else {
this.setDynamic(true);
}
}
$ns$IlvAbstractPopupMenu.prototype.getMenu = function(){
return this.menu;
}
$ns$IlvAbstractPopupMenu.prototype.setDynamic = function (dynamic) {
this.dynamic = dynamic;
}
$ns$IlvAbstractPopupMenu.prototype.isDynamic = function () {
return this.dynamic;
}
$ns$IlvAbstractPopupMenu.prototype.getItemStyleClass = function () {
return this.itemStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.setItemStyleClass = function (itemStyleClass){
this.itemStyleClass = itemStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.getItemHighlightedStyleClass = function (){
return this.itemHighlightedStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.setItemHighlightedStyleClass = function (itemHighlightedStyleClass){
this.itemHighlightedStyleClass = itemHighlightedStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.getItemDisabledStyleClass = function (){
return this.itemDisabledStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.setItemDisabledStyleClass = function (itemDisabledStyleClass){
this.itemDisabledStyleClass = itemDisabledStyleClass;
}
$ns$IlvAbstractPopupMenu.prototype.getSubMenuIcon = function (){
return this.subMenuIcon;
}
$ns$IlvAbstractPopupMenu.prototype.setSubmenuIcon = function (subMenuIcon){
this.subMenuIcon = subMenuIcon;
}
$ns$IlvAbstractPopupMenu.prototype.isPopupTrigger = function (event) {
return event.button == 2;
}
function $ns$IlvMenuItem (label, isEnabled, action, image, path) {
if (typeof(label) == "undefined")
return;
this.superConstructor();
if (typeof(isEnabled) == "undefined")
this._isEnabled = true;
else
this._isEnabled = isEnabled;
this._label = label;
if (action != null)
this.setAction(action);
this._img = image;
if (path != null) {
this._path = path;
}
}
$ns$IlvMenuItem.prototype = new $ns$IlvPanel();
$ns$IlvMenuItem.prototype.setClassName("$ns$IlvMenuItem");
$ns$IlvMenuItem.prototype.createHTMLContainer = function () {
if (!this._delegate) {
this._delegate = new $ns$IlvDynPanel();
this._div = this._delegate._div;
this._div.style.width = "auto";
this._layer = this._delegate._layer;
this._proxy = new $ns$IlvDynPanel();
var item = this;
var eventSource = this._proxy.getMouseEventSource();
if (eventSource.addEventListener) {
eventSource.addEventListener("mouseover", function(){item.onmouseover();}, false);
eventSource.addEventListener("mouseup", function() {item.mouseUpHandler();}, false);
} else {
eventSource.onmouseover = function () {
item.onmouseover();
};
eventSource.onmouseup = function () {
item.mouseUpHandler();
};
}
}
}
$ns$IlvMenuItem.prototype.mouseUpHandler = function() {
$ns$IlvAbstractPopupMenu.prototype.showAgentContextualMenu = false;
if (this.getLabel() == "" || this.getLabel() == "-" || !this.isEnabled() || this.setExpanded ) {
return true;
}
var root = this.getRoot();
root.setVisible(false);
if ($ns$IlvBrowserInfo.instance.ie5up) {
root.popupMenu.eventPanel.setVisible(false);
}
this.onmouseup();
}
$ns$IlvMenuItem.prototype.setAction = function (action) {
if (typeof(action) == "function" || typeof(action) == "string" )
this._action = action;
else if (typeof(action) != "undefined")
alert("The action parameter must be a function or a string");
}
$ns$IlvMenuItem.prototype.getAction = function () {
return this._action;
}
$ns$IlvMenuItem.prototype.getIconPreferredSize = function () {
if (document.all || $ns$IlvBrowserInfo.instance.nav6up)  {
if (this._img == null) {
return {width:8, height:0};
}
if (!$ns$IlvMenuItem._span) {
var span = document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
$ns$IlvMenuItem._span = span;
}
var span = $ns$IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML = "<img border='0' src="+this.getIcon()+"/>";
return {width: span.clientWidth, height: span.clientHeight};
}
if (!this._defaultIconSize) {
this._defaultIconSize = { width: 20, height: 20 };
}
return this._defaultIconSize;
}
$ns$IlvMenuItem.prototype.setPreferredIconSize = function (width,height) {
if (!this._defaultIconSize)
this._defaultIconSize = new Object();
this._defaultIconSize.width = width;
this._defaultIconSize.height = height;
}
$ns$IlvMenuItem.prototype.getPreferredSize = function () {
if (this._label && (document.all || $ns$IlvBrowserInfo.instance.nav6up))  {
if (!$ns$IlvMenuItem._span) {
var span = document.createElement("span");
document.body.appendChild(span);
span.style.position="absolute";
span.style.visibility="hidden";
span.style.left="0px";
span.style.top="0px";
$ns$IlvMenuItem._span = span;
}
var span = $ns$IlvMenuItem._span;
this.setSize(0,0);
span.innerHTML = this.createHTMLContent(0);
var size = new Object();
if (this._label == "-")
size.width = 0;
else
size.width = span.clientWidth;
size.height = span.clientHeight;
return size;
}
if (!this._defaultSize) {
this._defaultSize = {width:200, height:20};
}
return this._defaultSize;
}
$ns$IlvMenuItem.prototype.setPreferredSize = function (width,height) {
if (!this._defaultSize)
this._defaultSize = new Object();
this._defaultSize.width = width;
this._defaultSize.height = height;
}
$ns$IlvMenuItem.prototype.setVisible = function (isVisible) {
this.superInvoke("setVisible",isVisible);
this._proxy.setVisible(isVisible);
if (isVisible) {
this.update();
}
}
$ns$IlvMenuItem.prototype.setLabel = function (label) {
if (this._label != label) {
this._label = label || "";
this.update();
}
}
$ns$IlvMenuItem.prototype.getLabel = function () {
return this._label;
}
$ns$IlvMenuItem.prototype.setIcon = function (image) {
if (this._img != image) {
this._img = image;
this.update();
}
}
$ns$IlvMenuItem.prototype.getIcon = function () {
return this._img;
}
$ns$IlvMenuItem.prototype.setEnabled = function (isEnabled) {
if (this._isEnabled != isEnabled) {
this._isEnabled = isEnabled;
this.update();
}
}
$ns$IlvMenuItem.prototype.isEnabled = function () {
return this._isEnabled;
}
$ns$IlvMenuItem.prototype.setHighlighted = function (isHighlighted) {
if (this._isHighlighted != isHighlighted) {
this._isHighlighted = isHighlighted;
this.update();
}
}
$ns$IlvMenuItem.prototype.isHighlighted = function () {
return this._isHighlighted;
}
$ns$IlvMenuItem.prototype.setSize = function (width,height) {
this.superInvoke("setSize",width,height);
this._proxy.setSize(width,height);
this.update();
}
$ns$IlvMenuItem.prototype.setLocation = function (left,top) {
this.superInvoke("setLocation",left,top);
this._proxy.setLocation(left,top);
}
$ns$IlvMenuItem.prototype.getParent = function () {
return this._parent;
}
$ns$IlvMenuItem.prototype.isRoot = function () {
return !this.getParent();
}
$ns$IlvMenuItem.prototype.getRoot = function () {
var current = this;
while (!current.isRoot())
current = current.getParent();
return current;
}
$ns$IlvMenuItem.prototype.onmouseover = function () {
if (this.getLabel() == "" || this.getLabel() == "-")
return true;
if (this.getParent())
this.getParent().setHighlightedChild(this);
}
$ns$IlvMenuItem.prototype.onmouseup = function () {
if (this._action) {
if (typeof(this._action) == 'function')
this._action(this._view,this);
else
eval(this._action);
}
}
$ns$IlvMenuItem.prototype.performServerAction = function (actionName, params, updateAll) {
if (this.getRoot() && this.getRoot().popupMenu) {
var popup = this.getRoot().popupMenu;
var fParams = [popup._triggerLeft, popup._triggerTop, this._path];
popup.performServerAction(actionName, fParams.concat(params), updateAll);
}
}
$ns$IlvMenuItem.prototype.getStyle = function (width) {
var root = this.getRoot();
var style = "width:"+ (width?width+"px":"auto") + ";";
var styleClass;
if (root.popupMenu) {
if (root.popupMenu.itemStyleClass)
styleClass = root.popupMenu.itemStyleClass;
else
style+="background:#f0eff2;color:black;font-family:sans-serif;font-size:12px;";
if (this._isHighlighted) {
if (root.popupMenu.itemHighlightedStyleClass)
styleClass+= " " + root.popupMenu.itemHighlightedStyleClass;
else {
style += "background-color:#335ea8;color:white;";
}
}
if (!this._isEnabled) {
if (root.popupMenu.itemDisabledStyleClass)
styleClass+= " " + root.popupMenu.itemDisabledStyleClass;
else {
style += "color:#a7a6aa;";
}
}
}
return [style, styleClass];
}
$ns$IlvMenuItem.prototype.createHTMLContent = function (width, height) {
if (this._label) {
var cols = (this.setExpanded ? 4 : 3);
if (this._label == "-")
cols -=  2;
var styleArray = this.getStyle(width);
var h = '<table cols='+cols+' border=0 cellpadding=1 cellspacing=0';
if (styleArray[0] != null)
h +=' style="'+styleArray[0]+'"';
if (styleArray[1] != null)
h += ' class="'+styleArray[1]+'"';
h += (width ? ' width="'+width+'"' : '');
h += (height ? ' height="'+height+'"' : '');
h += '>';
h += '<tr>';
var size = 8;
if (this._iconWidth != null)
size = this._iconWidth;
if (this._label != "-") {
h += '<td width="'+size+'">';
if (this._img != null)
h += '<img border="0" src="'+this._img+'"/>';
h += '</td>';
}
h += '<td>';
if (this._label == "-")
h += "<hr/>"
else
h += " "+this._label+" ";
h += '</td>';
if (this._label != "-") {
if (this.setExpanded) {
h += '<td width="20" valign="middle"><div align=right>';
if (this.getRoot().popupMenu.subMenuIcon != null)
h += '<img border="0" src="'+this.getRoot().popupMenu.subMenuIcon+'"/>';
else
h += '&gt;';
h +='</div></td>';
} else
h += '<td width="10"></td>';
}
h += '</tr></table>';
return h;
}
return "";
}
$ns$IlvMenuItem.prototype.update = function () {
if (this._label == "")
return;
else if (!this.isVisible()) {
this._needUpdate = true;
return;
}
this._needUpdate = false;
var content = this.createHTMLContent(this.getWidth(), this.getHeight());
this._delegate.setContent(content);
}
$ns$IlvMenuItem.prototype.recycle = function () {
this._next = $ns$IlvMenuItem._reusable;
$ns$IlvMenuItem._reusable = this;
}
function $ns$IlvMenu (label, isEnabled, image ,path) {
this.superConstructor(label, isEnabled, null, image, path);
}
$ns$IlvMenu.prototype = new $ns$IlvMenuItem();
$ns$IlvMenu.prototype.setClassName("$ns$IlvMenu");
$ns$IlvMenu.prototype.createHTMLContainer = function () {
this.superInvoke("createHTMLContainer");
this.createBorders();
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
array[i].createHTMLContainer();
}
}
$ns$IlvMenu.prototype.createBorders = function () {
if (!this._border) {
this._border = [];
for (var i = 0; i < 4; i++)
this._border[i] = new $ns$IlvDynPanel();
this._border[0].setBackgroundColor("#C0C0C0");
this._border[1].setBackgroundColor("#000000");
this._border[2].setBackgroundColor("#FFFFFF");
this._border[3].setBackgroundColor("#808080");
}
}
$ns$IlvMenu.prototype.add = function (menuItem) {
if (!this._child)
this._child = [];
this._child[this._child.length] = menuItem;
menuItem._parent = this;
}
$ns$IlvMenu.prototype.getChildrenCount = function () {
return this._child ? this._child.length : 0;
}
$ns$IlvMenu.prototype.setVisible = function (isVisible) {
if (this.isRoot())
this._rootVisibility = isVisible;
var isExpanded = this.isExpanded();
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
array[i].setVisible(isVisible && isExpanded);
if (this.isRoot())
this.superInvoke("setVisible",false);
else
this.superInvoke("setVisible",isVisible);
for (i = 0; i < 4; i++)
this._border[i].setVisible(isExpanded && isVisible);
}
$ns$IlvMenu.prototype.isVisible = function () {
if (this.isRoot())
return this._rootVisibility;
else
return this.superInvoke("isVisible");
}
$ns$IlvMenu.prototype.setLocation = function (left, top) {
this.superInvoke("setLocation",left,top);
var width = (this.isRoot() ? 0 : this.getWidth());
var height = (this.isRoot() ? 0 : this.getHeight());
var b = document.body;
var pageLeft = window.pageXOffset || (b ? b.scrollLeft : 0);
var pageRight = window.innerWidth || (b ? b.clientWidth : 0);
pageRight -= pageLeft;
var pageTop = window.pageYOffset || (b ? b.scrollTop : 0);
var pageBottom = window.innerHeight || (b ? b.clientHeight : 0);
pageBottom -= pageTop;
var cWidth = this.getChildrenWidth();
var cHeight = this.getChildrenHeight();
if (left + width + cWidth > pageRight
&& left - cWidth > pageLeft)
left -= cWidth;
else
left += width;
if (top + cHeight > pageBottom
&& top + height - cHeight > pageTop)
top -= cHeight - height;
var zIndex = this._delegate.getZIndex();
var array = this._child;
var i, itop = top, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
array[i]._delegate.setZIndex(zIndex+2);
array[i]._proxy.setZIndex(zIndex+3);
array[i].setLocation(left,itop);
itop += array[i].getHeight();
}
for (i = 0; i < 4; i++)
this._border[i].setZIndex(zIndex+1);
this._border[0].setBounds(left-2,top-2,cWidth+4,cHeight+4);
this._border[1].setBounds(left-1,top-1,cWidth+3,cHeight+3);
this._border[2].setBounds(left-1,top-1,cWidth+2,cHeight+2);
this._border[3].setBounds(left,top,cWidth+1,cHeight+1);
}
$ns$IlvMenu.prototype.getChildren = function () {
var children = [];
var length = this.getChildrenCount();
for(var i=0; i<length; i++) {
children[i] = this._child[i];
}
return children;
}
$ns$IlvMenu.prototype.getChild = function (index) {
return this._child.length > index ? this._child[index] : null;
}
$ns$IlvMenu.prototype.getChildrenWidth = function () {
this.computeChildrenSize();
var width = 0;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var childW = array[i].getWidth();
if (width < childW)
width = childW;
}
return width;
}
$ns$IlvMenu.prototype.getChildrenHeight = function () {
this.computeChildrenSize();
var height = 0;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
height += array[i].getHeight() || 0;
return height;
}
$ns$IlvMenu.prototype.setHighlighted = function (isHighlighted) {
this.superInvoke("setHighlighted",isHighlighted);
this.setExpanded(isHighlighted);
}
$ns$IlvMenu.prototype.isExpanded = function () {
if (this.isRoot())
return true;
return this._isExpanded;
}
$ns$IlvMenu.prototype.setExpanded = function (isExpanded) {
if (isExpanded == this._isExpanded)
return;
if (isExpanded) {
var current = this;
while (current) {
current._isExpanded = true;
current = current.getParent();
}
var root = this.getRoot();
root.setVisible(root.isVisible());
} else {
this.collapse();
this.setVisible(this.isVisible());
}
}
$ns$IlvMenu.prototype.onmouseover = function () {
this.superInvoke("onmouseover");
this.setHighlightedChild(null);
}
$ns$IlvMenu.prototype.computeChildrenSize = function () {
if (this._child._sizeComputed)
return;
var width = 0;
var height = new Array();
var iconWidth = 0;
var array = this._child;
var i, itop = top, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var s;
s = this._child[i].getIconPreferredSize();
if (iconWidth < s.width) iconWidth = s.width;
}
for (i = 0; i < imax; i++) {
this._child[i]._iconWidth = iconWidth;
var s = this._child[i].getPreferredSize();
if (width < s.width) width = s.width;
height[i] = s.height;
}
for (i = 0; i < imax; i++) {
this._child[i].setSize(width,height[i]);
}
this._child._sizeComputed = true;
}
$ns$IlvMenu.prototype.setHighlightedChild = function (child) {
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++)
array[i].setHighlighted(child == array[i]);
}
$ns$IlvMenu.prototype.collapse = function () {
if (!this._isExpanded)
return;
this._isExpanded = false;
var array = this._child;
var i, imax = (array ? array.length :0);
for (i = 0; i < imax; i++) {
var menu = array[i];
if (menu._isExpanded)
menu.collapse();
}
}
$ns$IlvMenu.prototype.recycle = function () {
var array = this._child;
var i, imax = (array ? array.length : 0);
for (i = 0; i < imax; i++)
array[i].recycle();
this._next = $ns$IlvMenu._reusable;
$ns$IlvMenu._reusable = this;
}
