/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvSelectionRectangle (init, parentNode, fillOn) {
this.superConstructor(init, parentNode, fillOn);
}
$ns$IlvSelectionRectangle.prototype = new $ns$IlvDynRectangle("init");
$ns$IlvSelectionRectangle.prototype.setClassName("$ns$IlvSelectionRectangle");
$ns$IlvSelectionRectangle.prototype.setObjectProperty = function(propertyName, propertyValue) {
this.properties[0][propertyName] = propertyValue;
if (!this.invalidated)
this.invalidated = new Object();
this.invalidated[propertyName] = true;
}
$ns$IlvSelectionRectangle.prototype.getObjectProperty = function(propertyName) {
return this.properties[0][propertyName];
}
$ns$IlvSelectionRectangle.prototype.getObjectPropertyNames = function() {
var names = new Array();
var count = 0;
for (var i in this.properties[0]) {
names[count++] = i;
}
return names;
}
$ns$IlvSelectionRectangle.prototype.setObjectProperties = function(properties) {
if (!this.invalidated)
this.invalidated = new Object();
for (var i in this.properties[0]) {
this.properties[0][i] = null;
this.invalidated[i] = true;
}
for (var i in properties) {
this.properties[0][i] = properties[i];
this.invalidated[i] = true;
}
}
$ns$IlvSelectionRectangle.prototype.getObjectProperties = function() {
var r = new Object();
for (var i in this.properties[0]) {
r[i] = this.properties[0][i];
}
return r;
}
$ns$IlvSelectionRectangle.prototype.getObjectID = function() {
return this.id;
}
$ns$IlvSelectionRectangle.prototype.getObjectType = function() {
return this.type;
}
$ns$IlvSelectionRectangle.prototype.getObjectTag = function() {
return this.tag;
}
$ns$IlvSelectionRectangle.prototype.getProperties = function() {
return this.properties;
}
$ns$IlvSelectionRectangle.prototype.getInvalidatedProperties = function() {
var r = new Object();
if (this.invalidated) {
for (var i in this.invalidated) {
r[i] = this.properties[0][i];
}
}
var response = new Array();
response[0] = r;
for (var i = 1; i < this.properties.length; i++)
response[i] = this.properties[i];
return response;
}
$ns$IlvSelectionRectangle.prototype.setBounds = function (left, top, width, height) {
var t = this.getThickness();
this.superInvoke("setBounds", left-t, top-t, width+2*t, height+2*t);
}
$ns$IlvSelectionRectangle.prototype.setThickness = function (thickness) {
if (this.thickness == thickness)
return;
var old = this.thickness;
this.thickness = thickness || 0;
var b = this.getBounds();
this.setBounds(b.left+old, b.top+old, b.width-2*old, b.height-2*old);
if (this.visible)
this.recompute();
}
function $ns$IlvAbstractSelectionManager(init, moveActionName, selectionActionName, deleteActionName) {
if (typeof(init) == "undefined")
return;
this.recycledList = new Array();
this.rectangleList = new Array();
this.additionalParams = new Array();
this.multiSelectKey = "ctrl";
this.lineWidth = 1;
this.lineColor = 'black';
this.fillOn = false;
this.listeners = new $ns$IlvListenerList();
this.isMovableValue = false;
this.moveAllowed = true;
this.dragging = false;
this.imageMode = true;
this.moveActionName = moveActionName ? moveActionName : "moveNode";
this.selectionActionName = selectionActionName ? selectionActionName : "selectNode";
this.deleteActionName = deleteActionName ? deleteActionName : "deleteObject";
this.onRequestComplete = null;
$ns$IlvAbstractSelectionManager.instances[this.toString()] = this;
}
$ns$IlvAbstractSelectionManager.prototype = new $ns$IlvObject();
$ns$IlvAbstractSelectionManager.prototype.setClassName("$ns$IlvAbstractSelectionManager");
$ns$IlvAbstractSelectionManager.instances = new Array();
$ns$IlvAbstractSelectionManager.prototype.addSelectionChangedListener = function(listener) {
this.listeners.addListener(listener);
}
$ns$IlvAbstractSelectionManager.prototype.removeSelectionChangedListener = function(listener) {
this.listeners.removeListener(listener);
}
$ns$IlvAbstractSelectionManager.prototype.setImageMode = function (imageMode){
if (this.imageMode != imageMode) {
if (imageMode)
this.hideAll();
this.imageMode = imageMode;
this.performUpdateImageMode();
}
}
$ns$IlvAbstractSelectionManager.prototype.isImageMode = function (){
return this.imageMode;
}
$ns$IlvAbstractSelectionManager.prototype.setLineColor = function (color) {
if (this.lineColor != color) {
this.lineColor = color;
this.applyToAll(function(mgr,r){r.setColor(color)});
}
}
$ns$IlvAbstractSelectionManager.prototype.getLineColor = function () {
return this.lineColor;
}
$ns$IlvAbstractSelectionManager.prototype.setFillOn = function (fillOn) {
if (this.fillOn != fillOn) {
this.fillOn = fillOn;
this.applyToAll(function(mgr,r){r.setFillOn(fillOn)});
}
}
$ns$IlvAbstractSelectionManager.prototype.isFillOn = function () {
return this.fillOn;
}
$ns$IlvAbstractSelectionManager.prototype.setLineWidth = function (lineWidth) {
if (this.lineWidth != lineWidth) {
this.lineWidth = lineWidth;
this.applyToAll(function(mgr,r){r.setThickness(lineWidth);});
}
}
$ns$IlvAbstractSelectionManager.prototype.getLineWidth = function () {
return this.lineWidth;
}
$ns$IlvAbstractSelectionManager.prototype.setMoveAllowed = function (moveAllowed) {
this.moveAllowed = moveAllowed;
}
$ns$IlvAbstractSelectionManager.prototype.isMoveAllowed = function () {
return this.moveAllowed;
}
$ns$IlvAbstractSelectionManager.prototype.setMultipleSelectionKey = function (key) {
this.multiSelectKey = key;
}
$ns$IlvAbstractSelectionManager.prototype.getMultipleSelectionKey = function () {
return this.multiSelectKey;
}
$ns$IlvAbstractSelectionManager.prototype.setForceUpdateProperties = function (force) {
this.forceUpdateProperties = force;
}
$ns$IlvAbstractSelectionManager.prototype.isForceUpdateProperties = function () {
return this.forceUpdateProperties;
}
$ns$IlvAbstractSelectionManager.prototype.setOnRequestComplete = function (callback) {
this.onRequestComplete = callback;
}
$ns$IlvAbstractSelectionManager.prototype.getSelection = function() {
var length = this.rectangleList.length;
var res = new Array(length);
for (var i=0; i<length; i++)
res[i] = this.rectangleList[i];
return res;
}
$ns$IlvAbstractSelectionManager.prototype.setViewInternal = function(view) {
this.view = view;
}
$ns$IlvAbstractSelectionManager.prototype.applyToAll = function (f) {
var length = this.rectangleList.length;
for(var i=0; i<length; i++) {
f(this, this.rectangleList[i]);
}
}
$ns$IlvAbstractSelectionManager.prototype.isMultipleSelection = function (e) {
return this.multiSelectKey == "ctrl" ? e.ctrlKey : e.shiftKey;
}
$ns$IlvAbstractSelectionManager.prototype.getViewPosition = function () {
return this.view.getBounds();
}
$ns$IlvAbstractSelectionManager.prototype.createSelectionRectangle = function (left, top, width, height, properties) {
var r = this.createRectangle();
this.setRectangleProperties(r, properties);
var vBBox = this.view.getContentsBounds();
var rBBox = {left:vBBox.left+left, top:vBBox.top+top, width:width, height: height};
r.setBounds(vBBox.left+left, vBBox.top+top, width, height);
r.setClip(vBBox.left, vBBox.top, vBBox.width, vBBox.height);
r.recompute();
if (!$ns$IlvUtil.isIntersect(vBBox, rBBox)) {
r.setDisplayed(false);
}
this.rectangleList[this.rectangleList.length] = r;
}
$ns$IlvAbstractSelectionManager.prototype.createRectangle = function () {
var r;
if (this.recycledList.length == 0) {
r = new $ns$IlvSelectionRectangle(null, this.parentNode, this.fillOn);
r.setZIndex(2);
r.setColor(this.lineColor);
r.setThickness(this.lineWidth);
return r;
}
r = this.recycledList[this.recycledList.length-1];
r.setColor(this.lineColor);
r.setThickness(this.lineWidth);
r.setFillOn(this.fillOn);
r.setDisplayed(true);
this.recycledList.length = this.recycledList.length - 1;
return r;
}
$ns$IlvAbstractSelectionManager.prototype.setRectangleProperties = function(rectangle, properties) {
rectangle.id = properties[0];
rectangle.isMovable = properties[1];
rectangle.type = properties[2];
}
$ns$IlvAbstractSelectionManager.prototype.recycleAll = function () {
this.applyToAll(function(mgr, r){
r.setVisible(false);
r.setScrollPosition(0,0);
mgr.recycledList[mgr.recycledList.length] = r;
});
this.rectangleList.length = 0;
}
$ns$IlvAbstractSelectionManager.prototype.findById = function (id) {
var length = this.rectangleList.length;
for (var i=0; i<length; i++) {
if (this.rectangleList[i].id == id) {
return {id:id, rectangle:this.rectangleList[i], index:i};
}
}
return null;
}
$ns$IlvAbstractSelectionManager.prototype.recycle = function (id) {
var res = this.findById(id);
if (res != null) {
res.rectangle.setScrollPosition(0,0);
var l = this.recycledList.length;
this.recycledList[l] = res.rectangle;
this.rectangleList.splice(res.index,1);
res.rectangle.setVisible(false);
}
}
$ns$IlvAbstractSelectionManager.prototype.removeHTML = function() {
this.applyToAll(function(mgr, r){r.removeHTML()});
}
$ns$IlvAbstractSelectionManager.prototype.clipAll = function() {
var bbox = this.view.getContentsBounds();
this.applyToAll(function(mgr,r){r.setClip(bbox.left, bbox.top, bbox.width, bbox.height);});
}
$ns$IlvAbstractSelectionManager.prototype.isMovable = function (r) {
return r.isMovable;
}
$ns$IlvAbstractSelectionManager.prototype.isHiddenWhenDragging = function (r) {
return false;
}
$ns$IlvAbstractSelectionManager.prototype.isSelectionMovable = function() {
return this.isMovableValue;
}
$ns$IlvAbstractSelectionManager.prototype.computeSelectionMovable = function () {
var found = false;
for(var i=0; i<this.rectangleList.length && !found; i++) {
found = this.isMovable(this.rectangleList[i]);
}
this.isMovableComputed = true;
this.isMovableValue = found;
}
$ns$IlvAbstractSelectionManager.prototype.setScrollPosition = function (x, y) {
this.scrollX = x;
this.scrollY = y;
this.applyToAll(function(mgr,r){if(mgr.isMovable(r))r.setScrollPosition(x, y);})
}
$ns$IlvAbstractSelectionManager.prototype.getScrollPosition = function () {
return {x: this.scrollX, y: this.scrollY};
}
$ns$IlvAbstractSelectionManager.prototype.onViewScrolled = function (x, y) {
this.scrollX = x;
this.scrollY = y;
if (x == 0 && y == 0) {
return;
}
this.applyToAll( function(mgr,r){r.setScrollPosition(x, y);} );
}
$ns$IlvAbstractSelectionManager.prototype.isDragging = function() {
return this.dragging;
}
$ns$IlvAbstractSelectionManager.prototype.startDragging = function(e) {
this.selectionLoaded = false;
this.selectionRequested = false;
this.hasMoved = false;
this.multiKeyPressed = this.isMultipleSelection(e);
this.startx = e.mouseX;
this.starty = e.mouseY;
this.dragging = true;
if (this.multiKeyPressed) {
this.selectMulti(e.mouseX, e.mouseY);
} else {
this.selectOne(e.mouseX, e.mouseY, false);
}
}
$ns$IlvAbstractSelectionManager.prototype.whileDragging = function(e) {
var dx = e.mouseX - this.startx;
var dy = e.mouseY - this.starty;
if (!this.hasMoved && ((Math.abs(dx) > 3) || (Math.abs(dy) > 3))) {
this.hasMoved = true;
}
if (this.hasMoved && this.imageMode &&
!this.selectionLoaded && !this.selectionRequested &&
!this.selectionImageRequested) {
this.updateAll();
} else if (this.hasMoved && this.selectionLoaded && !this.selectionRequested) {
if (this.getSelection().length == 1) {
this.showAll();
} else {
this.showMovable();
}
if (this.noSelection) {
this.setScrollPosition(0, 0);
} else {
this.setScrollPosition(-dx, -dy);
}
}
}
$ns$IlvAbstractSelectionManager.prototype.stopDragging = function(e) {
this.dragging = false;
if (!this.hasMoved && !this.multiKeyPressed &&
((this.selectionLoaded && this.rectangleList.length > 1) || !this.selectionLoaded)) {
} else if (this.hasMoved && !this.noSelection && this.isSelectionMovable()) {
this.startx = this.startx ? this.startx : e.mouseX;
this.starty = this.starty ? this.starty : e.mouseY;
var dx = e.mouseX - this.startx;
var dy = e.mouseY - this.starty;
if (dx != 0 || dy != 0) {
this.performServerAction(this.moveActionName, [dx, dy]);
} else {
this.hideAll();
}
} else if (this.hasMoved && !this.noSelection) {
this.showAll();
}
}
$ns$IlvAbstractSelectionManager.prototype.abortDragging = function(e) {
this.dragging = false;
this.startx = 0;
this.starty = 0;
this.setScrollPosition(0, 0);
if (this.imageMode) {
this.hideAll();
} else {
this.showAll();
}
}
$ns$IlvAbstractSelectionManager.prototype.hideNotMovable = function () {
if (!this.notMovableHidden) {
this.notMovableHidden = true;
this.applyToAll(function(mgr,r) {
if (!mgr.isMovable(r)) r.setVisible(false);
});
}
}
$ns$IlvAbstractSelectionManager.prototype.showMovable = function () {
if (!this.notMovableHidden) {
this.notMovableHidden = true;
this.allHidden = false;
this.applyToAll(function(mgr,r) { r.setVisible(mgr.isMovable(r) || !mgr.isHiddenWhenDragging(r));});
}
}
$ns$IlvAbstractSelectionManager.prototype.hideAll = function () {
if (!this.allHidden) {
this.allHidden = true;
this.notMovableHidden = false;
this.applyToAll(function(mgr,r) {r.setVisible(false);});
}
}
$ns$IlvAbstractSelectionManager.prototype.showAll = function () {
this.allHidden = false;
this.notMovableHidden = false;
this.applyToAll(function(mgr,r) {r.setVisible(true);});
}
$ns$IlvAbstractSelectionManager.prototype.createRequestURL = function() {
}
$ns$IlvAbstractSelectionManager.prototype.getAdditionalParameters = function() {
return $ns$IlvRequestParameters.getRequestParameters(this.additionalParams);
}
$ns$IlvAbstractSelectionManager.prototype.setAdditionalParameters = function(key, value) {
$ns$IlvRequestParameters.setParameter(this.additionalParams, key, value);
}
$ns$IlvAbstractSelectionManager.prototype.removeAdditionalParameter = function(key) {
$ns$IlvRequestParameters.removeParameter(this.additionalParams, key);
}
$ns$IlvAbstractSelectionManager.prototype.sendRequest = function(request) {
this.selectionRequested = true;
var onload = "'"+this.toString()+"'";
if (document.layers) {
request+="&onload="+onload;
} else {
request+="&onload="+onload+"&parent=true";
}
if (!this._loader) {
this._loader = new $ns$IlvDynPanel();
}
this._loader.setURL(request);
return false;
}
$ns$IlvAbstractSelectionManager.prototype.performServerAction = function(actionName, params, listener) {
}
$ns$IlvAbstractSelectionManager.prototype.invokeOnRequestComplete = function() {
var callback = this.onRequestComplete;
if (callback) {
this.onRequestComplete = null;
callback();
}
}
$ns$IlvAbstractSelectionManager.prototype.selectOne = function(x, y, mouseUp) {
if (this.imageMode && !this.hasMoved) {
if (this.view) {
this.performServerAction(this.selectionActionName,
[x, y, false, mouseUp],
this.getSelectionImageRequestListener());
} else {
alert('ERROR: No view is attached to this selection manager.');
}
} else {
var request = this.createRequestURL();
request += "&selectionType=selectOne";
request += "&x="+x;
request += "&y="+y;
request += "&mouseUp="+mouseUp;
this.sendRequest(request);
}
}
$ns$IlvAbstractSelectionManager.prototype.selectMulti = function(x, y) {
if (this.imageMode) {
if (this.view) {
this.performServerAction(this.selectionActionName,
[x, y, true, false],
this.getSelectionImageRequestListener());
} else {
alert('ERROR: No view is attached to this selection manager.');
}
} else {
var request = this.createRequestURL();
request += "&selectionType=selectMulti";
request += "&x="+x;
request += "&y="+y;
this.sendRequest(request);
}
}
$ns$IlvAbstractSelectionManager.prototype.getSelectionImageRequestListener = function() {
this.selectionImageRequested = true;
if (!this.imageListener) {
this.imageListener = function(v) {
this.selectionImageRequested = false;
}
}
return this.imageListener;
}
$ns$IlvAbstractSelectionManager.prototype.updateAll = function() {
var request = this.createRequestURL();
request += "&selectionType=updateAll";
this.sendRequest(request);
}
$ns$IlvAbstractSelectionManager.prototype.updateSelectionProperties = function() {
this.updateAll();
}
$ns$IlvAbstractSelectionManager.prototype.doSelect = function(e) {
var x = e.mouseX;
var y = e.mouseY;
var multi = this.isMultipleSelection(e);
if (multi)
this.selectMulti(x, y);
else
this.selectOne(x, y);
}
$ns$IlvAbstractSelectionManager.onSelectionLoaded = function(name) {
var mgr = $ns$IlvAbstractSelectionManager.instances[name];
mgr.onSelectionLoaded();
mgr.invokeOnRequestComplete();
}
$ns$IlvAbstractSelectionManager.prototype.onSelectionLoaded = function() {
var ctx = this._loader.getContext();
if (ctx.refreshImage) {
this.hideAll();
this.performUpdateImage();
} else {
if (ctx.removeAll) {
this.recycleAll();
}
if (ctx.removeList) {
var length = ctx.removeList.length;
for(var i=0; i<length; i++) {
this.recycle(ctx.removeList[i][4][0]);
}
}
if (ctx.addList) {
var length = ctx.addList.length;
for(var i=0; i<length; i++) {
var r = ctx.addList[i];
var r0 = r[0];
this.createSelectionRectangle(r0.x, r0.y, r0.width, r0.height, r[1]);
}
}
this.noSelection = ctx.noSelection;
this.computeSelectionMovable();
if (!this.imageMode) {
this.showAll();
} else if (this.imageMode && this.hasMoved && this.dragging && this.isSelectionMovable()) {
this.showMovable();
}
this.updateCapabilities(ctx, this.view);
this.listeners.notify(this.getSelection());
}
this.selectionRequested = false;
this.selectionLoaded = true;
}
$ns$IlvAbstractSelectionManager.prototype.updateCapabilities = function(context, view) {
}
$ns$IlvAbstractSelectionManager.prototype.performUpdateImageMode = function() {
}
$ns$IlvAbstractSelectionManager.prototype.performUpdateImage = function() {
}
$ns$IlvAbstractSelectionManager.prototype.deleteSelection = function() {
this.performServerAction(this.deleteActionName);
}
$ns$IlvAbstractSelectionManager.prototype.commitSelectionProperties = function(updateImage, oncompleted, onfailed) {
var request = this.createRequestURL();
request += "&selectionType=setProperties";
var selection = this.rectangleList;
var collected = new Array();
var length = selection.length;
var requestContent = new Array();
for (var i = 0; i < length; i++) {
if (selection[i].invalidated) {
collected.push(selection[i]);
requestContent.push([selection[i].id].concat(selection[i].getInvalidatedProperties()));
}
}
requestContent = $ns$IlvJSONUtil.arrayToJSON(requestContent);
var selectionManager = this;
var onxhrcompleted = function(xhr) {
var length = collected.length;
for (var i = 0; i < length; i++)
collected[i].invalidated = false;
var errors = eval(xhr.responseText);
if (errors && errors.length > 0) {
var reports = new Array(errors.length);
for (var i = 0; i < errors.length; i++) {
reports[i] = new $ns$IlvSelectionPropertiesError(errors[i]);
}
errors = reports;
}
if (oncompleted)
oncompleted.call(selectionManager, errors, xhr);
if (updateImage)
selectionManager.performUpdateImage();
}
var onxhrfailed = function(xhr) {
if (onfailed)
onfailed.call(selectionManager, xhr);
}
this.xhr = $ns$IlvAjaxUtil.post(request, requestContent, this.xhr, onxhrcompleted, onxhrfailed);
}
function $ns$IlvSelectionPropertiesError(info) {
this.info = info;
}
$ns$IlvSelectionPropertiesError.ACCEPT_ERROR = 1;
$ns$IlvSelectionPropertiesError.CONVERSION_ERROR = 2;
$ns$IlvSelectionPropertiesError.SET_ERROR = 3;
$ns$IlvSelectionPropertiesError.prototype.getObjectID = function() {
return this.info[0];
}
$ns$IlvSelectionPropertiesError.prototype.getObjectErroneousProperty = function(propertyName) {
return this.info[1][propertyName]["errorValue"];
}
$ns$IlvSelectionPropertiesError.prototype.getObjectProperty = function(propertyName) {
return this.info[1][propertyName]["value"];
}
$ns$IlvSelectionPropertiesError.prototype.getType = function(propertyName) {
return this.info[1][propertyName]["type"];
}
$ns$IlvSelectionPropertiesError.prototype.getObjectPropertyNames = function() {
var names = new Array();
var count = 0;
for (var i in this.info[1]) {
names[count++] = i;
}
return names;
}
