/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvEmptyView(left, top, width, height, namespace) {
this.superConstructor();
this.left = left || 0;
this.top = top || 0;
this.width = width || 0;
this.height = height || 0;
this.cookieName = this.toString();
if (namespace)
this.cookieName = namespace + ":" + this.cookieName;
this.inHTML = false;
this.sizeListeners = null;
this.stateInCookie = true;
}
$ns$IlvEmptyView.prototype = new $ns$IlvObject;
$ns$IlvEmptyView.prototype.setClassName("$ns$IlvEmptyView");
$ns$IlvEmptyView.prototype.getBounds = function() {
return {left: this.left, top: this.top, width: this.width, height: this.height};
}
$ns$IlvEmptyView.prototype.setChildrenBounds = function(left, top, width, height) {
}
$ns$IlvEmptyView.prototype.setBounds = function(left, top, width, height) {
this._resized = (width != this.width || height != this.height);
this.left = left;
this.top = top;
this.width = width;
this.height = height;
this.setChildrenBounds(left, top, width, height);
if (this._resized)
this.fireSizeChanged();
}
$ns$IlvEmptyView.prototype.setSize = function (width, height) {
this.setBounds(this.left, this.top, width, height);
}
$ns$IlvEmptyView.prototype.setLocation = function (left, top) {
this.setBounds(left, top, this.width, this.height);
}
$ns$IlvEmptyView.prototype.getSize = function() {
return this.getBounds();
}
$ns$IlvEmptyView.prototype.getLocation = function() {
return this.getBounds();
}
$ns$IlvEmptyView.prototype.getLeft = function () {
return this.left;
}
$ns$IlvEmptyView.prototype.getTop = function () {
return this.top;
}
$ns$IlvEmptyView.prototype.getWidth = function () {
return this.width;
}
$ns$IlvEmptyView.prototype.getHeight = function () {
return this.height;
}
$ns$IlvEmptyView.prototype.addSizeListener = function(listener) {
if (!this.sizeListeners)
this.sizeListeners = new $ns$IlvListenerList();
this.sizeListeners.addListener(listener);
}
$ns$IlvEmptyView.prototype.removeSizeListener = function(listener) {
if (this.sizeListeners)
this.sizeListeners.removeListener(listener);
}
$ns$IlvEmptyView.prototype.fireSizeChanged = function() {
if (this.sizeListeners)
this.sizeListeners.notify(this);
}
$ns$IlvEmptyView.prototype.childrenToHTML = function() {
}
$ns$IlvEmptyView.prototype.toHTML = function() {
if (this.inHTML)
return;
this.childrenToHTML();
this.inHTML = true;
}
$ns$IlvEmptyView.prototype.setStateInCookie = function (stateInCookie) {
this.stateInCookie = stateInCookie;
}
$ns$IlvEmptyView.prototype.isStateInCookie = function () {
return this.stateInCookie;
}
$ns$IlvEmptyView.prototype.saveState = function (view) {
}
$ns$IlvEmptyView.prototype.restoreState = function (view) {
}
$ns$IlvEmptyView.prototype.saveSizeToCookie = function(expires) {
if (this.isStateInCookie()) {
setCookie(this.cookieName + ':width', this.getWidth(), expires);
setCookie(this.cookieName + ':height', this.getHeight(), expires);
}
}
$ns$IlvEmptyView.prototype.readSizeFromCookie = function() {
var size = new Object();
var cookie = getCookie(this.cookieName + ':width');
if (cookie)
size.width = parseInt(cookie);
else
size.width = this.getWidth();
cookie = getCookie(this.cookieName + ':height');
if (cookie)
size.height = parseInt(cookie);
else
size.height = this.getHeight();
return size;
}
