/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvImageView(left, top, width, height, image) {
this.superConstructor(left, top, width, height);
$ns$IlvImageView.instances[this.toString()] = this;
this.imageSrc = image;
this.imageState = $ns$IlvImageView.NOT_LOADED;
this.cursor = 'auto';
this.visible = true;
this.tooltip = '';
this.imageWidth = -1;
this.imageHeight = -1;
this.scrollX = 0;
this.scrollY = 0;
this.imageID = this.toString() + "IMG";
this.blendTransform = true;
this.imageScrollListeners = new $ns$IlvListenerList();
this.imageLoadingListeners = new $ns$IlvListenerList();
this.imagePreloadListeners = new $ns$IlvListenerList();
this.imageLoadListeners = new $ns$IlvListenerList();
this.errorListeners = new $ns$IlvListenerList();
this.timeoutListeners = new $ns$IlvListenerList();
this.timeout = 600;
this.registerDispose();
}
if (!window.$ns$IlvEmptyView)
alert("$ns$IlvImageView requires $ns$IlvEmptyView");
$ns$IlvImageView.prototype = new $ns$IlvEmptyView;
$ns$IlvImageView.prototype.setClassName("$ns$IlvImageView");
$ns$IlvImageView.prototype.traceImage = false;
$ns$IlvImageView.prototype.traceImageLoading = false;
$ns$IlvImageView.prototype.traceUpdateContent = false;
$ns$IlvImageView.instances = new Array();
$ns$IlvImageView.NOT_LOADED = 0;
$ns$IlvImageView.LOADING = 1;
$ns$IlvImageView.LOADED = 2;
$ns$IlvImageView.ERROR = 3;
$ns$IlvImageView.prototype.dispose = function() {
this.superInvoke("dispose");
this.abortImage();
var image = getImage(this.imageID);
if (image)
disposeImageSource(image);
$ns$IlvImageView.instances[this.toString()] = null;
}
$ns$IlvImageView.prototype.removeHTML = function () {
this.imagePanel.removeHTML();
}
$ns$IlvImageView.prototype.updateVisibility = function (){
this.imagePanel.updateVisibility();
}
$ns$IlvImageView.prototype.getToolTipText = function() {
return this.tooltip;
}
$ns$IlvImageView.prototype.setToolTipText = function(string) {
this.tooltip = string || '';
if (this.imagePanel) {
if ($ns$IlvBrowserInfo.instance.nav4) {
this.updateImagePanelContent();
} else if ($ns$IlvBrowserInfo.instance.nav6up){
var currentImage = getImage(this.imageID);
currentImage.title = string;
} else {
var currentImage = getImage(this.imageID);
currentImage.alt = string;
}
}
}
$ns$IlvImageView.prototype.isVisible = function () {
return this.visible;
}
$ns$IlvImageView.prototype.setVisible = function(visible) {
this.visible = visible;
if (this.imagePanel) {
if (!visible || this.isImageLoaded())
this.imagePanel.setVisible(visible);
}
}
$ns$IlvImageView.prototype.getCursor = function() {
return this.cursor;
}
$ns$IlvImageView.prototype.setCursor = function(cursor) {
this.cursor = cursor;
if (this.imagePanel)
this.imagePanel.setCursor(cursor);
}
$ns$IlvImageView.prototype.setBackgroundColor = function (color) {
this.bgColor = color;
if (this.imagePanel)
this.imagePanel.setBackgroundColor(color);
}
$ns$IlvImageView.prototype.setImageState = function(state) {
if (this.imageState == state)
return;
this.imageState = state;
if (state == $ns$IlvImageView.LOADING)
this.imageLoadingListeners.notify(this);
}
$ns$IlvImageView.prototype.isImageLoaded = function () {
return this.imageState == $ns$IlvImageView.LOADED;
}
$ns$IlvImageView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
var imagePanel = this.imagePanel;
if (imagePanel) {
if (this._resized) {
imagePanel.setBounds(left, top, width, height);
if (this.imageWidth < 0 || this.imageHeight < 0)
this.updateImagePanelContent();
} else {
imagePanel.setLocation(left, top);
}
}
}
$ns$IlvImageView.prototype.childrenToHTML = function() {
this.imagePanel = new $ns$IlvHTMLPanel(this.getHTMLContent());
this.imagePanel.setBounds(this.left, this.top, this.width, this.height);
if (this.scrollX != 0 || this.scrollY != 0)
this.imagePanel.setScrollPosition(this.scrollX, this.scrollY);
this.imagePanel.setCursor(this.getCursor());
if (this.bgColor)
this.imagePanel.setBackgroundColor(this.bgColor);
if (this.imageSrc) {
this.loadImage();
}
}
$ns$IlvImageView.prototype.getHTMLContent = function() {
var content = '<img align="top" border=0 ' +
'id="'   + this.imageID + '" ' +
'name="' + this.imageID + '" ' +
'galleryimg="false" ';
var w = this.imageWidth  >= 0 ? this.imageWidth  : this.getWidth();
var h = this.imageHeight >= 0 ? this.imageHeight : this.getHeight();
content += 'width=' + w + ' height=' + h + ' ';
content += 'src="'+$ns$ilvImagePath + 'empty.gif" ';
if (this.tooltip != '') {
content += 'alt="' + this.tooltip + '" title="' + this.tooltip+'" ';
}
content += '>';
return content;
}
$ns$IlvImageView.prototype.updateImagePanelContent = function(skipImageRedisplay) {
if (!this.imagePanel)
return;
trace(this.traceUpdateContent, "updateContent, skipRedisplay", this, skipImageRedisplay);
this.imagePanel.setVisible(false);
this.setImageState(this.imageSrc ? $ns$IlvImageView.LOADING : $ns$IlvImageView.NOT_LOADED);
if (this.imageSrc && !skipImageRedisplay)
var onImageTagChanged = '$ns$IlvImageView.instances[\''+this.toString()+'\'].loadImage()';
this.imagePanel.setContent(this.getHTMLContent(), onImageTagChanged);
}
$ns$IlvImageView.prototype.getImage = function() {
return this.imageSrc;
}
$ns$IlvImageView.prototype.setImage = function(image, width, height) {
var resize = (width != null && height != null);
trace(this.traceImage, "setImage, resize", this, image, resize);
if (resize) {
this.imageSrc = image;
this.setImageSize(width, height, false);
} else if (image != this.imageSrc) {
this.imageSrc = image;
if (image && this.inHTML) {
this.loadImage();
}
}
}
$ns$IlvImageView.prototype.getImageSize = function() {
var val = new Object();
val.width  = this.imageWidth  >= 0 ? this.imageWidth  : this.getWidth();
val.height = this.imageHeight >= 0 ? this.imageHeight : this.getHeight();
return val;
}
$ns$IlvImageView.prototype.setImageSize = function(width, height, skipImageRedisplay) {
trace(this.traceImage, "setImageSize", this, width, height);
this.imageWidth = width;
this.imageHeight = height;
this.updateImagePanelContent(skipImageRedisplay);
}
$ns$IlvImageView.prototype.getBlendTransform = function() {
return this.blendTransform;
}
$ns$IlvImageView.prototype.setBlendTransform = function(set) {
this.blendTransform = set;
}
$ns$IlvImageView.prototype.getScrollPosition = function() {
var val = new Object();
val.x = this.scrollX;
val.y = this.scrollY;
return val;
}
$ns$IlvImageView.prototype.setScrollPosition = function(x, y) {
if (this.scrollX != x || this.scrollY != y) {
this.scrollX = x;
this.scrollY = y;
if (this.imagePanel)
this.imagePanel.setScrollPosition(x, y);
this.imageScrollListeners.notify(this);
}
}
$ns$IlvImageView.prototype.addScrollListener = function(listener) {
this.imageScrollListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeScrollListener = function(listener) {
this.imageScrollListeners.removeListener(listener);
}
$ns$IlvImageView.prototype.loadImage = function() {
trace(this.traceImageLoading, "loadImage", this, this.imageSrc);
this.abortImage();
this.setImageState($ns$IlvImageView.LOADING);
var offscreen = new Image();
this.offscreen = offscreen;
offscreen.view = this;
offscreen.onload  = $ns$IlvImageView.offscreenLoadListener;
offscreen.onabort = $ns$IlvImageView.offscreenAbortListener;
offscreen.onerror = $ns$IlvImageView.offscreenErrorListener;
this.startErrorTimer();
offscreen.src = this.imageSrc;
}
$ns$IlvImageView.offscreenLoadListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
trace(view.traceImageLoading, "image preloaded", view, this.src);
view.imagePreloadListeners.notify(view);
if (view.blendTransform && $ns$IlvBrowserInfo.instance.ie5up) {
var layer = view.imagePanel.getMouseEventSource();
layer.style.filter = "blendTrans(duration=.4)";
if (layer.filters && layer.filters.blendTrans.status != 2) {
layer.filters.blendTrans.apply();
if (!$ns$IlvPanel.visibilityLock)
layer.style.visibility = "visible";
layer.filters.blendTrans.play();
}
}
trace(view.traceImageLoading, "image loaded", view, this.src);
var dim = view.getImageSize();
replaceImageWithDimensions(view.imageID, this, true, dim.width, dim.height);
if (view.isVisible()) {
view.imagePanel.setVisible(true);
}
this.onabort = null;
this.onerror = null;
this.onload = null;
view.setImageState($ns$IlvImageView.LOADED);
view.imageLoadListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
$ns$IlvImageView.offscreenAbortListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
view.setImageState($ns$IlvImageView.ERROR);
trace(view.traceImageLoading, "image aborted", view, this.src);
disposeImageSource(this);
view.errorListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
$ns$IlvImageView.offscreenErrorListener = function() {
var view = this.view;
if (!view)
return;
view.stopErrorTimer();
view.setImageState($ns$IlvImageView.ERROR);
trace(view.traceImageLoading, "image error", view, this.src);
disposeImageSource(this);
view.errorListeners.notify(view);
if (view.offscreen == this)
view.offscreen = null;
this.view = null;
}
$ns$IlvImageView.prototype.abortImage = function() {
var offscreen = this.offscreen;
if (!offscreen)
return;
this.offscreen = null;
this.stopErrorTimer();
trace(this.traceImageLoading, "abortImage", this, offscreen.src);
disposeImageSource(offscreen);
offscreen.view = null;
this.setImageState($ns$IlvImageView.NOT_LOADED);
}
$ns$IlvImageView.prototype.addImageLoadingListener = function(listener) {
this.imageLoadingListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeImageLoadingListener = function(listener) {
this.imageLoadingListeners.removeListener(listener);
}
$ns$IlvImageView.prototype.addImagePreloadListener = function(listener) {
this.imagePreloadListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeImagePreloadListener = function(listener) {
this.imagePreloadListeners.removeListener(listener);
}
$ns$IlvImageView.prototype.addImageLoadListener = function(listener) {
this.imageLoadListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeImageLoadListener = function(listener) {
this.imageLoadListeners.removeListener(listener);
}
$ns$IlvImageView.prototype.setTimeoutInterval = function(interval) {
this.timeout = interval;
}
$ns$IlvImageView.prototype.getTimeoutInterval= function() {
return this.timeout;
}
$ns$IlvImageView.prototype.startErrorTimer = function() {
this.stopErrorTimer();
this.errorInterval =
window.setTimeout('$ns$IlvImageView.prototype.onTimeout("' +
this.toString() + '")',
this.timeout*1000);
}
$ns$IlvImageView.prototype.stopErrorTimer = function() {
var inter = this.errorInterval;
this.errorInterval = null;
if (inter)
window.clearTimeout(inter);
}
$ns$IlvImageView.prototype.onTimeout = function(name) {
var view = $ns$IlvImageView.instances[name];
if (view != null) {
trace(view.traceImageLoading, "image timeout", view, view.imageSrc);
view.setImageState($ns$IlvImageView.ERROR);
view.timeoutListeners.notify(view);
}
}
$ns$IlvImageView.prototype.addTimeoutErrorListener = function(listener) {
this.timeoutListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeTimeoutErrorListener = function(listener) {
this.timeoutListeners.removeListener(listener);
}
$ns$IlvImageView.prototype.addErrorListener = function(listener) {
this.errorListeners.addListener(listener);
}
$ns$IlvImageView.prototype.removeErrorListener = function(listener) {
this.errorsListeners.removeListener(listener);
}
function $ns$IlvImageEventView(left, top, width, height, image) {
this.superConstructor(left, top, width, height, image);
this.glassView = new $ns$IlvGlassView(left, top, width, height);
this.glassView.imageView = this;
this.glassView.getEventOriginLeft = function() {
return this.imageView.getEventOriginLeft();
}
this.glassView.getEventOriginTop = function() {
return this.imageView.getEventOriginTop();
}
}
$ns$IlvImageEventView.prototype = new $ns$IlvImageView();
$ns$IlvImageEventView.prototype.setClassName("$ns$IlvImageEventView");
$ns$IlvImageEventView.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
this.glassView.removeHTML();
}
$ns$IlvImageEventView.prototype.setCursor = function(cursor) {
this.superInvoke("setCursor", cursor);
this.glassView.setCursor(cursor);
}
$ns$IlvImageEventView.prototype.setVisible = function(visible) {
this.superInvoke("setVisible", visible);
this.glassView.setVisible(visible);
}
$ns$IlvImageEventView.prototype.setToolTipText = function(string) {
this.superInvoke("setToolTipText", string);
this.glassView.setToolTipText(this.tooltip);
}
$ns$IlvImageEventView.prototype.isEnabled = function() {
return this.glassView.isEnabled();
}
$ns$IlvImageEventView.prototype.setEnabled = function(enabled) {
this.glassView.setEnabled(enabled);
}
$ns$IlvImageEventView.prototype.getEventHandler = function() {
return this.glassView.getEventHandler();
}
$ns$IlvImageEventView.prototype.setEventHandler = function(eventHandler) {
this.glassView.setEventHandler(eventHandler);
}
$ns$IlvImageEventView.prototype.getEventOriginLeft = function() {
return this.left;
}
$ns$IlvImageEventView.prototype.getEventOriginTop = function() {
return this.top;
}
$ns$IlvImageEventView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
this.glassView.setBounds(left, top, width, height);
}
$ns$IlvImageEventView.prototype.childrenToHTML = function() {
this.superInvoke("childrenToHTML");
this.glassView.setVisible(this.isVisible());
this.glassView.toHTML();
}
$ns$IlvImageEventView.prototype.updateVisibility = function (){
this.superInvoke("updateVisibility");
this.glassView.updateVisibility();
}
$ns$IlvImageEventView.prototype.removeHTML = function (){
this.superInvoke("removeHTML");
this.glassView.removeHTML();
}
