/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvResizableView(left, top, width, height, namespace) {
if (!window.$ns$IlvEmptyView)
alert("$ns$IlvResizableView requires $ns$IlvEmptyView");
this.superConstructor(left, top, width, height, namespace);
this.minimumHeight = 100;
this.minimumWidth = 100;
this.maximumWidth = 1024;
this.maximumHeight = 600;
this.resizable = false;
}
$ns$IlvResizableView.prototype = new $ns$IlvEmptyView;
$ns$IlvResizableView.prototype.setClassName("$ns$IlvResizableView");
$ns$IlvResizableView.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
if (this.resizeTool)
this.resizeTool.removeHTML();
}
$ns$IlvResizableView.prototype.updateVisibility = function () {
this.superInvoke("updateVisibility");
if (this.resizeTool)
this.resizeTool.updateVisibility();
}
$ns$IlvResizableView.prototype.setChildrenBounds = function(left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
if (this.resizeTool)
this.resizeTool.setBounds(left, top, width, height);
}
$ns$IlvResizableView.prototype.setResizable = function(set) {
this.resizable = set;
if (this.resizeTool)
this.resizeTool.setVisible(set);
}
$ns$IlvResizableView.prototype.isResizable = function(set) {
return this.resizable;
}
$ns$IlvResizableView.prototype.isResizeable = $ns$IlvResizableView.prototype.isResizable;
$ns$IlvResizableView.prototype.setResizeable = $ns$IlvResizableView.prototype.setResizable;
$ns$IlvResizableView.prototype.setMaximumSize = function(width, height) {
this.maximumWidth = width;
this.maximumHeight = height;
}
$ns$IlvResizableView.prototype.getMaximumSize = function() {
var size = new Object;
size.width =  this.maximumWidth;
size.height = this.maximumHeight;
return size;
}
$ns$IlvResizableView.prototype.setMinimumSize = function(width, height) {
this.minimumWidth = width;
this.minimumHeight = height;
}
$ns$IlvResizableView.prototype.getMinimumSize = function() {
var size = new Object;
size.width =  this.minimumWidth;
size.height = this.minimumHeight;
return size;
}
$ns$IlvResizableView.prototype.toHTML = function() {
this.superInvoke("toHTML");
this.resizeTool = new $ns$IlvResizeTool(this);
this.resizeTool.toHTML();
this.resizeTool.setVisible(this.resizable);
}
function $ns$IlvResizeTool(view) {
this.superConstructor();
this.view = view;
this.color = '#808080';
this.lineWidth = 2;
this.inHTML = false;
this.registerDispose();
}
$ns$IlvResizeTool.prototype = new $ns$IlvObject;
$ns$IlvResizeTool.prototype.setClassName("$ns$IlvResizeTool");
$ns$IlvResizeTool.prototype.removeHTML = function () {
this.superInvoke("removeHTML");
if (this.corner)
this.corner.removeHTML();
if (this.rect)
this.rect.removeHTML();
}
$ns$IlvResizeTool.prototype.updateVisibility = function () {
this.superInvoke("updateVisibility");
if (this.corner)
this.corner.updateVisibility();
if (this.rect)
this.rect.updateVisibility();
}
$ns$IlvResizeTool.prototype.dispose = function() {
this.superInvoke("dispose");
if (this.corner) {
this.corner.resizeTool = null;
this.corner = null;
}
this.view = null;
}
$ns$IlvResizeTool.prototype.setVisible = function(visible) {
if (this.corner)
this.corner.setVisible(visible);
}
$ns$IlvResizeTool.prototype.toHTML = function() {
if (this.inHTML)
return;
var view = this.view;
var x = view.left;
var y = view.top;
var w = view.width;
var h = view.height;
this.rect = new $ns$IlvRectangle();
this.rect.setColor(this.color);
this.rect.setThickness(this.lineWidth);
this.corner = new $ns$IlvGlassView(x + w - 20, y + h - 20, 20, 20);
var corner = this.corner;
corner.resizeTool = this;
corner.setContent('<img width="' + corner.getWidth() +
'" height="' + corner.getHeight() +
'" src="' + $ns$ilvImagePath + 'resize-corner.gif">');
corner.getEventOriginLeft = function() {
return this.resizeTool.view.getLeft();
}
corner.getEventOriginTop = function() {
return this.resizeTool.view.getTop();
}
corner.setEventHandler(this);
corner.setCursor("se-resize");
corner.toHTML();
this.inHTML = true;
}
$ns$IlvResizeTool.prototype.setBounds = function(x, y, w, h) {
this.corner.setBounds(x + w - 20, y + h - 20, 20, 20);
}
$ns$IlvResizeTool.prototype.startResize = function(e) {
this.dragging = true;
var view = this.view;
this.offsetX = view.getWidth() - e.mouseX;
this.offsetY = view.getHeight() - e.mouseY;
this.duringResize(e);
this.rect.setVisible(true);
}
$ns$IlvResizeTool.prototype.duringResize = function(e) {
if (!this.dragging)
return;
var view = this.view;
var width  = e.mouseX + this.offsetX;
var height = e.mouseY + this.offsetY;
var mini = view.getMinimumSize();
var maxi = view.getMaximumSize();
width  = Math.max(mini.width, width);
height = Math.max(mini.height, height);
width  = Math.min(width, maxi.width);
height = Math.min(height, maxi.height);
this.rect.setBounds(view.left, view.top, width, height);
var corner = this.corner;
corner.setLocation(width  + view.left - corner.getWidth(),
height + view.top  - corner.getHeight());
}
$ns$IlvResizeTool.prototype.stopResize = function(e) {
var view = this.view;
var width  = e.mouseX + this.offsetX;
var height = e.mouseY + this.offsetY;
var mini = view.getMinimumSize();
var maxi = view.getMaximumSize();
width  = Math.max(mini.width, width);
height = Math.max(mini.height, height);
width  = Math.min(width, maxi.width);
height = Math.min(height, maxi.height);
view.resizeTool = null;
view.setBounds(view.left, view.top, width, height);
view.resizeTool = this;
this.rect.setVisible(false);
var corner = this.corner;
corner.setLocation(width  + view.left - corner.getWidth(),
height + view.top  - corner.getHeight());
this.dragging = false;
}
$ns$IlvResizeTool.prototype.mouseDown = function(e) {
if (this.dragging)
this.stopResize(e);
else
this.startResize(e);
}
$ns$IlvResizeTool.prototype.mouseDrag = function(e) {
this.duringResize(e);
}
$ns$IlvResizeTool.prototype.mouseUp = function(e) {
if (this.dragging)
this.stopResize(e);
}
