/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvDragRectangleInteractor() {
this.superConstructor();
this.setCursor('crosshair');
this.listeners = new $ns$IlvListenerList();
this.color = 'black';
this.zleft = 0;
this.ztop = 0;
this.zbottom = 0;
this.zright = 0;
this.startx = 0;
this.starty = 0;
this.lineWidth = 2;
this.dragging = false;
this.ratio = 0;
}
$ns$IlvDragRectangleInteractor.prototype = new $ns$IlvInteractor;
$ns$IlvDragRectangleInteractor.prototype.setClassName("$ns$IlvDragRectangleInteractor");
$ns$IlvDragRectangleInteractor.prototype.addRectangleDraggedListener
= function(listener) {
this.listeners.addListener(listener);
}
$ns$IlvDragRectangleInteractor.prototype.removeRectangleDraggedListener
= function(listener) {
this.listeners.removeListener(listener);
}
$ns$IlvDragRectangleInteractor.prototype.setColor = function(color) {
this.color = color;
}
$ns$IlvDragRectangleInteractor.prototype.getColor = function() {
return this.color;
}
$ns$IlvDragRectangleInteractor.prototype.setLineWidth = function(lineWidth) {
this.lineWidth = lineWidth;
this.adjust();
}
$ns$IlvDragRectangleInteractor.prototype.getLineWidth = function() {
return this.lineWidth;
}
$ns$IlvDragRectangleInteractor.prototype.getXYRatio = function() {
return this.ratio;
}
$ns$IlvDragRectangleInteractor.prototype.setXYRatio = function(r) {
this.ratio = r;
}
$ns$IlvDragRectangleInteractor.prototype.adjust = function() {
if (this.view && this.view.getRectangle()) {
var view = this.view;
var zleft = this.zleft + view.getLeft();
var zright = this.zright + view.getLeft();
var ztop = this.ztop + view.getTop();
var zbottom = this.zbottom + view.getTop();
zleft = Math.max(zleft, view.getLeft());
ztop = Math.max(ztop, view.getTop());
zright = Math.min(zright, view.getLeft() + view.getWidth());
zbottom = Math.min(zbottom, view.getTop() + view.getHeight());
view.getRectangle().setColor(this.color);
view.getRectangle().setThickness(this.lineWidth);
view.getRectangle().setBounds(zleft,ztop,
zright-zleft,zbottom-ztop);
}
}
$ns$IlvDragRectangleInteractor.prototype.startDragging = function(e) {
this.startx = e.mouseX;
this.starty = e.mouseY;
this.whileDragging(e);
this.view.getRectangle().setVisible(true);
return false;
}
$ns$IlvDragRectangleInteractor.prototype.getRectangle = function() {
return this.view.getRectangle().getBounds();
}
$ns$IlvDragRectangleInteractor.prototype.whileDragging = function(e) {
var mouseX = e.mouseX;
var mouseY = e.mouseY;
var ratio = this.getXYRatio();
if (ratio != 0) {
var dx = mouseX - this.startx;
var dy = mouseY - this.starty;
var sgnX = (dx != 0) ? dx/Math.abs(dx) : 1;
var sgnY = (dy != 0) ? dy/Math.abs(dy) : 1;
dx = Math.abs(dx);
dy = Math.abs(dy);
if (dx < dy*ratio)
dx = parseInt(dy*ratio);
else
dy = parseInt(dx/ratio);
if (isNaN(dx)) dx = 0;
if (isNaN(dy)) dy = 0;
dx *= sgnX;
dy *= sgnY;
mouseX = dx + this.startx;
mouseY = dy + this.starty;
}
if (mouseX > this.startx) {
this.zleft = this.startx;
this.zright = mouseX;
}
else {
this.zleft = mouseX;
this.zright = this.startx;
}
if (mouseY >  this.starty) {
this.ztop = this.starty;
this.zbottom = mouseY;
}
else {
this.ztop = mouseY;
this.zbottom = this.starty;
}
this.adjust();
return false;
}
$ns$IlvDragRectangleInteractor.prototype.stopDragging = function(e) {
this.dragging = false;
this.view.getRectangle().setVisible(false);
var start = 0;
if (this.zleft == this.startx && this.ztop == this.starty)
start = 0;
else if (this.zright == this.startx && this.ztop == this.starty)
start = 3;
else if (this.zright == this.startx && this.zbottom == this.starty)
start = 2;
else if (this.zleft == this.startx && this.zbottom == this.starty)
start = 1;
if (this.dragevent == null)
this.dragevent = new Object();
this.dragevent.left = this.zleft;
this.dragevent.top = this.ztop;
this.dragevent.width = this.zright-this.zleft;
this.dragevent.height = this.zbottom-this.ztop;
this.dragevent.corner = start;
this.dragevent.mouseEvent = e;
this.listeners.notify(this.dragevent);
return false;
}
$ns$IlvDragRectangleInteractor.prototype.onmousedown = function(e) {
if (this.view != null) {
if (!this.dragging) {
this.dragging = true;
return this.startDragging(e);
}
else
return this.stopDragging(e);
}
return false;
}
$ns$IlvDragRectangleInteractor.prototype.onmousemove = function(e) {
if (this.dragging) {
return this.whileDragging(e);
}
return false;
}
$ns$IlvDragRectangleInteractor.prototype.onmouseup = function(e) {
if (this.dragging) {
this.stopDragging(e);
return false;
}
return false;
}
