/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

function $ns$IlvSelectionManager() {
if (!window.$ns$IlvAbstractSelectionManager)
alert("$ns$IlvSelectionManager requires $ns$IlvAbstractSelectionManager");
this.superConstructor(true);
}
$ns$IlvSelectionManager.prototype = new $ns$IlvAbstractSelectionManager();
$ns$IlvSelectionManager.prototype.setClassName("$ns$IlvSelectionManager");
$ns$IlvSelectionManager.prototype.setViewInternal = function(view) {
if (this.view != view) {
if (this.view) {
if (this.view.tileSize) {
this.view.getDynamicLayer().removeImageLoadListener(this.imageOnLoadListener);
this.view.getDynamicLayer().removeImagePreloadListener(this.imagePreloadListener);
this.removeAdditionalParameter("dynamic");
} else {
this.view.imagePanel.removeScrollListener(this.scrollListener);
this.view.removeImageOnLoadListener(this.imageOnLoadListener);
this.view.removeBeforeImageOnLoadListener(this.beforeImageOnLoadListener);
}
}
this.view = view;
if (view) {
var mgr = this;
if (this.view.isTiled()) {
this.setAdditionalParameters("dynamic", "true");
this.imageOnLoadListener = function (view) {
if (!mgr.imageMode) {
mgr.updateAll();
} else if (mgr.imageMode && !mgr.dragging) {
mgr.hideAll();
}
};
view.getDynamicLayer().addImageLoadListener(this.imageOnLoadListener);
this.imagePreloadListener = function (view) {
mgr.hideAll();
};
view.getDynamicLayer().addImagePreloadListener(this.imagePreloadListener);
} else {
this.scrollListener = function (imageView) {
if (!mgr.imageMode) {
var val = imageView.getScrollPosition();
mgr.onViewScrolled(val.x, val.y);
}
};
view.imagePanel.addScrollListener(this.scrollListener);
this.imageOnLoadListener = function (view) {
if (!mgr.imageMode) {
mgr.updateAll();
} else if (mgr.imageMode && !mgr.dragging) {
mgr.hideAll();
}
};
view.addImageOnLoadListener(this.imageOnLoadListener);
this.beforeImageOnLoadListener = function (view) {
mgr.hideAll();
};
view.addBeforeImageOnLoadListener(this.beforeImageOnLoadListener);
}
if (!this.imageMode) {
this.updateAll();
}
}
}
}
$ns$IlvSelectionManager.prototype.setRectangleProperties = function(rectangle, properties) {
this.superInvoke("setRectangleProperties", rectangle, properties);
rectangle.tag = properties[3];
rectangle.properties = properties.slice(4);
}
$ns$IlvSelectionManager.prototype.createRequestURL = function() {
var v = this.view;
var request = v.getRequestURL();
request += "?request=lightselect";
request += '&bbox=' + escape(v.qbboxx + ',' +  v.qbboxy + ',' + v.qbboxw + ',' + v.qbboxh);
request += '&width=' + v.getWidth();
request += '&height=' + v.getHeight();
var layers = v.isTiled() ? v.getDynamicVisibleLayers() : v.getVisibleLayers();
var slayers = "";
for (var i = 0;i < layers.length;i++) {
slayers += i == 0 ? layers[i] : ',' +layers[i];
}
request += '&layer=' + escape(slayers);
request += v.getAdditionalParameters();
request += this.getAdditionalParameters();
return request;
}
$ns$IlvSelectionManager.prototype.performServerAction = function(actionName, params, listener) {
if (this.isForceUpdateProperties()) {
if (!this.forceListener) {
this.forceListener = function (v) {
v.removeImageOnLoadListener(v.getSelectionManager().forceListener);
v.getSelectionManager().updateSelectionProperties();
};
}
this.view.addImageOnLoadListener(this.forceListener);
}
if (listener) {
var l = function (v) {
v.removeImageOnLoadListener(l);
listener.call(v.getSelectionManager(), v);
};
this.view.addImageOnLoadListener(l);
}
this.view.performAction(actionName, params);
}
$ns$IlvSelectionManager.prototype.updateCapabilities = function(context, view) {
if (context.minx) {
view.minx = context.minx;
view.miny = context.miny;
view.maxx = context.maxx;
view.maxy = context.maxy;
}
}
$ns$IlvSelectionManager.prototype.performUpdateImageMode = function() {
var params = new Array(this.imageMode);
if (this.view.capabilitiesLoaded) {
this.view.performAction("imageModeAction", params);
} else {
this.view.setAdditionalParameters('action', "imageModeAction("+this.imageMode+")");
this.imageModeListener = function (v) {
v.removeImageOnLoadListener(v.getSelectionManager().imageModeListener);
v.removeAdditionalParameter('action');
};
this.view.addImageOnLoadListener(this.imageModeListener);
}
}
$ns$IlvSelectionManager.prototype.performUpdateImage = function() {
if (this.isForceUpdateProperties()) {
if (!this.forceListener) {
this.forceListener = function (v) {
v.removeImageOnLoadListener(v.getSelectionManager().forceListener);
v.getSelectionManager().updateSelectionProperties();
};
}
this.view.addImageOnLoadListener(this.forceListener);
}
if (this.view.isTiled()) {
this.view.updateAll(false, true, true);
} else {
this.view.updateAll();
}
}
$ns$IlvSelectionManager.prototype.isHiddenWhenDragging = function (r) {
return r.getObjectType() == "link";
}
