/* 
 *  Copyright (C) 1996-2008 by ILOG.
 *  All rights reserved.
 *
 *  N O T I C E
 *
 * THIS MATERIAL IS CONSIDERED A TRADE SECRET BY ILOG.
 * UNAUTHORIZED ACCESS, USE, REPRODUCTION OR DISTRIBUTION IS PROHIBITED.
 */

if (typeof($ns$IlvFrameworkConstants) == 'undefined') {
$ns$IlvFrameworkConstants = function () {};
$ns$IlvFrameworkConstants.basePath = 'script/images/';
$ns$IlvFrameworkConstants.frameworkPath = 'script/framework/images/';
}
function $ns$IlvHTMLContainerPanel(left, top, width, height, overflow) {
this.superConstructor(left, top, width, height);
this.overflow = overflow;
this.name = this.toString();
this.inHTML = false;
this.objects = [];
this.bgcolor = null;
}
$ns$IlvHTMLContainerPanel.prototype = new $ns$IlvPanel();
$ns$IlvHTMLContainerPanel.prototype.setClassName('$ns$IlvHTMLContainerPanel');
$ns$IlvHTMLContainerPanel.prototype.setBackgroundColor = function(color) {
this.bgcolor = "#"+color;
if (this.inHTML) {
this._div.backgroundColor = this.bgcolor;
}
}
$ns$IlvHTMLContainerPanel.prototype.getBackgroundColor = function() {
return this.bgcolor;
}
$ns$IlvHTMLContainerPanel.prototype.toHTML = function() {
return this.childrenToHTML();
}
$ns$IlvHTMLContainerPanel.prototype.childrenToHTML = function() {
document.write('<div id = "' + this.name + '" ');
document.write('style = "');
if (this.overflow) {
document.write('overflow:' + this.overflow + ';');
}
document.write('position:absolute;');
document.write(' z-index:1;');
document.write('left:' + this.getLeft() + 'px;');
document.write('top:' + this.getTop() + 'px;');
if (this.getWidth() != 0) {
document.write('width:' + this.getWidth()+ 'px;');
document.write('height:' + this.getHeight()+ 'px;');
}
if (this.bgcolor) {
document.write('background-color:'+this.bgcolor+';');
}
document.write('-moz-user-select:none;');
document.write('">');
var length = this.objects.length;
for(var k = 0; k < length; k++)
this.objects[k].toHTML();
document.write('</div>');
this._div = document.getElementById(this.name);
this.inHTML = true;
var length = this.objects.length;
for(var k = 0; k < length; k++) {
if(this.objects[k].getHTMLFragment)
this._div.appendChild(this.objects[k].getHTMLFragment());
}
}
$ns$IlvHTMLContainerPanel.prototype.removeHTML = function () {
if (this._div)
this._div.parentNode.removeChild(this._div);
}
$ns$IlvHTMLContainerPanel.prototype.addObject = function(object) {
this.objects.push(object);
if (this.inHTML && object.getHTMLFragment)
this._div.appendChild(object.getHTMLFragment());
}
$ns$IlvHTMLContainerPanel.prototype.setLocation = function(x, y) {
this.superInvoke("setLocation", x, y);
if (this._div) {
this._div.style.left = x + 'px';
this._div.style.top = y + 'px';
}
}
$ns$IlvHTMLContainerPanel.prototype.setSize = function(w, h) {
this.superInvoke("setSize", w, h);
if (this._div) {
this._div.style.width = w + 'px';
this._div.style.height = h + 'px';
}
}
function $ns$IlvTile(manager, pivot, idX, idY, size) {
this.superConstructor(0, 0, size, size);
this.init = true;
this.name = this.toString();
this.manager = manager;
this.view = this.manager.view;
this.idX = idX;
this.idY = idY;
this.debug =false;
this.visible = true;
this._img = null;
this.visibilityListeners = new $ns$IlvListenerList();
}
$ns$IlvTile.prototype = new $ns$IlvEmptyView();
$ns$IlvTile.prototype.setClassName("$ns$IlvTile");
$ns$IlvTile.emptyTile = "empty.gif";
$ns$IlvTile.formatID = function(idX, idY) {
return idX + '.' + idY;
}
$ns$IlvTile.prototype.addVisibilityListener = function(listener) {
this.visibilityListeners.addListener(listener);
}
$ns$IlvTile.prototype.removeVisibilityListener = function(listener) {
this.visibilityListeners.removeListener(listener);
}
$ns$IlvTile.prototype.setSize = function(width, height, skipImageRedisplay) {
}
$ns$IlvTile.prototype.getID = function() {
return $ns$IlvTile.formatID(this.idX, this.idY);
}
$ns$IlvTile.prototype.setID = function(idX, idY) {
this.visible = true;
this.idX = idX;
this.idY = idY;
var img = this.getImageNode();
if (img) {
img.title = this.getID();
}
}
$ns$IlvTile.prototype.checkVisibility = function() {
var vSave = this.visible;
var b = this.manager.getVisibleTiles();
this.visible = b.minX <= this.idX && b.maxX>= this.idX &&  b.minY <= this.idY && b.maxY >= this.idY;
if (vSave && ! this.visible) {
this.visibilityListeners.notify(this, false);
} else if (! vSave && this.visible) {
this.visibilityListeners.notify(this, true);
}
}
$ns$IlvTile.prototype.clear = function() {
var img = this.getImageNode();
if (img) {
this.empty = true;
this.request = "";
img.src = $ns$IlvFrameworkConstants.basePath + $ns$IlvTile.emptyTile;
}
}
$ns$IlvTile.prototype.update = function(noUpdate, noVisibility, forceUpdate) {
if (! noVisibility) {
this.checkVisibility();
}
if (! noUpdate) {
var img;
img = this.getImageNode();
if (img) {
var request = this.manager.createTileRequestURL(this.idX, this.idY);
if (forceUpdate || request != this.request) {
this.request = request;
img.src = $ns$IlvFrameworkConstants.basePath + $ns$IlvTile.emptyTile;
img.src = this.request;
this.empty = false;
}
}
} else {
this.clear();
}
}
$ns$IlvTile.prototype.updateLocation = function(visibility) {
var size = this.manager.size;
this.setLocation(this.idX * size, this.idY * size, this.visible);
}
$ns$IlvTile.prototype.setLocation = function(x, y, visibility) {
var changed = (this.getLeft() != x || this.getTop() != y);
if (changed || this.init) {
this.init = false;
this.superInvoke("setLocation", x, y);
var img = this.getImageNode();
this.update(false, visibility, true);
if (img) {
img.style.left = x + 'px';
img.style.top = y + 'px';
}
}
}
$ns$IlvTile.prototype.getImageNode = function() {
if (!this._img) {
this._img = document.getElementById(this.name);
}
return this._img;
}
$ns$IlvTile.prototype.getHTMLFragment = function () {
var imgNode = document.createElement("img");
imgNode.id = this.name;
var css = 'position:absolute;-moz-user-select:none;' ;
css +='left:' + this.getLeft() + 'px; height:' + this.getHeight() + 'px;' ;
css +='top:' + this.getTop() + 'px; width:' + this.getWidth() + 'px;' ;
if (this.debug) {
css += "-moz-opacity:.75;border:1px solid black;";
}
imgNode.style.cssText = css;
imgNode.src = $ns$IlvFrameworkConstants.basePath + $ns$IlvTile.emptyTile;
imgNode.onload = function() {
this.style.visibility = "visible";
};
return imgNode;
}
$ns$IlvTile.prototype.onPoolAdd = function () {
var img = this.getImageNode();
if (img) {
img.style.display = 'none';
}
}
$ns$IlvTile.prototype.onPoolRemove = function () {
var img = this.getImageNode();
if (img) {
img.style.display = 'block';
}
}
$ns$IlvTile.prototype.isVisible = function() {
return this.visible;
}
function $ns$IlvTilePool() {
this.refs = {};
this.count = 0;
}
$ns$IlvTilePool.prototype = new $ns$IlvObject();
$ns$IlvTilePool.prototype.setClassName("$ns$IlvTilePool");
$ns$IlvTilePool.prototype.add = function(tile) {
tile.onPoolAdd();
if (this.exists(tile))
return false;
this.refs[tile.toString()] = tile;
this.count++;
return true;
}
$ns$IlvTilePool.prototype.pop = function() {
var key = null;
for (key in this.refs) break;
var tile = this.refs[key];
delete this.refs[tile.toString()];
this.count--;
tile.onPoolRemove();
return tile;
}
$ns$IlvTilePool.prototype.remove = function(tile) {
tile.onPoolRemove();
if (! this.refs[tile.toString()])
return false;
delete this.refs[tile.toString()];
this.count--;
return true;
}
$ns$IlvTilePool.prototype.exists = function(tile) {
return this.refs[tile.toString()] ? true : false;
}
$ns$IlvTilePool.prototype.size = function() {
return this.count;
}
function $ns$IlvTileManager(view, size) {
this.name = this.toString();
this.view = view;
this.size = size;
this.current = 0;
this.updatePending = false;
this.tiles = [];
this.pivot = new $ns$IlvHTMLContainerPanel(0, 0);
this.refs = {};
this.tilesPool = new $ns$IlvTilePool();
var pool = this.tilesPool;
var refs = this.refs;
$ns$IlvTileManager.instances[this.view] = this;
this.tileVisibilityChanged = function(tile, visibility) {
if (! visibility) {
pool.add(tile);
} else {
pool.remove(tile);
}
};
}
$ns$IlvTileManager.prototype = new $ns$IlvObject();
$ns$IlvTileManager.prototype.setClassName("$ns$IlvTileManager");
$ns$IlvTileManager.instances = {};
$ns$IlvTileManager.prototype.setStaticLayers = function(layers) {
this.staticLayers = layers.join(',');
}
$ns$IlvTileManager.prototype.createTileRequestURL = function(x, y) {
var request = this.view.requestURL + '?request=image';
var slayers = this.staticLayers;
request += '&layer=' + escape(this.staticLayers);
request += '&tile=' + this.view.tileSizeT + ',' +  x + ',' + y;
request += '&format='+ (this.format ? this.format : this.view.format);
request += '&width=' + this.size;
request += '&height=' + this.size;
if (this.view.getImageBackgroundColor()){
request += '&bgcolor=0x' + this.view.getImageBackgroundColor();
}
request += this.view.getAdditionalParameters();
return request;
}
$ns$IlvTileManager.prototype.setVisibleTiles = function(minX, maxX, minY, maxY, scale) {
if (scale || this.minX != minX || this.minY != minY || this.maxX != maxX || this.maxY != maxY) {
this.minX  = minX;
this.maxX = maxX;
this.minY  = minY;
this.maxY = maxY;
this.updatePending = true;
this.scale = scale;
if (scale) {
this.clearTilesImage();
}
}
}
$ns$IlvTileManager.prototype.getVisibleTiles = function() {
return { minX: this.minX, maxX: this.maxX, minY: this.minY, maxY: this.maxY};
}
$ns$IlvTileManager.prototype.getOrCreateTile = function(idX, idY) {
var tile = null;
if (this.tilesPool.size() > 0) {
tile = this.tilesPool.pop();
delete this.refs[$ns$IlvTile.formatID(tile.idX, tile.idY)];
tile.setID(idX, idY);
tile.init = true;
tile.updateLocation(true);
this.refs[$ns$IlvTile.formatID(idX, idY)] = tile;
} else {
tile = new $ns$IlvTile(this, this.pivot, idX, idY, this.size);
tile.addVisibilityListener(this.tileVisibilityChanged);
this.pivot.addObject(tile);
tile.updateLocation();
this.tiles[this.current++] = tile;
this.refs[$ns$IlvTile.formatID(idX, idY)] = tile;
}
return tile;
}
$ns$IlvTileManager.prototype.getTilesContainer = function() {
return this.pivot;
}
$ns$IlvTileManager.prototype.clearTilesImage = function() {
var length = this.tiles.length;
for(var k = 0; k < length; k++) {
this.tiles[k].clear();
}
}
$ns$IlvTileManager.prototype.organizeTiles = function(noUpdate) {
var length = this.tiles.length;
for(var k = 0; k < length; k++) {
this.tiles[k].checkVisibility();
}
if (this.updatePending) {
this.updatePending = false;
for(var x = this.minX; x <= this.maxX; x++) {
for(var y = this.minY; y <= this.maxY; y++) {
var t = this.refs[$ns$IlvTile.formatID(x, y)];
if (t) {
if (this.scale) {
t.update(false, true, true);
} else {
if (t._img.src.indexOf("empty.gif") != -1) {
t.update(false, true, true);
}
}
} else {
this.getOrCreateTile(x, y);
}
}
}
}
}
function $ns$IlvDynamicListenerList() {}
$ns$IlvDynamicListenerList.prototype = new $ns$IlvListenerList();
$ns$IlvDynamicListenerList.prototype.setClassName("$ns$IlvDynamicListenerList");
$ns$IlvDynamicListenerList.prototype.notify = function(obj) {
this.superInvoke("notify", obj.view);
};
function $ns$IlvDynamicLayer(view, layers) {
if (view) {
this.superConstructor(0, 0,
view.container.getWidth(),
view.container.getHeight());
this.name = this.toString();
this.view = view;
this.layers = layers;
this.format = 'PNG';
this.request = '';
this.qx = 0;
this.qy = 0;
this.qw = 0;
this.qh = 0;
this.updateInterval = 0;
this.updateIntervalID = null;
this.visible = true;
this.listenersMap = [];
this.zindex = 2;
this.timestamp = 0;
this.imagesBuffer = [];
this.blendTransform = false;
var layer = this;
this.imageScrollListeners = new $ns$IlvDynamicListenerList();
this.imageLoadingListeners = new $ns$IlvDynamicListenerList();
this.imagePreloadListeners = new $ns$IlvDynamicListenerList();
this.imageLoadListeners = new $ns$IlvDynamicListenerList();
this.errorListeners = new $ns$IlvDynamicListenerList();
this.timeoutListeners = new $ns$IlvDynamicListenerList();
this.imageLoadListeners.addListener(
function(view) {
var layer = view.getDynamicLayer();
layer.setUpdateInterval(layer.updateInterval);
if (!layer.panning) {
layer.setVisible(true);
}
});
$ns$IlvDynamicLayer.delayedTimeout = 300;
$ns$IlvDynamicLayer.instances[this.name] = this;
}
}
$ns$IlvDynamicLayer.prototype = new $ns$IlvImageView();
$ns$IlvDynamicLayer.prototype.setClassName("$ns$IlvDynamicLayer");
$ns$IlvDynamicLayer.instances = new Object();
$ns$IlvDynamicLayer.empty = $ns$ilvImagePath + "empty.gif";
$ns$IlvDynamicLayer.prototype.setVisible = function(visible) {
this.visible = visible;
if (this.imagePanel) {
this.imagePanel.setVisible(visible);
}
}
$ns$IlvDynamicLayer.prototype.setBounds = function (left, top, width, height){
this.superInvoke("setBounds", 0, 0, width, height);
var img = this.getImageNode();
if (img) {
img.style.width = width;
img.style.height = height;
}
}
$ns$IlvDynamicLayer.prototype.setLocation = function(x, y) {
}
$ns$IlvDynamicLayer.prototype.setPanning = function(panning) {
this.panning = panning;
}
$ns$IlvDynamicLayer.prototype.isPanning = function() {
return this.panning;
}
$ns$IlvDynamicLayer.prototype.setLayers = function(layers) {
this.layers = layers;
}
$ns$IlvDynamicLayer.prototype.getImageNode = function() {
return document.getElementById(this.imageID);
}
$ns$IlvDynamicLayer.endActionLoaded = function (layerName, id) {
var img = document.getElementById(id);
var layer = $ns$IlvDynamicLayer.instances[layerName];
layer.updateImage(img ? img : layer.getImageNode(), false);
}
$ns$IlvDynamicLayer.prototype.sendAction = function (req, img){
var onload = "'" + this.toString() + "','" + img.id + "'";
req += '&onload=' + escape(onload);
if (($ns$IlvBrowserInfo.instance.ie5up || document.getElementById) ) {
req += "&parent=true";
}
var index = req.indexOf("?request=") + 9;
req = req.substring(0,index) + "dynamicAction" + req.substring(req.indexOf("&", index), req.length);
if (!this.urlPanel) {
this.urlPanel = new $ns$IlvDynPanel();
}
this.urlPanel.setURL(req);
}
$ns$IlvDynamicLayer.prototype.updateImage = function(img, checkAction) {
if ($ns$IlvBrowserInfo.instance.ie &&
!$ns$IlvBrowserInfo.instance.ie7up) {
var req = this.request;
var actionFound = this.request.indexOf("&action=") != -1;
if (actionFound) {
if (checkAction) {
this.sendAction(req, img);
return;
} else {
var indexOfAction = req.indexOf("&action=");
req  = req.substring(0,indexOfAction) + req.substring(req.indexOf("&", indexOfAction+1), req.length);
}
}
var w = this.getWidth();
var h = this.getHeight();
var newImg = document.createElement("img");
newImg.id = this.imageID;
newImg.style.cssText = 'border-size:0;width:'+w+";height:"+h+";"
img.parentNode.replaceChild(newImg, img);
var v = this;
newImg.onload = function () {
v.imageLoadListeners.notify(v);
}
newImg.style.filter = 'progid:DXImageTransform.Microsoft.AlphaImageLoader(src="' + escape(req) + '",sizingMethod=\'scale\')';
newImg.src = $ns$ilvImagePath + "empty.gif";
}  else {
this.setImage(this.request, this.getWidth, this.getHeight());
}
}
$ns$IlvDynamicLayer.prototype.cancelUpdateTimer = function() {
if (this.updateTimer) {
clearTimeout(this.updateTimer);
}
}
$ns$IlvDynamicLayer.prototype.update = function(noUpdate, timerMode) {
if (timerMode){
if (this.updateTimer) {
clearTimeout(this.updateTimer);
}
var view = this;
this.updateTimer = setTimeout(function() {view.update(noUpdate, false);}, $ns$IlvDynamicLayer.delayedTimeout);
} else  if (this.layers) {
var v = this.view;
var vLayers = [];
var length = this.layers.length;
for (var i = 0; i < length; i++) {
if (v.isLayerVisible(this.layers[i])) {
vLayers[vLayers.length] = this.layers[i];
}
}
this.request =
v.createRequestURL(
v.qbboxx,
v.qbboxy,
v.qbboxw,
v.qbboxh,
this.getWidth(),
this.getHeight(),
vLayers,
this.format
) + "&transparent=true&dynamic=true";
if (this.updateIntervalID != null) {
window.clearTimeout(this.updateIntervalID);
}
this.updateImage(this.getImageNode(), true);
}
}
$ns$IlvDynamicLayer.prototype.setUpdateInterval = function(rate) {
if (this.inHTML) {
if (this.updateIntervalID != null)
window.clearTimeout(this.updateIntervalID);
if (rate != 0) {
var view = this;
this.updateIntervalID = setTimeout(function(){view.doRefresh();}, rate*1000);
}
}
this.updateInterval = rate;
}
$ns$IlvDynamicLayer.prototype.getUpdateInterval = function() {
return this.updateInterval;
}
$ns$IlvDynamicLayer.prototype.doRefresh = function() {
if (this.view.isAutoUpdateCapabilities()) {
this.view.getCapabilities(true, false, true, true);
} else {
this.update();
}
};
function $ns$IlvTiledView(left, top, width, height, tileSize, namespace) {
if (!window.$ns$IlvAbstractView)
alert("$ns$IlvTiledView requires $ns$IlvAbstractView");
if (width) {
this.superConstructor(left, top, width, height, namespace);
$ns$IlvTiledView.instances[this.toString()] = this;
this.format = 'JPEG';
this.capabilitiesPanel = null;
this.capabilitiesLoaded = false;
this.autoUpdateCapabilities = false;
this.initialized = false;
this.requestURL = null;
this.tileSize = tileSize ? tileSize : 256;
this.imageMap = false;
this.imageMapVisible = false;
this.interactor = null;
this.rectPanel = null;
this.qbboxx = 0;
this.qbboxy = 0;
this.qbboxw = 100;
this.qbboxh = 100;
this.minx = 0;
this.maxx = 0;
this.maxy = 0;
this.miny = 0;
this.zoom = 0;
this.maxZoom = 0;
this.panFactor = 0.5;
this.zoomFactor = 1.5;
this.error = false;
this.errorMessage = 'Sorry Service not available, try later';
this.timeout = 600;
this.allLayers = null;
this.visibleLayers = null;
this.overviewLayers = null;
this.dynLayers = new Object();
this.additionalParams = new Array();
this.capabilitiesListeners = new $ns$IlvListenerList();
this.interactorListeners = new $ns$IlvListenerList();
this.container = new $ns$IlvHTMLContainerPanel(left, top, width, height, "hidden");
this.tilesManager = new $ns$IlvTileManager(this, this.tileSize);
this.container.addObject(this.tilesManager.getTilesContainer());
this.dLayer = new $ns$IlvDynamicLayer(this);
this.dLayer.addImageLoadListener(function (view) {if (view.isCapabilitiesLoaded()) {view.updateImageMap();}});
this.container.addObject(this.dLayer);
this.bboxListeners = new $ns$IlvListenerList();
this.panAnimListeners = new $ns$IlvListenerList();
this.setAdditionalParameters("tiled", true);
}
}
$ns$IlvTiledView.prototype = new $ns$IlvAbstractView();
$ns$IlvTiledView.prototype.setClassName("$ns$IlvTiledView");
$ns$IlvTiledView.instances = new Object();
$ns$IlvTiledView.emptyImage = 'empty.gif';
$ns$IlvTiledView.prototype.removeHTML = function () {
this.imagePanel.removeHTML();
if (this.rectPanel)
this.rectPanel.removeHTML();
if (this.container)
this.container.removeHTML();
if (this.imageMapPanel)
this.imageMapPanel.removeHTML();
if (this.rectPanel)
this.rectPanel.removeHTML();
if (this.imageMapPanelPost)
this.imageMapPanelPost.removeHTML();
}
$ns$IlvTiledView.prototype.setChildrenBounds = function (left, top, width, height) {
this.superInvoke("setChildrenBounds", left, top, width, height);
this.container.setBounds(left, top, width, height);
this.imageMapPanel.setBounds(left, top, width, height);
if (this.dLayer) {
this.dLayer.setBounds(0, 0, width, height);
}
this.setViewBBoxNoCheck(this.qbboxx, this.qbboxy, this.qbboxw,this.qbboxh,true,false);
}
$ns$IlvTiledView.prototype.getLayers = function() {
var list = [];
var length = this.allLayers.length;
for (var i = 0;i < length;i++)
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvTiledView.prototype.getVisibleLayers = function() {
var list = [];
var length = this.allLayers.length;
for (var i = 0; i < length; i++)
if (this.visibleLayers[i])
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvTiledView.prototype.getDynamicVisibleLayers = function() {
var list = [];
var length = this.allLayers.length;
for (var i = 0; i < length; i++)
if (this.visibleLayers[i] && this.dynLayers[this.allLayers[i]])
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvTiledView.prototype.getStaticVisibleLayers = function() {
var list = [];
var length = this.allLayers.length;
for (var i = 0; i < length; i++)
if (this.visibleLayers[i] && ! this.dynLayers[this.allLayers[i]])
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvTiledView.prototype.setLayerVisible = function(layer, visible) {
var length = this.allLayers.length;
for (var i = 0; i < length; i++)
if (this.allLayers[i] == layer &&
(this.visibleLayers[i] != visible) && this.isDynamicLayer(layer)) {
this.visibleLayers[i] = visible;
this.overviewLayers[i] = visible;
}
this.update(false);
}
$ns$IlvTiledView.prototype.isDynamicLayer = function(layer) {
return this.dynLayers[layer];
}
$ns$IlvTiledView.prototype.getDynamicLayers = function() {
var array = [];
for(var key in this.dynLayers) {
array.push(key);
}
return array;
}
$ns$IlvTiledView.prototype.isTiled = function() {
return true;
}
$ns$IlvTiledView.prototype.isLayerVisible = function(layer) {
var length = this.allLayers.length;
for (var i = 0;i < length;i++)
if (this.allLayers[i] == layer)
return this.visibleLayers[i];
return false;
}
$ns$IlvTiledView.prototype.init = function() {
this.getCapabilities(true, true, false, false);
this.initialized = true;
}
$ns$IlvTiledView.prototype.setGenerateImageMap = function(set) {
this.imageMap = set;
}
$ns$IlvTiledView.prototype.isGenerateImageMap = function() {
return this.imageMap;
}
$ns$IlvTiledView.prototype.setImageFormat = function(format) {
this.format = format;
}
$ns$IlvTiledView.prototype.updateImageMap = function() {
if (!this.imageMap) return;
this.imageMapPanel.setVisible(false);
var layers = [];
var length = this.allLayers.length
for (var i = 0;i < length; i++)
if (this.visibleLayers[i])
layers[layers.length] = this.allLayers[i];
this.imageMapPanelPost.setURL(
this.createImageMapRequestURL(this.qbboxx, this.qbboxy,
this.qbboxw, this.qbboxh,
this.getWidth(), this.getHeight(),
layers));
}
$ns$IlvTiledView.prototype.createImageMapRequestURL = function(qx, qy, qw, qh, width, height, layers) {
var request = this.requestURL + "?request=imagemap";
if ($ns$IlvBrowserInfo.instance.ie5up || document.getElementById) {
request += "&parent=true";
}
var slayers = "";
var length = layers.length;
for (var i = 0; i <length; i++) {
slayers += i ==0 ? layers[i] : ',' + layers[i];
}
request += '&layer=' + escape(slayers);
request += '&bbox=' + escape(qx + ',' + qy + ',' + qw + ',' + qh);
request += '&format='+this.format;
request += '&width=' + width;
request += '&height=' + height;
request += '&again=' + this.againString();
request += '&onload=' + escape("'"+this.toString()+"'");
request += this.getAdditionalParameters();
if (this.emptyImagePath == null) {
var tmp = new Image();
tmp.src = $ns$IlvFrameworkConstants.basePath + 'empty.gif';
this.emptyImagePath = tmp.src;
}
request += '&image=' + escape(this.emptyImagePath);
return request;
}
$ns$IlvTiledView.imageMapUpdated = function(viewName) {
var view = $ns$IlvTiledView.instances[viewName];
var doc = view.imageMapPanelPost.getContext().document;
view.imageMapPanel.setContent(doc.body.innerHTML);
if (view.imageMapVisible) {
view.imageMapPanel.setVisible(true);
}
}
$ns$IlvTiledView.prototype.showImageMap = function() {
this.imageMapVisible = true;
if (this.imageMapPanel)
this.imageMapPanel.setVisible(true);
}
$ns$IlvTiledView.prototype.hideImageMap = function() {
this.imageMapVisible = false;
if (this.imageMapPanel)
this.imageMapPanel.setVisible(false);
}
$ns$IlvTiledView.prototype.getImageFormat = function() {
return this.format;
}
$ns$IlvTiledView.prototype.setMessagePanel = function ($ns$ilvHTMLPanel) {
this.infoPanel = $ns$ilvHTMLPanel;
}
$ns$IlvTiledView.prototype.getMessagePanel = function () {
return this.infoPanel;
}
$ns$IlvTiledView.prototype.addCapabilitiesOnLoadListener = function(listener) {
this.capabilitiesListeners.addListener(listener);
}
$ns$IlvTiledView.prototype.removeCapabilitiesOnLoadListener = function(listener) {
this.capabilitiesListeners.removeListener(listener);
}
$ns$IlvTiledView.prototype.addBeforeImageOnLoadListener = function(listener) {
this.dLayer.addImagePreloadListener(listener)
}
$ns$IlvTiledView.prototype.removeBeforeImageOnLoadListener = function(listener) {
this.dLayer.removeImagePreloadListener(listener);
}
$ns$IlvTiledView.prototype.addImageOnLoadListener = function(listener) {
this.dLayer.addImageLoadListener(listener);
}
$ns$IlvTiledView.prototype.removeImageOnLoadListener = function(listener) {
this.dLayer.removeImageLoadListener(listener);
}
$ns$IlvTiledView.prototype.addViewBBoxListener = function(listener) {
this.bboxListeners.addListener(listener);
}
$ns$IlvTiledView.prototype.removeViewBBoxLoadListener = function(listener) {
this.bboxListeners.removeListener(listener);
}
$ns$IlvTiledView.prototype.addEndPanAnimationListener = function(listener) {
this.panAnimListeners.addListener(listener);
}
$ns$IlvTiledView.prototype.removeEndPanAnimationListener = function(listener) {
this.panAnimListeners.removeListener(listener);
}
$ns$IlvTiledView.prototype.updateVisibility = function (){
this.superInvoke("updateVisibility");
if (this.rectPanel)
this.rectPanel.updateVisibility();
}
$ns$IlvTiledView.prototype.isCapabilitiesLoaded = function() {
return this.capabilitiesLoaded;
}
$ns$IlvTiledView.prototype.createCapabilitiesRequestURL = function() {
var request = this.requestURL + '?request=capabilities&format=html';
request += '&width=' + this.getWidth();
request += '&height=' + this.getHeight();
request += this.getAdditionalParameters();
request += '&again=' + this.againString();
return request;
}
$ns$IlvTiledView.prototype.createRequestURL = function(qx, qy, qw, qh, width, height, layers, format) {
var request = this.requestURL + '?request=image';
var slayers = "";
var length = layers.length;
for (var i = 0; i <length; i++) {
slayers += i ==0 ? layers[i] : ',' + layers[i];
}
request += '&layer=' + escape(slayers);
request += '&bbox=' + escape(qx + ',' +  qy + ',' + qw + ',' + qh);
request += '&format='+ (format ? format : this.format);
request += '&width=' + width;
request += '&height=' + height;
if (this.getImageBackgroundColor())
request += '&bgcolor=0x' + this.getImageBackgroundColor();
request += this.getAdditionalParameters();
request += '&again=' + this.againString();
return request;
}
$ns$IlvTiledView.prototype.performAction = function(actionName, params) {
var buf = actionName + '(';
if (params != null) {
buf += params.join(',');
}
buf += ')';
this.setAdditionalParameters('action', buf);
this.dLayer.update(false);
this.removeAdditionalParameter('action');
}
$ns$IlvTiledView.prototype.readAdditionalCapabilities = function(context) {}
$ns$IlvTiledView.prototype.getCapabilities = function(reload, showAll, keepLayerVisibility, dynamicLayerRefresh) {
var request = this.createCapabilitiesRequestURL();
if (($ns$IlvBrowserInfo.instance.ie5up || document.getElementById) && !$ns$IlvBrowserInfo.instance.opera) {
request += "&parent=true";
}
var onload = "'" + this.toString() + "'," +
(reload?'true':'false') + ',' +
(showAll?'true':'false')+ ',' +
(keepLayerVisibility?'true':'false') + ',' +
(dynamicLayerRefresh?'true':'false');
request += '&onload=' + escape(onload);
this.capabilitiesPanel.setURL(request);
}
$ns$IlvTiledView.endCapabilitiesLoaded = function(viewName,
reload,
showAll,
keepLayerVisibility,
dynamicLayerRefresh) {
var view = $ns$IlvTiledView.instances[viewName];
var oldLayers = view.allLayers;
var oldVisibility = view.visibleLayers;
var context = view.capabilitiesPanel.getContext();
view.allLayers = [];
view.visibleLayers = [];
view.overviewLayers = [];
view.minx = context.minx;
view.maxx = context.maxx;
view.miny = context.miny;
view.maxy = context.maxy;
view.readMaxZoomLevel(context);
view.readZoomLevels(context);
var length = context.themes.length;
for (i = 0; i < length; i++) {
view.allLayers[i] = context.themes[i];
view.visibleLayers[i] = true;
view.overviewLayers[i] = context.overviewthemes[i];
}
if(context.dynLayers) {
var dLayersNames = [];
var length = context.dynLayers.length;
for (i = 0; i < length; i++) {
view.dynLayers[context.dynLayers[i]] = true;
dLayersNames[i] = context.dynLayers[i];
}
view.dLayer.setLayers(dLayersNames);
view.dLayer.setVisible(true);
}
view.tilesManager.setStaticLayers(view.getStaticVisibleLayers());
view.readAdditionalCapabilities(context);
view.capabilitiesLoaded = true;
view.capabilitiesListeners.notify(view);
if (reload) {
if (getCookie(view.cookieName + 'url') || !view.isStateInCookie()) {
if (getCookie(view.cookieName + 'url')) {
view.initFromCookie();
view.recenter();
view.updateImage();
} else
view.restoreState(view);
} else {
view.showAll();
}
} else {
if (keepLayerVisibility && oldLayers != null) {
var length = oldLayers.length;
for (i = 0;i < length;i++) {
if (!oldVisibility[i]) {
view.setLayerVisible(oldLayers[i], false, false);
}
}
if (dynamicLayerRefresh) {
view.dLayer.update();
} else {
if (showAll) {
view.showAll();
} else {
view.recenter();
view.updateImage();
}
}
}
}
}
$ns$IlvTiledView.prototype.initFromUrl = function(url) {
var view = this;
var bbox = this.parseValue(url, 'bbox');
var s = 0;
var e = bbox.indexOf(',', s);
view.qbboxx = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.indexOf(',', s);
view.qbboxy = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.indexOf(',', s);
view.qbboxw = parseFloat(bbox.substring(s, e));
s = e + 1;
e = bbox.length;
view.qbboxh = parseFloat(bbox.substring(s, e));
var length = view.allLayers.length;
for (var i = 0;i < length; i++) {
view.visibleLayers[i] = false;
}
var layers = unescape(this.parseValue(url, 'layer'));
var layer;
s = 0;
e = 0;
var stop = false;
while (true) {
e = layers.indexOf(',', s);
if (e == -1) {
e = layers.length;
stop = true;
}
layer = layers.substring(s, e);
for (var i = 0;i < length;i++)
if (view.allLayers[i] == layer)
view.visibleLayers[i] = true;
if (stop) break;
s = e + 1;
}
}
$ns$IlvTiledView.prototype.initFromCookie = function() {
var view = this;
var url = getCookie(view.cookieName + 'url');
view.initFromUrl(url);
}
$ns$IlvTiledView.prototype.parseValue = function(str, search) {
var s = str.indexOf(search, 0);
if (s == -1) return -1;
var e = str.indexOf('&', s + 1);
if (e == -1) e = str.length;
return str.substring(s + search.length + 1, e);
}
$ns$IlvTiledView.prototype.getCurrentZoomLevel = function() {
var mBBox = this.getManagerBBox();
var vBBox = this.getViewBBox();
var a = mBBox.width/vBBox.width;
var b = mBBox.height/vBBox.height;
return a > b? a: b;
}
$ns$IlvTiledView.prototype.readMaxZoomLevel = function(context) {
this.maxZoom = context.maxZoom;
}
$ns$IlvTiledView.prototype.readZoomLevels = function(context) {
this.zoomLevels = context.zoomLevels;
if (this.zoomLevels) {
this.maxZoom = this.zoomLevels[this.zoomLevels.length-1];
}
}
$ns$IlvTiledView.prototype.getOverviewLayers = function() {
var list = [];
var length = this.allLayers.length;
for (var i = 0; i < length; i++)
if (this.overviewLayers[i])
list[list.length] = this.allLayers[i];
return list;
}
$ns$IlvTiledView.prototype.setRequestURL = function (requestURL) {
this.requestURL = requestURL;
}
$ns$IlvTiledView.prototype.getRequestURL = function () {
return this.requestURL;
}
$ns$IlvTiledView.prototype.getRequest = function() {
if (this.allLayers){
var layers = this.getVisibleLayers();
return this.createRequestURL(this.qbboxx, this.qbboxy,
this.qbboxw, this.qbboxh,
this.getWidth(), this.getHeight(),
layers);
}
else
return "";
}
$ns$IlvTiledView.prototype.childrenToHTML = function() {
this.superInvoke("childrenToHTML");
this.rectPanel = new $ns$IlvRectangle();
this.rectPanel.setZIndex(3);
this.capabilitiesPanel = new $ns$IlvURLPanel(0, 0, 0, 0);
this.imageMapPanelPost = new $ns$IlvURLPanel(0,0,0,0);
this.imageMapPanel = new $ns$IlvHTMLPanel('');
this.imageMapPanel.setBounds(this.getLeft(), this.getTop(),
this.getWidth(), this.getHeight());
this.imageMapPanel.setZIndex(5);
if (this.container)
this.container.toHTML();
}
$ns$IlvTiledView.prototype.setInteractor = function(inter) {
if (this.interactor == inter)
return;
var old = this.interactor;
if (this.interactor != null)
this.interactor.setViewInternal(null);
this.interactor = inter;
if (inter != null)
inter.setViewInternal(this);
this.interactorListeners.notify(this, old, inter);
}
$ns$IlvTiledView.prototype.getInteractor = function() {
return this.interactor;
}
$ns$IlvTiledView.prototype.addInteractorListener = function(listener) {
this.interactorListeners.addListener(listener);
}
$ns$IlvTiledView.prototype.removeInteractorListener = function(listener) {
this.interactorListeners.removeListener(listener);
}
$ns$IlvTiledView.prototype.mouseMove = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseMove)
return this.interactor.mouseMove(e);
else if (this.interactor.onmousemove)
return this.interactor.onmousemove(e);
}
return true;
}
$ns$IlvTiledView.prototype.mouseDrag = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseDrag)
return this.interactor.mouseDrag(e);
else if (this.interactor.onmousemove)
return this.interactor.onmousemove(e);
}
return true;
}
$ns$IlvTiledView.prototype.keyPress = function(e) {
if (this.interactor != null) {
if (this.interactor.keyPress)
return this.interactor.keyPress(e);
else if (this.interactor.onkeypress)
return this.interactor.onkeypress(e);
}
return true;
}
$ns$IlvTiledView.prototype.keyUp = function(e) {
if (this.interactor != null) {
if (this.interactor.keyUp)
return this.interactor.keyUp(e);
else if (this.interactor.onkeyup)
return this.interactor.onkeyup(e);
}
return true;
}
$ns$IlvTiledView.prototype.keyDown = function(e) {
if (this.interactor != null) {
if (this.interactor.keyDown)
return this.interactor.keyDown(e);
else if (this.interactor.onkeydown)
return this.interactor.onkeydown(e);
}
return true;
}
$ns$IlvTiledView.prototype.mouseUp = function(e) {
var interactor = this.interactor;
var popupMenu = this.popupMenu;
if (popupMenu!=null && popupMenu.isPopupTrigger(e)) {
var modelId;
if (interactor != null)
modelId = interactor.getMenuModelId();
return popupMenu.displayPopupMenu(this, e, modelId);
}  else {
if (this.interactor != null) {
if (this.interactor.mouseUp)
return this.interactor.mouseUp(e);
else if (this.interactor.onmouseup)
return this.interactor.onmouseup(e);
}
}
return true;
}
$ns$IlvTiledView.prototype.mouseDown = function(e) {
var interactor = this.interactor;
var popupMenu = this.popupMenu;
if (popupMenu!=null && popupMenu.isPopupTrigger(e)) {
this.eventPanel._dragging = false;
return true;
} else {
if (popupMenu != null) {
popupMenu.internalResetEvent();
popupMenu.hidePopupMenu();
}
if (this.capabilitiesLoaded) {
if (interactor != null) {
if (interactor.mouseDown)
return interactor.mouseDown(e);
else if (interactor.onmousedown)
return interactor.onmousedown(e);
}
}
}
return true;
}
$ns$IlvTiledView.prototype.mouseWheel = function(e) {
if (this.interactor != null) {
if (this.interactor.mouseWheel)
return this.interactor.mouseWheel(e);
else if (this.interactor.onmousewheel)
return this.interactor.onmousewheel(e);
}
return true;
}
$ns$IlvTiledView.prototype.mouseOver = function(e) {
var interactor = this.interactor;
if (interactor != null) {
if (interactor.message) {
window.status = interactor.message;
if (this.initialized && this.infoPanel)
this.infoPanel.setContent(interactor.message);
}
if (interactor.mouseOver)
return interactor.mouseOver(e);
else if (interactor.onmouseover)
return interactor.onmouseover(e);
}
return true;
}
$ns$IlvTiledView.prototype.mouseOut = function(e) {
var interactor = this.interactor;
if (interactor != null) {
window.status='';
if (this.initialized && this.infoPanel)
this.infoPanel.setContent('');
if (interactor.mouseOut)
return interactor.mouseOut(e);
else if (interactor.onmouseout)
return interactor.onmouseout(e);
}
return true;
}
$ns$IlvTiledView.prototype.getRectangle = function() {
return this.rectPanel;
}
$ns$IlvTiledView.prototype.getViewBBox = function() {
return {left:this.qbboxx, top:this.qbboxy, width:this.qbboxw, height:this.qbboxh};
}
$ns$IlvTiledView.prototype.setViewBBox = function(x, y, w, h, scale, noUpdate) {
if (this.zoomLevels) {
var ratio = w/h;
var mBBox = this.getManagerBBox();
var a = mBBox.width/w;
var b = mBBox.height/h;
var  zooml = a > b? a: b;
var index = this.getNearestZoomLevel(zooml);
var nZooml = this.zoomLevels[index];
if (zooml != nZooml) {
var ow = w;
var oh = h;
if (a>b) {
w = mBBox.width / nZooml;
h = w / ratio;
} else {
h = mBBox.height / nZooml;
w = h * ratio;
}
var dif = ow - w;
x += dif/2;
dif = oh - h;
y += dif/2;
}
}
this.setViewBBoxNoCheck(x, y, w, h, scale, noUpdate);
}
$ns$IlvTiledView.prototype.setViewBBoxNoCheck = function(x, y, w, h, scale, noUpdate, animation) {
if (this.capabilitiesLoaded) {
if(!animation) {
this.stopPanAnimation();
}
var oldBBox = this.getViewBBox();
var pivot = this.tilesManager.getTilesContainer();
this.qbboxx = x;
this.qbboxy = y;
this.qbboxw = w;
this.qbboxh = h;
this.recenter();
var vBBox = this.getViewBBox();
var mBBox = this.getManagerBBox();
var bufferTop = 0;
var bufferRight = 0;
var bufferBottom = 0;
var bufferLeft = 0;
if (scale) {
this.sx = this.getWidth() / vBBox.width;
this.sy = this.getHeight() / vBBox.height;
this.tx = 0 - this.sx * vBBox.left;
this.ty = 0 - this.sy * vBBox.top;
this.tileSizeT = this.tileSize /  this.sx;
this.managerBBoxT = {
x: this.sx * mBBox.left + this.tx,
y: this.sy * mBBox.top + this.ty,
width: mBBox.width * this.sx,
height: mBBox.height * this.sy
};
this.countX = Math.floor(mBBox.width / this.tileSizeT) + 1;
this.countY = Math.floor(mBBox.height / this.tileSizeT) + 1;
this.viewBBoxT = {
x: -this.managerBBoxT.x,
y: -this.managerBBoxT.y,
width: this.getWidth() * 1,
height: this.getHeight() * 1
};
} else {
var dx = (vBBox.left - oldBBox.left) * this.sx;
var dy = (vBBox.top - oldBBox.top) * this.sy;
this.viewBBoxT.x += dx;
this.viewBBoxT.y += dy;
bufferLeft = (dx < 0) ? 1 : 0;
bufferRight = (dx > 0) ? 1 : 0;
bufferTop = (dy < 0) ? 1 : 0;
bufferBottom = (dy > 0) ? 1 : 0;
}
var xmin  = Math.floor(this.viewBBoxT.x / this.tileSize) - bufferLeft;
var xmax = Math.ceil((this.viewBBoxT.x+this.viewBBoxT.width) / this.tileSize) -1 + bufferRight;
var ymin  = Math.floor(this.viewBBoxT.y / this.tileSize) - bufferTop;
var ymax = Math.ceil((this.viewBBoxT.y+this.viewBBoxT.height)/ this.tileSize) -1 + bufferBottom;
if (xmin < 0) {
xmin = 0;
}
if (xmax >= this.countX) {
xmax = this.countX-1;
}
if (ymin < 0) {
ymin = 0;
}
if (ymax >= this.countY) {
ymax = this.countY-1;
}
this.tilesManager.setVisibleTiles(xmin, xmax, ymin, ymax, scale);
pivot.setLocation(Math.round(-this.viewBBoxT.x), Math.round(-this.viewBBoxT.y));
this.bboxListeners.notify(this);
if (! noUpdate) {
if (window.$ns$IlvSelectionManager) {
this.getSelectionManager().hideAll();
}
if (this.getDynamicLayer()) {
this.getDynamicLayer().setVisible(false);
}
this.update(false, true);
}
}
}
$ns$IlvTiledView.prototype.recenter = function() {
if (this.getHeight() == 0 || this.getWidth() == 0)
return;
var ratio = this.getWidth()/this.getHeight();
var a = (this.maxx - this.minx)/this.qbboxw;
var b = ((this.maxy - this.miny)/this.qbboxh);
var zooml = a > b? a: b;
if (zooml > this.maxZoom) {
if (a > b) {
var d = this.qbboxw - (this.maxx - this.minx)/this.maxZoom;
this.qbboxw = (this.maxx - this.minx)/this.maxZoom;
this.qbboxx += d/2;
d = this.qbboxh - this.qbboxw/ratio;
this.qbboxh = this.qbboxw/ratio;
this.qbboxy += d/2;
} else {
var d = this.qbboxh - (this.maxy - this.miny)/this.maxZoom;
this.qbboxh = (this.maxy - this.miny)/this.maxZoom;
this.qbboxy += d/2;
d = this.qbboxw - this.qbboxh*ratio;
this.qbboxw = this.qbboxh*ratio;
this.qbboxx += d/2;
}
}
if (this.qbboxx < this.minx)
this.qbboxx = this.minx;
if (this.qbboxy <  this.miny)
this.qbboxy = this.miny;
if (this.qbboxw >  this.maxx - this.minx)
this.qbboxw = this.maxx - this.minx;
if (this.qbboxh >  this.maxy - this.miny)
this.qbboxh = this.maxy - this.miny;
if (this.qbboxx + this.qbboxw >  this.maxx)
this.qbboxx = this.maxx - this.qbboxw;
if (this.qbboxy + this.qbboxh >  this.maxy)
this.qbboxy = this.maxy - this.qbboxh;
if (this.qbboxw < this.qbboxh *ratio) {
var dif = this.qbboxw - this.qbboxh*ratio;
this.qbboxw = this.qbboxh*ratio;
this.qbboxx += dif/2;
} else {
var dif = this.qbboxh - this.qbboxw/ratio;
this.qbboxh = this.qbboxw/ratio;
this.qbboxy += dif/2;
}
}
$ns$IlvTiledView.prototype.centerAt = function(x, y) {
this.setViewBBoxNoCheck(x - this.qbboxw/2, y - this.qbboxh/2,
this.qbboxw, this.qbboxh);
}
$ns$IlvTiledView.prototype.getManagerBBox = function() {
return {left:this.minx, top:this.miny, width:this.maxx - this.minx, height:this.maxy - this.miny};
}
$ns$IlvTiledView.prototype.stopPanAnimation = function() {
if (this.panTimer) {
clearTimeout(this.panTimer);
this.panAnimListeners.notify(this, false);
this.dLayer.setPanning(false);
}
}
$ns$IlvTiledView.prototype.createPanAnimation = function(destX, destY) {
if (this.panTimer) {
clearTimeout(this.panTimer);
}
var vBBox = this.getViewBBox();
var mBBox = this.getManagerBBox();
var dx = vBBox.left - destX;
var dy = vBBox.top - destY;
if ((dx == 0 && dy ==0) || isNaN(dx) || isNaN(dx)) {
this.panAnimListeners.notify(this, false);
return ;
}
var d = Math.sqrt(dx*dx + dy*dy);
var dMax = Math.sqrt(mBBox.width*mBBox.width +mBBox.height * mBBox.height);
var time = 3000 * d / dMax;
var stepTime = 50;
var curX = this.qbboxx;
var curY = this.qbboxy;
var dx = ((destX - curX) * stepTime) / time;
var dy = ((destY - curY) * stepTime) / time;
var step = 0;
var nbStep = Math.floor(time/stepTime);
this.dLayer.setPanning(true);
this.dLayer.setVisible(false);
if (window.$ns$IlvSelectionManager) {
this.getSelectionManager().hideAll();
}
var view = this;
this.panTimer = setTimeout(function(){view.panAnimation(destX,destY,dx,dy,step,nbStep,stepTime);}, stepTime);
}
$ns$IlvTiledView.prototype.panAnimation = function(fX, fY, dx, dy, step, nbSteps, stepTime) {
if (this.panTimer) {
clearTimeout(this.panTimer);
}
step++;
if (step < nbSteps) {
this.moveTo(this.qbboxx + dx, this.qbboxy + dy, true, true);
this.tilesManager.organizeTiles();
var view = this;
this.panTimer = setTimeout(function(){view.panAnimation(fX,fY,dx,dy,step,nbSteps,stepTime);}, stepTime);
} else {
this.moveTo(fX, fY, true, false);
this.update(false, false);
this.panAnimListeners.notify(this, true);
}
}
$ns$IlvTiledView.prototype.moveTo = function(x, y, noUpdate, animation) {
this.setViewBBoxNoCheck(x, y, this.qbboxw, this.qbboxh, false, noUpdate, animation);
}
$ns$IlvTiledView.prototype.panEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor, this.qbboxy);
}
$ns$IlvTiledView.prototype.panWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor, this.qbboxy);
}
$ns$IlvTiledView.prototype.panSouth = function() {
this.moveTo(this.qbboxx, this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.panNorth = function() {
this.moveTo(this.qbboxx, this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.panSouthEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor,
this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.panNorthEast = function() {
this.moveTo(this.qbboxx + this.qbboxw*this.panFactor,
this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.panSouthWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor,
this.qbboxy + this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.panNorthWest = function() {
this.moveTo(this.qbboxx - this.qbboxw*this.panFactor,
this.qbboxy - this.qbboxh*this.panFactor);
}
$ns$IlvTiledView.prototype.setPanFactor = function(factor) {
this.panFactor = factor;
}
$ns$IlvTiledView.prototype.getPanFactor = function() {
return this.panFactor;
}
$ns$IlvTiledView.prototype.setZoomFactor = function(factor) {
this.zoomFactor = factor;
}
$ns$IlvTiledView.prototype.getZoomFactor = function() {
return this.zoomFactor;
}
$ns$IlvTiledView.prototype.getNearestZoomLevel = function(zooml) {
var diff = Math.abs(zooml - this.zoomLevels[0]);
var index = 0;
for (var i=1; i<this.zoomLevels.length; i++) {
var diffC = Math.abs(zooml - this.zoomLevels[i]);
if (diffC < diff) {
diff = diffC;
index = i;
}
}
return index;
}
$ns$IlvTiledView.prototype.getCurrentFixedZoomLevel = function() {
var a = (this.maxx - this.minx)/this.qbboxw;
var b = ((this.maxy - this.miny)/this.qbboxh);
var  zooml = a > b? a: b;
var index = this.getNearestZoomLevel(zooml);
return {index:index, realValue:zooml,value:this.zoomLevels[index]};
}
$ns$IlvTiledView.prototype.applyZoomlevel = function(zoomLevel) {
var bbox = this.getViewBBox();
var managerBBox = this.getManagerBBox();
var zoom = Math.max(managerBBox.width/bbox.width,
managerBBox.height/bbox.height);
this.zoomByNoCheck(zoomLevel/zoom);
}
$ns$IlvTiledView.prototype.zoomIn = function() {
if (this.zoomLevels) {
var zoomLevel = this.getCurrentFixedZoomLevel();
var index = zoomLevel.index;
if(index+1 < this.zoomLevels.length) {
var zooml = this.zoomLevels[index+1];
this.applyZoomlevel(zooml);
}
} else {
this.zoomBy(this.zoomFactor);
}
}
$ns$IlvTiledView.prototype.zoomOut = function() {
if (this.zoomLevels) {
var zoomLevel = this.getCurrentFixedZoomLevel();
var index = zoomLevel.index;
if(index-1 >= 0) {
var zooml = this.zoomLevels[index-1];
this.applyZoomlevel(zooml);
}
} else {
this.zoomBy(1 / this.zoomFactor);
}
}
$ns$IlvTiledView.prototype.zoomBy = function(z) {
if (this.zoomLevels) {
var a = (this.maxx - this.minx)/this.qbboxw;
var b = ((this.maxy - this.miny)/this.qbboxh);
var  cZooml = a > b? a: b;
var zooml = z * cZooml;
var index = this.getNearestZoomLevel(zooml);
zooml = this.zoomLevels[index];
this.zoomByNoCheck(zooml/cZooml);
} else {
this.zoomByNoCheck(z);
}
}
$ns$IlvTiledView.prototype.zoomByNoCheck = function(z) {
this.setViewBBoxNoCheck(this.qbboxx + this.qbboxw*(1 - 1/z)/2,
this.qbboxy + this.qbboxh*(1 - 1/z)/2,
this.qbboxw/z, this.qbboxh/z, true);
}
$ns$IlvTiledView.prototype.getMaxZoomLevel = function() {
return this.maxZoom;
}
$ns$IlvTiledView.prototype.showAll = function() {
if (this.zoomLevels) {
var mBBox = this.getManagerBBox();
var zoomLevel = this.zoomLevels[0];
var qbbox = {};
qbbox.width = mBBox.width / zoomLevel;
qbbox.height = mBBox.height / zoomLevel;
var dif = mBBox.width - qbbox.width;
qbbox.left = mBBox.left + dif/2;
dif = mBBox.height - qbbox.height;
qbbox.top = mBBox.top + dif/2;
this.setViewBBoxNoCheck(qbbox.left, qbbox.top, qbbox.width, qbbox.height, true);
} else {
this.setViewBBoxNoCheck(this.minx,
this.miny,
this.maxx - this.minx,
this.maxy - this.miny,
true);
}
}
$ns$IlvTiledView.prototype.updateImage = function() {
this.setViewBBox(this.qbboxx,
this.qbboxy,
this.qbboxw,
this.qbboxh,
true);
}
$ns$IlvTiledView.prototype.updateAll = function(showAll, keepLayerVisibility, dynamicLayerRefresh) {
this.capabilitiesLoaded = false;
this.getCapabilities(false, showAll, keepLayerVisibility, dynamicLayerRefresh);
}
$ns$IlvTiledView.prototype.update = function(noFullUpdate, delayedDynLayer) {
if (this.dLayer) {
this.dLayer.update(noFullUpdate, delayedDynLayer);
}
this.tilesManager.organizeTiles(noFullUpdate);
if (this.isStateInCookie()) {
var request = this.getRequest();
setCookie(this.cookieName + 'url', unescape(request));
} else {
this.saveState(this);
}
}
$ns$IlvTiledView.prototype.againString = function() {
var date = new Date();
var str = date.toUTCString();
str = str + ' ' + date.getMilliseconds();
return escape(str);
}
$ns$IlvTiledView.prototype.getAdditionalParameters = function() {
return $ns$IlvRequestParameters.getRequestParameters(this.additionalParams);
}
$ns$IlvTiledView.prototype.setAdditionalParameters = function(key, value) {
$ns$IlvRequestParameters.setParameter(this.additionalParams, key, value);
}
$ns$IlvTiledView.prototype.removeAdditionalParameter = function(key) {
$ns$IlvRequestParameters.removeParameter(this.additionalParams, key);
}
$ns$IlvTiledView.prototype.setPopupMenu = function(popupMenu) {
this.popupMenu = popupMenu;
this.popupMenu.setViewInternal(this);
}
$ns$IlvTiledView.prototype.getSelectionManager = function () {
if (!this.selectManager) {
if (!window.$ns$IlvSelectionManager)
alert("You must import $ns$IlvAbstractSelectionManager.js and $ns$IlvSelectionManager.js scripts to use light selection.");
else {
this.selectManager = new $ns$IlvSelectionManager();
this.selectManager.setViewInternal(this);
}
}
return this.selectManager;
}
$ns$IlvTiledView.prototype.getPopupMenu = function() {
return this.popupMenu;
}
$ns$IlvTiledView.prototype.getZoomLevels = function() {
return this.zoomLevels;
}
$ns$IlvTiledView.prototype.setImageBackgroundColor = function(color) {
this.imgbgcolor = color;
this.container.setBackgroundColor(color);
}
$ns$IlvTiledView.prototype.getImageBackgroundColor = function() {
return this.imgbgcolor;
}
$ns$IlvTiledView.prototype.setWaitingImage = function(waitingImage) {
}
$ns$IlvTiledView.prototype.getWaitingImage = function() {
return null;
}
$ns$IlvTiledView.prototype.setUpdateInterval = function(rate) {
this.dLayer.setUpdateInterval(rate);
}
$ns$IlvTiledView.prototype.getUpdateInterval = function() {
return this.dLayer.getUpdateInterval();
}
$ns$IlvTiledView.prototype.getDynamicLayer = function() {
return this.dLayer;
}
$ns$IlvTiledView.prototype.isAutoUpdateCapabilities = function() {
return this.autoUpdateCapabilities;
}
$ns$IlvTiledView.prototype.setAutoUpdateCapabilities = function(set) {
this.autoUpdateCapabilities = set;
}
$ns$IlvTiledView.prototype.getContentsBounds = function () {
return this.getBounds();
}
