drop table statistics cascade;
CREATE  TABLE STATISTICS(SRC_ID BIGINT NOT NULL,DEST_ID BIGINT NOT NULL,TYPE SMALLINT,RRD_FILE VARCHAR(255),XML_FILE VARCHAR(255),CAPACITY BIGINT,AVG_RX DOUBLE PRECISION,AVG_TX DOUBLE PRECISION,TOTAL_RXTX DOUBLE PRECISION,MAX_RX DOUBLE PRECISION,MAX_TX DOUBLE PRECISION,TOTAL_ERR DOUBLE PRECISION,TOTAL_DISCARD DOUBLE PRECISION,LAST_WEEK_AVG_RX DOUBLE PRECISION,LAST_WEEK_AVG_TX DOUBLE PRECISION,LAST_WEEK_TOTAL_RXTX DOUBLE PRECISION,LAST_WEEK_MAX_RX DOUBLE PRECISION,LAST_WEEK_MAX_TX DOUBLE PRECISION,LAST_WEEK_TOTAL_ERR DOUBLE PRECISION,LAST_WEEK_TOTAL_DISCARD DOUBLE PRECISION,LAST_MONTH_AVG_RX DOUBLE PRECISION,LAST_MONTH_AVG_TX DOUBLE PRECISION,LAST_MONTH_TOTAL_RXTX DOUBLE PRECISION,LAST_MONTH_MAX_RX DOUBLE PRECISION,LAST_MONTH_MAX_TX DOUBLE PRECISION,LAST_MONTH_TOTAL_ERR DOUBLE PRECISION,LAST_MONTH_TOTAL_DISCARD DOUBLE PRECISION,LAST_YEAR_AVG_RX DOUBLE PRECISION,LAST_YEAR_AVG_TX DOUBLE PRECISION,LAST_YEAR_TOTAL_RXTX DOUBLE PRECISION,LAST_YEAR_MAX_RX DOUBLE PRECISION,LAST_YEAR_MAX_TX DOUBLE PRECISION,LAST_YEAR_TOTAL_ERR DOUBLE PRECISION,LAST_YEAR_TOTAL_DISCARD DOUBLE PRECISION,LAST_UPDATE_TIME TIMESTAMP,LAST_THRESHOLD_EVENT_TIME TIMESTAMP,THRESHOLD_EVENT_COUNT SMALLINT,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_STATISTICS PRIMARY KEY(SRC_ID,DEST_ID));
CREATE INDEX STATISTICS_DEST_ID ON STATISTICS(DEST_ID);
drop table switch cascade;

CREATE  TABLE SWITCH(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,LICENSE_ID BIGINT,WWN bytea,IP_ADDRESS bytea,IS_MDS BOOLEAN,TYPE INTEGER,IS_MANAGABLE BOOLEAN,UNMANAGABLE_CAUSE VARCHAR(255),NON_MDS_MODEL VARCHAR(255),SYS_NAME VARCHAR(255),SYS_CONTACT VARCHAR(255),SYS_LOCATION VARCHAR(255),SYS_UPTIME BIGINT,ACTIVE_SUP_SLOT INTEGER,STANDBY_SUP_STATE INTEGER,CONN_UNIT_STATUS INTEGER,FEATURE_FLAG INTEGER,FEATURES_STRING VARCHAR(255),IS_LICENSE_VIOLATION BOOLEAN,VERSION VARCHAR(255),IS_PRESENT BOOLEAN,SERIAL_NUMBER VARCHAR(255),NUM_PORTS INTEGER,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,IS_TRAP_REGISTERED BOOLEAN,IS_SYSLOG_REGISTERED BOOLEAN,SYS_DESCRIPTION VARCHAR(255),VENDOR VARCHAR(255),FCFE_MODULE_ID INTEGER,STANDBY_SUP_SLOT INTEGER,MODULE_INDEX_OFFSET INTEGER,OPER_MODE INTEGER,CPU_USAGE INTEGER,MEM_USAGE INTEGER,sign varchar(255),lic_details varchar(500),is_ech_support smallint default 1, is_vdc boolean, vdc_id integer, vdc_mac bytea, DEFAULT_VDC_MAC bytea, vdc_name varchar(255), fcoe_capable boolean, NUM_1G_PORT INTEGER, NUM_2G_PORT INTEGER, NUM_4G_PORT INTEGER, NUM_8G_PORT INTEGER, NUM_10G_PORT INTEGER, NUM_16G_PORT INTEGER, NUM_40G_PORT INTEGER, NUM_100G_PORT INTEGER, l_report boolean, PRIMARY_IP VARCHAR(255), SECONDARY_IP VARCHAR(255), RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX SWITCH_IP_INDEX ON SWITCH(IP_ADDRESS);
CREATE INDEX SWITCH_FABRIC_ID ON SWITCH(FABRIC_ID);
CREATE INDEX SWITCH_WWN_INDEX ON SWITCH(WWN);

drop table switch_port cascade;
CREATE  TABLE SWITCH_PORT(ID BIGINT NOT NULL PRIMARY KEY,IF_INDEX INTEGER,SWITCH_ID BIGINT,WWN bytea,FICON_PORT_ADDRESS bytea,FICON_ADDRESS INTEGER,IS_HUB BOOLEAN,IS_CHANNEL BOOLEAN,CHANNEL_ID BIGINT,LAST_UPDATE_TIME TIMESTAMP,STATUS SMALLINT,IS_SPAN BOOLEAN,PORT_GROUP INTEGER,SLOT SMALLINT,IF_SPEED BIGINT,IF_NAME VARCHAR(255),IF_TYPE INTEGER,PARENT INTEGER,SME_STATE INTEGER,IOA_STATE INTEGER,CLUSTER_ID VARCHAR(255),IF_CONNTYPE INTEGER,IF_DESCR VARCHAR(255),IS_VFC BOOLEAN, VFC_BIND_TYPE SMALLINT, VFC_BIND_IFINDEX INTEGER, VFC_BIND_MAC bytea, DISPLAY_NAME VARCHAR(255), IS_PHYSICAL BOOLEAN, IF_ADMINSTATUS SMALLINT, IF_OPERSTATUS INTEGER, IF_ALIAS VARCHAR(255), RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX SWITCH_PORT_SWITCH_ID_INDEX ON SWITCH_PORT(SWITCH_ID);
CREATE INDEX SWITCH_PORT_CHANNEL_ID_INDEX ON SWITCH_PORT(CHANNEL_ID);

drop table end_port cascade;
CREATE  TABLE END_PORT(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,ENCLOSURE_ID BIGINT,HBA_ID BIGINT,SWITCH_PORT_ID BIGINT,WWN bytea,NODE_WWN bytea,FICON_PORT_ADDRESS bytea,FLAGS INTEGER,SYM_PORT_NAME VARCHAR(255),SYM_NODE_NAME VARCHAR(255),PORT_IP_ADDR VARCHAR(255),ALIAS VARCHAR(255),IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,OPER_STATUS_CAUSE INTEGER,IF_NAME VARCHAR(255),IS_LOOP BOOLEAN,FC4_TYPES bytea,FC4_FEATURES INTEGER,NAME VARCHAR(255), VFC_BINDTO VARCHAR(255), SERVICE_PROFILE VARCHAR(255), RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX END_PORT_FABRIC_ID_INDEX ON END_PORT(FABRIC_ID);
CREATE INDEX END_PORT_ENCLOSURE_ID_INDEX ON END_PORT(ENCLOSURE_ID);
CREATE INDEX END_PORT_SWITCH_PORT_ID_INDEX ON END_PORT(SWITCH_PORT_ID);
CREATE INDEX END_PORT_WWN_INDEX ON END_PORT(WWN);
CREATE INDEX END_PORT_NODE_WWN_INDEX ON END_PORT(NODE_WWN);

drop table fabric cascade;
CREATE  TABLE FABRIC(ID BIGINT NOT NULL PRIMARY KEY,SEED_SWITCH_ID BIGINT,IVR_SEED_SWITCH_ID BIGINT,ALIAS_SEED_SWITCH_ID BIGINT,LICENSE_ID BIGINT,IVR_ENF_ZONESET_NAME VARCHAR(255),IVR_ENF_ZONESET_ACTIVATE_TIME BIGINT,IVR_ACTIVE_ZONESET_CHECKSUM bytea,POLLING_ENABLED BOOLEAN,POLLING_INTERVAL INTEGER,LAST_SCAN_TIME BIGINT,SNMP_RETRIES INTEGER,SNMP_TIMEOUT INTEGER,FMUSER_ID BIGINT,NAME VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,SAN_ID BIGINT,FID INTEGER,IS_PERSISTENT BOOLEAN,ON_DEMAND_POLL_FREQ INTEGER,IVR_TOPO_CFG_CHECKSUM bytea,IVR_TOPO_ACT_CHECKSUM bytea,IVR_TOPO_AFID_CFG_CHECKSUM bytea,IVR_TOPO_DEF_AFID_CHECKSUM bytea,IVR_TOPO_VALIDATED BOOLEAN,USE_GLOBAL_ALIAS BOOLEAN,DEVICE_ALIAS_SEED_ID BIGINT, IS_MANAGEABLE BOOLEAN,DEVICE_ALIAS_CHECKSUM bytea, VSANS_INCLUDED VARCHAR(255),  VSANS_EXCLUDED VARCHAR(255),RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX FABRIC_SEED_SWITCH_ID ON FABRIC(SEED_SWITCH_ID);
CREATE INDEX FABRIC_IVR_SEED_SWITCH_ID ON FABRIC(IVR_SEED_SWITCH_ID);
CREATE INDEX FABRIC_DEVICE_ALIAS_SEED_ID ON FABRIC(DEVICE_ALIAS_SEED_ID);

drop table isl cascade;
CREATE  TABLE ISL(ID BIGINT NOT NULL PRIMARY KEY,PORT1_ID BIGINT,PORT2_ID BIGINT,OPER_MODE SMALLINT,IS_PRESENT BOOLEAN,STATUS SMALLINT,OPER_STATUS_CAUSE INTEGER,OPER_STATUS_DESCRIPTION VARCHAR(521),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,CHANNEL_CONFIG_CHILD_COUNT INTEGER,CHANNEL_CURRENT_CHILD_COUNT INTEGER,AUTO_CREATED BOOLEAN,IS_CHANNELMEMBER BOOLEAN,CHANNEL_ID BIGINT,IF_INDEX_1 INTEGER,IF_INDEX_2 INTEGER,FICON_ADDRESS_1 INTEGER,FICON_ADDRESS_2 INTEGER,FCSP_AUTHENTICATED BOOLEAN,ESP_SECURED BOOLEAN,ESP_READY BOOLEAN,IS_FCIP BOOLEAN,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX ISL_P1_INDEX ON ISL(PORT1_ID);
CREATE INDEX ISL_P2_INDEX ON ISL(PORT2_ID);
CREATE INDEX ISL_CHANNELMEMBER ON ISL(IS_CHANNELMEMBER);

drop table npv_link cascade;
CREATE  TABLE NPV_LINK(ID BIGINT NOT NULL PRIMARY KEY,CORE_SWITCH_ID BIGINT,NP_SWITCH_ID BIGINT,F_PORT_INDEX INTEGER,NP_PORT_INDEX INTEGER,F_WWN bytea,NP_WWN bytea,OPER_STATUS_CAUSE INTEGER,SPEED BIGINT,IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,CHANNEL_CONFIG_CHILD_COUNT INTEGER,CHANNEL_CURRENT_CHILD_COUNT INTEGER,AUTO_CREATED BOOLEAN, IS_CHANNELMEMBER BOOLEAN, CHANNEL_ID BIGINT, RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX NPV_LINK_FP_INDEX ON NPV_LINK(F_PORT_INDEX);
CREATE INDEX NPV_LINK_NPP_INDEX ON NPV_LINK(NP_PORT_INDEX);

drop table vsan cascade;
CREATE  TABLE VSAN(ID BIGINT NOT NULL PRIMARY KEY,NAME VARCHAR(255),IS_UP BOOLEAN,IS_DISJOINT BOOLEAN,SEED_SWITCH_ID BIGINT,ENF_ZONESET_NAME VARCHAR(255),ENF_ZONESET_ACTIVATE_TIME BIGINT,FABRIC_ID BIGINT,VSAN_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,PRINCIPAL_SWWN bytea,FICON_STATE INTEGER,INTER_OPER_MODE INTEGER,PRINCIPAL_SW_ID BIGINT,ADMIN_STATE smallint,MTU INTEGER,LOAD_BALANCING_TYPE smallint,INORDER_DELIVERY BOOLEAN,NETWORK_DROP_LATENCY INTEGER,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX VSAN_FABRIC_VSAN_ID_INDEX ON VSAN(FABRIC_ID,VSAN_ID);
CREATE INDEX VSAN_VSAN_ID_INDEX ON VSAN(VSAN_ID);

drop table zone_member cascade;
CREATE  TABLE ZONE_MEMBER(ID BIGINT NOT NULL PRIMARY KEY,ZONE_ID BIGINT,TYPE INTEGER,MEMBER_ID bytea,LUN_ID bytea,LAST_UPDATE_TIME TIMESTAMP,IVR_VSAN_ID BIGINT,PORT_STATUS bytea,AFID INTEGER,CFS_REGION_ID BIGINT, ENDPORT_ID BIGINT, SWITCHPORT_ID BIGINT, NAME VARCHAR(255), SWITCH_INT VARCHAR(255), RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX ZONE_MEMBER_ZONEID_INDEX ON ZONE_MEMBER(ZONE_ID);
CREATE INDEX ZONE_MEMBER_MEMBERID_INDEX ON ZONE_MEMBER(MEMBER_ID);
CREATE INDEX ZONE_MEMBER_LUN_ID_INDEX ON ZONE_MEMBER(LUN_ID);
CREATE INDEX ZONE_MEMBER_CFS_REGION_ID_INDEX ON ZONE_MEMBER(CFS_REGION_ID);

drop table zone cascade;
CREATE  TABLE ZONE(ID BIGINT NOT NULL PRIMARY KEY,PARENT_ID BIGINT,IS_IVR BOOLEAN,ZONE_INDEX INTEGER,NAME VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,READ_ONLY BOOLEAN,QOS BOOLEAN,QOS_PRIORITY INTEGER,BROADCAST BOOLEAN,CFS_REGION_ID BIGINT, RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX ZONE_VSAN_INDEX ON ZONE(PARENT_ID);
CREATE INDEX ZONE_VSAN_IVR_INDEX ON ZONE(PARENT_ID, IS_IVR);
CREATE INDEX ZONE_CFS_INDEX ON ZONE(PARENT_ID, CFS_REGION_ID);

drop table vsan_domain_info cascade;
CREATE  TABLE VSAN_DOMAIN_INFO(VSAN_ID BIGINT NOT NULL,SWITCH_ID BIGINT NOT NULL,DOMAIN_ID SMALLINT,WWN bytea,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VSAN_DOMAIN_INFO PRIMARY KEY(VSAN_ID,SWITCH_ID));
CREATE INDEX VSAN_DOMAIN_VSAN_ID ON VSAN_DOMAIN_INFO(VSAN_ID);
CREATE INDEX VSAN_DOMAIN_SWITCH_ID ON VSAN_DOMAIN_INFO(SWITCH_ID);

drop table vsan_isl_info cascade;
CREATE  TABLE VSAN_ISL_INFO(VSAN_ID BIGINT NOT NULL,ISL_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VSAN_ISL_INFO PRIMARY KEY(VSAN_ID,ISL_ID));
CREATE INDEX VSAN_ISL_VSAN_ID ON VSAN_ISL_INFO(VSAN_ID);
CREATE INDEX VSAN_ISL_ISL_ID ON VSAN_ISL_INFO(ISL_ID);

drop table vsan_npvl_info cascade;
CREATE  TABLE VSAN_NPVL_INFO(VSAN_ID BIGINT NOT NULL,NPVL_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VSAN_NPVL_INFO PRIMARY KEY(VSAN_ID,NPVL_ID));
CREATE INDEX VSAN_NPVL_VSAN_ID ON VSAN_NPVL_INFO(VSAN_ID);
CREATE INDEX VSAN_NPVL_NPVL_ID ON VSAN_NPVL_INFO(NPVL_ID);

drop table vsan_endport_info cascade;
CREATE  TABLE VSAN_ENDPORT_INFO(VSAN_ID BIGINT NOT NULL,ENDPORT_ID BIGINT NOT NULL,FCID INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VSAN_ENDPORT_INFO PRIMARY KEY(VSAN_ID,ENDPORT_ID));
CREATE INDEX VSAN_ENDPORT_VSAN_ID ON VSAN_ENDPORT_INFO(VSAN_ID);
CREATE INDEX VSAN_ENDPORT_ENDPORT_ID ON VSAN_ENDPORT_INFO(ENDPORT_ID);

drop table cfs_region cascade;
CREATE  TABLE CFS_REGION(ID BIGINT NOT NULL PRIMARY KEY,REGION_ID INTEGER,IVR_SEED_SWITCH_ID BIGINT,ALIAS_SEED_SWITCH_ID BIGINT,IVR_ENF_ZONESET_NAME VARCHAR(255),IVR_ENF_ZONESET_ACTIVATE_TIME BIGINT,FABRIC_ID BIGINT,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX CFS_REGION_FABRIC_CFS_REGION_ID_INDEX ON CFS_REGION(FABRIC_ID,REGION_ID);
CREATE INDEX CFS_REGION_REGION_ID_INDEX ON CFS_REGION(REGION_ID);

drop table sequence cascade;
CREATE  TABLE SEQUENCE(ID SMALLINT NOT NULL PRIMARY KEY,VALUE BIGINT);

drop table clustersequence;
CREATE  TABLE CLUSTERSEQUENCE(ID SMALLINT NOT NULL,SERVER_ID SMALLINT NOT NULL, VALUE BIGINT, CONSTRAINT SYS_PK_CLUSTERSEQUENCE PRIMARY KEY(ID, SERVER_ID));
drop table LOGICSVR_FABRIC;
CREATE TABLE LOGICSVR_FABRIC(LSVR_ID SMALLINT NOT NULL,F_ID INTEGER NOT NULL,CONSTRAINT SYS_PK_LOGICSVR_FABRIC PRIMARY KEY(LSVR_ID, F_ID));
drop table PHYSICAL_LOGICSVR;
CREATE TABLE PHYSICAL_LOGICSVR(IP_ADDR bytea NOT NULL PRIMARY KEY,LSVR_ID SMALLINT NOT NULL,LAST_SCAN_TIME BIGINT,STATUS SMALLINT DEFAULT 2, LOCATION VARCHAR(255), UNIQUE(LSVR_ID));

drop table SVR_PROP;
CREATE TABLE SVR_PROP(KEY VARCHAR(255) PRIMARY KEY,VALUE VARCHAR(255));

drop table vcenter cascade;
CREATE TABLE VCENTER(ID BIGINT NOT NULL PRIMARY KEY,VC_ID INTEGER,SERVER_ID INTEGER DEFAULT 0,IP_ADDRESS bytea,USER_NAME VARCHAR(255),PASSWORD VARCHAR(255),DISCOVERY BOOLEAN, STATE BOOLEAN, STATUS_DESCRIPTION VARCHAR(255), LAST_SCAN_TIME BIGINT DEFAULT 0,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table host_cluster cascade;
CREATE TABLE HOST_CLUSTER(ID BIGINT NOT NULL PRIMARY KEY,NAME VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table enclosure cascade;
CREATE  TABLE ENCLOSURE(ID BIGINT NOT NULL PRIMARY KEY,VHOST_ID BIGINT,NAME VARCHAR(255),IS_VIRTUAL BOOLEAN,ENC_TYPE INTEGER,OS_INFO VARCHAR(255),IP_ADDRESS VARCHAR(255),DM_PATH VARCHAR(255),IS_VM_HOST BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT DEFAULT 0,SAN_ID BIGINT,VENDOR VARCHAR(255),MODEL VARCHAR(255),VERSION VARCHAR(255),SERVICE_PROFILE VARCHAR(255), SERVER_BLADE VARCHAR(255), RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX ENCL_NAME_INDEX ON ENCLOSURE(NAME);

drop table vhost cascade;
CREATE  TABLE VHOST(ID BIGINT NOT NULL PRIMARY KEY,VCENTER_ID BIGINT,CLUSTER_ID BIGINT,NAME VARCHAR(255),FULL_NAME VARCHAR(255),MOREF VARCHAR(255),MAC_ADDRESS VARCHAR(255),IP_ADDRESS VARCHAR(255),OS_INFO VARCHAR(255),VENDOR VARCHAR(255),MODEL VARCHAR(255),VERSION VARCHAR(255),MEMORY_SIZE BIGINT,CPUCOUNT INTEGER,CPU_SPEED_AVG BIGINT,HBAS VARCHAR(4000),MULTIPATH VARCHAR(255),ISCSI_NAMES VARCHAR(4000),ALIASES VARCHAR(255),CONN_STATE INTEGER,POWER_STATE INTEGER,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT DEFAULT 0,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table vm cascade;
CREATE TABLE VM(ID BIGINT NOT NULL PRIMARY KEY,VCENTER_ID BIGINT,VHOST_ID BIGINT,NAME VARCHAR(255),FULL_NAME VARCHAR(255),MOREF VARCHAR(255),MEMORY_SIZE BIGINT,CPUCOUNT INTEGER,OS_TYPE VARCHAR(255),DNS_NAME VARCHAR(255),IP_ADDRESS bytea,POWER_STATE INTEGER,HEART_BEAT_STATUS VARCHAR(255),DISK_READ_AVG FLOAT8,DISK_WRITE_AVG FLOAT8,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX VM_IP_INDEX ON VM(IP_ADDRESS);
CREATE INDEX VM_VHOST_ID ON VM(VHOST_ID);

drop table vnic cascade;
CREATE TABLE VNIC(ID BIGINT NOT NULL PRIMARY KEY,VCENTER_ID BIGINT,VM_ID BIGINT,PORT_GROUP VARCHAR(255),MAC VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX VNIC_MAC ON VNIC(MAC);
CREATE INDEX VNIC_VCENTER_ID ON VNIC(VCENTER_ID);

drop table vnic_ip_address;
CREATE  TABLE VNIC_IP_ADDRESS(VNIC_ID BIGINT NOT NULL,IP_ADDRESS VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP, PRIMARY KEY (VNIC_ID,IP_ADDRESS ));

drop table phynic cascade;
CREATE TABLE PHYNIC(ID BIGINT NOT NULL PRIMARY KEY,VCENTER_ID BIGINT,VHOST_ID BIGINT,MO_KEY VARCHAR(255),DEVICE VARCHAR(255),MAC VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX PHYNIC_MAC ON PHYNIC(MAC);
CREATE INDEX PHYNIC_VCENTER_ID ON PHYNIC(VCENTER_ID);

drop table vm_phynic_info cascade;
CREATE TABLE VM_PHYNIC_INFO(VM_ID BIGINT NOT NULL,PHYNIC_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VM_PHYNIC_INFO PRIMARY KEY(VM_ID,PHYNIC_ID));
CREATE INDEX VM_PHYNIC_VM_ID ON VM_PHYNIC_INFO(VM_ID);
CREATE INDEX VM_PHYNIC_PHYNIC_ID ON VM_PHYNIC_INFO(PHYNIC_ID);

drop table data_store cascade;
CREATE  TABLE DATA_STORE(ID BIGINT NOT NULL PRIMARY KEY,VCENTER_ID BIGINT,FABRIC_ID BIGINT, NODE_WWN bytea, PORT_WWN bytea, LUN_UUID VARCHAR(255),LUN INTEGER, SCSI_LUN VARCHAR(255), UUID VARCHAR(255), CANONICAL_NAME VARCHAR(255), URL VARCHAR(255), NAME VARCHAR(255), FREE_SPACE BIGINT,MAX_FILESIZE BIGINT,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME BIGINT,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table enc_datastore_info cascade;
CREATE  TABLE ENC_DATASTORE_INFO(ENCLOSURE_ID BIGINT NOT NULL,DATASTORE_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_ENC_DATASTORE_INFO PRIMARY KEY(ENCLOSURE_ID,DATASTORE_ID));
CREATE INDEX ENC_DATASTORE_ENCLOSURE_ID ON ENC_DATASTORE_INFO(ENCLOSURE_ID);
CREATE INDEX ENC_DATASTORE_DATASTORE_ID ON ENC_DATASTORE_INFO(DATASTORE_ID);

drop table vm_datastore_info cascade;
CREATE  TABLE VM_DATASTORE_INFO(VM_ID BIGINT NOT NULL,DATASTORE_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_VM_DATASTORE_INFO PRIMARY KEY(VM_ID,DATASTORE_ID));
CREATE INDEX VM_DATASTORE_VM_ID ON VM_DATASTORE_INFO(VM_ID);
CREATE INDEX VM_DATASTORE_DATASTORE_ID ON VM_DATASTORE_INFO(DATASTORE_ID);

drop table events cascade;
CREATE  TABLE EVENTS(EVENTID BIGINT NOT NULL PRIMARY KEY,FIRST_SEEN TIMESTAMP,LAST_SEEN TIMESTAMP,COUNT BIGINT default 0,SWITCH_TIME TIMESTAMP,TYPE INTEGER,FACILITY varchar(20),SEVERITY INTEGER,SOURCE VARCHAR(255) default '',DESCR VARCHAR(4000) default '',SYSLOGEVENT varchar(80),VSANID BIGINT default 0,DCID BIGINT,SWITCHID BIGINT, SRCID BIGINT,DESTID BIGINT,ENCLOSURE_ID BIGINT default -1,GROUP_ID BIGINT default -1,ACK SMALLINT default 0,DCTYPE SMALLINT default 0,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX EVENTS_SEVERITY_INDEX ON EVENTS(SEVERITY);
CREATE INDEX EVENTS_GROUP_INDEX ON EVENTS(GROUP_ID);

drop table accounting;
CREATE TABLE ACCOUNTING(EVENTID BIGINT NOT NULL PRIMARY KEY,FIRST_SEEN TIMESTAMP,LAST_SEEN TIMESTAMP,COUNT BIGINT default 0,SWITCH_TIME TIMESTAMP,FACILITY VARCHAR(20), SEVERITY INTEGER,SOURCE VARCHAR(256) default '',DESCR VARCHAR(4000) default '',SYSLOGEVENT VARCHAR(80),VSANID BIGINT default 0,DCID BIGINT, SWITCHID BIGINT, SRCID BIGINT,DESTID BIGINT,USER_NAME VARCHAR(256),GROUP_ID BIGINT default -1,ACK SMALLINT default 0,DCTYPE SMALLINT default 0,RESERVE_COL1 VARCHAR(256),RESERVE_COL2 VARCHAR(256) );
CREATE INDEX ACCOUNTING_SEVERITY_INDEX ON ACCOUNTING(SEVERITY);

CREATE TABLE DCNMUSER(ID BIGINT NOT NULL PRIMARY KEY,VERSION INTEGER,USERID VARCHAR(256)  NOT NULL,PASSWORD VARCHAR(256), ROLE VARCHAR(256), SALT INTEGER DEFAULT 0, UNIQUE (USERID));


drop table FAILED_ATTEMPTS cascade;
CREATE  TABLE FAILED_ATTEMPTS(USER_NAME VARCHAR(256), FAILED_ATTEMPT_TIME BIGINT, PRIMARY KEY(USER_NAME, FAILED_ATTEMPT_TIME));
CREATE INDEX FAILED_ATTEMPTS_INDEX ON FAILED_ATTEMPTS(USER_NAME);

drop table SNMPUSER cascade;
CREATE  TABLE SNMPUSER(ID BIGINT NOT NULL PRIMARY KEY,VERSION INTEGER,USER_NAME VARCHAR(255),AUTH_PASSWORD VARCHAR(255),PRIV_PASSWORD VARCHAR(255),AUTH_PROTOCOL INTEGER,PRIV_PROTOCOL INTEGER,SECURITY_NAME VARCHAR(255),ROLE_NAME VARCHAR(255),IS_LOGGING_IN BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table ROLE cascade;
CREATE  TABLE ROLE(ROLE_NAME VARCHAR(255) NOT NULL PRIMARY KEY, DESCRIPTION VARCHAR(255));

drop table ROLE_FABRIC_INFO cascade;
CREATE  TABLE ROLE_FABRIC_INFO(ROLE_NAME VARCHAR(255) NOT NULL, FABRIC_ID BIGINT NOT NULL, LAST_UPDATE_TIME timestamp, CONSTRAINT role_fabric PRIMARY KEY(role_name,fabric_id));

drop table USERFABRIC_INFO cascade;
drop table USERFABRIC cascade;
CREATE  TABLE USERFABRIC(FMUSER_NAME VARCHAR(255) NOT NULL,FABRIC_ID BIGINT NOT NULL,SNMPUSER_ID BIGINT,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255),CONSTRAINT SYS_PK_USERFABRIC PRIMARY KEY(FMUSER_NAME,FABRIC_ID));
CREATE INDEX USERFABRIC_INDEX ON USERFABRIC(FMUSER_NAME,FABRIC_ID);

drop table SCSI_TARGET;
CREATE  TABLE SCSI_TARGET(ID BIGINT NOT NULL PRIMARY KEY,WWN bytea,ENCLOSURE_ID BIGINT,DEV_TYPE INTEGER,VENDOR_ID VARCHAR(255),PRODUCT_ID VARCHAR(255),REV_LEVEL VARCHAR(255),OTHER_INFO bytea,IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,STATUS INTEGER,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table HBA cascade;
CREATE  TABLE HBA(ID BIGINT NOT NULL PRIMARY KEY,ENCLOSURE_ID BIGINT,HWWN bytea,NWWN bytea,TYPE SMALLINT,MANUFACTURER VARCHAR(255),SERIAL_NUMBER VARCHAR(255),MODEL VARCHAR(255),MODEL_DESCRIPTION VARCHAR(255),HW_VERSION VARCHAR(255),SW_VERSION VARCHAR(255),DRIVER_VERSION VARCHAR(255),OPT_ROM_VERSION VARCHAR(255),OS VARCHAR(255),IP_ADDRESS VARCHAR(255),IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,STATUS INTEGER,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX HBA_ENCLOSURE_ID_INDEX ON HBA(ENCLOSURE_ID);
CREATE INDEX HBA_HWWN_INDEX ON HBA(HWWN);
CREATE INDEX HBA_NWWN_INDEX ON HBA(NWWN);

drop table FICON_INFO cascade;
CREATE  TABLE FICON_INFO(ID BIGINT NOT NULL PRIMARY KEY,VENDOR VARCHAR(255),TYPE_NUM VARCHAR(255),MODEL_NUM VARCHAR(255),SERIAL_NUM VARCHAR(255),PORT_ID VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX FICON_PORT_ID_INDEX ON FICON_INFO(PORT_ID);

drop table LICENSE cascade;
CREATE  TABLE LICENSE(ID BIGINT NOT NULL PRIMARY KEY,SWITCH_ID BIGINT,FEATURE_NAME VARCHAR(255),TYPE INTEGER,LICENSE_FLAG bytea,MAX_LICENSE INTEGER,MISSING_LICENSE INTEGER,CURRENT_LICENSE INTEGER,EXPIRE BIGINT DEFAULT -1,GRACE_PERIOD INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX LICENSE_SWITCH_ID_INDEX ON LICENSE(SWITCH_ID);

drop table SNMP_COMMUNITY cascade;
CREATE  TABLE SNMP_COMMUNITY(ID BIGINT NOT NULL PRIMARY KEY,IP_ADDRESS VARCHAR(255) NOT NULL,READ VARCHAR(255),WRITE VARCHAR(255),RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));

drop table SPAN_PORT cascade;
CREATE  TABLE SPAN_PORT(ID BIGINT NOT NULL PRIMARY KEY,IF_INDEX INTEGER,SWITCH_ID BIGINT,LAST_SCAN_TIME BIGINT,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANPORT_SWITCH_ID_INDEX ON SPAN_PORT(SWITCH_ID);
CREATE INDEX SPANPORT_IFINDEX_INDEX ON SPAN_PORT(IF_INDEX);

drop table SPAN_SESSION cascade;
CREATE  TABLE SPAN_SESSION(ID BIGINT NOT NULL PRIMARY KEY,SESSION_ID INTEGER,SPAN_PORT_ID BIGINT,OPER_STATUS INTEGER,VSAN_FILTER VARCHAR(255),VSAN_SOURCE VARCHAR(255),LAST_SCAN_TIME BIGINT,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANSESSION_SPANPORT_ID_INDEX ON SPAN_SESSION(SPAN_PORT_ID);
CREATE INDEX SPANSESSION_SESSION_ID_INDEX ON SPAN_SESSION(SESSION_ID);

drop table SPAN_SOURCE_PORT cascade;
CREATE  TABLE SPAN_SOURCE_PORT(ID BIGINT NOT NULL PRIMARY KEY,IF_INDEX INTEGER,DIRECTION INTEGER,SESSION_ID BIGINT,LAST_SCAN_TIME BIGINT,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANSOURCEPORT_IFINDEX_INDEX ON SPAN_SOURCE_PORT(IF_INDEX);
CREATE INDEX SPANSOURCEPORT_SESSION_ID_INDEX ON SPAN_SOURCE_PORT(SESSION_ID);

drop table NTOP cascade;
CREATE  TABLE NTOP(ID BIGINT NOT NULL PRIMARY KEY,IP_ADDR VARCHAR(255),PORT_NUMBER INTEGER,LAST_SCAN_TIME BIGINT,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX NTOP_IP_INDEX ON NTOP(IP_ADDR);
CREATE INDEX NTOP_PORT_INDEX ON NTOP(PORT_NUMBER);

drop table NTOP_SPAN_INFO cascade;
CREATE  TABLE NTOP_SPAN_INFO(ID BIGINT NOT NULL PRIMARY KEY,NTOP_ID BIGINT,SPAN_PORT_ID BIGINT,ETH_NAME VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX NTOP_SPAN_NTOPID_INDEX ON NTOP_SPAN_INFO(NTOP_ID);
CREATE INDEX NTOP_SPAN_SPANID_INDEX ON NTOP_SPAN_INFO(SPAN_PORT_ID);

drop table PM_COLLECTION cascade;
CREATE  TABLE PM_COLLECTION(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,VSAN_LIST VARCHAR(255),MONITOR_ISL BOOLEAN,MONITOR_HOST BOOLEAN,MONITOR_STORAGE BOOLEAN,MONITOR_FLOW BOOLEAN,MONITOR_GIGE BOOLEAN,MONITOR_OTHER BOOLEAN,TRAFFIC_THRESHOLD_ENABLE BOOLEAN,EVENT_THRESHOLD BOOLEAN,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX PM_POLICY_FABRIC_ID_INDEX ON PM_COLLECTION(FABRIC_ID);

drop table PM_OPTION cascade;
CREATE  TABLE PM_OPTION(ID BIGINT NOT NULL PRIMARY KEY,AUTO_COLLECT_NEW_DEVICE BOOLEAN,INTERPOLATION BOOLEAN,THRESHOLD_TYPE INTEGER,CRITICAL_WATERMARK INTEGER,WARNING_WATERMARK INTEGER,BASELINE_PERIOD INTEGER,LAST_UPDATE_TIME TIMESTAMP,FIVE_MIN_SAMPLE_DAYS INTEGER DEFAULT 600,THIRTY_MIN_SAMPLE_DAYS INTEGER DEFAULT 700,TWO_HOUR_SAMPLE_DAYS INTEGER DEFAULT 775,DAILY_SAMPLE_DAYS INTEGER DEFAULT 300,ISL_INTERVAL INTEGER DEFAULT 300, COLLECT_LAN_ISL BOOLEAN, COLLECT_LAN_FEX BOOLEAN, COLLECT_LAN_OTHER BOOLEAN, COLLECT_LAN_ERROR BOOLEAN, THRESHOLD_ISL_ONLY BOOLEAN);

drop table EVENT_FORWARD cascade;
CREATE  TABLE EVENT_FORWARD(ID BIGINT NOT NULL PRIMARY KEY,TYPE INTEGER,FID BIGINT,VSAN_SCOPE VARCHAR(255),SEVERITY INTEGER,ADDRESS VARCHAR(255),EVENTTYPE INTEGER,SUBTYPE INTEGER default -1,LAST_UPDATE_TIME TIMESTAMP,GID BIGINT default -1,ISLAN SMALLINT default 0, facility VARCHAR(255) default '', sysType VARCHAR(255) default '', desRegx VARCHAR(255) default '', PGID INTEGER DEFAULT -1);

drop table NAV_GROUPS cascade;
CREATE  TABLE NAV_GROUPS(ID BIGINT NOT NULL PRIMARY KEY,NAME VARCHAR(255),TYPE INTEGER);
CREATE INDEX NAV_GROUPS_ID_INDEX ON NAV_GROUPS(ID);
drop table NAV_GROUP_MEMBER cascade;
CREATE  TABLE NAV_GROUP_MEMBER(ID BIGINT NOT NULL PRIMARY KEY,MEM_DBID BIGINT,MEM_NAME VARCHAR(255),TYPE INTEGER, GROUP_ID BIGINT);
CREATE INDEX NAV_GROUP_MEMBER_ID_INDEX ON NAV_GROUP_MEMBER(ID);

drop table APP_GROUPS cascade;
CREATE  TABLE APP_GROUPS(ID BIGINT NOT NULL PRIMARY KEY,NAME VARCHAR(255));
CREATE INDEX APP_GROUPS_ID_INDEX ON APP_GROUPS(ID);
drop table APP_GROUP_MEMBER cascade;
CREATE  TABLE APP_GROUP_MEMBER(ID BIGINT NOT NULL PRIMARY KEY,SWITCH_ID BIGINT,IF_ID BIGINT,TYPE INTEGER, 
												GROUP_ID BIGINT REFERENCES APP_GROUPS ON DELETE CASCADE);
CREATE INDEX APP_GROUP_MEMBER_ID_INDEX ON APP_GROUP_MEMBER(ID);

drop table PM_BUFFER_COUNT cascade;
CREATE TABLE PM_BUFFER_COUNT (UPDATE_TIME TIMESTAMP,
							SWITCH_ID BIGINT, IF_INDEX INTEGER,COUNT INTEGER);

drop table CAPACITY_TIME cascade;
CREATE TABLE CAPACITY_TIME (ID BIGINT NOT NULL PRIMARY KEY, UPDATE_DATE TIMESTAMP, UPDATE_YEAR INTEGER,
							DAY_OF_YEAR INTEGER, DAY_OF_MONTH INTEGER,WEEK_OF_YEAR INTEGER,
							MONTH_OF_YEAR INTEGER, QUARTER INTEGER);
CREATE INDEX CAPACITY_TIME_ID_INDEX ON CAPACITY_TIME(ID);

drop table CAPACITY_DATA cascade;
CREATE TABLE CAPACITY_DATA (TIME_ID BIGINT NOT NULL, FABRIC_ID BIGINT, SWITCH_ID BIGINT,
							AVAIL_1G INTEGER, TOTAL_1G INTEGER,
							AVAIL_2G INTEGER, TOTAL_2G INTEGER,
							AVAIL_4G INTEGER, TOTAL_4G INTEGER,
							AVAIL_8G INTEGER, TOTAL_8G INTEGER,
							AVAIL_10G INTEGER, TOTAL_10G INTEGER,
							AVAIL_16G INTEGER, TOTAL_16G INTEGER,
							AVAIL_40G INTEGER, TOTAL_40G INTEGER,
							AVAIL_100G INTEGER, TOTAL_100G INTEGER,
							AVAIL_NA INTEGER, TOTAL_NA INTEGER, HEALTH FLOAT8, EVENTS BIGINT);
drop table CAPACITY_DATA_SMIS cascade;
CREATE TABLE CAPACITY_DATA_SMIS (TIME_ID BIGINT NOT NULL, SYSTEM_ID BIGINT, POOL_ID BIGINT,
							RAW_CAPACITY BIGINT, REMAINING_RAW_CAPACITY BIGINT,
							TOTAL_MANAGED BIGINT, REMAINING_MANAGED BIGINT);
			
drop table CAPACITY_DATA_SMIS_LUN cascade;
CREATE TABLE CAPACITY_DATA_SMIS_LUN (TIME_ID BIGINT NOT NULL, SYSTEM_ID BIGINT, LUN_ID BIGINT,
							TOTAL_MANAGED BIGINT, REMAINING_MANAGED BIGINT);
							
drop table GROUPS cascade;
CREATE  TABLE GROUPS(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,NAME VARCHAR(255),TYPE INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX GROUP_ID_INDEX ON GROUPS(ID);
CREATE UNIQUE INDEX GROUP_FABRICID_NAME_INDEX ON GROUPS(FABRIC_ID,NAME);

drop table GROUP_FABRIC_INFO cascade;
CREATE  TABLE GROUP_FABRIC_INFO(GROUP_ID BIGINT NOT NULL,FABRIC_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_FABRIC_INFO PRIMARY KEY(GROUP_ID,FABRIC_ID));
CREATE INDEX GROUP_FABRIC_GROUP_ID ON GROUP_FABRIC_INFO(GROUP_ID);
CREATE INDEX GROUP_FABRIC_FABRIC_ID ON GROUP_FABRIC_INFO(FABRIC_ID);

drop table GROUP_MEMBER_INFO cascade;
CREATE  TABLE GROUP_MEMBER_INFO(GROUP_ID BIGINT NOT NULL,MEMBER_ID BIGINT NOT NULL,TYPE INTEGER,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_MEMBER_INFO PRIMARY KEY(GROUP_ID,MEMBER_ID));
CREATE INDEX GROUP_MEMBER_GROUP_ID ON GROUP_MEMBER_INFO(GROUP_ID);
CREATE INDEX GROUP_MEMBER_MEMBER_ID ON GROUP_MEMBER_INFO(MEMBER_ID);

drop table GROUP_USER_INFO cascade;
CREATE  TABLE GROUP_USER_INFO(GROUP_ID BIGINT NOT NULL,FMUSER_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_USER_INFO PRIMARY KEY(GROUP_ID,FMUSER_ID));
CREATE INDEX GROUP_USER_GROUP_ID ON GROUP_USER_INFO(GROUP_ID);
CREATE INDEX GROUP_USER_FMUSER_ID ON GROUP_USER_INFO(FMUSER_ID);

drop table HW_COMPONENT cascade;
CREATE  TABLE HW_COMPONENT(ID BIGINT NOT NULL PRIMARY KEY,SWITCH_ID BIGINT,NAME VARCHAR(255),PHYSICAL_INDEX INTEGER,RELATIVE_POSITION INTEGER,HW_TYPE INTEGER,VENDOR_TYPE bytea,HW_REVISION VARCHAR(255),FW_REVISION VARCHAR(255),SW_REVISION VARCHAR(255),SERIAL_NUMBER VARCHAR(255),MANUFACTURER VARCHAR(255),MODEL_NAME VARCHAR(255),ASSET_ID VARCHAR(255),STATUS_DESCRIPTION VARCHAR(255),SEC_SERIAL_NUMBER VARCHAR(255),LAST_SCAN_TIME BIGINT,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX HW_COMPONENT_ID_INDEX ON HW_COMPONENT(ID);
CREATE INDEX HW_COMPONENT_SWITCH_ID ON HW_COMPONENT(SWITCH_ID);

drop table HW_CARD cascade;
CREATE  TABLE HW_CARD(HW_COMPONENT_ID BIGINT NOT NULL PRIMARY KEY,MODEL_TYPE INTEGER,ADMIN_STATUS INTEGER,OPER_STATUS INTEGER,RESET_REASON VARCHAR(255),STATUS_LAST_CHANGE_TIME BIGINT,POWER_ADMIN_STATUS INTEGER,POWER_OPER_STATUS INTEGER,POWER_CURRENT INTEGER,DMM_STATE INTEGER,IOA_STATE INTEGER,SE_STATE INTEGER,SANTAP_STATE INTEGER);

drop table HW_POWER_SUPPLY cascade;
CREATE  TABLE HW_POWER_SUPPLY(HW_COMPONENT_ID BIGINT NOT NULL PRIMARY KEY,REDUNDANCY_MODE INTEGER,TOTAL_DRAWN_CURRENT INTEGER,TOTAL_AVAILABLE_CURRENT INTEGER,POWER_UNITS VARCHAR(255));

drop table SWITCH_MGMT_ADDRESS;
CREATE  TABLE SWITCH_MGMT_ADDRESS(SWITCH_ID BIGINT NOT NULL,MGMT_ADDRESS bytea,MGMT_TYPE smallint,LAST_UPDATE_TIME TIMESTAMP, PRIMARY KEY (SWITCH_ID,MGMT_ADDRESS ));

drop table PM_EXTRAOID cascade;
CREATE  TABLE PM_EXTRAOID(ID BIGINT NOT NULL PRIMARY KEY,FID BIGINT,NAME VARCHAR(255),DISPLAYNAME VARCHAR(255),SWITCHIP VARCHAR(255),TYPE VARCHAR(255),SWITCHNAME VARCHAR(255),SWITCHID BIGINT);
CREATE INDEX PM_EXTRAOID_FABRIC_ID_INDEX ON PM_EXTRAOID(FID);

drop table PM_DATAINDEX cascade;
CREATE  TABLE PM_DATAINDEX(ID BIGINT NOT NULL PRIMARY KEY,LOGICALFILENAME VARCHAR(255),FILETYPE INTEGER,DATAINDEX INTEGER,PHYSICALFILEINDEX INTEGER);
CREATE INDEX PM_DATAINDEX_LOGICALFILE_INDEX ON PM_DATAINDEX(LOGICALFILENAME);

drop table PM_INDEXBOOKMARK cascade;
CREATE  TABLE PM_INDEXBOOKMARK(TYPE BIGINT NOT NULL,BOOKMARKINDEX INTEGER,BOOKMARKCOUNT INTEGER,SERVERID INTEGER, PRIMARY KEY(TYPE, SERVERID));
CREATE INDEX PM_INDEXBOOKMARK_INDEX ON PM_INDEXBOOKMARK(TYPE);

drop table DEVICE_ALIAS cascade;
CREATE  TABLE DEVICE_ALIAS(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,CFS_REGION_ID BIGINT,WWN bytea,ALIAS VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX DEVALIAS_FABRIC_ID ON DEVICE_ALIAS(FABRIC_ID);
CREATE INDEX DEVALIAS_CFS_REGION_ID ON DEVICE_ALIAS(CFS_REGION_ID);
CREATE INDEX DEVALIAS_WWN_INDEX ON DEVICE_ALIAS(WWN);

drop table FC_ALIAS cascade;
CREATE  TABLE FC_ALIAS(ID BIGINT NOT NULL PRIMARY KEY,VSAN_ID BIGINT,WWN bytea,ALIAS VARCHAR(255),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX FCALIAS_VSAN_ID ON FC_ALIAS(VSAN_ID);
CREATE INDEX FCALIAS_WWN_INDEX ON FC_ALIAS(WWN);

drop table XMLDOCS cascade;
CREATE TABLE XMLDOCS (
                DOCUMENT_NAME     TEXT, 
                USER_NAME         TEXT, 
                CONTENT         BYTEA,
                CHECKSUM        BIGINT,
                LAST_UPDATE_TIME TIMESTAMP,
             FILESIZE        BIGINT,
                UNIQUE (DOCUMENT_NAME,USER_NAME)
                );
drop table config_file cascade;
CREATE TABLE config_file (
                DOCUMENT_NAME     TEXT, 
                USER_NAME         TEXT, 
                CONTENT         BYTEA,
                CHECKSUM        BIGINT,                LAST_UPDATE_TIME TIMESTAMP,
             FILESIZE        BIGINT,
                UNIQUE (DOCUMENT_NAME,USER_NAME)
                );
drop table client_files cascade;
CREATE TABLE client_files (
                DOCUMENT_NAME     TEXT, 
                USER_NAME         TEXT, 
                CONTENT         BYTEA,
                CHECKSUM        BIGINT,                LAST_UPDATE_TIME TIMESTAMP,
             FILESIZE        BIGINT,
                UNIQUE (DOCUMENT_NAME,USER_NAME)
                );
drop table fm_session;
CREATE TABLE fm_session(
    ID  BIGINT NOT NULL,
    SERVER_ID  BIGINT NOT NULL,
    CLIENT VARCHAR(80) NOT NULL,
    IS_LOCAL BOOLEAN NOT NULL,
    USER_NAME VARCHAR(80) NOT NULL,
    AUTH_PASSWORD VARCHAR(80) NOT NULL,    
    ROLE_NAME VARCHAR(80) NOT NULL,
    LOGIN_TIME TIMESTAMP NOT NULL,
    LAST_ACCESS_TIME TIMESTAMP NOT NULL,
    PRIMARY KEY(ID, SERVER_ID)
);

drop table file_lic;
CREATE TABLE file_lic(
    sign varchar(255) PRIMARY KEY,
    details varchar(4000) NOT NULL
);

drop table host_redundancy_errors;
CREATE TABLE host_redundancy_errors(
	lsvr_id smallint NOT NULL,
	host_enclosure_id BIGINT NOT NULL,
	storage_enclosure_id BIGINT default -1,
	storage_str VARCHAR(255) default NULL,
	severity INTEGER NOT NULL,
	error_id INTEGER NOT NULL,
	first_seen TIMESTAMP NOT NULL,
	CONSTRAINT host_redundancy_events_pkey PRIMARY KEY (lsvr_id, host_enclosure_id, storage_enclosure_id)
);

drop table host_redundancy_ignored_host;
CREATE TABLE host_redundancy_ignored_host(
	host_enclosure_id BIGINT NOT NULL PRIMARY KEY,
	type smallint NOT NULL,
	reason VARCHAR(4000) default ''
);

drop table host_redundancy_Summary;
CREATE TABLE host_redundancy_Summary(
	title VARCHAR(255) NOT NULL PRIMARY KEY,
	summary_type smallint NOT NULL,
	count Integer NOT NULL,
	filter_type smallint NOT NULL ,
	last_update_time timestamp
);

drop table SMECLUSTER cascade;
CREATE TABLE SMECLUSTER(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,CLUSTER_ID VARCHAR(255),NAME VARCHAR(255),STATE INTEGER,IS_MASTER BOOLEAN,MASTER_ADDR_TYPE INTEGER, MASTER_ADDR VARCHAR(255), MASTER_IP VARCHAR(255), SWITCH_ID BIGINT,IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX CLUSTER_FABRIC_ID ON SMECLUSTER(FABRIC_ID);
CREATE INDEX CLUSTER_SWITCH_ID ON SMECLUSTER(SWITCH_ID);


drop table BASE_SVC_CLUSTER cascade;
CREATE TABLE BASE_SVC_CLUSTER(ID BIGINT NOT NULL PRIMARY KEY,FABRIC_ID BIGINT,CLUSTER_ID VARCHAR(255),NAME VARCHAR(255), CLUSTER_TYPE INTEGER, STATE INTEGER,IS_MASTER BOOLEAN,MASTER_ADDR_TYPE INTEGER, MASTER_ADDR VARCHAR(255), MASTER_IP VARCHAR(255), SWITCH_ID BIGINT,IS_PRESENT BOOLEAN,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR(255),RESERVE_COL2 VARCHAR(255));
CREATE INDEX BASE_SVC_CLUSTER_FABRIC_ID ON BASE_SVC_CLUSTER(FABRIC_ID);
CREATE INDEX BASE_SVC_CLUSTER_SWITCH_ID ON BASE_SVC_CLUSTER(SWITCH_ID);




drop TABLE qrtz_job_details cascade;
CREATE TABLE qrtz_job_details
  (
    JOB_NAME  VARCHAR(256) NOT NULL,
    JOB_GROUP VARCHAR(80) NOT NULL,
    DESCRIPTION VARCHAR(120) NULL,
    JOB_CLASS_NAME   VARCHAR(128) NOT NULL, 
    IS_DURABLE BOOL NOT NULL,
    IS_VOLATILE BOOL NOT NULL,
    IS_STATEFUL BOOL NOT NULL,
    REQUESTS_RECOVERY BOOL NOT NULL,
    JOB_DATA BYTEA NULL,
    PRIMARY KEY (JOB_NAME,JOB_GROUP)
);
drop TABLE qrtz_job_listeners cascade;
CREATE TABLE qrtz_job_listeners
  (
    JOB_NAME  VARCHAR(256) NOT NULL, 
    JOB_GROUP VARCHAR(80) NOT NULL,
    JOB_LISTENER VARCHAR(80) NOT NULL,
    PRIMARY KEY (JOB_NAME,JOB_GROUP,JOB_LISTENER),
    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
    REFERENCES QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP) 
);
drop TABLE qrtz_triggers cascade;
CREATE TABLE qrtz_triggers
  (
    TRIGGER_NAME VARCHAR(256) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    JOB_NAME  VARCHAR(256) NOT NULL, 
    JOB_GROUP VARCHAR(80) NOT NULL,
    IS_VOLATILE BOOL NOT NULL,
    DESCRIPTION VARCHAR(120) NULL,
    NEXT_FIRE_TIME BIGINT NULL,
    PREV_FIRE_TIME BIGINT NULL,
    TRIGGER_STATE VARCHAR(16) NOT NULL,
    TRIGGER_TYPE VARCHAR(8) NOT NULL,
    START_TIME BIGINT NOT NULL,
    END_TIME BIGINT NULL,
    CALENDAR_NAME VARCHAR(80) NULL,
    MISFIRE_INSTR SMALLINT NULL,
    JOB_DATA BYTEA NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
    REFERENCES QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP) 
);
drop TABLE qrtz_simple_triggers cascade;
CREATE TABLE qrtz_simple_triggers
  (
    TRIGGER_NAME VARCHAR(256) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    REPEAT_COUNT BIGINT NOT NULL,
    REPEAT_INTERVAL BIGINT NOT NULL,
    TIMES_TRIGGERED BIGINT NOT NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop TABLE qrtz_cron_triggers cascade;
CREATE TABLE qrtz_cron_triggers
  (
    TRIGGER_NAME VARCHAR(256) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    CRON_EXPRESSION VARCHAR(80) NOT NULL,
    TIME_ZONE_ID VARCHAR(80),
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop TABLE qrtz_blob_triggers cascade;
CREATE TABLE qrtz_blob_triggers
  (
    TRIGGER_NAME VARCHAR(256) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    BLOB_DATA BYTEA NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
        REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop TABLE qrtz_trigger_listeners cascade;
CREATE TABLE qrtz_trigger_listeners
  (
    TRIGGER_NAME  VARCHAR(256) NOT NULL, 
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    TRIGGER_LISTENER VARCHAR(80) NOT NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);

drop TABLE qrtz_calendars cascade;
CREATE TABLE qrtz_calendars
  (
    CALENDAR_NAME  VARCHAR(80) NOT NULL, 
    CALENDAR BYTEA NOT NULL,
    PRIMARY KEY (CALENDAR_NAME)
);

drop TABLE qrtz_paused_trigger_grps cascade;
CREATE TABLE qrtz_paused_trigger_grps
  (
    TRIGGER_GROUP  VARCHAR(80) NOT NULL, 
    PRIMARY KEY (TRIGGER_GROUP)
);
drop TABLE qrtz_fired_triggers cascade; 
CREATE TABLE qrtz_fired_triggers 
  (
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(256) NOT NULL,
    TRIGGER_GROUP VARCHAR(80) NOT NULL,
    IS_VOLATILE BOOL NOT NULL,
    INSTANCE_NAME VARCHAR(256) NOT NULL,
    FIRED_TIME BIGINT NOT NULL,
    STATE VARCHAR(16) NOT NULL,
    JOB_NAME VARCHAR(256) NULL,
    JOB_GROUP VARCHAR(80) NULL,
    IS_STATEFUL BOOL NULL,
    REQUESTS_RECOVERY BOOL NULL,
    PRIMARY KEY (ENTRY_ID)
);
drop TABLE qrtz_scheduler_state cascade; 
CREATE TABLE qrtz_scheduler_state 
  (
    INSTANCE_NAME VARCHAR(256) NOT NULL,
    LAST_CHECKIN_TIME BIGINT NOT NULL,
    CHECKIN_INTERVAL BIGINT NOT NULL,
    RECOVERER VARCHAR(80) NULL,
    PRIMARY KEY (INSTANCE_NAME)
);
DROP TABLE QRTZ_LOCKS cascade;
CREATE TABLE qrtz_locks
  (
    LOCK_NAME  VARCHAR(40) NOT NULL, 
    PRIMARY KEY (LOCK_NAME)
);


INSERT INTO qrtz_locks values('TRIGGER_ACCESS');
INSERT INTO qrtz_locks values('JOB_ACCESS');
INSERT INTO qrtz_locks values('CALENDAR_ACCESS');
INSERT INTO qrtz_locks values('STATE_ACCESS');
INSERT INTO qrtz_locks values('MISFIRE_ACCESS');
INSERT into PM_OPTION (ID, AUTO_COLLECT_NEW_DEVICE,INTERPOLATION,THRESHOLD_TYPE,CRITICAL_WATERMARK, 
WARNING_WATERMARK, BASELINE_PERIOD,  FIVE_MIN_SAMPLE_DAYS, THIRTY_MIN_SAMPLE_DAYS, 
TWO_HOUR_SAMPLE_DAYS, DAILY_SAMPLE_DAYS, ISL_INTERVAL, COLLECT_LAN_ISL, COLLECT_LAN_FEX, COLLECT_LAN_OTHER, COLLECT_LAN_ERROR, THRESHOLD_ISL_ONLY ) 
values (1,true,false,0,80,
60, 7,  600,700, 775, 300,300,true,false,false,false,true);

INSERT INTO nav_groups values(1, 'Default_SAN',2);
INSERT INTO nav_groups values(2, 'Default_LAN',1);

CREATE TABLE SME_SETTINGS(
    NAME VARCHAR(64) NOT NULL, 
    VALUE VARCHAR(64), 
    CONSTRAINT SME_SETTINGS_PKEY PRIMARY KEY (NAME)
);

CREATE TABLE SME_CLUSTER(
    CLUSTER_NAME VARCHAR(64) NOT NULL, 
    CLUSTER_ID VARCHAR(64), 
    STATUS BIGINT, 
    CKMC_STATE BIGINT,
    MASTER_IP_ADDR VARCHAR(32),
    KMC_ID VARCHAR(32),
    CONSTRAINT SME_CLUSTER_PKEY PRIMARY KEY (CLUSTER_NAME)
);

CREATE TABLE SME_CLUSTER_ATTRIBUTES(
    CLUSTER_NAME VARCHAR(64) NOT NULL, 
    SECURITY_MODE BIGINT, 
    RECOVERY_THRESHOLD BIGINT, 
    RECOVERY_TOTAL BIGINT,    
    CAPABILITY BIGINT,  
    ACTIVE_LOCK BIGINT,
    CONSTRAINT SME_CLUSTER_ATTRIBUTES_PKEY PRIMARY KEY (CLUSTER_NAME)
);

CREATE TABLE SME_CLUSTER_SMARTCARD(
    CLUSTER_NAME VARCHAR(64) NOT NULL, 
    MASTER_KEY_GUID VARCHAR(64) NOT NULL,  
    MASTER_KEY_VERSION VARCHAR(8)NOT NULL,
    RECOVERY_SHARE_VERSION VARCHAR(8) NOT NULL,
    SHARE_INDEX BIGINT,
    SMARTCARD_LABEL VARCHAR(32),
    SMARTCARD_SERIAL_NUMBER VARCHAR(32),
    RO_USERNAME VARCHAR(32),
    CONSTRAINT SME_CLUSTER_SMARTCARD_PKEY PRIMARY KEY (CLUSTER_NAME, MASTER_KEY_GUID, MASTER_KEY_VERSION, RECOVERY_SHARE_VERSION, SHARE_INDEX)
);

CREATE TABLE SME_TAPE_GROUP(
    CLUSTER_NAME VARCHAR(64) NOT NULL,  
    TAPEGROUP_NAME VARCHAR(64) NOT NULL,  
    STATUS BIGINT,  
    CONSTRAINT SME_TAPE_GROUP_PKEY PRIMARY KEY (CLUSTER_NAME, TAPEGROUP_NAME)
);

CREATE TABLE SME_TAPE_VOLUMEGROUP (
    CLUSTER_NAME VARCHAR(64) NOT NULL, 
    TAPEGROUP_NAME VARCHAR(64) NOT NULL, 
    VOLUME_GROUP_NAME VARCHAR(64) NOT NULL,  
    STATUS BIGINT,  
    CONSTRAINT SME_TAPE_VOLUMEGROUP_PKEY PRIMARY KEY (CLUSTER_NAME, TAPEGROUP_NAME, VOLUME_GROUP_NAME)
);

CREATE TABLE SME_KEY(
    GUID VARCHAR(64) NOT NULL,  
    CLUSTER_NAME VARCHAR(64) NOT NULL,  
    CLONED_FROM_GUID VARCHAR(64),  
    CLUSTER_ID VARCHAR(64),  
    STATUS BIGINT,  
    KEY_TYPE BIGINT,  
    ENTITY_INDEX VARCHAR(256),  
    VERSION BIGINT,  
    WRAP_BY_GUID VARCHAR(64),  
    KEY_DATA VARCHAR(2048),
    MASTER_KEY_GUID VARCHAR(64),  
    CREATION_TIME TIMESTAMP,  
    ARCHIVAL_TIME TIMESTAMP,  
    CONSTRAINT SME_KEY_PKEY PRIMARY KEY (GUID, CLUSTER_NAME)
);

CREATE INDEX SME_KEY_CLONED_FROM_GUID_INDEX ON SME_KEY(CLONED_FROM_GUID, CLUSTER_NAME);

CREATE INDEX SME_KEY_ENTITY_INDEX ON SME_KEY(KEY_TYPE, ENTITY_INDEX, VERSION);

CREATE TABLE SME_ACCOUNTING_LOG
(
    LOG_ID BIGINT NOT NULL,
    TIME_STAMP TIMESTAMP NOT NULL,
    HOST_NAME VARCHAR(64) NOT NULL,
    USER_NAME VARCHAR(64),
    CLUSTER_NAME VARCHAR(64),
    CLUSTER_ID VARCHAR(64),
    OPERATION VARCHAR(64),
    STATUS VARCHAR(64),
    DETAILS VARCHAR(1024),
  CONSTRAINT SME_ACCOUNTING_LOG_PKEY PRIMARY KEY (LOG_ID)
);

CREATE TABLE SME_REPLICATION_REL
(
    SRC_CLUSTER_NAME VARCHAR(64) NOT NULL,
    SRC_TAPE_GROUP_NAME VARCHAR(64) NOT NULL,
    SRC_VOLUME_GROUP_NAME VARCHAR(64) NOT NULL,
    REPLICATION_ID BIGINT NOT NULL,
    STATUS BIGINT,
    CREATION_TIME TIMESTAMP,
    DEST_CLUSTER_NAME VARCHAR(64),
    DEST_TAPE_GROUP_NAME VARCHAR(64),
    DEST_VOLUME_GROUP_NAME VARCHAR(64),
    STATUS_DESC VARCHAR(255),
    LAST_UPDATE_TIME TIMESTAMP,
    CONSTRAINT SME_REPLICATION_REL_PKEY PRIMARY KEY (SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_VOLUME_GROUP_NAME, REPLICATION_ID)
);

CREATE TABLE SME_REPL_PENDING_KEY
(
    GUID VARCHAR(64) NOT NULL,
    SRC_CLUSTER_NAME VARCHAR(64) NOT NULL,
      DEST_CLUSTER_NAME VARCHAR(64),
      DEST_TAPE_GROUP_NAME VARCHAR(64),
      DEST_TAPE_VOLUME_GROUP_NAME VARCHAR(64),
    SRC_TAPE_GROUP_NAME VARCHAR(64),
      SRC_TAPE_VOLUME_GROUP_NAME VARCHAR(64),
    SCHEDULED_REPLICATION_TIME TIMESTAMP,
    CONSTRAINT SME_REPL_PENDING_KEY_PKEY PRIMARY KEY (GUID, SRC_CLUSTER_NAME, DEST_CLUSTER_NAME, 
DEST_TAPE_GROUP_NAME, DEST_TAPE_VOLUME_GROUP_NAME)
);

CREATE TABLE SME_REPL_ERROR_KEY
(
    GUID VARCHAR(64) NOT NULL,
    SRC_CLUSTER_NAME VARCHAR(64) NOT NULL,
    DEST_CLUSTER_NAME VARCHAR(64) NOT NULL,
    DEST_TAPE_GROUP_NAME VARCHAR(64) NOT NULL,
    DEST_VOLUME_GROUP_NAME VARCHAR(64) NOT NULL,
    SRC_TAPE_GROUP_NAME VARCHAR(64),
      SRC_TAPE_VOLUME_GROUP_NAME VARCHAR(64),
    STATUS BIGINT,
    REPLICATION_TIME TIMESTAMP,
    STATUS_DESC VARCHAR(255),
    CONSTRAINT SME_REPL_ERROR_KEY_PKEY PRIMARY KEY (GUID, SRC_CLUSTER_NAME, DEST_CLUSTER_NAME, DEST_TAPE_GROUP_NAME, DEST_VOLUME_GROUP_NAME)
);

CREATE INDEX SME_REPL_PENDING_KEY_SRC_INDEX ON SME_REPL_PENDING_KEY(SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_TAPE_VOLUME_GROUP_NAME);

CREATE INDEX SME_REPL_ERROR_KEY_SRC_INDEX ON SME_REPL_ERROR_KEY(SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_TAPE_VOLUME_GROUP_NAME);

CREATE TABLE SME_DISK
(
    CLUSTER_NAME VARCHAR(64) NOT NULL,
    DISKGROUP_NAME VARCHAR(64) NOT NULL,
    DISK_NAME VARCHAR(64) NOT NULL,
    STATUS BIGINT,
    VENDOR VARCHAR(16) NOT NULL,
    PRODUCT VARCHAR(32) NOT NULL,
    DEVICE VARCHAR(16) NOT NULL,
	CONSTRAINT SME_DISK_PKEY PRIMARY KEY (CLUSTER_NAME, DISKGROUP_NAME, DISK_NAME)
);

CREATE TABLE SME_DISK_GROUP
(
    CLUSTER_NAME VARCHAR(64) NOT NULL,
    DISKGROUP_NAME VARCHAR(64) NOT NULL,
    STATUS BIGINT,
  CONSTRAINT SME_DISK_GROUP_PKEY PRIMARY KEY (CLUSTER_NAME, DISKGROUP_NAME)
);

CREATE TABLE SME_RKC_RELATIONSHIP
(
    SRC_CLUSTER_NAME VARCHAR(64) NOT NULL,
    SRC_GROUP_NAME VARCHAR(64) NOT NULL,
    SRC_NAME VARCHAR(64) NOT NULL,
    SRC_VENDOR VARCHAR(16) NOT NULL,
    SRC_PRODUCT VARCHAR(32) NOT NULL,
    SRC_WWN VARCHAR(512) NOT NULL,
    SRC_ASL_TOKEN VARCHAR(16) NOT NULL,
    SRC_LABEL VARCHAR(64),
    DEST_CLUSTER_NAME VARCHAR(64) NOT NULL,
    DEST_GROUP_NAME VARCHAR(64),
    DEST_NAME VARCHAR(64),
    DEST_VENDOR VARCHAR(16) NOT NULL,
    DEST_PRODUCT VARCHAR(32) NOT NULL,
    DEST_WWN VARCHAR(512) NOT NULL,
    DEST_ASL_TOKEN VARCHAR(16),
    DEST_LABEL VARCHAR(64),
    DESCRIPTION VARCHAR(255),
    STATUS BIGINT,
    RELATIONTYPE BIGINT,
  CONSTRAINT SME_RKC_RELATIONSHIP_PKEY PRIMARY KEY (SRC_CLUSTER_NAME, SRC_VENDOR, SRC_PRODUCT, SRC_WWN, DEST_CLUSTER_NAME, DEST_VENDOR, DEST_PRODUCT, DEST_WWN)
);


DROP  TABLE ETHISL cascade;
CREATE  TABLE ETHISL(ID BIGINT NOT NULL PRIMARY KEY,  PORT1_ID BIGINT, PORT2_ID BIGINT, OPER_MODE SMALLINT, IS_PRESENT BOOLEAN, LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME BIGINT, IS_CHANNEL BOOLEAN, CHANNEL_ID BIGINT, IS_TRUNK BOOLEAN, NATIVE_VLANID INTEGER, ACCESS_VLANID INTEGER, IS_FEXISL BOOLEAN);

DROP  TABLE VPC_INFO cascade;
CREATE  TABLE VPC_INFO(ID BIGINT NOT NULL PRIMARY KEY, VPC_ID INTEGER, DOMAIN_ID INTEGER, MULTICHASSIS_VPC_SW_ID BIGINT, PRIMARY_VPC_SWITCH_ID BIGINT, PRIMARY_VPC_PO_ID INTEGER, PRIMARY_VPC_PEERLINK_ID INTEGER, SECONDARY_VPC_SWITCH_ID BIGINT, SECONDARY_VPC_PO_ID INTEGER, SECONDARY_VPC_PEERLINK_ID INTEGER, IS_VPC_CONSISTENT BOOLEAN, IS_PEERLINK_CONSISTENT BOOLEAN, LAST_UPDATE_TIME TIMESTAMP);

DROP  TABLE ETHSWITCH cascade;
CREATE  TABLE ETHSWITCH(ID BIGINT NOT NULL PRIMARY KEY, LICENSE_ID BIGINT, IP_ADDRESS bytea, TYPE INTEGER, MODEL_NAME VARCHAR(255), IS_MANAGEABLE BOOLEAN, UNMANAGEABLE_CAUSE VARCHAR(255), NUM_PORTS INTEGER, GLOBAL_DEVICE_ID VARCHAR(255), DEVICE_ID VARCHAR(255), CAPABILITY bytea, VTP_MGMT_DOMAIN bytea, VLAN_LIST VARCHAR(4000), SYS_NAME VARCHAR(255), SYS_CONTACT VARCHAR(255), SYS_LOCATION VARCHAR(255), SYS_UPTIME BIGINT, VERSION VARCHAR(255), IS_PRESENT BOOLEAN, SERIAL_NUMBER VARCHAR(255), LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME BIGINT, SYS_DESCRIPTION VARCHAR(255), VENDOR VARCHAR(255), OPER_MODE SMALLINT, IS_VDC BOOLEAN, VDC_ID INTEGER, VDC_MAC VARCHAR(255), VDC_NAME VARCHAR(255), DEFAULT_VDC_MAC bytea, VDC_STATE SMALLINT, FCOE_CAPABLE SMALLINT, FCOE_ENABLED BOOLEAN, CPU_USAGE INTEGER, MEM_USAGE INTEGER, IS_FEX BOOLEAN, FEX_ID INTEGER, FEX_ENABLED BOOLEAN, DISC_STATUS INTEGER, DISC_DESCR VARCHAR(2000), DEEP_DESC VARCHAR(2000), LANSWITCH_CLASSID BIGINT, NUM_1G_PORT INTEGER, NUM_2G_PORT INTEGER, NUM_4G_PORT INTEGER, NUM_8G_PORT INTEGER, NUM_10G_PORT INTEGER, NUM_16G_PORT INTEGER, NUM_40G_PORT INTEGER, NUM_100G_PORT INTEGER, SIGN VARCHAR(255),LIC_DETAILS VARCHAR(500),IS_PM_COLLECT BOOLEAN, IS_FWSM BOOLEAN, IS_DEEP_DISC BOOLEAN, L_REPORT BOOLEAN, FEATURES_STRING VARCHAR(255), PRIMARY_IP VARCHAR(255), SECONDARY_IP VARCHAR(255));

DROP  TABLE LANSWITCH_MAP cascade;
CREATE  TABLE LANSWITCH_MAP(ID BIGINT NOT NULL, LAN_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP,    LAST_SCAN_TIME BIGINT, CONSTRAINT LANSWITCH_MAP_PKEY PRIMARY KEY (ID, LAN_ID));

DROP  TABLE ETHSWITCH_PORT cascade;
CREATE  TABLE ETHSWITCH_PORT(ID BIGINT NOT NULL PRIMARY KEY, IF_INDEX INTEGER, SWITCH_ID BIGINT, LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME BIGINT, STATUS SMALLINT, IF_ADMINSTATUS SMALLINT, PORT_MODE VARCHAR(255), IF_STATUS_REASON VARCHAR(2000), IF_SPEED BIGINT, IF_NAME VARCHAR(255), IF_TYPE INTEGER, IF_DESCR VARCHAR(255), IF_ALIAS VARCHAR(255), IP_ADDR VARCHAR(255), MTU INTEGER, IS_CHANNEL BOOLEAN, CHANNEL_ID BIGINT, IS_TRUNK BOOLEAN, IS_PHYSICAL BOOLEAN, OPER_STATUS_CAUSE SMALLINT, NATIVE_VLANID INTEGER, ACCESS_VLANID INTEGER, SHARED_MODE INTEGER);

DROP  TABLE CDP_SEED cascade;
CREATE  TABLE CDP_SEED(ID BIGINT NOT NULL PRIMARY KEY, LAN_ID BIGINT, SERIAL_NUMBER VARCHAR(255), INET_ADDR bytea, IP_RANGE VARCHAR(255), SUBNET VARCHAR(255), MASK VARCHAR(255), CRED_ID BIGINT, MAX_HOPS BIGINT, PLATFORM VARCHAR(255), LAST_UPDATE_TIME TIMESTAMP, seed_type INTEGER, disc_state INTEGER, ip_list VARCHAR(4000), group_id BIGINT, create_time BIGINT, enable_pwd VARCHAR(255), dcnm_user VARCHAR(255), deep_taskid BIGINT, deep_desc VARCHAR(255), deep_updatetime BIGINT, manageable BOOLEAN, fwsm BOOLEAN);

DROP  TABLE ETHSWITCH_SEED cascade;
CREATE TABLE ETHSWITCH_SEED(SWITCH_ID BIGINT NOT NULL, SEED_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHSWITCH_SEED_PKEY PRIMARY KEY(SWITCH_ID, SEED_ID));

DROP TABLE ETHSWITCH_FEX cascade;
CREATE TABLE ETHSWITCH_FEX(SWITCH_ID BIGINT NOT NULL, FEX_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP, CONSTRAINT ETHSWITCH_FEX_PKEY PRIMARY KEY(SWITCH_ID, FEX_ID));

DROP  TABLE LAN cascade;
CREATE TABLE LAN (ID BIGINT NOT NULL PRIMARY KEY, LAN_ID BIGINT, LAN_NAME VARCHAR(255), LAST_SCAN_TIME BIGINT, LAST_UPDATE_TIME TIMESTAMP, IS_PERSISTENT BOOLEAN, IS_MANAGEABLE BOOLEAN, RESERVE_COL1 VARCHAR(255) ,RESERVE_COL2 VARCHAR(255));

DROP  TABLE ETHSWITCH_PORT_VLAN cascade;
CREATE  TABLE ETHSWITCH_PORT_VLAN(PORT_ID BIGINT NOT NULL,VLAN_ID BIGINT NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHSWITCH_PORT_VLAN_PKEY PRIMARY KEY(PORT_ID, VLAN_ID));

DROP  TABLE ETHISL_VLAN cascade;
CREATE  TABLE ETHISL_VLAN(ISL_ID BIGINT NOT NULL,VLAN_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHISL_VLAN_PKEY PRIMARY KEY(ISL_ID, VLAN_ID));

DROP  TABLE ETHSWITCH_VLAN cascade;
CREATE  TABLE ETHSWITCH_VLAN(ETHSWITCH_ID BIGINT NOT NULL,VLAN_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHSWITCH_VLAN_PKEY PRIMARY KEY(ETHSWITCH_ID, VLAN_ID));

DROP  TABLE CDP_VLAN cascade;
CREATE TABLE CDP_VLAN (ID BIGINT NOT NULL PRIMARY KEY, VLAN_ID INTEGER, LAN_ID BIGINT, MTU INTEGER, ADMINSTATE SMALLINT,  OPTERSTATE SMALLINT, VLAN_TYPE SMALLINT, VLAN_NAME VARCHAR(255), LAST_SCAN_TIME BIGINT, LAST_UPDATE_TIME TIMESTAMP, IS_PERSISTENT BOOLEAN, IS_MANAGEABLE BOOLEAN, RESERVE_COL1 VARCHAR(255) ,RESERVE_COL2 VARCHAR(255));

DROP  TABLE VLAN_LAN cascade;
CREATE TABLE VLAN_LAN(VLAN_ID BIGINT NOT NULL, LAN_ID BIGINT NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT VLAN_LAN_PKEY PRIMARY KEY(VLAN_ID, LAN_ID));


DROP TABLE FM_CA_STORE;
CREATE TABLE FM_CA_STORE
(
   NAME VARCHAR(256) NOT NULL PRIMARY KEY,
   FILE_STORE bytea,
   CERT bytea,
   CERT_TYPE VARCHAR(256),
   PRIVATE_KEY bytea,
   PUBLIC_KEY bytea,
   PUB_KEY_FORMAT VARCHAR(256),
   PRIV_KEY_FORMAT VARCHAR(256),
   PUB_KEY_ALG VARCHAR(256),
   PRIV_KEY_ALG VARCHAR(256),
   ALIAS VARCHAR(256),
   PASSWORD VARCHAR(256)
);


DROP TABLE FLEX_DASHBOARD;
CREATE TABLE FLEX_DASHBOARD 
(
    USER_NAME VARCHAR(256), 
    VIEW_NAME VARCHAR(256), 
    DATA VARCHAR(2048),
    CONSTRAINT FLEX_DASHBOARD_PKEY PRIMARY KEY (USER_NAME, VIEW_NAME)
);

DROP TABLE FLEX_DASHBOARD_TOPO_NODES;
CREATE TABLE FLEX_DASHBOARD_TOPO_NODES 
(
    USER_NAME VARCHAR(256), 
    VIEW_NAME VARCHAR(256), 
    DATA VARCHAR(4096),
    CONSTRAINT FLEX_DASHBOARD_TOPO_NODES_PKEY PRIMARY KEY (USER_NAME, VIEW_NAME)
);

DROP TABLE WS_TOKEN;
CREATE TABLE WS_TOKEN 
(
    TOKEN VARCHAR(256), 
    EXPIRE BIGINT, 
    CONSTRAINT WS_TOKEN_PKEY PRIMARY KEY (TOKEN)
);

drop table HOST CASCADE;
CREATE TABLE HOST(ID BIGINT NOT NULL PRIMARY KEY, NAME VARCHAR(256), FULL_NAME VARCHAR(256), ENCLOSURE_ID BIGINT, VHOST_ID BIGINT, USER_MODIFIED BOOLEAN, 
		MAC VARCHAR(4000), IP VARCHAR(4000), PWWN VARCHAR(4000), MULTIPATH VARCHAR(1024), OS_INFO VARCHAR(1024), HBAS VARCHAR(4000),
		VCLUSTER VARCHAR(256), CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP, 
		RESERVE_COL1 VARCHAR(256), RESERVE_COL2 VARCHAR(256) );
CREATE INDEX HOST_NAME_INDEX ON HOST(NAME);

drop table HOST_MAP CASCADE;
CREATE TABLE HOST_MAP(ID BIGINT NOT NULL PRIMARY KEY, HOST_ID BIGINT, ENCLOSURE_ID BIGINT, VHOST_ID BIGINT, LANHOST_ID BIGINT, CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP);
CREATE INDEX HOST_MAP_HOSTID_INDEX ON HOST_MAP(HOST_ID);
CREATE INDEX HOST_MAP_ENCID_INDEX ON HOST_MAP(ENCLOSURE_ID);
CREATE INDEX HOST_MAP_VHOSTID_INDEX ON HOST_MAP(VHOST_ID);
CREATE INDEX HOST_MAP_LANHOSTID_INDEX ON HOST_MAP(LANHOST_ID);

drop table LAN_HOST CASCADE;
CREATE TABLE LAN_HOST(ID BIGINT NOT NULL PRIMARY KEY, NAME VARCHAR(256), DESCRIPTION VARCHAR(256), MAC VARCHAR(256), ETH_SWITCH_ID BIGINT, ETH_IFNAME VARCHAR(256), IPADDRESS VARCHAR(256), ETHSWITCH_PORT_ID BIGINT, VLAN INTEGER, VHOST_ID BIGINT, CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP);
CREATE INDEX LAN_HOST_MAC_INDEX ON HOST(MAC);

DROP TABLE CLUSTERNODES CASCADE;
CREATE TABLE CLUSTERNODES(IPADDRESS VARCHAR(100) not null, PORT INTEGER not null, CONSTRAINT SYS_PK_CLUSTERNODES PRIMARY KEY(IPADDRESS, PORT));

DROP TABLE reports_properties cascade;
create TABLE reports_properties(server VARCHAR(256),
                                name VARCHAR(256),
                                writable INTEGER,
                                LAST_UPDATE_TIME TIMESTAMP,
                                reportcontent BYTEA default '',
                                PRIMARY KEY (server,name));
                                
DROP TABLE ConfigTemplate CASCADE;
create table ConfigTemplate (
	instanceClassId int8 not null primary key,
	version int4 not null, 
	instanceName varchar(255) not null,
	name varchar(255), 
	description varchar(255),
	tagsCol varchar(255), 
	fileName varchar(255), 
	userDefined bool not null, 
	content oid, 
	unique (instanceName)
);
           
DROP TABLE san_ConfDelTaskDevDetails CASCADE;
create table san_ConfDelTaskDevDetails (
	instanceClassId int8 not null primary key, 
	version int4 not null, 
    instanceState int4, 
	instanceName varchar(255), 
    ipAddress varchar(255), 
	configDeliveryTaskDeviceStatus int4, 
	failureCause varchar(255), 
	configCommands oid, 
	failedCommands oid,
	SAN_CFGDELIVERYTASK_ID int8, 
	IDX int4,
	unique (instanceName)
);  
          
DROP TABLE san_ConfigDeliveryTask CASCADE;
create table san_ConfigDeliveryTask (
	instanceClassId int8 not null primary key, 
	CLASS_TYPE varchar(255) not null, 
	version int4 not null, 
	instanceState int4, 
	instanceName varchar(255), 
	owner varchar(255), 
	userName varchar(255), 
	password varchar(255), 
	enablePwd varchar(255), 
	createdTime timestamp, 
	description varchar(255), 
	progress int4, 
         timeout int4,  
	taskEnabled bool, 
	scheduledTime timestamp, 
	startTime timestamp, 
	endTime timestamp, 
	isCopyRunToStartTask bool, 
	configDeliveryTaskSourceType int4, 
	configDeliveryTaskStatus int4, 
	cfgDeliveryTaskRollbackSetting int4, 
	cfgDelivryTaskDelivryOrderSett int4, 
	command varchar(255), 
	configTimestamp timestamp, 
	sourceIpAddress varchar(255), 
	sourceTemplate varchar(255), 
	CONFIGTEMPLATE_ID int8,
	unique (instanceName)
);              
         
alter table san_ConfDelTaskDevDetails add constraint san_conftaskdevdetails_fk foreign key (SAN_CFGDELIVERYTASK_ID) references san_ConfigDeliveryTask ;        
alter table san_ConfigDeliveryTask add constraint san_configtask_fk foreign key (CONFIGTEMPLATE_ID) references ConfigTemplate;

DROP SEQUENCE SAN_CONFIGDELIVERYTASK_SEQUENCE;
create sequence SAN_CONFIGDELIVERYTASK_SEQUENCE;

drop table ZONE_JOB cascade;
CREATE  TABLE ZONE_JOB(
	ID BIGINT NOT NULL PRIMARY KEY,
	JOB_TYPE INTEGER,
	VSAN_ID BIGINT,
	VSAN_WWN bytea,
	WWN bytea,
	ZONESET_NAME VARCHAR(255),
	JOB_STATUS INTEGER,
	JOB_CREATE_TIME TIMESTAMP,
	JOB_FINISH_TIME TIMESTAMP,
	JOB_DEL_ON_COMPLETION BOOLEAN,
	JOB_TIME_BEFORE_REMOVAL BIGINT,
	JOB_STATUS_DESC varchar(255),
	OLD_ZONESET_NAME VARCHAR(255),
	OLD_ZONESET_ACTIVATION_TIME TIMESTAMP);

	
CREATE INDEX ZONE_JOB_VSAN_INDEX ON ZONE_JOB(VSAN_ID, VSAN_WWN, ID);


drop table if exists SMIS_PROVIDER cascade;
CREATE  TABLE SMIS_PROVIDER
(
ID BIGINT,
PROVID INTEGER,
PROVIDER_NS VARCHAR(255) NOT NULL,
INTEROP_NS VARCHAR(255),
URL VARCHAR(255),
USERNAME VARCHAR(64),
PASSWORD VARCHAR(64),
PORT INTEGER,
SECURE BOOLEAN,
VENDOR VARCHAR(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_STORAGE_SYSTEM cascade;
CREATE  TABLE SMIS_STORAGE_SYSTEM
(
ID BIGINT,
PROVIDER_DB_ID BIGINT REFERENCES SMIS_PROVIDER ON DELETE CASCADE,
SYSTEM_NAME VARCHAR(255) NOT NULL,
STORAGE_TYPE VARCHAR(255),
VENDOR VARCHAR(255) NOT NULL,
VERSION VARCHAR(255),
MODEL VARCHAR(255),
SERIAL_NUMBER VARCHAR(255) NOT NULL,
PART_NUMBER VARCHAR(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_SYSTEM_COMPONENT cascade;
CREATE  TABLE SMIS_SYSTEM_COMPONENT
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
SYSTEM_COMPONENT_NAME VARCHAR(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_POOL cascade;
CREATE  TABLE SMIS_POOL
(
ID BIGINT,
SYSTEM_DB_ID BIGINT  REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE, 
POOL_NAME VARCHAR(256) NOT NULL,
RAW_CAPACITY BIGINT,
TOTAL_MANAGED BIGINT,
REMAINING_MANAGED BIGINT,
REMAINING_RAW_CAPACITY BIGINT,
SUBSCRIBED_CAPACITY BIGINT,
PERCENT_SUBSCRIBED INTEGER, 
STATUS VARCHAR(255),   
RAID_TYPE VARCHAR(255),  
DISK_TYPE VARCHAR(255),    
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_STORAGE_PROCESSOR cascade;
CREATE  TABLE SMIS_STORAGE_PROCESSOR
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
PROCESSOR_NAME VARCHAR(255) NOT NULL,
PROCESSOR_NUMBER BIGINT,
NUM_PORTS BIGINT,
MEM_SIZE BIGINT,
SERIAL_NUMBER VARCHAR(255),
SLOT_NUMBER BIGINT,
READ_CACHE BIGINT,
WRITE_CACHE BIGINT,
STATUS VARCHAR(255),
IP_ADDRESS VARCHAR(15),
FRONT_END_ADAPTER BOOLEAN, 
BACK_END_ADAPTER BOOLEAN,
SRDF_ADAPTER BOOLEAN,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_STORAGE_PORT cascade;
CREATE  TABLE SMIS_STORAGE_PORT
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
PROCESSOR_DB_ID BIGINT,   /* can be null */
PORT_NAME VARCHAR(255) NOT NULL,
PORT_NUMBER INTEGER,
PORT_TYPE INTEGER,
NETWORK_ADDRESS VARCHAR(255),
PERM_ADDRESS VARCHAR(255),
PORT_DESCRIPTION VARCHAR(255),
SPEED BIGINT,
PORT_USAGE BIGINT,
STATUS VARCHAR(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table if exists SMIS_DISK cascade;
CREATE  TABLE SMIS_DISK
(
ID BIGINT,
SYSTEM_COMPONENT_DB_ID BIGINT  REFERENCES SMIS_SYSTEM_COMPONENT ON DELETE CASCADE,
DISK_NAME VARCHAR(255) NOT NULL,
DRIVE_TYPE VARCHAR(255),
RAW_CAPACITY BIGINT,
USER_CAPACITY BIGINT,
USER_SECTORS BIGINT,
STATE INTEGER,
RAID_TYPE VARCHAR(255),
STORAGE_POOL VARCHAR(255),
STATUS VARCHAR(255),       
MANUFACTURER VARCHAR(255),
MODEL VARCHAR(255),
SERIAL_NUMBER VARCHAR(255),
PART_NUMBER VARCHAR(255),
FIRMWARE_REV VARCHAR(255),
CURRENT_SPEED BIGINT,
MAX_SPEED BIGINT,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_HOST cascade;
CREATE  TABLE SMIS_HOST
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
HOST_NWWN VARCHAR(255),
HOST_NAME VARCHAR(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
); 


drop table if exists SMIS_HOST_PORT cascade;
CREATE  TABLE SMIS_HOST_PORT
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
HOST_DB_ID BIGINT REFERENCES SMIS_HOST ON DELETE CASCADE,
HOST_PWWN VARCHAR(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);
CREATE INDEX SMIS_HOST_PORT_HOST_PWWN ON SMIS_HOST_PORT(HOST_PWWN);

drop table if exists SMIS_STORAGE_LUN cascade;
CREATE  TABLE SMIS_STORAGE_LUN
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
LUN_NAME VARCHAR(255) NOT NULL,
LUN_ID VARCHAR(255) NOT NULL,
WWN VARCHAR(255),
POOL_NAME VARCHAR(255),
TOTAL_MANAGED_SPACE BIGINT,
REMAINING_MANAGED_SPACE BIGINT,
CONSUMED_CAPACITY BIGINT,
STATUS VARCHAR(255),
RAID_TYPE VARCHAR(255),
DISK_TYPE VARCHAR(255),
CURRENT_OWNER VARCHAR(255),
DEFAULT_OWNER VARCHAR(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table if exists SMIS_HOST_LUN_MAP cascade;
CREATE  TABLE SMIS_HOST_LUN_MAP
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
HOST_PORT_DB_ID BIGINT REFERENCES SMIS_HOST_PORT ON DELETE CASCADE,
LUN_DB_ID BIGINT REFERENCES SMIS_STORAGE_LUN ON DELETE CASCADE,
HOST_LUN_ID VARCHAR(255),
TARGET_PWWN VARCHAR(255),
LUN_ID VARCHAR(255),
READABLE_HOST_NAME VARCHAR(255),
ADAPTER_NAME VARCHAR(255),
LUN_ACCESS INTEGER,
ACCESS_PRIV_GRANTED BOOLEAN,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table if exists SMIS_DISK_LUN_MAP cascade;
CREATE  TABLE SMIS_DISK_LUN_MAP
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
DISK_DB_ID BIGINT REFERENCES SMIS_DISK ON DELETE CASCADE,
LUN_DB_ID BIGINT REFERENCES SMIS_STORAGE_LUN ON DELETE CASCADE,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table if exists SMIS_DISK_POOL_MAP cascade;
CREATE  TABLE SMIS_DISK_POOL_MAP
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
DISK_DB_ID BIGINT REFERENCES SMIS_DISK ON DELETE CASCADE,
POOL_DB_ID BIGINT REFERENCES SMIS_POOL ON DELETE CASCADE,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table if exists SMIS_STORAGE_FILER_VOLUME cascade;
CREATE  TABLE SMIS_STORAGE_FILER_VOLUME
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
FILER_VOLUME_NAME VARCHAR(255) NOT NULL,
CONTAINING_AGGREGATE VARCHAR(255) NOT NULL,
AVAILABLE_CAPACITY BIGINT,
TOTAL_CAPACITY BIGINT,
USED_CAPACITY BIGINT,
NUM_OF_FILES BIGINT,
MAX_NUM_OF_FILES BIGINT,
STATUS VARCHAR(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table if exists SMIS_STATISTICS_DISK cascade;
CREATE  TABLE SMIS_STATISTICS_DISK
(
ID BIGINT,
SYSTEM_DB_ID BIGINT REFERENCES SMIS_STORAGE_SYSTEM ON DELETE CASCADE,
DISK_NAME VARCHAR(255),
TIME_ID BIGINT NOT NULL,
totalIOs BIGINT,	
kBytesTransferred BIGINT,
iOTimeCounter BIGINT,	
readIOs BIGINT,
readHitIOs BIGINT,	
readIOTimeCounter BIGINT,
readHitIOTimeCounter BIGINT,
kBytesRead BIGINT,
writeIOs BIGINT, 
writeHitIOs BIGINT,
writeIOTimeCounter BIGINT,
writeHitIOTimeCounter BIGINT, 
kBytesWritten BIGINT,
idleTimeCounter BIGINT, 
maintOp BIGINT,
maintTimeCounter BIGINT,
currentPWRSavingLogTimeStamp BIGINT, 
kbSeeked BIGINT,
queueArrivals BIGINT, 
queueLength BIGINT,
spinningCounter BIGINT, 
spinUPS BIGINT, 
standbyCounter BIGINT, 
readHits BIGINT,
readMisses BIGINT,
writeHits BIGINT,
writeMisses BIGINT,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);

drop table UCS_BLADE cascade;
CREATE TABLE UCS_BLADE (ID BIGINT, switch_id BIGINT, admin_power VARCHAR(255), admin_state VARCHAR(255), assigned_to_dn VARCHAR(255), association VARCHAR(255),
	availability VARCHAR(255), available_memory BIGINT, chassis_id INTEGER, descr VARCHAR(255), dn VARCHAR(255), low_voltage_memory VARCHAR(255),
	managing_inst VARCHAR(255), memory_speed INTEGER, model VARCHAR(255), name VARCHAR(255), num_of_adaptors INTEGER, num_of_cores INTEGER, num_of_cores_enabled INTEGER, 
	num_of_cpus INTEGER, num_of_eth_host_ifs INTEGER, num_of_fc_host_ifs INTEGER, num_of_threads INTEGER, oper_power VARCHAR(255), oper_qualifier VARCHAR(255), 
	oper_state VARCHAR(255), operability VARCHAR(255), original_uuid VARCHAR(255), presence VARCHAR(255), revision INTEGER, serial VARCHAR(255), server_id VARCHAR(255), 
	slot_id INTEGER, total_memory BIGINT, uuid VARCHAR(255), vendor VARCHAR(255),  created_time TIMESTAMP, last_update_time BIGINT,
	PRIMARY KEY(ID)
);

DROP TABLE UCS_BLADE_MGMT_IF cascade;
CREATE TABLE UCS_BLADE_MGMT_IF(id BIGINT, switch_id BIGINT, blade_id BIGINT REFERENCES UCS_BLADE ON DELETE CASCADE, access_type VARCHAR(255), admin_state VARCHAR(255), 
	discovery VARCHAR(255), dn VARCHAR(255), epdn VARCHAR(255), ext_broadcast VARCHAR(255), ext_gw VARCHAR(255), ext_ip VARCHAR(255), ext_mask VARCHAR(255), 
	if_id INTEGER, if_role VARCHAR(255), if_type VARCHAR(255), ip VARCHAR(255), locale VARCHAR(255), mac VARCHAR(255), mask VARCHAR(255), 
	name VARCHAR(255), peer_chassis_id VARCHAR(255), peer_dn VARCHAR(255), peer_port_id INTEGER, peer_slot_id INTEGER, port_id INTEGER, slot_id INTEGER, 
	state_qual VARCHAR(255), subject VARCHAR(255), transport VARCHAR(255), type VARCHAR(255), vnet INTEGER, created_time TIMESTAMP, last_update_time BIGINT,
	PRIMARY KEY(ID) 
);

drop table STORAGE_ENCLOSURE cascade;
CREATE TABLE STORAGE_ENCLOSURE (ID BIGINT, enclosure_id BIGINT, storage_system_id BIGINT, name VARCHAR(255), ip VARCHAR(255), created_time TIMESTAMP, last_update_time BIGINT, 
	PRIMARY KEY(ID)
);


commit;
\q

