drop table statistics CASCADE CONSTRAINTS;
CREATE  TABLE STATISTICS(SRC_ID INTEGER NOT NULL,DEST_ID INTEGER NOT NULL,TYPE SMALLINT,RRD_FILE VARCHAR2(256) ,XML_FILE VARCHAR2(256) ,CAPACITY INTEGER,AVG_RX BINARY_DOUBLE,AVG_TX BINARY_DOUBLE,TOTAL_RXTX BINARY_DOUBLE,MAX_RX BINARY_DOUBLE,MAX_TX BINARY_DOUBLE,TOTAL_ERR BINARY_DOUBLE,TOTAL_DISCARD BINARY_DOUBLE,LAST_WEEK_AVG_RX BINARY_DOUBLE,LAST_WEEK_AVG_TX BINARY_DOUBLE,LAST_WEEK_TOTAL_RXTX BINARY_DOUBLE,LAST_WEEK_MAX_RX BINARY_DOUBLE,LAST_WEEK_MAX_TX BINARY_DOUBLE,LAST_WEEK_TOTAL_ERR BINARY_DOUBLE,LAST_WEEK_TOTAL_DISCARD BINARY_DOUBLE,LAST_MONTH_AVG_RX BINARY_DOUBLE,LAST_MONTH_AVG_TX BINARY_DOUBLE,LAST_MONTH_TOTAL_RXTX BINARY_DOUBLE,LAST_MONTH_MAX_RX BINARY_DOUBLE,LAST_MONTH_MAX_TX BINARY_DOUBLE,LAST_MONTH_TOTAL_ERR BINARY_DOUBLE,LAST_MONTH_TOTAL_DISCARD BINARY_DOUBLE,LAST_YEAR_AVG_RX BINARY_DOUBLE,LAST_YEAR_AVG_TX BINARY_DOUBLE,LAST_YEAR_TOTAL_RXTX BINARY_DOUBLE,LAST_YEAR_MAX_RX BINARY_DOUBLE,LAST_YEAR_MAX_TX BINARY_DOUBLE,LAST_YEAR_TOTAL_ERR BINARY_DOUBLE,LAST_YEAR_TOTAL_DISCARD BINARY_DOUBLE,LAST_UPDATE_TIME TIMESTAMP,LAST_THRESHOLD_EVENT_TIME TIMESTAMP,THRESHOLD_EVENT_COUNT SMALLINT,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_STATISTICS PRIMARY KEY(SRC_ID,DEST_ID));
CREATE INDEX STATISTICS_DEST_ID ON STATISTICS(DEST_ID);
drop table switch CASCADE CONSTRAINTS;
CREATE  TABLE SWITCH(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,LICENSE_ID INTEGER,WWN RAW(8),IP_ADDRESS RAW(100),IS_MDS NUMBER(1),TYPE INTEGER,IS_MANAGABLE NUMBER(1),UNMANAGABLE_CAUSE VARCHAR2(256) ,NON_MDS_MODEL VARCHAR2(256) ,SYS_NAME VARCHAR2(256) ,SYS_CONTACT VARCHAR2(256) ,SYS_LOCATION VARCHAR2(256) ,SYS_UPTIME INTEGER,ACTIVE_SUP_SLOT INTEGER,STANDBY_SUP_STATE INTEGER,CONN_UNIT_STATUS INTEGER,FEATURE_FLAG INTEGER,FEATURES_STRING VARCHAR2(256),IS_LICENSE_VIOLATION NUMBER(1),VERSION VARCHAR2(256) ,IS_PRESENT NUMBER(1),SERIAL_NUMBER VARCHAR2(256) ,NUM_PORTS INTEGER,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,IS_TRAP_REGISTERED NUMBER(1),IS_SYSLOG_REGISTERED NUMBER(1),SYS_DESCRIPTION VARCHAR2(256) ,VENDOR VARCHAR2(256) ,FCFE_MODULE_ID INTEGER,STANDBY_SUP_SLOT INTEGER,MODULE_INDEX_OFFSET INTEGER,OPER_MODE INTEGER,CPU_USAGE INTEGER,MEM_USAGE INTEGER,sign varchar2(255), lic_details varchar2(500),IS_ECH_SUPPORT NUMBER(1) default 1,  is_vdc number(1), vdc_id integer, vdc_mac raw(6), DEFAULT_VDC_MAC raw(6), vdc_name varchar2(255), fcoe_capable number(1), NUM_1G_PORT INTEGER, NUM_2G_PORT INTEGER, NUM_4G_PORT INTEGER, NUM_8G_PORT INTEGER, NUM_10G_PORT INTEGER, NUM_16G_PORT INTEGER, NUM_40G_PORT INTEGER, NUM_100G_PORT INTEGER, l_report number(1), PRIMARY_IP VARCHAR2(256), SECONDARY_IP VARCHAR2(256), RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX SWITCH_IP_INDEX ON SWITCH(IP_ADDRESS);
CREATE INDEX SWITCH_FABRIC_ID ON SWITCH(FABRIC_ID);
CREATE INDEX SWITCH_WWN_INDEX ON SWITCH(WWN);
drop table switch_port CASCADE CONSTRAINTS;
CREATE  TABLE SWITCH_PORT(ID INTEGER NOT NULL PRIMARY KEY,IF_INDEX INTEGER,SWITCH_ID INTEGER,WWN RAW(8),FICON_PORT_ADDRESS RAW(100),FICON_ADDRESS INTEGER,IS_HUB NUMBER(1),IS_CHANNEL NUMBER(1),CHANNEL_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,STATUS SMALLINT,IS_SPAN NUMBER(1),PORT_GROUP INTEGER,SLOT SMALLINT,IF_SPEED INTEGER,IF_NAME VARCHAR2(256) ,IF_TYPE INTEGER,PARENT INTEGER,CLUSTER_ID VARCHAR2(256),SME_STATE INTEGER,IOA_STATE INTEGER,IF_CONNTYPE INTEGER,IF_DESCR VARCHAR2(256), 
	IS_VFC NUMBER(1), VFC_BIND_TYPE SMALLINT, VFC_BIND_IFINDEX INTEGER, VFC_BIND_MAC RAW(6), DISPLAY_NAME VARCHAR2(256), IS_PHYSICAL NUMBER(1), IF_ADMINSTATUS SMALLINT, IF_OPERSTATUS INTEGER, IF_ALIAS VARCHAR2(256), RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );

CREATE INDEX SWITCH_PORT_SWITCH_ID_INDEX ON SWITCH_PORT(SWITCH_ID);
CREATE INDEX SWITCH_PORT_CHANNEL_ID_INDEX ON SWITCH_PORT(CHANNEL_ID);
CREATE INDEX SWITCH_PORT_IFINDEX_ID_INDEX ON SWITCH_PORT(SWITCH_ID, IF_INDEX);
drop table end_port  CASCADE CONSTRAINTS;
CREATE  TABLE END_PORT(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,ENCLOSURE_ID INTEGER,HBA_ID INTEGER,SWITCH_PORT_ID INTEGER,WWN RAW(8),NODE_WWN RAW(100),FICON_PORT_ADDRESS RAW(100),FLAGS INTEGER,SYM_PORT_NAME VARCHAR2(256) ,SYM_NODE_NAME VARCHAR2(256) ,PORT_IP_ADDR VARCHAR2(256) ,ALIAS VARCHAR2(256) ,IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,OPER_STATUS_CAUSE INTEGER,IF_NAME VARCHAR2(256) ,IS_LOOP NUMBER(1),FC4_TYPES RAW(100),FC4_FEATURES INTEGER,NAME VARCHAR2(256) ,VFC_BINDTO VARCHAR2(256), SERVICE_PROFILE VARCHAR2(256), RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX END_PORT_FABRIC_ID_INDEX ON END_PORT(FABRIC_ID);
CREATE INDEX END_PORT_ENCLOSURE_ID_INDEX ON END_PORT(ENCLOSURE_ID);
CREATE INDEX END_PORT_SWITCH_PORT_ID_INDEX ON END_PORT(SWITCH_PORT_ID);
CREATE INDEX END_PORT_WWN_INDEX ON END_PORT(WWN);
CREATE INDEX END_PORT_NODE_WWN_INDEX ON END_PORT(NODE_WWN);
drop table fabric CASCADE CONSTRAINTS;
CREATE  TABLE FABRIC(ID INTEGER NOT NULL PRIMARY KEY,SEED_SWITCH_ID INTEGER,IVR_SEED_SWITCH_ID INTEGER,ALIAS_SEED_SWITCH_ID INTEGER,LICENSE_ID INTEGER,IVR_ENF_ZONESET_NAME VARCHAR2(256) ,IVR_ENF_ZONESET_ACTIVATE_TIME INTEGER,IVR_ACTIVE_ZONESET_CHECKSUM RAW(100),POLLING_ENABLED NUMBER(1),POLLING_INTERVAL INTEGER,LAST_SCAN_TIME INTEGER,SNMP_RETRIES INTEGER,SNMP_TIMEOUT INTEGER,FMUSER_ID INTEGER,NAME VARCHAR2(256) ,LAST_UPDATE_TIME TIMESTAMP,SAN_ID INTEGER,FID INTEGER,IS_PERSISTENT NUMBER(1),ON_DEMAND_POLL_FREQ INTEGER,IVR_TOPO_CFG_CHECKSUM RAW(100),IVR_TOPO_ACT_CHECKSUM RAW(100),IVR_TOPO_AFID_CFG_CHECKSUM RAW(100),IVR_TOPO_DEF_AFID_CHECKSUM RAW(100),IVR_TOPO_VALIDATED NUMBER(1),USE_GLOBAL_ALIAS NUMBER(1),  IS_MANAGEABLE  NUMBER(1), DEVICE_ALIAS_SEED_ID INTEGER,DEVICE_ALIAS_CHECKSUM RAW(100),VSANS_INCLUDED VARCHAR2(256),  VSANS_EXCLUDED VARCHAR2(256),RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX FABRIC_SEED_SWITCH_ID ON FABRIC(SEED_SWITCH_ID);
CREATE INDEX FABRIC_IVR_SEED_SWITCH_ID ON FABRIC(IVR_SEED_SWITCH_ID);
CREATE INDEX FABRIC_DEVICE_ALIAS_SEED_ID ON FABRIC(DEVICE_ALIAS_SEED_ID);
drop table isl  CASCADE CONSTRAINTS;
CREATE  TABLE ISL(ID INTEGER NOT NULL PRIMARY KEY,PORT1_ID INTEGER,PORT2_ID INTEGER,OPER_MODE SMALLINT,IS_PRESENT NUMBER(1),STATUS SMALLINT,OPER_STATUS_CAUSE INTEGER,OPER_STATUS_DESCRIPTION VARCHAR2(256) ,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,CHANNEL_CONFIG_CHILD_COUNT INTEGER,CHANNEL_CURRENT_CHILD_COUNT INTEGER,AUTO_CREATED NUMBER(1),IS_CHANNELMEMBER NUMBER(1),CHANNEL_ID INTEGER,IF_INDEX_1 INTEGER,IF_INDEX_2 INTEGER,FICON_ADDRESS_1 INTEGER,FICON_ADDRESS_2 INTEGER,FCSP_AUTHENTICATED NUMBER(1),ESP_SECURED NUMBER(1),ESP_READY NUMBER(1),IS_FCIP NUMBER(1),RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX ISL_P1_INDEX ON ISL(PORT1_ID);
CREATE INDEX ISL_P2_INDEX ON ISL(PORT2_ID);
CREATE INDEX ISL_CHANNELMEMBER ON ISL(IS_CHANNELMEMBER);
drop table npv_link  CASCADE CONSTRAINTS;
CREATE TABLE NPV_LINK(ID INTEGER NOT NULL PRIMARY KEY,CORE_SWITCH_ID INTEGER,NP_SWITCH_ID INTEGER,F_PORT_INDEX INTEGER,NP_PORT_INDEX INTEGER,F_WWN RAW(8),NP_WWN RAW(8),OPER_STATUS_CAUSE INTEGER,SPEED INTEGER,IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,CHANNEL_CONFIG_CHILD_COUNT INTEGER,CHANNEL_CURRENT_CHILD_COUNT INTEGER,AUTO_CREATED  NUMBER(1), IS_CHANNELMEMBER NUMBER(1), CHANNEL_ID INTEGER,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256));
CREATE INDEX NPV_LINK_FP_INDEX ON NPV_LINK(F_PORT_INDEX);
CREATE INDEX NPV_LINK_NPP_INDEX ON NPV_LINK(NP_PORT_INDEX);
drop table vsan CASCADE CONSTRAINTS;
CREATE  TABLE VSAN(ID INTEGER NOT NULL PRIMARY KEY,NAME VARCHAR2(256) ,IS_UP NUMBER(1),IS_DISJOINT NUMBER(1),SEED_SWITCH_ID INTEGER,ENF_ZONESET_NAME VARCHAR2(256) ,ENF_ZONESET_ACTIVATE_TIME INTEGER,FABRIC_ID INTEGER,VSAN_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,PRINCIPAL_SWWN RAW(100),FICON_STATE INTEGER,INTER_OPER_MODE INTEGER,PRINCIPAL_SW_ID INTEGER,ADMIN_STATE number(4),MTU INTEGER,LOAD_BALANCING_TYPE number(4),INORDER_DELIVERY NUMBER(1),NETWORK_DROP_LATENCY INTEGER,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX VSAN_FABRIC_VSAN_ID_INDEX ON VSAN(FABRIC_ID,VSAN_ID);
CREATE INDEX VSAN_VSAN_ID_INDEX ON VSAN(VSAN_ID);
drop table zone_member  CASCADE CONSTRAINTS;
CREATE  TABLE ZONE_MEMBER(ID INTEGER NOT NULL PRIMARY KEY,ZONE_ID INTEGER,TYPE INTEGER,MEMBER_ID RAW(100),LUN_ID RAW(1000),LAST_UPDATE_TIME TIMESTAMP,IVR_VSAN_ID INTEGER,PORT_STATUS RAW(100),AFID INTEGER,CFS_REGION_ID INTEGER,ENDPORT_ID INTEGER, SWITCHPORT_ID INTEGER, NAME VARCHAR2(256), SWITCH_INT VARCHAR2(256), RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX ZONE_MEMBER_ZONEID_INDEX ON ZONE_MEMBER(ZONE_ID);
CREATE INDEX ZONE_MEMBER_MEMBERID_INDEX ON ZONE_MEMBER(ZONE_ID,MEMBER_ID);
CREATE INDEX ZONE_MEMBER_LUN_ID_INDEX ON ZONE_MEMBER(LUN_ID);
CREATE INDEX ZONE_MEM_CFS_REGID_INDEX ON ZONE_MEMBER(CFS_REGION_ID);
drop table zone  CASCADE CONSTRAINTS;
CREATE  TABLE ZONE(ID INTEGER NOT NULL PRIMARY KEY,PARENT_ID INTEGER,IS_IVR NUMBER(1),ZONE_INDEX INTEGER,NAME VARCHAR2(256) ,LAST_UPDATE_TIME TIMESTAMP,READ_ONLY NUMBER(1),QOS NUMBER(1),QOS_PRIORITY INTEGER,BROADCAST NUMBER(1),CFS_REGION_ID INTEGER,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX ZONE_VSAN_INDEX ON ZONE(PARENT_ID);
CREATE INDEX ZONE_ISIVR_INDEX ON ZONE(PARENT_ID, IS_IVR);
CREATE INDEX ZONE_CFS_INDEX ON ZONE(PARENT_ID, CFS_REGION_ID);
drop table vsan_domain_info  CASCADE CONSTRAINTS;
CREATE  TABLE VSAN_DOMAIN_INFO(VSAN_ID INTEGER NOT NULL,SWITCH_ID INTEGER NOT NULL,DOMAIN_ID SMALLINT,WWN RAW(100),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_VSAN_DOMAIN_INFO PRIMARY KEY(VSAN_ID,SWITCH_ID));
CREATE INDEX VSAN_DOMAIN_VSAN_ID ON VSAN_DOMAIN_INFO(VSAN_ID);
CREATE INDEX VSAN_DOMAIN_SWITCH_ID ON VSAN_DOMAIN_INFO(SWITCH_ID);
drop table VSAN_ISL_INFO  CASCADE CONSTRAINTS;
CREATE  TABLE VSAN_ISL_INFO(VSAN_ID INTEGER NOT NULL,ISL_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_VSAN_ISL_INFO PRIMARY KEY(VSAN_ID,ISL_ID));
CREATE INDEX VSAN_ISL_VSAN_ID ON VSAN_ISL_INFO(VSAN_ID);
CREATE INDEX VSAN_ISL_ISL_ID ON VSAN_ISL_INFO(ISL_ID);
drop table VSAN_NPVL_INFO CASCADE CONSTRAINTS;
CREATE  TABLE VSAN_NPVL_INFO(VSAN_ID INTEGER NOT NULL,NPVL_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_VSAN_NPVL_INFO PRIMARY KEY(VSAN_ID,NPVL_ID));
CREATE INDEX VSAN_NPVL_VSAN_ID ON VSAN_NPVL_INFO(VSAN_ID);
CREATE INDEX VSAN_NPVL_NPVL_ID ON VSAN_NPVL_INFO(NPVL_ID);
drop table VSAN_ENDPORT_INFO CASCADE CONSTRAINTS;
CREATE  TABLE VSAN_ENDPORT_INFO(VSAN_ID INTEGER NOT NULL,ENDPORT_ID INTEGER NOT NULL,FCID INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_VSAN_ENDPORT_INFO PRIMARY KEY(VSAN_ID,ENDPORT_ID));
CREATE INDEX VSAN_ENDPORT_VSAN_ID ON VSAN_ENDPORT_INFO(VSAN_ID);
CREATE INDEX VSAN_ENDPORT_ENDPORT_ID ON VSAN_ENDPORT_INFO(ENDPORT_ID);
drop table CFS_REGION CASCADE CONSTRAINTS;
CREATE  TABLE CFS_REGION(ID INTEGER NOT NULL PRIMARY KEY,REGION_ID INTEGER,IVR_SEED_SWITCH_ID INTEGER,ALIAS_SEED_SWITCH_ID INTEGER,IVR_ENF_ZONESET_NAME VARCHAR2(256),IVR_ENF_ZONESET_ACTIVATE_TIME INTEGER,FABRIC_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
CREATE INDEX CFS_REGION_FABRIC_REGION_ID ON CFS_REGION(FABRIC_ID,REGION_ID);
CREATE INDEX CFS_REGION_REGION_ID_INDEX ON CFS_REGION(REGION_ID);
drop table sequence;
CREATE  TABLE SEQUENCE(ID SMALLINT NOT NULL PRIMARY KEY,VALUE INTEGER);
drop table clustersequence CASCADE CONSTRAINTS;
CREATE  TABLE CLUSTERSEQUENCE(ID SMALLINT NOT NULL,SERVER_ID SMALLINT NOT NULL, VALUE INTEGER, CONSTRAINT SYS_PK_CLUSTERSEQUENCE PRIMARY KEY(ID, SERVER_ID));
drop table LOGICSVR_FABRIC CASCADE CONSTRAINTS;
CREATE TABLE LOGICSVR_FABRIC(LSVR_ID SMALLINT NOT NULL,F_ID INTEGER NOT NULL,CONSTRAINT SYS_PK_LOGICSVR_FABRIC PRIMARY KEY(LSVR_ID, F_ID));
drop table PHYSICAL_LOGICSVR CASCADE CONSTRAINTS;
CREATE TABLE PHYSICAL_LOGICSVR(IP_ADDR RAW(100) NOT NULL PRIMARY KEY,LSVR_ID SMALLINT NOT NULL,LAST_SCAN_TIME INTEGER DEFAULT 0, STATUS  NUMBER(1) DEFAULT 2, LOCATION VARCHAR2(256), UNIQUE(LSVR_ID));
drop table SVR_PROP CASCADE CONSTRAINTS;
CREATE TABLE SVR_PROP(KEY VARCHAR2(256) PRIMARY KEY,VALUE VARCHAR2(256));
drop table vcenter CASCADE CONSTRAINTS;
CREATE TABLE VCENTER(ID INTEGER NOT NULL PRIMARY KEY,VC_ID INTEGER,SERVER_ID INTEGER DEFAULT 0,IP_ADDRESS RAW(100),USER_NAME VARCHAR2(256),PASSWORD VARCHAR2(256),DISCOVERY  NUMBER(1), STATE  NUMBER(1), STATUS_DESCRIPTION  VARCHAR2(256), LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
drop table host_cluster CASCADE CONSTRAINTS;
CREATE TABLE HOST_CLUSTER(ID INTEGER NOT NULL PRIMARY KEY,NAME VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
drop table enclosure CASCADE CONSTRAINTS;
CREATE  TABLE ENCLOSURE(ID INTEGER NOT NULL PRIMARY KEY,VHOST_ID INTEGER,NAME VARCHAR2(256) ,IS_VIRTUAL NUMBER(1),ENC_TYPE INTEGER,OS_INFO VARCHAR2(256) ,IP_ADDRESS VARCHAR2(256),DM_PATH VARCHAR2(256),IS_VM_HOST NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,SAN_ID INTEGER,VENDOR VARCHAR2(256) ,MODEL VARCHAR2(256) ,VERSION VARCHAR2(256) ,SERVICE_PROFILE VARCHAR2(256), SERVER_BLADE VARCHAR2(256), RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX ENCL_NAME_INDEX ON ENCLOSURE(NAME);
drop table vhost CASCADE CONSTRAINTS;
CREATE  TABLE VHOST(ID INTEGER NOT NULL PRIMARY KEY,VCENTER_ID INTEGER,CLUSTER_ID INTEGER,NAME VARCHAR2(256),FULL_NAME VARCHAR2(256),MOREF VARCHAR2(256),MAC_ADDRESS VARCHAR2(256),IP_ADDRESS VARCHAR2(256),OS_INFO VARCHAR2(256),VENDOR VARCHAR2(256),MODEL VARCHAR2(256),VERSION VARCHAR2(256),MEMORY_SIZE NUMBER(20),CPUCOUNT INTEGER,CPU_SPEED_AVG NUMBER(20),HBAS VARCHAR2(4000),ISCSI_NAMES VARCHAR2(4000),MULTIPATH VARCHAR2(256),ALIASES VARCHAR2(256),CONN_STATE INTEGER,POWER_STATE INTEGER,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
drop table vm CASCADE CONSTRAINTS;
CREATE  TABLE VM(ID INTEGER NOT NULL PRIMARY KEY,VCENTER_ID INTEGER,VHOST_ID INTEGER,NAME VARCHAR2(256),FULL_NAME VARCHAR2(256),MOREF VARCHAR2(256),MEMORY_SIZE NUMBER(20),CPUCOUNT INTEGER,OS_TYPE VARCHAR2(256),DNS_NAME VARCHAR2(256),IP_ADDRESS  RAW(100),POWER_STATE INTEGER,HEART_BEAT_STATUS VARCHAR2(256),DISK_READ_AVG NUMBER,DISK_WRITE_AVG NUMBER,LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME NUMBER(20),RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
CREATE INDEX VM_IP_INDEX ON VM(IP_ADDRESS);
CREATE INDEX VM_VHOST_ID ON VM(VHOST_ID);
drop table vnic CASCADE CONSTRAINTS;
CREATE TABLE VNIC(ID INTEGER NOT NULL PRIMARY KEY,VCENTER_ID INTEGER,VM_ID INTEGER,PORT_GROUP VARCHAR2(256),MAC VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
CREATE INDEX VNIC_MAC ON VNIC(MAC);
CREATE INDEX VNIC_VCENTER_ID ON VNIC(VCENTER_ID);
drop table vnic_ip_address;
CREATE  TABLE VNIC_IP_ADDRESS(VNIC_ID INTEGER NOT NULL,IP_ADDRESS VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP, PRIMARY KEY (VNIC_ID,IP_ADDRESS ));
drop table phynic CASCADE CONSTRAINTS;
CREATE TABLE PHYNIC(ID INTEGER NOT NULL PRIMARY KEY,VCENTER_ID INTEGER,VHOST_ID INTEGER,MO_KEY VARCHAR2(256),DEVICE VARCHAR2(256),MAC VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME INTEGER,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
CREATE INDEX PHYNIC_MAC ON PHYNIC(MAC);
CREATE INDEX PHYNIC_VCENTER_ID ON PHYNIC(VCENTER_ID);
drop table vm_phynic_info CASCADE CONSTRAINTS;
CREATE TABLE VM_PHYNIC_INFO(VM_ID INTEGER NOT NULL,PHYNIC_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256),CONSTRAINT SYS_PK_VM_PHYNIC_INFO PRIMARY KEY(VM_ID,PHYNIC_ID));
CREATE INDEX VM_PHYNIC_VM_ID ON VM_PHYNIC_INFO(VM_ID);
CREATE INDEX VM_PHYNIC_PHYNIC_ID ON VM_PHYNIC_INFO(PHYNIC_ID);
drop table data_store CASCADE CONSTRAINTS;
CREATE  TABLE DATA_STORE(ID INTEGER NOT NULL PRIMARY KEY,VCENTER_ID INTEGER, FABRIC_ID INTEGER, NODE_WWN RAW(100), PORT_WWN RAW(100), LUN_UUID VARCHAR2(256), LUN INTEGER, SCSI_LUN VARCHAR2(256), UUID VARCHAR2(256), CANONICAL_NAME VARCHAR2(256), URL VARCHAR2(256), NAME VARCHAR2(256), FREE_SPACE NUMBER(20),MAX_FILESIZE NUMBER(20),LAST_UPDATE_TIME TIMESTAMP,LAST_SCAN_TIME NUMBER(20),RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
drop table enc_datastore_info CASCADE CONSTRAINTS;
CREATE  TABLE ENC_DATASTORE_INFO(ENCLOSURE_ID INTEGER NOT NULL,DATASTORE_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256),CONSTRAINT SYS_PK_ENC_DATASTORE_INFO PRIMARY KEY(ENCLOSURE_ID,DATASTORE_ID));
CREATE INDEX ENC_DATASTORE_ENCLOSURE_ID ON ENC_DATASTORE_INFO(ENCLOSURE_ID);
CREATE INDEX ENC_DATASTORE_DATASTORE_ID ON ENC_DATASTORE_INFO(DATASTORE_ID);
drop table vm_datastore_info CASCADE CONSTRAINTS;
CREATE  TABLE VM_DATASTORE_INFO(VM_ID INTEGER NOT NULL,DATASTORE_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256),CONSTRAINT SYS_PK_VM_DATASTORE_INFO PRIMARY KEY(VM_ID,DATASTORE_ID));
CREATE INDEX VM_DATASTORE_VM_ID ON VM_DATASTORE_INFO(VM_ID);
CREATE INDEX VM_DATASTORE_DATASTORE_ID ON VM_DATASTORE_INFO(DATASTORE_ID);
drop table events CASCADE CONSTRAINTS;
CREATE TABLE EVENTS(EVENTID INTEGER NOT NULL PRIMARY KEY,FIRST_SEEN TIMESTAMP,LAST_SEEN TIMESTAMP,COUNT NUMBER(22) DEFAULT 0,SWITCH_TIME TIMESTAMP,TYPE INTEGER,FACILITY VARCHAR2(20),SEVERITY INTEGER,SOURCE VARCHAR2(256),DESCR VARCHAR2(4000),SYSLOGEVENT VARCHAR2(80),VSANID INTEGER DEFAULT 0,DCID INTEGER,SWITCHID INTEGER,SRCID INTEGER,DESTID INTEGER,ENCLOSURE_ID INTEGER,GROUP_ID INTEGER,ACK NUMBER(1),DCTYPE NUMBER(1),RESERVE_COL1 VARCHAR2(255),RESERVE_COL2 VARCHAR2(255));
CREATE INDEX EVENTS_SEVERITY_INDEX ON EVENTS(SEVERITY);
CREATE INDEX EVENTS_GROUP_INDEX ON EVENTS(GROUP_ID);
drop table accounting CASCADE CONSTRAINTS;
CREATE TABLE ACCOUNTING(EVENTID INTEGER NOT NULL PRIMARY KEY,FIRST_SEEN TIMESTAMP,LAST_SEEN TIMESTAMP,COUNT NUMBER(22) DEFAULT 0,SWITCH_TIME TIMESTAMP,FACILITY VARCHAR2(20),SEVERITY INTEGER,SOURCE VARCHAR2(255),DESCR VARCHAR2(4000),SYSLOGEVENT VARCHAR2(80),VSANID INTEGER,DCID INTEGER,SWITCHID INTEGER,SRCID INTEGER,DESTID INTEGER,USER_NAME VARCHAR2(255),GROUP_ID INTEGER,ACK NUMBER(1),DCTYPE NUMBER(1),REVERSE_COL1 VARCHAR2(255),RESERVE_COL2 VARCHAR2(255));
CREATE INDEX ACCOUNTING_SEVERITY_INDEX ON ACCOUNTING(SEVERITY);
DROP TABLE DCNMUSER CASCADE CONSTRAINTS;
CREATE TABLE DCNMUSER(ID INTEGER NOT NULL PRIMARY KEY,VERSION INTEGER,USERID VARCHAR2(256)  NOT NULL,PASSWORD VARCHAR2(256), ROLE VARCHAR2(256), SALT INTEGER DEFAULT 0, UNIQUE (USERID));
drop table FAILED_ATTEMPTS CASCADE CONSTRAINTS;
CREATE  TABLE FAILED_ATTEMPTS(USER_NAME VARCHAR2(256), FAILED_ATTEMPT_TIME INTEGER, PRIMARY KEY(USER_NAME, FAILED_ATTEMPT_TIME));
CREATE INDEX FAILED_ATTEMPTS_INDEX ON FAILED_ATTEMPTS(USER_NAME);
drop table snmpuser CASCADE CONSTRAINTS;
CREATE  TABLE SNMPUSER(ID INTEGER NOT NULL PRIMARY KEY,VERSION INTEGER,USER_NAME VARCHAR2(256) ,AUTH_PASSWORD VARCHAR2(256) ,PRIV_PASSWORD VARCHAR2(256) ,AUTH_PROTOCOL INTEGER,PRIV_PROTOCOL INTEGER,SECURITY_NAME VARCHAR2(256) ,ROLE_NAME VARCHAR2(256) ,IS_LOGGING_IN NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
drop table role CASCADE CONSTRAINTS;
CREATE  TABLE ROLE(ROLE_NAME VARCHAR2(256)  NOT NULL PRIMARY KEY, DESCRIPTION VARCHAR2(256) );
drop table role_fabric_info CASCADE CONSTRAINTS;
CREATE  TABLE ROLE_FABRIC_INFO(ROLE_NAME VARCHAR2(256)  NOT NULL, FABRIC_ID INTEGER NOT NULL, LAST_UPDATE_TIME timestamp, CONSTRAINT role_fabric PRIMARY KEY(role_name,fabric_id));
drop table USERFABRIC CASCADE CONSTRAINTS;
CREATE  TABLE USERFABRIC(FMUSER_NAME VARCHAR2(256) NOT NULL,FABRIC_ID INTEGER NOT NULL,SNMPUSER_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_USERFABRIC PRIMARY KEY(FMUSER_NAME,FABRIC_ID));
drop table userswitch_info CASCADE CONSTRAINTS;
CREATE  TABLE USERSWITCH_INFO(FMUSER_ID INTEGER NOT NULL,IP_ADDRESS RAW(100) NOT NULL,SNMPUSER_ID INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) ,CONSTRAINT SYS_PK_USERSWITCH_INFO PRIMARY KEY(FMUSER_ID,IP_ADDRESS));
drop table scsi_target CASCADE CONSTRAINTS;
CREATE  TABLE SCSI_TARGET(ID INTEGER NOT NULL PRIMARY KEY,WWN RAW(8),ENCLOSURE_ID INTEGER,DEV_TYPE INTEGER,VENDOR_ID VARCHAR2(256) ,PRODUCT_ID VARCHAR2(256) ,REV_LEVEL VARCHAR2(256) ,OTHER_INFO RAW(100),IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,STATUS INTEGER,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
drop table hba CASCADE CONSTRAINTS;
CREATE  TABLE HBA(ID INTEGER NOT NULL PRIMARY KEY,ENCLOSURE_ID INTEGER,HWWN RAW(8),NWWN RAW(8),TYPE SMALLINT,MANUFACTURER VARCHAR2(256) ,SERIAL_NUMBER VARCHAR2(256) ,MODEL VARCHAR2(256) ,MODEL_DESCRIPTION VARCHAR2(256) ,HW_VERSION VARCHAR2(256) ,SW_VERSION VARCHAR2(256) ,DRIVER_VERSION VARCHAR2(256) ,OPT_ROM_VERSION VARCHAR2(256) ,OS VARCHAR2(256) ,IP_ADDRESS VARCHAR2(256) ,IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,STATUS INTEGER,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX HBA_ENCLOSURE_ID_INDEX ON HBA(ENCLOSURE_ID);
CREATE INDEX HBA_HWWN_INDEX ON HBA(HWWN);
CREATE INDEX HBA_NWWN_INDEX ON HBA(NWWN);
drop table ficon_info CASCADE CONSTRAINTS;
CREATE  TABLE FICON_INFO(ID INTEGER NOT NULL PRIMARY KEY,VENDOR VARCHAR2(256) ,TYPE_NUM VARCHAR2(256) ,MODEL_NUM VARCHAR2(256) ,SERIAL_NUM VARCHAR2(256) ,PORT_ID VARCHAR2(256) ,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX FICON_PORT_ID_INDEX ON FICON_INFO(PORT_ID);
drop table license CASCADE CONSTRAINTS;
CREATE  TABLE LICENSE(ID INTEGER NOT NULL PRIMARY KEY,SWITCH_ID INTEGER,FEATURE_NAME VARCHAR2(256) ,TYPE INTEGER,LICENSE_FLAG RAW(100),MAX_LICENSE INTEGER,MISSING_LICENSE INTEGER,CURRENT_LICENSE INTEGER,EXPIRE INTEGER DEFAULT -1,GRACE_PERIOD INTEGER,LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX LICENSE_SWITCH_ID_INDEX ON LICENSE(SWITCH_ID);
drop table snmp_community CASCADE CONSTRAINTS;
CREATE  TABLE SNMP_COMMUNITY(ID INTEGER NOT NULL PRIMARY KEY,IP_ADDRESS VARCHAR2(256)  NOT NULL,READ VARCHAR2(256) ,WRITE VARCHAR2(256) ,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
drop table span_port CASCADE CONSTRAINTS;
CREATE  TABLE SPAN_PORT(ID INTEGER NOT NULL PRIMARY KEY,IF_INDEX INTEGER,SWITCH_ID INTEGER,LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANPORT_SWITCH_ID_INDEX ON SPAN_PORT(SWITCH_ID);
CREATE INDEX SPANPORT_IFINDEX_INDEX ON SPAN_PORT(IF_INDEX);
drop table span_session CASCADE CONSTRAINTS;
CREATE  TABLE SPAN_SESSION(ID INTEGER NOT NULL PRIMARY KEY,SESSION_ID INTEGER,SPAN_PORT_ID INTEGER,OPER_STATUS INTEGER,VSAN_FILTER VARCHAR2(256) ,VSAN_SOURCE VARCHAR2(256) ,LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANSESSION_SPANPORT_ID_INDEX ON SPAN_SESSION(SPAN_PORT_ID);
CREATE INDEX SPANSESSION_SESSION_ID_INDEX ON SPAN_SESSION(SESSION_ID);
drop table SPAN_SOURCE_PORT CASCADE CONSTRAINTS;
CREATE  TABLE SPAN_SOURCE_PORT(ID INTEGER NOT NULL PRIMARY KEY,IF_INDEX INTEGER,DIRECTION INTEGER,SESSION_ID INTEGER,LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SPANSOURCEPORT_IFINDEX_INDEX ON SPAN_SOURCE_PORT(IF_INDEX);
CREATE INDEX SPANSOURCEPORT_SE_ID_INDEX ON SPAN_SOURCE_PORT(SESSION_ID);
drop table NTOP CASCADE CONSTRAINTS;
CREATE  TABLE NTOP(ID INTEGER NOT NULL PRIMARY KEY,IP_ADDR VARCHAR2(256) ,PORT_NUMBER INTEGER,LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX NTOP_IP_INDEX ON NTOP(IP_ADDR);
CREATE INDEX NTOP_PORT_INDEX ON NTOP(PORT_NUMBER);
drop table NTOP_SPAN_INFO CASCADE CONSTRAINTS;
CREATE  TABLE NTOP_SPAN_INFO(ID INTEGER NOT NULL PRIMARY KEY,NTOP_ID INTEGER,SPAN_PORT_ID INTEGER,ETH_NAME VARCHAR2(256) ,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX NTOP_SPAN_NTOPID_INDEX ON NTOP_SPAN_INFO(NTOP_ID);
CREATE INDEX NTOP_SPAN_SPANID_INDEX ON NTOP_SPAN_INFO(SPAN_PORT_ID);
drop table PM_COLLECTION CASCADE CONSTRAINTS;
CREATE  TABLE PM_COLLECTION(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,VSAN_LIST VARCHAR2(256) ,MONITOR_ISL NUMBER(1),MONITOR_HOST NUMBER(1),MONITOR_STORAGE NUMBER(1),MONITOR_FLOW NUMBER(1),MONITOR_GIGE NUMBER(1),MONITOR_OTHER NUMBER(1),TRAFFIC_THRESHOLD_ENABLE NUMBER(1),EVENT_THRESHOLD NUMBER(1),LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX PM_POLICY_FABRIC_ID_INDEX ON PM_COLLECTION(FABRIC_ID);
drop table PM_OPTION CASCADE CONSTRAINTS;
CREATE  TABLE PM_OPTION(ID INTEGER NOT NULL PRIMARY KEY,AUTO_COLLECT_NEW_DEVICE NUMBER(1),INTERPOLATION NUMBER(1),THRESHOLD_TYPE INTEGER,CRITICAL_WATERMARK INTEGER,WARNING_WATERMARK INTEGER,BASELINE_PERIOD INTEGER,LAST_UPDATE_TIME TIMESTAMP,FIVE_MIN_SAMPLE_DAYS INTEGER DEFAULT 600,THIRTY_MIN_SAMPLE_DAYS INTEGER DEFAULT 700,TWO_HOUR_SAMPLE_DAYS INTEGER DEFAULT 775,DAILY_SAMPLE_DAYS INTEGER DEFAULT 300,ISL_INTERVAL INTEGER DEFAULT 300, COLLECT_LAN_ISL NUMBER(1), COLLECT_LAN_FEX NUMBER(1), COLLECT_LAN_OTHER NUMBER(1), COLLECT_LAN_ERROR NUMBER(1), THRESHOLD_ISL_ONLY NUMBER(1));
drop table EVENT_FORWARD CASCADE CONSTRAINTS;
CREATE TABLE EVENT_FORWARD(ID INTEGER NOT NULL PRIMARY KEY,TYPE INTEGER,FID INTEGER,VSAN_SCOPE VARCHAR2(255),SEVERITY INTEGER,ADDRESS VARCHAR2(255),EVENTTYPE INTEGER,SUBTYPE INTEGER,LAST_UPDATE_TIME TIMESTAMP,GID INTEGER,ISLAN NUMBER(1),FACILITY VARCHAR2(255),SYSTYPE VARCHAR2(255),DESREGX VARCHAR2(255),PGID INTEGER);
drop table NAV_GROUPS CASCADE CONSTRAINTS;
CREATE  TABLE NAV_GROUPS(ID INTEGER NOT NULL PRIMARY KEY,NAME VARCHAR(255),TYPE INTEGER);
CREATE UNIQUE INDEX NAV_GROUPS_ID_INDEX ON NAV_GROUPS(ID);
drop table NAV_GROUP_MEMBER CASCADE CONSTRAINTS;
CREATE  TABLE NAV_GROUP_MEMBER(ID INTEGER NOT NULL PRIMARY KEY,MEM_DBID INTEGER,MEM_NAME VARCHAR(255),TYPE INTEGER, GROUP_ID INTEGER);
CREATE INDEX NAV_GROUP_MEMBER_ID_INDEX ON NAV_GROUP_MEMBER(ID);
drop table APP_GROUPS CASCADE CONSTRAINTS;
CREATE  TABLE APP_GROUPS(ID INTEGER NOT NULL PRIMARY KEY,NAME VARCHAR(255));
CREATE UNIQUE INDEX APP_GROUPS_ID_INDEX ON APP_GROUPS(ID);
drop table APP_GROUP_MEMBER CASCADE CONSTRAINTS;
CREATE  TABLE APP_GROUP_MEMBER(ID INTEGER NOT NULL PRIMARY KEY,IF_ID INTEGER,SWITCH_ID INTEGER,TYPE INTEGER, GROUP_ID INTEGER,
								FOREIGN KEY(GROUP_ID) REFERENCES APP_GROUPS ON DELETE CASCADE);
CREATE INDEX APP_GROUP_MEMBER_ID_INDEX ON APP_GROUP_MEMBER(ID);
drop table PM_BUFFER_COUNT CASCADE CONSTRAINTS;
CREATE TABLE PM_BUFFER_COUNT (UPDATE_TIME TIMESTAMP,SWITCH_ID INTEGER, IF_INDEX INTEGER,COUNT INTEGER);
drop table CAPACITY_TIME CASCADE CONSTRAINTS;
CREATE TABLE CAPACITY_TIME (ID INTEGER NOT NULL PRIMARY KEY, UPDATE_DATE TIMESTAMP, UPDATE_YEAR INTEGER,
							DAY_OF_YEAR INTEGER, DAY_OF_MONTH INTEGER,WEEK_OF_YEAR INTEGER,
							MONTH_OF_YEAR INTEGER, QUARTER INTEGER);
CREATE INDEX CAPACITY_TIME_ID_INDEX ON CAPACITY_TIME(ID);
drop table CAPACITY_DATA CASCADE CONSTRAINTS;
CREATE TABLE CAPACITY_DATA (TIME_ID INTEGER NOT NULL, FABRIC_ID INTEGER, SWITCH_ID INTEGER,
							AVAIL_1G INTEGER, TOTAL_1G INTEGER,
							AVAIL_2G INTEGER, TOTAL_2G INTEGER,
							AVAIL_4G INTEGER, TOTAL_4G INTEGER,
							AVAIL_8G INTEGER, TOTAL_8G INTEGER,
							AVAIL_10G INTEGER, TOTAL_10G INTEGER,
							AVAIL_16G INTEGER, TOTAL_16G INTEGER,
							AVAIL_40G INTEGER, TOTAL_40G INTEGER,
							AVAIL_100G INTEGER, TOTAL_100G INTEGER,
							AVAIL_NA INTEGER, TOTAL_NA INTEGER, HEALTH NUMBER, EVENTS INTEGER);
drop table CAPACITY_DATA_SMIS CASCADE CONSTRAINTS;
CREATE TABLE CAPACITY_DATA_SMIS (TIME_ID INTEGER NOT NULL, SYSTEM_ID INTEGER, POOL_ID INTEGER,
							RAW_CAPACITY INTEGER, REMAINING_RAW_CAPACITY INTEGER,
							TOTAL_MANAGED INTEGER, REMAINING_MANAGED INTEGER);
drop table CAPACITY_DATA_SMIS_LUN CASCADE CONSTRAINTS;
CREATE TABLE CAPACITY_DATA_SMIS_LUN (TIME_ID INTEGER NOT NULL, SYSTEM_ID INTEGER, LUN_ID INTEGER,
							TOTAL_MANAGED INTEGER, REMAINING_MANAGED INTEGER);
drop table GROUPS CASCADE CONSTRAINTS;
CREATE  TABLE GROUPS(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,NAME VARCHAR2(256) ,TYPE INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE UNIQUE INDEX GROUP_FABRICID_NAME_INDEX ON GROUPS(FABRIC_ID,NAME);
drop table GROUP_FABRIC_INFO CASCADE CONSTRAINTS;
CREATE  TABLE GROUP_FABRIC_INFO(GROUP_ID INTEGER NOT NULL,FABRIC_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_FABRIC_INFO PRIMARY KEY(GROUP_ID,FABRIC_ID));
CREATE INDEX GROUP_FABRIC_GROUP_ID ON GROUP_FABRIC_INFO(GROUP_ID);
CREATE INDEX GROUP_FABRIC_FABRIC_ID ON GROUP_FABRIC_INFO(FABRIC_ID);
drop table GROUP_MEMBER_INFO CASCADE CONSTRAINTS;
CREATE  TABLE GROUP_MEMBER_INFO(GROUP_ID INTEGER NOT NULL,MEMBER_ID INTEGER NOT NULL,TYPE INTEGER,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_MEMBER_INFO PRIMARY KEY(GROUP_ID,MEMBER_ID));
CREATE INDEX GROUP_MEMBER_GROUP_ID ON GROUP_MEMBER_INFO(GROUP_ID);
CREATE INDEX GROUP_MEMBER_MEMBER_ID ON GROUP_MEMBER_INFO(MEMBER_ID);
drop table GROUP_USER_INFO  CASCADE CONSTRAINTS;
CREATE  TABLE GROUP_USER_INFO(GROUP_ID INTEGER NOT NULL,FMUSER_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT SYS_PK_GROUP_USER_INFO PRIMARY KEY(GROUP_ID,FMUSER_ID));
CREATE INDEX GROUP_USER_GROUP_ID ON GROUP_USER_INFO(GROUP_ID);
CREATE INDEX GROUP_USER_FMUSER_ID ON GROUP_USER_INFO(FMUSER_ID);
drop table HW_COMPONENT CASCADE CONSTRAINTS;
CREATE  TABLE HW_COMPONENT(ID INTEGER NOT NULL PRIMARY KEY,SWITCH_ID INTEGER,NAME VARCHAR2(256) ,PHYSICAL_INDEX INTEGER,RELATIVE_POSITION INTEGER,HW_TYPE INTEGER,VENDOR_TYPE RAW(200),HW_REVISION VARCHAR2(256) ,FW_REVISION VARCHAR2(256) ,SW_REVISION VARCHAR2(256) ,SERIAL_NUMBER VARCHAR2(256) ,MANUFACTURER VARCHAR2(256) ,MODEL_NAME VARCHAR2(256) ,ASSET_ID VARCHAR2(256) ,STATUS_DESCRIPTION VARCHAR2(256) ,SEC_SERIAL_NUMBER VARCHAR2(256) , LAST_SCAN_TIME INTEGER,LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX HW_COMPONENT_SWITCH_ID ON HW_COMPONENT(SWITCH_ID);
drop table HW_CARD CASCADE CONSTRAINTS;
CREATE  TABLE HW_CARD(HW_COMPONENT_ID INTEGER NOT NULL PRIMARY KEY,MODEL_TYPE INTEGER,ADMIN_STATUS INTEGER,OPER_STATUS INTEGER,RESET_REASON VARCHAR2(256) ,STATUS_LAST_CHANGE_TIME INTEGER,POWER_ADMIN_STATUS INTEGER,POWER_OPER_STATUS INTEGER,POWER_CURRENT INTEGER,DMM_STATE INTEGER,IOA_STATE INTEGER,SE_STATE INTEGER,SANTAP_STATE INTEGER);
drop table HW_POWER_SUPPLY CASCADE CONSTRAINTS;
CREATE  TABLE HW_POWER_SUPPLY(HW_COMPONENT_ID INTEGER NOT NULL PRIMARY KEY,REDUNDANCY_MODE INTEGER,TOTAL_DRAWN_CURRENT INTEGER,TOTAL_AVAILABLE_CURRENT INTEGER,POWER_UNITS VARCHAR2(256) );
drop table SWITCH_MGMT_ADDRESS CASCADE CONSTRAINTS;
CREATE  TABLE SWITCH_MGMT_ADDRESS(SWITCH_ID INTEGER NOT NULL,MGMT_ADDRESS RAW(100),MGMT_TYPE number(4),LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX SWITCH_MGMT_ADDRESS_ID_INDEX ON SWITCH_MGMT_ADDRESS(SWITCH_ID);
drop table PM_EXTRAOID CASCADE CONSTRAINTS;
CREATE  TABLE PM_EXTRAOID(ID INTEGER NOT NULL PRIMARY KEY,FID INTEGER,NAME VARCHAR2(256) ,DISPLAYNAME VARCHAR2(256) ,SWITCHIP VARCHAR2(256) ,TYPE VARCHAR2(256) ,SWITCHNAME VARCHAR2(256), SWITCHID INTEGER );
CREATE INDEX PM_EXTRAOID_FABRIC_ID_INDEX ON PM_EXTRAOID(FID);
drop table PM_DATAINDEX CASCADE CONSTRAINTS;
CREATE  TABLE PM_DATAINDEX(ID INTEGER,LOGICALFILENAME VARCHAR2(256) ,FILETYPE INTEGER,DATAINDEX INTEGER,PHYSICALFILEINDEX INTEGER);
CREATE INDEX PM_DATAINDEX_LOGICALFILE_INDEX ON PM_DATAINDEX(LOGICALFILENAME);
drop table PM_INDEXBOOKMARK CASCADE CONSTRAINTS;
CREATE  TABLE PM_INDEXBOOKMARK(TYPE INTEGER  NOT NULL,BOOKMARKINDEX INTEGER,BOOKMARKCOUNT INTEGER,SERVERID INTEGER, PRIMARY KEY(TYPE, SERVERID));
drop table device_alias CASCADE CONSTRAINTS;
CREATE  TABLE DEVICE_ALIAS(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,CFS_REGION_ID INTEGER,WWN RAW(8),ALIAS VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX DEVALIAS_FABRIC_ID ON DEVICE_ALIAS(FABRIC_ID);
CREATE INDEX DEVALIAS_CFS_REGION_ID ON DEVICE_ALIAS(CFS_REGION_ID);
CREATE INDEX DEVALIAS_WWN_INDEX ON DEVICE_ALIAS(WWN);
drop table fc_alias CASCADE CONSTRAINTS;
CREATE  TABLE FC_ALIAS(ID INTEGER NOT NULL PRIMARY KEY,VSAN_ID INTEGER,WWN RAW(8),ALIAS VARCHAR2(256),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256) ,RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX FCALIAS_VSAN_ID ON FC_ALIAS(VSAN_ID);
CREATE INDEX FCALIAS_WWN_INDEX ON FC_ALIAS(WWN);
drop table SMECLUSTER  CASCADE CONSTRAINTS;
CREATE TABLE SMECLUSTER(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,CLUSTER_ID VARCHAR2(256),NAME VARCHAR2(256),STATE INTEGER,IS_MASTER NUMBER(1),MASTER_ADDR_TYPE INTEGER, MASTER_ADDR VARCHAR2(256),MASTER_IP VARCHAR2(256), SWITCH_ID INTEGER,IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP,RESERVE_COL1 VARCHAR2(256),RESERVE_COL2 VARCHAR2(256));
CREATE INDEX CLUSTER_FABRIC_ID ON SMECLUSTER(FABRIC_ID);
CREATE INDEX CLUSTER_SWITCH_ID ON SMECLUSTER(SWITCH_ID);
drop table BASE_SVC_CLUSTER  CASCADE CONSTRAINTS;
CREATE TABLE BASE_SVC_CLUSTER(ID INTEGER NOT NULL PRIMARY KEY,FABRIC_ID INTEGER,CLUSTER_ID VARCHAR2(255),NAME VARCHAR2(255), CLUSTER_TYPE INTEGER, STATE INTEGER,IS_MASTER NUMBER(1),MASTER_ADDR_TYPE INTEGER, MASTER_ADDR VARCHAR2(255), MASTER_IP VARCHAR2(255), SWITCH_ID INTEGER,IS_PRESENT NUMBER(1),LAST_UPDATE_TIME TIMESTAMP);
CREATE INDEX BASE_SVC_CLUSTER_FABRIC_ID ON BASE_SVC_CLUSTER(FABRIC_ID);
CREATE INDEX BASE_SVC_CLUSTER_SWITCH_ID ON BASE_SVC_CLUSTER(SWITCH_ID);
drop table fm_session CASCADE CONSTRAINTS;
CREATE TABLE fm_session(
    ID  INTEGER NOT NULL,
    SERVER_ID  INTEGER NOT NULL,
    CLIENT VARCHAR2(80) NOT NULL,
    IS_LOCAL NUMBER(1) NOT NULL,
    USER_NAME VARCHAR2(80) NOT NULL,    
    AUTH_PASSWORD VARCHAR2(80) NOT NULL,    
    ROLE_NAME VARCHAR2(80) NOT NULL,
    LOGIN_TIME TIMESTAMP NOT NULL,
    LAST_ACCESS_TIME TIMESTAMP NOT NULL,
    PRIMARY KEY(ID, SERVER_ID)
);
drop table file_lic CASCADE CONSTRAINTS;
CREATE TABLE file_lic(
    sign varchar2(255) PRIMARY KEY,
    details varchar2(4000) NOT NULL
);
drop table host_redundancy_errors;
CREATE TABLE host_redundancy_errors(
	lsvr_id smallint NOT NULL,
	host_enclosure_id INTEGER NOT NULL,
	storage_enclosure_id INTEGER default -1,
	storage_str VARCHAR(255) default NULL,
	severity INTEGER NOT NULL,
	error_id INTEGER NOT NULL,
	first_seen TIMESTAMP NOT NULL,
	CONSTRAINT host_redundancy_events_pkey PRIMARY KEY (lsvr_id, host_enclosure_id, storage_enclosure_id)
);

drop table host_redundancy_ignored_host;
CREATE TABLE host_redundancy_ignored_host(
	host_enclosure_id INTEGER NOT NULL PRIMARY KEY,
	type smallint NOT NULL,
	reason VARCHAR(4000) default ''
);

drop table host_redundancy_Summary;
CREATE TABLE host_redundancy_Summary(
	title VARCHAR(255) NOT NULL PRIMARY KEY,
	summary_type smallint NOT NULL,
	count Integer NOT NULL,
	filter_type smallint NOT NULL,
	last_update_time timestamp 
);
INSERT into PM_OPTION (ID, AUTO_COLLECT_NEW_DEVICE,INTERPOLATION,THRESHOLD_TYPE,CRITICAL_WATERMARK, 
WARNING_WATERMARK, BASELINE_PERIOD, LAST_UPDATE_TIME, FIVE_MIN_SAMPLE_DAYS, THIRTY_MIN_SAMPLE_DAYS, 
TWO_HOUR_SAMPLE_DAYS, DAILY_SAMPLE_DAYS, ISL_INTERVAL, COLLECT_LAN_ISL, COLLECT_LAN_FEX, COLLECT_LAN_OTHER, COLLECT_LAN_ERROR, THRESHOLD_ISL_ONLY) 
values (1,1,0,0,80,
60, 7, sysdate, 600,700, 775, 300,300,1,0,0,0,1);

INSERT INTO nav_groups values(1, 'Default_SAN',2);
INSERT INTO nav_groups values(2, 'Default_LAN',1);


drop table qrtz_job_details CASCADE CONSTRAINTS;
CREATE TABLE qrtz_job_details
  (
    JOB_NAME  VARCHAR2(256) NOT NULL,
    JOB_GROUP VARCHAR2(80) NOT NULL,
    DESCRIPTION VARCHAR2(120) NULL,
    JOB_CLASS_NAME   VARCHAR2(128) NOT NULL, 
    IS_DURABLE VARCHAR2(1) NOT NULL,
    IS_VOLATILE VARCHAR2(1) NOT NULL,
    IS_STATEFUL VARCHAR2(1) NOT NULL,
    REQUESTS_RECOVERY VARCHAR2(1) NOT NULL,
    JOB_DATA BLOB NULL,
    PRIMARY KEY (JOB_NAME,JOB_GROUP)
);
drop table qrtz_job_listeners CASCADE CONSTRAINTS;
CREATE TABLE qrtz_job_listeners
  (
    JOB_NAME  VARCHAR2(256) NOT NULL, 
    JOB_GROUP VARCHAR2(80) NOT NULL,
    JOB_LISTENER VARCHAR2(80) NOT NULL,
    PRIMARY KEY (JOB_NAME,JOB_GROUP,JOB_LISTENER),
    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
    REFERENCES QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP)
);
drop table qrtz_triggers CASCADE CONSTRAINTS;
CREATE TABLE qrtz_triggers
  (
    TRIGGER_NAME VARCHAR2(256) NOT NULL,
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    JOB_NAME  VARCHAR2(256) NOT NULL, 
    JOB_GROUP VARCHAR2(80) NOT NULL,
    IS_VOLATILE VARCHAR2(1) NOT NULL,
    DESCRIPTION VARCHAR2(120) NULL,
    NEXT_FIRE_TIME NUMBER(13) NULL,
    PREV_FIRE_TIME NUMBER(13) NULL,
    TRIGGER_STATE VARCHAR2(16) NOT NULL,
    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
    START_TIME NUMBER(13) NOT NULL,
    END_TIME NUMBER(13) NULL,
    CALENDAR_NAME VARCHAR2(80) NULL,
    MISFIRE_INSTR NUMBER(2) NULL,
    JOB_DATA BLOB NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (JOB_NAME,JOB_GROUP) 
    REFERENCES QRTZ_JOB_DETAILS(JOB_NAME,JOB_GROUP) 
);
drop table qrtz_simple_triggers CASCADE CONSTRAINTS;
CREATE TABLE qrtz_simple_triggers
  (
    TRIGGER_NAME VARCHAR2(256) NOT NULL,
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    REPEAT_COUNT NUMBER(7) NOT NULL,
    REPEAT_INTERVAL NUMBER(12) NOT NULL,
    TIMES_TRIGGERED NUMBER(8) NOT NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop table qrtz_cron_triggers CASCADE CONSTRAINTS;
CREATE TABLE qrtz_cron_triggers
  (
    TRIGGER_NAME VARCHAR2(256) NOT NULL,
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    CRON_EXPRESSION VARCHAR2(80) NOT NULL,
    TIME_ZONE_ID VARCHAR2(80),
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop table qrtz_blob_triggers CASCADE CONSTRAINTS;
CREATE TABLE qrtz_blob_triggers
  (
    TRIGGER_NAME VARCHAR2(256) NOT NULL,
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    BLOB_DATA BLOB NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
        REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop table qrtz_trigger_listeners CASCADE CONSTRAINTS;
CREATE TABLE qrtz_trigger_listeners
  (
    TRIGGER_NAME  VARCHAR2(256) NOT NULL, 
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    TRIGGER_LISTENER VARCHAR2(80) NOT NULL,
    PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER),
    FOREIGN KEY (TRIGGER_NAME,TRIGGER_GROUP) 
    REFERENCES QRTZ_TRIGGERS(TRIGGER_NAME,TRIGGER_GROUP)
);
drop table qrtz_calendars CASCADE CONSTRAINTS;
CREATE TABLE qrtz_calendars
  (
    CALENDAR_NAME  VARCHAR2(80) NOT NULL, 
    CALENDAR BLOB NOT NULL,
    PRIMARY KEY (CALENDAR_NAME)
);
drop table qrtz_paused_trigger_grps CASCADE CONSTRAINTS;
CREATE TABLE qrtz_paused_trigger_grps
  (
    TRIGGER_GROUP  VARCHAR2(80) NOT NULL, 
    PRIMARY KEY (TRIGGER_GROUP)
);
drop table qrtz_fired_triggers CASCADE CONSTRAINTS;
CREATE TABLE qrtz_fired_triggers 
  (
    ENTRY_ID VARCHAR2(95) NOT NULL,
    TRIGGER_NAME VARCHAR2(256) NOT NULL,
    TRIGGER_GROUP VARCHAR2(80) NOT NULL,
    IS_VOLATILE VARCHAR2(1) NOT NULL,
    INSTANCE_NAME VARCHAR2(256) NOT NULL,
    FIRED_TIME NUMBER(13) NOT NULL,
    STATE VARCHAR2(16) NOT NULL,
    JOB_NAME VARCHAR2(256) NULL,
    JOB_GROUP VARCHAR2(80) NULL,
    IS_STATEFUL VARCHAR2(1) NULL,
    REQUESTS_RECOVERY VARCHAR2(1) NULL,
    PRIMARY KEY (ENTRY_ID)
);
drop table qrtz_scheduler_state CASCADE CONSTRAINTS;
CREATE TABLE qrtz_scheduler_state 
  (
    INSTANCE_NAME VARCHAR2(256) NOT NULL,
    LAST_CHECKIN_TIME NUMBER(13) NOT NULL,
    CHECKIN_INTERVAL NUMBER(13) NOT NULL,
    RECOVERER VARCHAR2(80) NULL,
    PRIMARY KEY (INSTANCE_NAME)
);
delete from qrtz_locks;
drop table qrtz_locks CASCADE CONSTRAINTS;
CREATE TABLE qrtz_locks
  (
    LOCK_NAME  VARCHAR2(40) NOT NULL, 
    PRIMARY KEY (LOCK_NAME)
);
INSERT INTO qrtz_locks values('TRIGGER_ACCESS');
INSERT INTO qrtz_locks values('JOB_ACCESS');
INSERT INTO qrtz_locks values('CALENDAR_ACCESS');
INSERT INTO qrtz_locks values('STATE_ACCESS');
INSERT INTO qrtz_locks values('MISFIRE_ACCESS');
create index idx_qrtz_j_req_recovery on qrtz_job_details(REQUESTS_RECOVERY);
create index idx_qrtz_t_next_fire_time on qrtz_triggers(NEXT_FIRE_TIME);
create index idx_qrtz_t_state on qrtz_triggers(TRIGGER_STATE);
create index idx_qrtz_t_nft_st on qrtz_triggers(NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_qrtz_t_volatile on qrtz_triggers(IS_VOLATILE);
create index idx_qrtz_ft_trig_name on qrtz_fired_triggers(TRIGGER_NAME);
create index idx_qrtz_ft_trig_group on qrtz_fired_triggers(TRIGGER_GROUP);
create index idx_qrtz_ft_trig_nm_gp on qrtz_fired_triggers(TRIGGER_NAME,TRIGGER_GROUP);
create index idx_qrtz_ft_trig_volatile on qrtz_fired_triggers(IS_VOLATILE);
create index idx_qrtz_ft_trig_inst_name on qrtz_fired_triggers(INSTANCE_NAME);
create index idx_qrtz_ft_job_name on qrtz_fired_triggers(JOB_NAME);
create index idx_qrtz_ft_job_group on qrtz_fired_triggers(JOB_GROUP);
create index idx_qrtz_ft_job_stateful on qrtz_fired_triggers(IS_STATEFUL);
create index idx_qrtz_ft_job_req_recovery on qrtz_fired_triggers(REQUESTS_RECOVERY);

drop table XMLDOCS CASCADE CONSTRAINTS;
CREATE TABLE XMLDOCS (
             DOCUMENT_NAME    VARCHAR2(256),
             USER_NAME        VARCHAR2(256),
             CONTENT           CLOB,
             CHECKSUM        INTEGER,
         LAST_UPDATE_TIME  TIMESTAMP,
             FILESIZE        INTEGER,
             unique(DOCUMENT_NAME,USER_NAME)
               );
drop table config_file CASCADE CONSTRAINTS;
CREATE TABLE config_file (
             DOCUMENT_NAME    VARCHAR2(256),
             USER_NAME        VARCHAR2(256),
             CONTENT           CLOB,
             CHECKSUM        INTEGER,
         LAST_UPDATE_TIME  TIMESTAMP,
             FILESIZE        INTEGER,
             unique(DOCUMENT_NAME,USER_NAME)
               );
drop table client_files CASCADE CONSTRAINTS;
CREATE TABLE client_files (
             DOCUMENT_NAME    VARCHAR2(256),
             USER_NAME        VARCHAR2(256),
             CONTENT           CLOB,
             CHECKSUM        INTEGER,
         LAST_UPDATE_TIME  TIMESTAMP,
             FILESIZE        INTEGER,
             unique(DOCUMENT_NAME,USER_NAME)
               );

DROP TABLE SME_SETTINGS CASCADE CONSTRAINTS;
CREATE TABLE SME_SETTINGS(
    NAME VARCHAR2(64) NOT NULL, 
    VALUE VARCHAR2(64), 
    CONSTRAINT SME_SETTINGS_PKEY PRIMARY KEY (NAME)
);

DROP TABLE SME_CLUSTER CASCADE CONSTRAINTS;
CREATE TABLE SME_CLUSTER(
    CLUSTER_NAME VARCHAR2(64) NOT NULL, 
    CLUSTER_ID VARCHAR2(64), 
    STATUS INTEGER, 
    CKMC_STATE INTEGER,  
    MASTER_IP_ADDR VARCHAR2(32),
    KMC_ID VARCHAR2(32),
    CONSTRAINT SME_CLUSTER_PKEY PRIMARY KEY (CLUSTER_NAME)
);

DROP TABLE SME_CLUSTER_ATTRIBUTES CASCADE CONSTRAINTS;
CREATE TABLE SME_CLUSTER_ATTRIBUTES(
    CLUSTER_NAME VARCHAR2(64) NOT NULL, 
    SECURITY_MODE INTEGER, 
    RECOVERY_THRESHOLD INTEGER,  
    RECOVERY_TOTAL INTEGER,
    CAPABILITY INTEGER,     
    ACTIVE_LOCK INTEGER, 
    CONSTRAINT SME_CLUSTER_ATTRIBUTES_PKEY PRIMARY KEY (CLUSTER_NAME)
);

DROP TABLE SME_CLUSTER_SMARTCARD CASCADE CONSTRAINTS;
CREATE TABLE SME_CLUSTER_SMARTCARD(
    CLUSTER_NAME VARCHAR2(64) NOT NULL, 
    MASTER_KEY_GUID VARCHAR2(64) NOT NULL,  
    MASTER_KEY_VERSION VARCHAR2(8)NOT NULL,
    RECOVERY_SHARE_VERSION VARCHAR2(8) NOT NULL,
    SHARE_INDEX INTEGER,
    SMARTCARD_LABEL VARCHAR2(32),
    SMARTCARD_SERIAL_NUMBER VARCHAR2(32),
    RO_USERNAME VARCHAR2(32),
    CONSTRAINT SME_CLUSTER_SMARTCARD_PKEY PRIMARY KEY (CLUSTER_NAME, MASTER_KEY_GUID, MASTER_KEY_VERSION, RECOVERY_SHARE_VERSION, SHARE_INDEX)
);

DROP TABLE SME_TAPE_GROUP CASCADE CONSTRAINTS;
CREATE TABLE SME_TAPE_GROUP(
    CLUSTER_NAME VARCHAR2(64) NOT NULL,  
    TAPEGROUP_NAME VARCHAR2(64) NOT NULL,  
    STATUS INTEGER,  
    CONSTRAINT SME_TAPE_GROUP_PKEY PRIMARY KEY (CLUSTER_NAME, TAPEGROUP_NAME)
);

DROP TABLE SME_TAPE_VOLUMEGROUP CASCADE CONSTRAINTS;
CREATE TABLE SME_TAPE_VOLUMEGROUP (
    CLUSTER_NAME VARCHAR2(64) NOT NULL, 
    TAPEGROUP_NAME VARCHAR2(64) NOT NULL, 
    VOLUME_GROUP_NAME VARCHAR2(64) NOT NULL,  
    STATUS INTEGER,  
    CONSTRAINT SME_TAPE_VOLUMEGROUP_PKEY PRIMARY KEY (CLUSTER_NAME, TAPEGROUP_NAME, VOLUME_GROUP_NAME)
);

DROP TABLE SME_KEY CASCADE CONSTRAINTS;
CREATE TABLE SME_KEY(
    GUID VARCHAR2(64) NOT NULL,  
    CLUSTER_NAME VARCHAR2(64) NOT NULL,  
    CLONED_FROM_GUID VARCHAR2(64),  
    CLUSTER_ID VARCHAR2(64), 
    STATUS INTEGER,  
    KEY_TYPE INTEGER,  
    ENTITY_INDEX VARCHAR2(256),  
    VERSION INTEGER,  
    WRAP_BY_GUID VARCHAR2(64),  
    KEY_DATA VARCHAR2(2048),
    MASTER_KEY_GUID VARCHAR2(64),  
    CREATION_TIME TIMESTAMP,  
    ARCHIVAL_TIME TIMESTAMP,  
    CONSTRAINT SME_KEY_PKEY PRIMARY KEY (GUID, CLUSTER_NAME)
);


CREATE INDEX SME_KEY_CLONED_FROM_GUID_INDEX ON SME_KEY(CLONED_FROM_GUID, CLUSTER_NAME);

CREATE INDEX SME_KEY_ENTITY_INDEX ON SME_KEY(KEY_TYPE, ENTITY_INDEX, VERSION);

DROP TABLE SME_ACCOUNTING_LOG CASCADE CONSTRAINTS;
CREATE TABLE SME_ACCOUNTING_LOG
(
    LOG_ID INTEGER NOT NULL,
    TIME_STAMP TIMESTAMP NOT NULL,
    HOST_NAME VARCHAR2(64) NOT NULL,
    USER_NAME VARCHAR2(64),
    CLUSTER_NAME VARCHAR2(64),
    CLUSTER_ID VARCHAR2(64),
    OPERATION VARCHAR2(64),
    STATUS VARCHAR2(64),
    DETAILS VARCHAR2(1024),
  CONSTRAINT SME_ACCOUNTING_LOG_PKEY PRIMARY KEY (LOG_ID)
);

DROP TABLE SME_REPLICATION_REL CASCADE CONSTRAINTS;
CREATE TABLE SME_REPLICATION_REL
(
    SRC_CLUSTER_NAME VARCHAR2(64) NOT NULL,
    SRC_TAPE_GROUP_NAME VARCHAR2(64) NOT NULL,
    SRC_VOLUME_GROUP_NAME VARCHAR2(64) NOT NULL,
    REPLICATION_ID INTEGER NOT NULL,
    STATUS INTEGER,
    CREATION_TIME TIMESTAMP,
    DEST_CLUSTER_NAME VARCHAR2(64),
    DEST_TAPE_GROUP_NAME VARCHAR2(64),
    DEST_VOLUME_GROUP_NAME VARCHAR2(64),
    STATUS_DESC VARCHAR2(255),
    LAST_UPDATE_TIME TIMESTAMP,
    CONSTRAINT SME_REPLICATION_REL_PKEY PRIMARY KEY (SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_VOLUME_GROUP_NAME, REPLICATION_ID)
);

DROP TABLE SME_REPL_PENDING_KEY CASCADE CONSTRAINTS;
CREATE TABLE SME_REPL_PENDING_KEY
(
    GUID VARCHAR2(64) NOT NULL,
    SRC_CLUSTER_NAME VARCHAR2(64) NOT NULL,
      DEST_CLUSTER_NAME VARCHAR2(64),
      DEST_TAPE_GROUP_NAME VARCHAR2(64),
      DEST_TAPE_VOLUME_GROUP_NAME VARCHAR2(64),
    SRC_TAPE_GROUP_NAME VARCHAR2(64),
      SRC_TAPE_VOLUME_GROUP_NAME VARCHAR2(64),
    SCHEDULED_REPLICATION_TIME TIMESTAMP,
    CONSTRAINT SME_REPL_PENDING_KEY_PKEY PRIMARY KEY (GUID, SRC_CLUSTER_NAME, DEST_CLUSTER_NAME, 
DEST_TAPE_GROUP_NAME, DEST_TAPE_VOLUME_GROUP_NAME)
);

DROP TABLE SME_REPL_ERROR_KEY CASCADE CONSTRAINTS;
CREATE TABLE SME_REPL_ERROR_KEY
(
    GUID VARCHAR2(64) NOT NULL,
    SRC_CLUSTER_NAME VARCHAR2(64) NOT NULL,
    DEST_CLUSTER_NAME VARCHAR2(64) NOT NULL,
    DEST_TAPE_GROUP_NAME VARCHAR2(64) NOT NULL,
    DEST_VOLUME_GROUP_NAME VARCHAR2(64) NOT NULL,
    SRC_TAPE_GROUP_NAME VARCHAR2(64),
      SRC_TAPE_VOLUME_GROUP_NAME VARCHAR2(64),
    STATUS INTEGER,
    REPLICATION_TIME TIMESTAMP,
    STATUS_DESC VARCHAR2(255),
    CONSTRAINT SME_REPL_ERROR_KEY_PKEY PRIMARY KEY (GUID, SRC_CLUSTER_NAME, DEST_CLUSTER_NAME, DEST_TAPE_GROUP_NAME, DEST_VOLUME_GROUP_NAME)
);
CREATE INDEX SME_REPL_PENDING_KEY_SRC_INDEX ON SME_REPL_PENDING_KEY(SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_TAPE_VOLUME_GROUP_NAME);
CREATE INDEX SME_REPL_ERROR_KEY_SRC_INDEX ON SME_REPL_ERROR_KEY(SRC_CLUSTER_NAME, SRC_TAPE_GROUP_NAME, SRC_TAPE_VOLUME_GROUP_NAME);

DROP TABLE SME_DISK CASCADE CONSTRAINTS;
CREATE TABLE SME_DISK
(
    CLUSTER_NAME VARCHAR2(64) NOT NULL,
    DISKGROUP_NAME VARCHAR2(64) NOT NULL,
    DISK_NAME VARCHAR2(64) NOT NULL,
    STATUS INTEGER,
    VENDOR VARCHAR2(16) NOT NULL,
    PRODUCT VARCHAR2(32) NOT NULL,
    DEVICE VARCHAR2(16) NOT NULL,
	CONSTRAINT SME_DISK_PKEY PRIMARY KEY (CLUSTER_NAME, DISKGROUP_NAME, DISK_NAME)
);

DROP TABLE SME_DISK_GROUP CASCADE CONSTRAINTS;
CREATE TABLE SME_DISK_GROUP
(
    CLUSTER_NAME VARCHAR2(64) NOT NULL,
    DISKGROUP_NAME VARCHAR2(64) NOT NULL,
    STATUS INTEGER,
  CONSTRAINT SME_DISK_GROUP_PKEY PRIMARY KEY (CLUSTER_NAME, DISKGROUP_NAME)
);

DROP TABLE SME_RKC_RELATIONSHIP CASCADE CONSTRAINTS;
CREATE TABLE SME_RKC_RELATIONSHIP
(
    SRC_CLUSTER_NAME VARCHAR2(64) NOT NULL,
    SRC_GROUP_NAME VARCHAR2(64) NOT NULL,
    SRC_NAME VARCHAR2(64) NOT NULL,
    SRC_VENDOR VARCHAR2(16) NOT NULL,
    SRC_PRODUCT VARCHAR2(32) NOT NULL,
    SRC_WWN VARCHAR2(512) NOT NULL,
    SRC_ASL_TOKEN VARCHAR2(16) NOT NULL,
    SRC_LABEL VARCHAR2(64),
    DEST_CLUSTER_NAME VARCHAR2(64) NOT NULL,
    DEST_GROUP_NAME VARCHAR2(64),
    DEST_NAME VARCHAR2(64),
    DEST_VENDOR VARCHAR2(16) NOT NULL,
    DEST_PRODUCT VARCHAR2(32) NOT NULL,
    DEST_WWN VARCHAR2(512) NOT NULL,
    DEST_ASL_TOKEN VARCHAR2(16),
    DEST_LABEL VARCHAR2(64),
    DESCRIPTION VARCHAR2(255),
    STATUS INTEGER,
    RELATIONTYPE INTEGER,
  CONSTRAINT SME_RKC_RELATIONSHIP_PKEY PRIMARY KEY (SRC_CLUSTER_NAME, SRC_VENDOR, SRC_PRODUCT, SRC_WWN, DEST_CLUSTER_NAME, DEST_VENDOR, DEST_PRODUCT, DEST_WWN)
);


DROP  TABLE ETHISL CASCADE CONSTRAINTS;
CREATE  TABLE ETHISL(ID INTEGER NOT NULL PRIMARY KEY, PORT1_ID INTEGER, PORT2_ID INTEGER, OPER_MODE SMALLINT, IS_PRESENT NUMBER(1), LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME INTEGER, IS_CHANNEL NUMBER(1), CHANNEL_ID INTEGER, IS_TRUNK NUMBER(1), NATIVE_VLANID INTEGER, ACCESS_VLANID INTEGER, IS_FEXISL NUMBER(1));

DROP  TABLE VPC_INFO CASCADE CONSTRAINTS;
CREATE  TABLE VPC_INFO(ID INTEGER NOT NULL PRIMARY KEY, VPC_ID INTEGER, DOMAIN_ID INTEGER, MULTICHASSIS_VPC_SW_ID INTEGER,  PRIMARY_VPC_SWITCH_ID INTEGER, PRIMARY_VPC_PO_ID INTEGER, PRIMARY_VPC_PEERLINK_ID INTEGER, SECONDARY_VPC_SWITCH_ID INTEGER, SECONDARY_VPC_PO_ID INTEGER, SECONDARY_VPC_PEERLINK_ID INTEGER, IS_VPC_CONSISTENT NUMBER(1), IS_PEERLINK_CONSISTENT NUMBER(1), LAST_UPDATE_TIME TIMESTAMP);

DROP  TABLE ETHSWITCH CASCADE CONSTRAINTS;
CREATE  TABLE ETHSWITCH(ID INTEGER NOT NULL PRIMARY KEY, LICENSE_ID INTEGER, IP_ADDRESS RAW(100), TYPE INTEGER, MODEL_NAME VARCHAR2(255), IS_MANAGEABLE NUMBER(1), UNMANAGEABLE_CAUSE VARCHAR2(256), NUM_PORTS INTEGER, GLOBAL_DEVICE_ID VARCHAR2(256), DEVICE_ID VARCHAR2(256), CAPABILITY RAW(100), VTP_MGMT_DOMAIN RAW(1000), VLAN_LIST VARCHAR2(4000), SYS_NAME VARCHAR2(256), SYS_CONTACT VARCHAR2(256), SYS_LOCATION VARCHAR2(256), SYS_UPTIME INTEGER, VERSION VARCHAR2(256), IS_PRESENT NUMBER(1), SERIAL_NUMBER VARCHAR2(256), LAST_UPDATE_TIME TIMESTAMP,  LAST_SCAN_TIME INTEGER,  SYS_DESCRIPTION VARCHAR2(256), VENDOR VARCHAR2(256), OPER_MODE INTEGER, IS_VDC NUMBER(1), VDC_ID INTEGER, VDC_MAC VARCHAR2(255), VDC_NAME VARCHAR2(255), DEFAULT_VDC_MAC RAW(6), VDC_STATE SMALLINT, FCOE_CAPABLE SMALLINT, FCOE_ENABLED NUMBER(1), CPU_USAGE INTEGER, MEM_USAGE INTEGER, is_fex NUMBER(1),  fex_id INTEGER, fex_enabled NUMBER(1), disc_status INTEGER, disc_descr VARCHAR2(2000), deep_desc VARCHAR2(2000), lanswitch_classid INTEGER, NUM_1G_PORT INTEGER, NUM_2G_PORT INTEGER, NUM_4G_PORT INTEGER, NUM_8G_PORT INTEGER, NUM_10G_PORT INTEGER, NUM_16G_PORT INTEGER,  NUM_40G_PORT INTEGER, NUM_100G_PORT INTEGER, SIGN VARCHAR2(255), LIC_DETAILS VARCHAR2(500), IS_PM_COLLECT NUMBER(1), IS_FWSM NUMBER(1), IS_DEEP_DISC NUMBER(1), l_report number(1), FEATURES_STRING VARCHAR2(256), PRIMARY_IP VARCHAR2(256), SECONDARY_IP VARCHAR2(256));

DROP  TABLE LANSWITCH_MAP  CASCADE CONSTRAINTS;
CREATE  TABLE LANSWITCH_MAP(ID INTEGER NOT NULL, LAN_ID INTEGER NOT NULL, LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME INTEGER, CONSTRAINT LANSWITCH_MAP_PKEY PRIMARY KEY (ID, LAN_ID));

DROP  TABLE ETHSWITCH_PORT CASCADE CONSTRAINTS;
CREATE  TABLE ETHSWITCH_PORT(ID INTEGER NOT NULL PRIMARY KEY, IF_INDEX INTEGER,SWITCH_ID INTEGER, LAST_UPDATE_TIME TIMESTAMP, LAST_SCAN_TIME INTEGER, STATUS SMALLINT, IF_ADMINSTATUS SMALLINT, PORT_MODE VARCHAR2(255), IF_STATUS_REASON VARCHAR2(2000), IF_SPEED INTEGER, IF_NAME VARCHAR2(256), IF_TYPE INTEGER, IF_DESCR VARCHAR2(256), IF_ALIAS VARCHAR2(256), IP_ADDR VARCHAR2(256), MTU INTEGER, IS_CHANNEL NUMBER(1), CHANNEL_ID INTEGER, IS_TRUNK NUMBER(1), IS_PHYSICAL NUMBER(1), OPER_STATUS_CAUSE SMALLINT, NATIVE_VLANID INTEGER, ACCESS_VLANID INTEGER, SHARED_MODE INTEGER);

DROP  TABLE CDP_SEED CASCADE CONSTRAINTS;
CREATE  TABLE CDP_SEED(ID INTEGER NOT NULL PRIMARY KEY, LAN_ID INTEGER, SERIAL_NUMBER VARCHAR2(256), INET_ADDR RAW(100), IP_RANGE VARCHAR2(256), SUBNET VARCHAR2(256), MASK VARCHAR2(256),CRED_ID INTEGER, MAX_HOPS INTEGER, PLATFORM VARCHAR2(256), LAST_UPDATE_TIME TIMESTAMP, seed_type INTEGER, disc_state INTEGER, ip_list VARCHAR2(4000), group_id INTEGER, create_time INTEGER, enable_pwd VARCHAR2(256), dcnm_user VARCHAR2(256),deep_taskid INTEGER, deep_desc VARCHAR2(256), deep_updatetime INTEGER, manageable NUMBER(1), fwsm NUMBER(1));

DROP  TABLE ETHSWITCH_SEED CASCADE CONSTRAINTS;
CREATE TABLE ETHSWITCH_SEED(SWITCH_ID INTEGER NOT NULL, SEED_ID INTEGER NOT NULL, LAST_UPDATE_TIME TIMESTAMP, CONSTRAINT ETHSWITCH_SEED_PKEY PRIMARY KEY(SWITCH_ID, SEED_ID));

DROP TABLE ETHSWITCH_FEX CASCADE CONSTRAINTS;
CREATE TABLE ETHSWITCH_FEX(SWITCH_ID INTEGER NOT NULL, FEX_ID INTEGER NOT NULL, LAST_UPDATE_TIME TIMESTAMP, CONSTRAINT ETHSWITCH_FEX_PKEY PRIMARY KEY(SWITCH_ID, FEX_ID));

DROP  TABLE LAN CASCADE CONSTRAINTS;
CREATE TABLE LAN (ID INTEGER NOT NULL PRIMARY KEY, LAN_ID INTEGER, LAN_NAME VARCHAR2(256), LAST_SCAN_TIME INTEGER, LAST_UPDATE_TIME TIMESTAMP, IS_PERSISTENT NUMBER(1), IS_MANAGEABLE  NUMBER(1), RESERVE_COL1 VARCHAR2(256), RESERVE_COL2 VARCHAR2(256));

DROP  TABLE ETHSWITCH_PORT_VLAN CASCADE CONSTRAINTS;
CREATE  TABLE ETHSWITCH_PORT_VLAN(PORT_ID INTEGER NOT NULL,VLAN_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHSWITCH_PORT_VLAN_PKEY PRIMARY KEY(PORT_ID, VLAN_ID));

DROP  TABLE ETHISL_VLAN CASCADE CONSTRAINTS;
CREATE  TABLE ETHISL_VLAN(ISL_ID INTEGER NOT NULL,VLAN_ID INTEGER NOT NULL,LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHISL_VLAN_PKEY PRIMARY KEY(ISL_ID, VLAN_ID));

DROP  TABLE ETHSWITCH_VLAN  CASCADE CONSTRAINTS;
CREATE  TABLE ETHSWITCH_VLAN(ETHSWITCH_ID INTEGER NOT NULL,VLAN_ID INTEGER NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT ETHSWITCH_VLAN_PKEY PRIMARY KEY(ETHSWITCH_ID, VLAN_ID));

DROP  TABLE CDP_VLAN  CASCADE CONSTRAINTS;
CREATE TABLE CDP_VLAN (ID INTEGER NOT NULL PRIMARY KEY, VLAN_ID INTEGER, LAN_ID INTEGER, MTU INTEGER, ADMINSTATE SMALLINT,  OPTERSTATE SMALLINT, VLAN_TYPE SMALLINT, VLAN_NAME VARCHAR2(255), LAST_SCAN_TIME INTEGER, LAST_UPDATE_TIME TIMESTAMP, IS_PERSISTENT NUMBER(1), IS_MANAGEABLE NUMBER(1), RESERVE_COL1 VARCHAR2(255) ,RESERVE_COL2 VARCHAR2(255));

DROP  TABLE VLAN_LAN  CASCADE CONSTRAINTS;
CREATE TABLE VLAN_LAN(VLAN_ID INTEGER NOT NULL, LAN_ID INTEGER NOT NULL, LAST_UPDATE_TIME TIMESTAMP,CONSTRAINT VLAN_LAN_PKEY PRIMARY KEY(VLAN_ID, LAN_ID));

DROP TABLE FM_CA_STORE CASCADE CONSTRAINTS;
CREATE TABLE FM_CA_STORE
(
   NAME VARCHAR2(256) NOT NULL PRIMARY KEY,
   FILE_STORE BLOB,
   CERT BLOB,
   CERT_TYPE VARCHAR2(256),
   PRIVATE_KEY BLOB,
   PUBLIC_KEY BLOB,
   PUB_KEY_FORMAT VARCHAR2(256),
   PRIV_KEY_FORMAT VARCHAR2(256),
   PUB_KEY_ALG VARCHAR2(256),
   PRIV_KEY_ALG VARCHAR2(256),
   ALIAS VARCHAR2(256),
   PASSWORD VARCHAR2(256)
);

DROP TABLE FLEX_DASHBOARD CASCADE CONSTRAINTS;
CREATE TABLE FLEX_DASHBOARD 
(
    USER_NAME VARCHAR2(256), 
    VIEW_NAME VARCHAR2(256), 
    DATA VARCHAR2(2048),
    CONSTRAINT FLEX_DASHBOARD_PKEY PRIMARY KEY (USER_NAME, VIEW_NAME)
);

DROP TABLE FLEX_DASHBOARD_TOPO_NODES CASCADE CONSTRAINTS;
CREATE TABLE FLEX_DASHBOARD_TOPO_NODES 
(
    USER_NAME VARCHAR2(256), 
    VIEW_NAME VARCHAR2(256), 
    DATA VARCHAR2(4000),
    CONSTRAINT FLEX_DASHBOARD_TOPO_NODES_PKEY PRIMARY KEY (USER_NAME, VIEW_NAME)
);

DROP TABLE WS_TOKEN CASCADE CONSTRAINTS;
CREATE TABLE WS_TOKEN 
(
    TOKEN VARCHAR2(256), 
    EXPIRE INTEGER, 
    CONSTRAINT WS_TOKEN_PKEY PRIMARY KEY (TOKEN)
);

drop table HOST CASCADE CONSTRAINTS;
CREATE TABLE HOST(ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR2(256), FULL_NAME VARCHAR2(256), ENCLOSURE_ID INTEGER, VHOST_ID INTEGER, USER_MODIFIED NUMBER(1), 
		MAC VARCHAR2(4000), IP VARCHAR2(4000), PWWN VARCHAR2(4000), MULTIPATH VARCHAR2(1024), OS_INFO VARCHAR2(1024), HBAS VARCHAR2(4000),
		VCLUSTER VARCHAR2(256), CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP, 
		RESERVE_COL1 VARCHAR2(256), RESERVE_COL2 VARCHAR2(256) );
CREATE INDEX HOST_NAME_INDEX ON HOST(NAME);

drop table HOST_MAP CASCADE CONSTRAINTS;
CREATE TABLE HOST_MAP(ID INTEGER NOT NULL PRIMARY KEY, HOST_ID INTEGER, ENCLOSURE_ID INTEGER, VHOST_ID INTEGER, LANHOST_ID INTEGER, CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP);
CREATE INDEX HOST_MAP_HOSTID_INDEX ON HOST_MAP(HOST_ID);
CREATE INDEX HOST_MAP_ENCID_INDEX ON HOST_MAP(ENCLOSURE_ID);
CREATE INDEX HOST_MAP_VHOSTID_INDEX ON HOST_MAP(VHOST_ID);
CREATE INDEX HOST_MAP_LANHOSTID_INDEX ON HOST_MAP(LANHOST_ID);

drop table LAN_HOST CASCADE CONSTRAINTS;
CREATE TABLE LAN_HOST(ID INTEGER NOT NULL PRIMARY KEY, NAME VARCHAR2(256), DESCRIPTION VARCHAR2(256), MAC VARCHAR2(256), ETH_SWITCH_ID INTEGER, ETH_IFNAME VARCHAR2(256), IPADDRESS VARCHAR2(256), ETHSWITCH_PORT_ID INTEGER, VLAN INTEGER, VHOST_ID INTEGER, CREATED_TIME TIMESTAMP, LAST_UPDATED_TIME TIMESTAMP);
CREATE INDEX LAN_HOST_MAC_INDEX ON LAN_HOST(MAC);

DROP TABLE CLUSTERNODES CASCADE CONSTRAINTS;
CREATE TABLE CLUSTERNODES (IPADDRESS VARCHAR2(100) not null, PORT INTEGER not null, CONSTRAINT SYS_PK_CLUSTERNODES PRIMARY KEY(IPADDRESS, PORT));

DROP TABLE reports_properties cascade CONSTRAINTS;
create TABLE reports_properties(server VARCHAR2(100),
                                name VARCHAR2(256),
                                writable INTEGER,
                                LAST_UPDATE_TIME TIMESTAMP,
                                reportcontent BLOB default '',
                                PRIMARY KEY (server,name));
DROP TABLE ConfigTemplate CASCADE CONSTRAINTS;
create table ConfigTemplate (
	instanceClassId number(19,0) not null primary key,
	version number(10,0) not null, 
	instanceName varchar2(255), 
	name varchar2(255), 
	description varchar2(255), 
	tagsCol varchar2(255), 
	fileName varchar2(255), 
	userDefined number(1,0) not null, 
	content blob,
	unique (instanceName)
);
           
DROP TABLE san_ConfDelTaskDevDetails CASCADE CONSTRAINTS;
create table san_ConfDelTaskDevDetails (
	instanceClassId number(19,0) not null primary key, 
   	version number(10,0) not null, 
   	instanceState number(10,0), 
   	instanceName varchar2(255), 
   	ipAddress varchar2(255), 
   	configDeliveryTaskDeviceStatus number(10,0), 
   	failureCause blob, 
   	configCommands blob, 
   	failedCommands blob, 
   	SAN_CFGDELIVERYTASK_ID number(19,0), 
   	IDX number(10,0),
   	unique (instanceName)
);

DROP TABLE san_ConfigDeliveryTask CASCADE CONSTRAINTS;
create table san_ConfigDeliveryTask (
	instanceClassId number(19,0) not null primary key,
   	CLASS_TYPE varchar2(255) not null, 
   	version number(10,0) not null, 
   	instanceState number(10,0), 
   	instanceName varchar2(255), 
   	owner varchar2(255), 
   	userName varchar2(255), 
   	password varchar2(255), 
   	enablePwd varchar2(255), 
   	createdTime timestamp, 
   	description varchar2(255), 
   	progress number(10,0), 
           timeout number(10,0), 
   	taskEnabled number(1,0), 
   	scheduledTime timestamp, 
   	startTime timestamp, 
   	endTime timestamp, 
   	isCopyRunToStartTask number(1,0), 
   	allCommandsStr blob, 
   	configDeliveryTaskSourceType number(10,0), 
   	configDeliveryTaskStatus number(10,0), 
   	cfgDeliveryTaskRollbackSetting number(10,0), 
   	cfgDelivryTaskDelivryOrderSett number(10,0), 
   	command varchar2(255), 
   	configTimestamp timestamp, 
   	sourceIpAddress varchar2(255), 
   	sourceTemplate varchar2(255), 
  	CONFIGTEMPLATE_ID number(19,0), 
   	unique (instanceName)
);

alter table san_ConfDelTaskDevDetails add constraint san_conftaskdevdetails_fk foreign key (SAN_CFGDELIVERYTASK_ID) references san_ConfigDeliveryTask;
alter table san_ConfigDeliveryTask add constraint san_configtask_fk foreign key (CONFIGTEMPLATE_ID) references ConfigTemplate;

drop sequence SAN_CFGDELIVERYTASK_SEQUENCE;
create sequence SAN_CFGDELIVERYTASK_SEQUENCE;

drop table ZONE_JOB cascade CONSTRAINTS;
CREATE  TABLE ZONE_JOB(
	ID INTEGER NOT NULL PRIMARY KEY,
	JOB_TYPE SMALLINT,
	VSAN_ID INTEGER,
	VSAN_WWN RAW(8),
	WWN RAW(8),
	ZONESET_NAME VARCHAR2(255),
	JOB_STATUS SMALLINT,
	JOB_CREATE_TIME TIMESTAMP,
	JOB_FINISH_TIME TIMESTAMP,
	JOB_DEL_ON_COMPLETION NUMBER(1),
	JOB_TIME_BEFORE_REMOVAL INTEGER,
	JOB_STATUS_DESC varchar2(255),
	OLD_ZONESET_NAME VARCHAR2(255),
	OLD_ZONESET_ACTIVATION_TIME TIMESTAMP);

CREATE INDEX ZONE_JOB_VSAN_INDEX ON ZONE_JOB(VSAN_ID, VSAN_WWN, ID);

drop table SMIS_PROVIDER cascade CONSTRAINTS;
CREATE  TABLE SMIS_PROVIDER
(
ID INTEGER,
PROVID SMALLINT,
PROVIDER_NS VARCHAR2(255) NOT NULL,
INTEROP_NS VARCHAR2(255),
URL VARCHAR2(255),
USERNAME VARCHAR2(64),
PASSWORD VARCHAR2(64),
PORT INTEGER,
SECURE NUMBER(1),
VENDOR VARCHAR2(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID)
);


drop table SMIS_STORAGE_SYSTEM cascade CONSTRAINTS;
CREATE  TABLE SMIS_STORAGE_SYSTEM
(
ID INTEGER,
PROVIDER_DB_ID INTEGER,
SYSTEM_NAME VARCHAR2(255) NOT NULL,
STORAGE_TYPE VARCHAR2(255),
VENDOR VARCHAR2(255) NOT NULL,
VERSION VARCHAR2(255),
MODEL VARCHAR2(255),
SERIAL_NUMBER VARCHAR2(255) NOT NULL,
PART_NUMBER VARCHAR2(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT provider_fk FOREIGN KEY (PROVIDER_DB_ID) 
REFERENCES SMIS_PROVIDER (ID) ON DELETE CASCADE 
);


drop table SMIS_SYSTEM_COMPONENT cascade CONSTRAINTS;
CREATE  TABLE SMIS_SYSTEM_COMPONENT
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
SYSTEM_COMPONENT_NAME VARCHAR2(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT component_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);


drop table SMIS_POOL cascade CONSTRAINTS;
CREATE  TABLE SMIS_POOL
(
ID INTEGER,
SYSTEM_DB_ID INTEGER, 
POOL_NAME VARCHAR2(256) NOT NULL,
RAW_CAPACITY INTEGER,
TOTAL_MANAGED INTEGER,
REMAINING_MANAGED INTEGER,
REMAINING_RAW_CAPACITY INTEGER,
SUBSCRIBED_CAPACITY INTEGER,
PERCENT_SUBSCRIBED INTEGER, 
STATUS VARCHAR2(255),   
RAID_TYPE VARCHAR2(255),  
DISK_TYPE VARCHAR2(255),    
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT pool_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);


drop table SMIS_STORAGE_PROCESSOR cascade CONSTRAINTS;
CREATE  TABLE SMIS_STORAGE_PROCESSOR
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
PROCESSOR_NAME VARCHAR2(255) NOT NULL,
PROCESSOR_NUMBER INTEGER,
NUM_PORTS INTEGER,
MEM_SIZE INTEGER,
SERIAL_NUMBER VARCHAR2(255),
SLOT_NUMBER INTEGER,
READ_CACHE INTEGER,
WRITE_CACHE INTEGER,
STATUS VARCHAR2(255),
IP_ADDRESS VARCHAR2(15),
FRONT_END_ADAPTER NUMBER(1), 
BACK_END_ADAPTER NUMBER(1),
SRDF_ADAPTER NUMBER(1),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT processor_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);


drop table SMIS_STORAGE_PORT cascade CONSTRAINTS;
CREATE  TABLE SMIS_STORAGE_PORT
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
PROCESSOR_DB_ID INTEGER,  
PORT_NAME VARCHAR2(255) NOT NULL,
PORT_NUMBER INTEGER,
PORT_TYPE INTEGER,
NETWORK_ADDRESS VARCHAR2(255),
PERM_ADDRESS VARCHAR2(255),
PORT_DESCRIPTION VARCHAR2(255),
SPEED INTEGER,
PORT_USAGE INTEGER,
STATUS VARCHAR2(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT port_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);

drop table SMIS_DISK cascade CONSTRAINTS;
CREATE  TABLE SMIS_DISK
(
ID INTEGER,
SYSTEM_COMPONENT_DB_ID INTEGER,
DISK_NAME VARCHAR2(255) NOT NULL,
DRIVE_TYPE VARCHAR2(255),
RAW_CAPACITY INTEGER,
USER_CAPACITY INTEGER,
USER_SECTORS INTEGER,
STATE INTEGER,
RAID_TYPE VARCHAR2(255),
STORAGE_POOL VARCHAR2(255),
STATUS VARCHAR2(255),       
MANUFACTURER VARCHAR2(255),
MODEL VARCHAR2(255),
SERIAL_NUMBER VARCHAR2(255),
PART_NUMBER VARCHAR2(255),
FIRMWARE_REV VARCHAR2(255),
CURRENT_SPEED INTEGER,
MAX_SPEED INTEGER,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT disk_fk FOREIGN KEY (SYSTEM_COMPONENT_DB_ID) 
REFERENCES SMIS_SYSTEM_COMPONENT (ID) ON DELETE CASCADE 
);


drop table SMIS_HOST cascade CONSTRAINTS;
CREATE  TABLE SMIS_HOST
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
HOST_NWWN VARCHAR2(255),
HOST_NAME VARCHAR2(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT host_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);


drop table SMIS_HOST_PORT cascade CONSTRAINTS;
CREATE  TABLE SMIS_HOST_PORT
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
HOST_DB_ID INTEGER,
HOST_PWWN VARCHAR2(255) NOT NULL,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT host_port_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE,
CONSTRAINT host_port_host_fk FOREIGN KEY (HOST_DB_ID) 
REFERENCES SMIS_HOST (ID) ON DELETE CASCADE 
);
CREATE INDEX SMIS_HOST_PORT_HOST_PWWN ON SMIS_HOST_PORT(HOST_PWWN);

drop table SMIS_STORAGE_LUN cascade CONSTRAINTS;
CREATE  TABLE SMIS_STORAGE_LUN
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
LUN_NAME VARCHAR2(255) NOT NULL,
LUN_ID VARCHAR2(255) NOT NULL,
WWN VARCHAR2(255),
POOL_NAME VARCHAR2(255),
TOTAL_MANAGED_SPACE INTEGER,
REMAINING_MANAGED_SPACE INTEGER,
CONSUMED_CAPACITY INTEGER,
STATUS VARCHAR2(255),
RAID_TYPE VARCHAR2(255),
DISK_TYPE VARCHAR2(255),
CURRENT_OWNER VARCHAR2(255),
DEFAULT_OWNER VARCHAR2(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT volume_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);

drop table SMIS_HOST_LUN_MAP cascade CONSTRAINTS;
CREATE  TABLE SMIS_HOST_LUN_MAP
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
HOST_PORT_DB_ID INTEGER,
LUN_DB_ID INTEGER,
HOST_LUN_ID VARCHAR2(255),
TARGET_PWWN VARCHAR2(255),
LUN_ID VARCHAR2(255),
READABLE_HOST_NAME VARCHAR2(255),
ADAPTER_NAME VARCHAR2(255),
LUN_ACCESS INTEGER,
ACCESS_PRIV_GRANTED NUMBER(1),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT host_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE, 
CONSTRAINT host_port_fk FOREIGN KEY (HOST_PORT_DB_ID) 
REFERENCES SMIS_HOST_PORT (ID) ON DELETE CASCADE, 
CONSTRAINT host_volume_fk FOREIGN KEY (LUN_DB_ID) 
REFERENCES SMIS_STORAGE_LUN (ID) ON DELETE CASCADE 
);

drop table SMIS_DISK_LUN_MAP cascade CONSTRAINTS;
CREATE  TABLE SMIS_DISK_LUN_MAP
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
DISK_DB_ID INTEGER,
LUN_DB_ID INTEGER,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT disk_lun_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE, 
CONSTRAINT disk_lun_disk_fk FOREIGN KEY (DISK_DB_ID) 
REFERENCES SMIS_DISK (ID) ON DELETE CASCADE, 
CONSTRAINT disk_lun_lun_fk FOREIGN KEY (LUN_DB_ID) 
REFERENCES SMIS_STORAGE_LUN (ID) ON DELETE CASCADE 
);

drop table SMIS_DISK_POOL_MAP cascade CONSTRAINTS;
CREATE  TABLE SMIS_DISK_POOL_MAP
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
DISK_DB_ID INTEGER,
POOL_DB_ID INTEGER,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT disk_pool_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE, 
CONSTRAINT disk_pool_disk_fk FOREIGN KEY (DISK_DB_ID) 
REFERENCES SMIS_DISK (ID) ON DELETE CASCADE, 
CONSTRAINT disk_pool_pool_fk FOREIGN KEY (POOL_DB_ID) 
REFERENCES SMIS_POOL (ID) ON DELETE CASCADE 
);

drop table SMIS_STORAGE_FILER_VOLUME cascade CONSTRAINTS;
CREATE TABLE SMIS_STORAGE_FILER_VOLUME
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
FILER_VOLUME_NAME VARCHAR2(255) NOT NULL,
CONTAINING_AGGREGATE VARCHAR2(255) NOT NULL,
AVAILABLE_CAPACITY INTEGER,
TOTAL_CAPACITY INTEGER,
USED_CAPACITY INTEGER,
NUM_OF_FILES INTEGER,
MAX_NUM_OF_FILES INTEGER,
STATUS VARCHAR2(255),
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT fv_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);

drop table SMIS_STATISTICS_DISK cascade CONSTRAINTS;
CREATE  TABLE SMIS_STATISTICS_DISK
(
ID INTEGER,
SYSTEM_DB_ID INTEGER,
DISK_NAME VARCHAR2(255),
TIME_ID INTEGER NOT NULL,
totalIOs INTEGER,	
kBytesTransferred INTEGER,
iOTimeCounter INTEGER,	
readIOs INTEGER,
readHitIOs INTEGER,	
readIOTimeCounter INTEGER,
readHitIOTimeCounter INTEGER,
kBytesRead INTEGER,
writeIOs INTEGER, 
writeHitIOs INTEGER,
writeIOTimeCounter INTEGER,
writeHitIOTimeCounter INTEGER, 
kBytesWritten INTEGER,
idleTimeCounter INTEGER, 
maintOp INTEGER,
maintTimeCounter INTEGER,
currentPWRSavingLogTimeStamp INTEGER, 
kbSeeked INTEGER,
queueArrivals INTEGER, 
queueLength INTEGER,
spinningCounter INTEGER, 
spinUPS INTEGER, 
standbyCounter INTEGER, 
readHits INTEGER,
readMisses INTEGER,
writeHits INTEGER,
writeMisses INTEGER,
LAST_UPDATED TIMESTAMP,
PRIMARY KEY(ID),
CONSTRAINT ssd_sys_fk FOREIGN KEY (SYSTEM_DB_ID) 
REFERENCES SMIS_STORAGE_SYSTEM (ID) ON DELETE CASCADE 
);


drop table UCS_BLADE cascade CONSTRAINTS;
CREATE TABLE UCS_BLADE (ID INTEGER, switch_id INTEGER, admin_power VARCHAR2(255), admin_state VARCHAR2(255), assigned_to_dn VARCHAR2(255),
	association VARCHAR2(255), availability VARCHAR2(255), available_memory INTEGER, chassis_id INTEGER, descr VARCHAR2(255), dn VARCHAR2(255),
	low_voltage_memory VARCHAR2(255), managing_inst VARCHAR2(255), memory_speed INTEGER, model VARCHAR2(255), name VARCHAR2(255),
	num_of_adaptors INTEGER, num_of_cores INTEGER, num_of_cores_enabled INTEGER, num_of_cpus INTEGER, num_of_eth_host_ifs INTEGER,
	num_of_fc_host_ifs INTEGER, num_of_threads INTEGER, oper_power VARCHAR2(255), oper_qualifier VARCHAR2(255), oper_state VARCHAR2(255), 
	operability VARCHAR2(255), original_uuid VARCHAR2(255), presence VARCHAR2(255), revision INTEGER, serial VARCHAR2(255), server_id VARCHAR2(255), 
	slot_id INTEGER, total_memory INTEGER, uuid VARCHAR2(255), vendor VARCHAR2(255), created_time TIMESTAMP, last_update_time INTEGER,
	PRIMARY KEY(ID)
);

DROP TABLE UCS_BLADE_MGMT_IF cascade CONSTRAINTS;
CREATE TABLE UCS_BLADE_MGMT_IF (ID INTEGER, switch_id INTEGER, blade_id INTEGER, access_type VARCHAR2(255), admin_state VARCHAR2(255), discovery VARCHAR2(255), 
	dn VARCHAR2(255), epdn VARCHAR2(255), ext_broadcast VARCHAR2(255), ext_gw VARCHAR2(255), ext_ip VARCHAR2(255), ext_mask VARCHAR2(255), 
	if_id INTEGER, if_role VARCHAR2(255), if_type VARCHAR2(255), ip VARCHAR2(255), locale VARCHAR2(255), mac VARCHAR2(255), mask VARCHAR2(255), 
	name VARCHAR2(255), peer_chassis_id VARCHAR2(255), peer_dn VARCHAR2(255), peer_port_id INTEGER, peer_slot_id INTEGER, port_id INTEGER, slot_id INTEGER, 
	state_qual VARCHAR2(255), subject VARCHAR2(255), transport VARCHAR2(255), type VARCHAR2(255), vnet INTEGER, created_time TIMESTAMP, last_update_time INTEGER,
	PRIMARY KEY(ID),
	CONSTRAINT blade_fk FOREIGN KEY (blade_id) REFERENCES UCS_BLADE (ID) ON DELETE CASCADE
);

drop table STORAGE_ENCLOSURE cascade CONSTRAINTS;
CREATE TABLE STORAGE_ENCLOSURE (ID INTEGER, enclosure_id INTEGER, storage_system_id INTEGER, name VARCHAR2(255), ip VARCHAR2(255), created_time TIMESTAMP, last_update_time INTEGER, 
	PRIMARY KEY(ID)
);

commit;
exit;

