/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.JideButtonUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class BasicJideButtonUI
extends JideButtonUI {
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "JideButton.";
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected Color _focusColor;
    protected boolean _isFloatingIcon = false;
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((AbstractButton)jComponent);
        this.installListeners((AbstractButton)jComponent);
        this.installKeyboardActions((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, ((AbstractButton)jComponent).getText());
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Object object = UIDefaultsLookup.get("Theme.painter");
        this._painter = object instanceof ThemePainter ? (ThemePainter)object : new BasicPainter();
        String string = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultTextIconGap = UIDefaultsLookup.getInt(string + "textIconGap");
            this.defaultTextShiftOffset = UIDefaultsLookup.getInt(string + "textShiftOffset");
            this._focusColor = UIDefaultsLookup.getColor("Button.focus");
            this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
            this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
            this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
            this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
            this.defaults_initialized = true;
        }
        this.updateMargin(abstractButton);
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
    }

    protected void installListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.putClientProperty(this, basicButtonListener);
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addChangeListener(basicButtonListener);
        }
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (basicButtonListener != null) {
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        this._painter = null;
        this._focusColor = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        this.defaults_initialized = false;
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicJideButtonListener(abstractButton);
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    protected Color getFocusColor() {
        return this._focusColor;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BasicJideButtonUI.viewRect.x = insets.left;
        BasicJideButtonUI.viewRect.y = insets.top;
        BasicJideButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BasicJideButtonUI.viewRect.x);
        BasicJideButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BasicJideButtonUI.viewRect.y);
        BasicJideButtonUI.textRect.height = 0;
        BasicJideButtonUI.textRect.width = 0;
        BasicJideButtonUI.textRect.y = 0;
        BasicJideButtonUI.textRect.x = 0;
        BasicJideButtonUI.iconRect.height = 0;
        BasicJideButtonUI.iconRect.width = 0;
        BasicJideButtonUI.iconRect.y = 0;
        BasicJideButtonUI.iconRect.x = 0;
        this.paintBackground(graphics, abstractButton);
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = JideSwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), bl, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        this.paintIcon(abstractButton, graphics);
        Boolean bl2 = UIManager.getBoolean("Theme.highContrast");
        if (bl2.booleanValue() && JideSwingUtilities.getButtonState(abstractButton) == 1) {
            ++BasicJideButtonUI.textRect.x;
            ++BasicJideButtonUI.textRect.y;
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
    }

    protected void paintIcon(AbstractButton abstractButton, Graphics graphics) {
        if (abstractButton.getIcon() != null) {
            Icon icon = this.getIcon(abstractButton);
            ButtonModel buttonModel = abstractButton.getModel();
            if (icon != null) {
                if (this.isFloatingIcon() && buttonModel.isEnabled()) {
                    if (buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isSelected()) {
                        if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false")) && abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 0) {
                            if (icon instanceof ImageIcon) {
                                ImageIcon imageIcon = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                                imageIcon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            } else {
                                ImageIcon imageIcon = IconsFactory.createGrayImage(abstractButton, icon);
                                imageIcon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            }
                            icon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x - 1, BasicJideButtonUI.iconRect.y - 1);
                        } else {
                            icon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                        }
                    } else {
                        icon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(abstractButton, graphics, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                }
            }
        }
    }

    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(abstractButton, icon);
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                this.clearTextShiftOffset();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (!bl) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0, -jComponent.getWidth() + 1);
            if (buttonModel.isEnabled()) {
                graphics2D.setColor(this.getForegroundOfState(abstractButton));
                JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics2D, string, n, rectangle.y + this.getTextShiftOffset(), rectangle.x + fontMetrics.getAscent() + this.getTextShiftOffset());
            } else {
                Color color = UIDefaultsLookup.getColor("Button.disabledForeground");
                graphics2D.setColor(color == null ? abstractButton.getBackground().darker() : color);
                JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics2D, string, n, rectangle.y, rectangle.x + fontMetrics.getAscent());
            }
            if (abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 3 && (((JideButton)abstractButton).isAlwaysShowHyperlink() || abstractButton.getModel().isRollover())) {
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
            }
            graphics2D.dispose();
        } else {
            Color color = graphics.getColor();
            if (buttonModel.isEnabled()) {
                graphics.setColor(this.getForegroundOfState(abstractButton));
                JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
            } else {
                Color color2 = UIDefaultsLookup.getColor("Button.disabledForeground");
                graphics.setColor(color2 == null ? abstractButton.getBackground().darker() : color2);
                JideSwingUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
            if (abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 3 && (((JideButton)abstractButton).isAlwaysShowHyperlink() || abstractButton.getModel().isRollover())) {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 2);
            }
            graphics.setColor(color);
        }
    }

    protected Color getForegroundOfState(AbstractButton abstractButton) {
        int n = JideSwingUtilities.getButtonState(abstractButton);
        Color color = null;
        if (abstractButton instanceof ComponentStateSupport) {
            color = ((ComponentStateSupport)((Object)abstractButton)).getForegroundOfState(n);
        }
        if (color == null || color instanceof UIResource) {
            color = abstractButton.getForeground();
        }
        return color;
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        boolean bl;
        boolean bl2 = true;
        Object object = abstractButton.getClientProperty("JideButton.paintDefaultBorder");
        if (object instanceof Boolean) {
            bl2 = (Boolean)object;
        }
        if (bl = (object = abstractButton.getClientProperty("JideButton.alwaysPaintBackground")) instanceof Boolean ? ((Boolean)object).booleanValue() : abstractButton.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
        if (abstractButton.isContentAreaFilled()) {
            if (abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 0) {
                Rectangle rectangle = new Rectangle(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
                int n = JideSwingUtilities.getButtonState(abstractButton);
                if (n != 0) {
                    this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, 0, n);
                } else if (bl) {
                    this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), n);
                    if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        JideSwingUtilities.fillGradient(graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton));
                    }
                }
            } else if (abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 2) {
                this.paintBackgroundInFlatStyle(graphics, abstractButton, bl);
            } else if (abstractButton instanceof JideButton && ((JideButton)abstractButton).getButtonStyle() == 1) {
                this.paintBackgroundInToolboxStyle(graphics, abstractButton, bl, bl2);
            }
        }
    }

    private void paintBackgroundInFlatStyle(Graphics graphics, AbstractButton abstractButton, boolean bl) {
        Rectangle rectangle = new Rectangle(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        int n = JideSwingUtilities.getButtonState(abstractButton);
        switch (n) {
            case 3: {
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height - 1);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(rectangle.x, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 1: {
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height - 1);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(rectangle.x, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 2: {
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height - 1);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(rectangle.x, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 4: 
            case 5: {
                if (!bl) break;
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height - 1);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(rectangle.x, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
                graphics.drawLine(rectangle.width - 1, rectangle.y, rectangle.width - 1, rectangle.height - 1);
                break;
            }
            case 0: {
                if (!bl) break;
                this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), n);
            }
        }
    }

    private void paintBackgroundInToolboxStyle(Graphics graphics, AbstractButton abstractButton, boolean bl, boolean bl2) {
        Rectangle rectangle = new Rectangle(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        if (abstractButton.getModel().isPressed()) {
            this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), 1);
            if (bl2) {
                graphics.setColor(this._darkShadowColor);
                graphics.drawLine(0, 0, abstractButton.getWidth() - 2, 0);
                graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 2);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(1, 1, abstractButton.getWidth() - 3, 1);
                graphics.drawLine(1, 1, 1, abstractButton.getHeight() - 3);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            }
        } else if (abstractButton.getModel().isSelected() && abstractButton.getModel().isRollover()) {
            this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), 1);
            if (bl2) {
                graphics.setColor(this._darkShadowColor);
                graphics.drawLine(0, 0, abstractButton.getWidth() - 2, 0);
                graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 2);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(1, 1, abstractButton.getWidth() - 3, 1);
                graphics.drawLine(1, 1, 1, abstractButton.getHeight() - 3);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            }
        } else if (abstractButton.getModel().isSelected()) {
            this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), 3);
            if (bl2) {
                graphics.setColor(this._darkShadowColor);
                graphics.drawLine(0, 0, abstractButton.getWidth() - 2, 0);
                graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 2);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(1, 1, abstractButton.getWidth() - 3, 1);
                graphics.drawLine(1, 1, 1, abstractButton.getHeight() - 3);
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            }
        } else if (abstractButton.getModel().isRollover() || abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
            this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), 2);
            if (bl2) {
                graphics.setColor(this._lightHighlightColor);
                graphics.drawLine(0, 0, abstractButton.getWidth() - 1, 0);
                graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 1);
                graphics.setColor(this._shadowColor);
                graphics.drawLine(1, abstractButton.getHeight() - 2, abstractButton.getWidth() - 2, abstractButton.getHeight() - 2);
                graphics.drawLine(abstractButton.getWidth() - 2, 1, abstractButton.getWidth() - 2, abstractButton.getHeight() - 2);
                graphics.setColor(this._darkShadowColor);
                graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
                graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            }
        } else if (bl) {
            this.getPainter().paintButtonBackground(abstractButton, graphics, rectangle, JideSwingUtilities.getOrientationOf(abstractButton), 0);
        } else {
            graphics.setColor(this._lightHighlightColor);
            graphics.drawLine(0, 0, abstractButton.getWidth() - 1, 0);
            graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 1);
            graphics.setColor(this._shadowColor);
            graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
        }
        if (bl) {
            graphics.setColor(this._lightHighlightColor);
            graphics.drawLine(0, 0, abstractButton.getWidth() - 1, 0);
            graphics.drawLine(0, 0, 0, abstractButton.getHeight() - 1);
            graphics.setColor(this._shadowColor);
            graphics.drawLine(0, abstractButton.getHeight() - 1, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
            graphics.drawLine(abstractButton.getWidth() - 1, 0, abstractButton.getWidth() - 1, abstractButton.getHeight() - 1);
        }
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return dimension;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected void updateMargin(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        if (LookAndFeelFactory.isLnfInUse("javax.swing.plaf.synth.SynthLookAndFeel")) {
            SynthContext synthContext;
            SynthStyle synthStyle = SynthLookAndFeel.getStyle(abstractButton, Region.BUTTON);
            Insets insets = synthStyle.getInsets(synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, 0), new InsetsUIResource(0, 0, 0, 0));
            if (insets != null) {
                abstractButton.setMargin(insets);
            }
        } else if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            if (BasicJideButtonUI.shouldWrapText(abstractButton)) {
                abstractButton.setMargin(UIDefaultsLookup.getInsets(string + "margin.vertical"));
            } else {
                abstractButton.setMargin(UIDefaultsLookup.getInsets(string + "margin"));
            }
        }
    }

    public static boolean shouldWrapText(Component component) {
        return false;
    }
}

